spring:
  application:
    name: ${cfg.artifactId}
  datasource:
    dynamic:
      datasource:
        master:
        <#if cfg.username??>
          username: ${cfg.username}
        </#if>
        <#if cfg.password??>
          password: ${cfg.password}
        </#if>
        <#if cfg.driverClassName??>
          driver-class-name: ${cfg.driverClassName}
        </#if>
        <#if cfg.url??>
          url: ${cfg.url}
        </#if>
          <#if cfg.publicKey??>
          druid:
            public-key: ${cfg.publicKey}
          </#if>

<#if cfg.backendServerPort??>
server:
  port: ${cfg.backendServerPort}
</#if>

<#if cfg.registryServerName?? && cfg.registryServerName == 'eureka'>
eureka:
  client:
    <#if cfg.registryServerAddr??>
    service-url:
      defaultZone: ${cfg.registryServerAddr}
    </#if>
</#if>
