<project xmlns="http://maven.apache.org/POM/4.0.0"
         xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
         xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd">
    <modelVersion>4.0.0</modelVersion>
    <version>${cfg.parentVersion}</version>
    <groupId>${cfg.groupId}</groupId>
    <artifactId>${cfg.artifactId}</artifactId>

    <properties>
        <java.version>1.8</java.version>
        <spring.boot.version>${cfg.springbootVersion}</spring.boot.version>
    </properties>

    <dependencies>
        <!-- base -->
        <dependency>
            <groupId>${cfg.baseGroupId}</groupId>
            <artifactId>${cfg.baseArtifactId}</artifactId>
            <version>${cfg.parentVersion}</version>
<#--            <scope>provided</scope>-->
            <exclusions>
                <!--  可以使用eureka 注册中心 或者 nacos -->
                <exclusion>
                    <groupId>com.alibaba.nacos</groupId>
                    <artifactId>nacos-client</artifactId>
                </exclusion>
                <exclusion>
                    <groupId>com.alibaba.cloud</groupId>
                    <artifactId>spring-cloud-starter-alibaba-nacos-discovery</artifactId>
                </exclusion>
                <exclusion>
                    <groupId>org.springframework.cloud</groupId>
                    <artifactId>
                        spring-cloud-starter-netflix-hystrix
                    </artifactId>
                </exclusion>
                <exclusion>
                    <groupId>org.springframework.cloud</groupId>
                    <artifactId>
                        spring-cloud-starter-netflix-hystrix-dashboard
                    </artifactId>
                </exclusion>
                <exclusion>
                    <groupId>com.alibaba.cloud</groupId>
                    <artifactId>spring-cloud-starter-alibaba-nacos-config</artifactId>
                </exclusion>
                <!-- 五合一启动时 不需要seata  -->
                <exclusion>
                    <groupId>com.alibaba.cloud</groupId>
                    <artifactId>spring-cloud-alibaba-seata</artifactId>
                </exclusion>
                <exclusion>
                    <groupId>io.seata</groupId>
                    <artifactId>seata-spring-boot-starter</artifactId>
                </exclusion>
                <exclusion>
                    <artifactId>spring-cloud-starter-alibaba-seata</artifactId>
                    <groupId>com.alibaba.cloud</groupId>
                </exclusion>
                <exclusion>
                    <artifactId>spring-boot-starter-jdbc</artifactId>
                    <groupId>org.springframework.boot</groupId>
                </exclusion>
            </exclusions>
        </dependency>
        <dependency>
            <groupId>org.springframework.boot</groupId>
            <artifactId>spring-boot-autoconfigure</artifactId>
            <version>${r"${spring.boot.version}"}</version>
        </dependency>
        <dependency>
            <groupId>com.hotent</groupId>
            <artifactId>uc-api-impl</artifactId>
            <version>${cfg.parentVersion}</version>
        </dependency>
        <dependency>
            <groupId>com.hotent</groupId>
            <artifactId>poi</artifactId>
            <version>${cfg.parentVersion}</version>
        </dependency>
        <!-- spring boot -->
        <dependency>
            <groupId>org.springframework.boot</groupId>
            <artifactId>spring-boot-starter</artifactId>
            <version>${r"${spring.boot.version}"}</version>
        </dependency>
        <dependency>
            <groupId>org.springframework</groupId>
            <artifactId>spring-tx</artifactId>
        </dependency>
        <dependency>
            <groupId>org.springframework</groupId>
            <artifactId>spring-jdbc</artifactId>
        </dependency>
    </dependencies>

    <!-- 定义全局依赖供子模块使用 -->
    <dependencyManagement>
        <dependencies>
            <!-- spring boot -->
            <dependency>
                <groupId>org.springframework.boot</groupId>
                <artifactId>spring-boot-dependencies</artifactId>
                <version>${r"${spring.boot.version}"}</version>
                <scope>import</scope>
                <type>pom</type>
            </dependency>
        </dependencies>
    </dependencyManagement>
    <build>
        <plugins>
            <!-- 编译插件 -->
            <plugin>
                <groupId>org.apache.maven.plugins</groupId>
                <artifactId>maven-compiler-plugin</artifactId>
                <configuration>
                    <source>${r'${java.version}'}</source>
                    <target>${r'${java.version}'}</target>
                </configuration>
            </plugin>
        </plugins>
    </build>

</project>
