package ${cfg.basePackage}.${cfg.moduleName}.controller;

import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import ${cfg.basePackage}.${cfg.moduleName}.manager.FlowEntityManager;
import ${cfg.basePackage}.${cfg.moduleName}.service.FlowService;
import ${cfg.basePackage}.${cfg.moduleName}.vo.FlowImageDataVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.Map;

/**
* 流程接口
*
<#if cfg.companyName??>
    * @company ${cfg.companyName}
</#if>
* @author ${author}
<#if cfg.authorEmail??>
    * @email ${cfg.authorEmail}
</#if>
* @since ${date}
*/
@RestController
@RequestMapping("/demo/flow")
@Api(value = "流程", tags = "流程接口")
public class FlowController {

    @Resource
    private FlowService flowService;

    @PostMapping("/start")
    @ApiOperation(value = "启动流程", notes = "传入流程信息")
    public CommonResult<String> start(@Valid @RequestBody Map<String, Object> vars, @RequestParam String entityName, @RequestParam String flowKey) {
        FlowEntityManager flowEntityManager = (FlowEntityManager) AppUtil.getBean(entityName + "ManagerImpl");
        return flowEntityManager.start(vars, flowKey);
    }

    @GetMapping("/getBpmImage")
    @ApiOperation(value = "获取流程图", notes = "传入流程实例ID instId")
    public CommonResult<FlowImageDataVo> getBpmImage(@ApiParam(value = "流程实例ID", required = true) @RequestParam String instId) throws Exception {
        return CommonResult.<FlowImageDataVo>ok().value(flowService.getBpmImage(instId));
    }

    @GetMapping("/instanceFlowOpinions")
    @ApiOperation(value = "获取流程审批历史", notes = "传入流程实例ID instId")
    public CommonResult<?> instanceFlowOpinions(@ApiParam(value = "流程实例ID", required = true) @RequestParam String instId) throws Exception {
        return flowService.instanceFlowOpinions(instId);
    }

    @PostMapping("/complete")
    @ApiOperation(value = "处理任务（同意）", notes = "传入流程实例ID instId")
    public CommonResult<?> complete(@ApiParam(value = "流程实例ID", required = true) @RequestParam String instId, @RequestParam String entityName) throws Exception {
        FlowEntityManager flowEntityManager = (FlowEntityManager) AppUtil.getBean(entityName + "ManagerImpl");
        return flowEntityManager.agree(instId);
    }

    @PostMapping("/backToStart")
    @ApiOperation(value = "驳回", notes = "传入流程实例ID instId")
    public CommonResult<?> backToStart(@ApiParam(value = "流程实例ID", required = true) @RequestParam String instId, @RequestParam String entityName) throws Exception {
        FlowEntityManager flowEntityManager = (FlowEntityManager) AppUtil.getBean(entityName + "ManagerImpl");
        return flowEntityManager.backToStart(instId);
    }

    @GetMapping("/instance/status")
    @ApiOperation(value = "根据实例ID获取并更新实例状态", notes = "根据实例ID获取并更新实例状态")
    public CommonResult<String> getStatusByInstId(@ApiParam(value = "流程实例ID", required = true) @RequestParam String instId, @RequestParam String entityName) throws Exception {
        FlowEntityManager flowEntityManager = (FlowEntityManager) AppUtil.getBean(entityName + "ManagerImpl");
        return flowEntityManager.getStatusByInstId(instId);
    }

    @GetMapping("/business/status")
    @ApiOperation(value = "根据业务主键获取并更新实例状态", notes = "根据业务主键获取并更新实例状态")
    public CommonResult<String> getStatusByBusinessId(@ApiParam(value = "业务主键", required = true) @RequestParam String id, @RequestParam String entityName) throws Exception {
        FlowEntityManager flowEntityManager = (FlowEntityManager) AppUtil.getBean(entityName + "ManagerImpl");
        return flowEntityManager.getStatusByBusinessId(id);
    }

}