package ${cfg.basePackage}.${cfg.moduleName}.entity;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.hotent.base.entity.BaseModel;

import java.time.LocalDateTime;

/**
 * @Author: Cola
 * @Date: 2021/08/20/11:31
 * @Description:
 **/
public class DefaultBpmProcessInstance extends BaseModel<DefaultBpmProcessInstance> implements BpmProcessInstance,Cloneable {

    /*流程实例ID*/
    protected String  id;
    /*流程实例标题*/
    protected String  subject;
    /*流程定义ID*/
    protected String  procDefId;
    /*BPMN流程定义ID*/
    protected String  bpmnDefId;
    /*流程定义Key*/
    protected String  procDefKey;
    protected String  procDefName; /*流程名称*/
    protected String  bizKey; /*关联数据业务主键*/
    protected String  sysCode; /*关联数据系统编码*/
    protected String  formKey; /*绑定的表单主键*/
    //实例状态
    protected String  status;
	@JsonFormat(shape= JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    protected LocalDateTime endTime; /*实例结束时间*/
    protected Long  duration; /*持续时间(ms)*/
    protected String  typeId; /*所属分类ID*/
    protected String  resultType; /*流程结束后的最终审批结果，agree=同意；refuse=拒绝*/
    protected String  bpmnInstId; /*BPMN流程实例ID*/
    protected String  isFormmal="Y"; /*是否正式数据*/
    protected String  parentInstId="0"; /*父实例Id*/
    protected  String superNodeId;/*父流程节点定义ID*/
    protected  String urgentState;/*紧急状态*/
    protected  String creator;
    protected String  createBy; /*创建人ID*/
	@JsonFormat(shape= JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    protected LocalDateTime  createTime; /*创建时间*/
    protected String  createOrgId; /*创建者所属组织ID*/
    protected String  updateBy; /*更新人ID*/
	@JsonFormat(shape= JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    protected LocalDateTime  updateTime; /*更新时间*/
    //是否禁止
    protected int isForbidden=0;


    protected String createOrgPath="";/*创建者所属组织全路径*/

    //是否物理删除（0：否，1：是）
    protected int isDele=0;
    //支持手机表单。
    protected int supportMobile=0;
    //业务数据存储模式。
    protected String dataMode="";
    //流程分管授权权限对象
    protected Object authorizeRight;
    //任务名称，做查询使用。
    protected String taskName="";
    //是否为驳回状态下驳回到发起人
    protected Boolean isBackToStart = false;
    //是否显示表单修改记录
    protected boolean showModifyRecord = false;
    //表单formKey
    protected String bpmFormKey;
    // 流程标题存在时，是否重新生成流程标题并更新
    protected boolean updateSubjectWhenExist = false;

    @Override
	public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
	public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
	public String getProcDefId() {
        return procDefId;
    }

    public void setProcDefId(String procDefId) {
        this.procDefId = procDefId;
    }

    public String getBpmnDefId() {
        return bpmnDefId;
    }

    public void setBpmnDefId(String bpmnDefId) {
        this.bpmnDefId = bpmnDefId;
    }

    public String getProcDefKey() {
        return procDefKey;
    }

    public void setProcDefKey(String procDefKey) {
        this.procDefKey = procDefKey;
    }

    public String getProcDefName() {
        return procDefName;
    }

    public void setProcDefName(String procDefName) {
        this.procDefName = procDefName;
    }

    public String getBizKey() {
        return bizKey;
    }

    public void setBizKey(String bizKey) {
        this.bizKey = bizKey;
    }

    public String getSysCode() {
        return sysCode;
    }

    public void setSysCode(String sysCode) {
        this.sysCode = sysCode;
    }

    public String getFormKey() {
        return formKey;
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public LocalDateTime getEndTime() {
        return endTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public Long getDuration() {
        return duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public String getTypeId() {
        return typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public String getResultType() {
        return resultType;
    }

    public void setResultType(String resultType) {
        this.resultType = resultType;
    }

    public String getBpmnInstId() {
        return bpmnInstId;
    }

    public void setBpmnInstId(String bpmnInstId) {
        this.bpmnInstId = bpmnInstId;
    }

    public String getIsFormmal() {
        return isFormmal;
    }

    public void setIsFormmal(String isFormmal) {
        this.isFormmal = isFormmal;
    }

    public String getParentInstId() {
        return parentInstId;
    }

    public void setParentInstId(String parentInstId) {
        this.parentInstId = parentInstId;
    }

    public String getSuperNodeId() {
        return superNodeId;
    }

    public void setSuperNodeId(String superNodeId) {
        this.superNodeId = superNodeId;
    }

    public String getUrgentState() {
        return urgentState;
    }

    public void setUrgentState(String urgentState) {
        this.urgentState = urgentState;
    }

    public String getCreator() {
        return creator;
    }

	@Override
	public String getCreateAccount() {
		return createBy;
	}

	public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public String getCreateOrgId() {
        return createOrgId;
    }

    public void setCreateOrgId(String createOrgId) {
        this.createOrgId = createOrgId;
    }

    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public int getIsForbidden() {
        return isForbidden;
    }

    public void setIsForbidden(int isForbidden) {
        this.isForbidden = isForbidden;
    }

    public String getCreateOrgPath() {
        return createOrgPath;
    }

    public void setCreateOrgPath(String createOrgPath) {
        this.createOrgPath = createOrgPath;
    }

    public int getIsDele() {
        return isDele;
    }

    public void setIsDele(int isDele) {
        this.isDele = isDele;
    }

    public int getSupportMobile() {
        return supportMobile;
    }

	@Override
	public String getPcInstUrl() {
		return null;
	}

	@Override
	public String getMobileInstUrl() {
		return null;
	}

	public void setSupportMobile(int supportMobile) {
        this.supportMobile = supportMobile;
    }

    public String getDataMode() {
        return dataMode;
    }

    public void setDataMode(String dataMode) {
        this.dataMode = dataMode;
    }

    public Object getAuthorizeRight() {
        return authorizeRight;
    }

    public void setAuthorizeRight(Object authorizeRight) {
        this.authorizeRight = authorizeRight;
    }

    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public Boolean getBackToStart() {
        return isBackToStart;
    }

    public void setBackToStart(Boolean backToStart) {
        isBackToStart = backToStart;
    }

    public boolean isShowModifyRecord() {
        return showModifyRecord;
    }

    public void setShowModifyRecord(boolean showModifyRecord) {
        this.showModifyRecord = showModifyRecord;
    }

    public String getBpmFormKey() {
        return bpmFormKey;
    }

    public void setBpmFormKey(String bpmFormKey) {
        this.bpmFormKey = bpmFormKey;
    }

    public boolean isUpdateSubjectWhenExist() {
        return updateSubjectWhenExist;
    }

    public void setUpdateSubjectWhenExist(boolean updateSubjectWhenExist) {
        this.updateSubjectWhenExist = updateSubjectWhenExist;
    }

    @Override
    public String toString() {
        return "DefaultBpmProcessInstance{" +
                "id='" + id + '\'' +
                ", subject='" + subject + '\'' +
                ", procDefId='" + procDefId + '\'' +
                ", bpmnDefId='" + bpmnDefId + '\'' +
                ", procDefKey='" + procDefKey + '\'' +
                ", procDefName='" + procDefName + '\'' +
                ", bizKey='" + bizKey + '\'' +
                ", sysCode='" + sysCode + '\'' +
                ", formKey='" + formKey + '\'' +
                ", status='" + status + '\'' +
                ", endTime=" + endTime +
                ", duration=" + duration +
                ", typeId='" + typeId + '\'' +
                ", resultType='" + resultType + '\'' +
                ", bpmnInstId='" + bpmnInstId + '\'' +
                ", isFormmal='" + isFormmal + '\'' +
                ", parentInstId='" + parentInstId + '\'' +
                ", superNodeId='" + superNodeId + '\'' +
                ", urgentState='" + urgentState + '\'' +
                ", creator='" + creator + '\'' +
                ", createBy='" + createBy + '\'' +
                ", createTime=" + createTime +
                ", createOrgId='" + createOrgId + '\'' +
                ", updateBy='" + updateBy + '\'' +
                ", updateTime=" + updateTime +
                ", isForbidden=" + isForbidden +
                ", createOrgPath='" + createOrgPath + '\'' +
                ", isDele=" + isDele +
                ", supportMobile=" + supportMobile +
                ", dataMode='" + dataMode + '\'' +
                ", authorizeRight=" + authorizeRight +
                ", taskName='" + taskName + '\'' +
                ", isBackToStart=" + isBackToStart +
                ", showModifyRecord=" + showModifyRecord +
                ", bpmFormKey='" + bpmFormKey + '\'' +
                ", updateSubjectWhenExist=" + updateSubjectWhenExist +
                '}';
    }
}
