package ${cfg.basePackage}.${cfg.moduleName}.entity;


import com.fasterxml.jackson.annotation.JsonFormat;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


/**
 * <pre>
 * 对象功能:流程任务 entity对象
 * 开发公司:广州宏天软件有限公司
 * 开发人员:zyp
 * 创建时间:2014-02-12 18:04:14
 * </pre>
 */

public class DefaultBpmTask {
    /***/
    private static final long serialVersionUID = 2240144872175803135L;

    protected String id; /* 任务ID */

    protected String name; /* 任务名称 */

    protected String subject; /* 待办事项标题 */

    protected String taskId = ""; /* 关联的任务ID */

    protected String execId; /* 关联 - 节点执行ID */

    protected String nodeId; /* 关联 - 任务节点ID */

    protected String procInstId; /* 关联 - 流程实例ID */

    protected String procDefId; /* 关联 - 流程定义ID */

    protected String instIsForbidden; /* 关联 - 流程实例是否禁止 */

    protected String procDefKey; /* 关联 - 流程定义KEY */

    protected String procDefName; /* 关联 - 流程名称 */

    protected String ownerId = "0"; /* 任务所属人ID */

    protected String assigneeId = "0"; /* 任务执行人ID */

    // 任务执行人人
    protected  String assigneeName = "";

    // 任务所属人
    protected  String ownerName = "";

    protected String status; /* 任务状态 */

    protected Long priority; /* 任务优先级 */
	@JsonFormat(shape= JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    protected LocalDateTime dueTime; /* 任务到期时间 */

    protected Short suspendState; /* 是否挂起(0正常,1挂起) */

    protected String parentId = "0";

    // 流程实例ID
    protected String bpmnInstId = "";

    protected String bpmnDefId = "";

    //类型ID
    protected String typeId = "";

    protected  Integer isRead = null;

    protected  Integer isRevoke = null;


    //支持手机表单
    protected int supportMobile=0;
	@JsonFormat(shape= JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    protected LocalDateTime createTime = LocalDateTime.now();

    //流转日期
    protected LocalDate transDate;

    // 流程分管授权权限对象
//    protected AuthorizeRight authorizeRight;

    //任务执行人是否为空，这个不保存到数据库。
    protected transient boolean isIdentityEmpty = false;
//
//    // 任务候选人
//    protected transient List<BpmIdentity> identityList = null;
//
//    protected transient SkipResult skipResult = new SkipResult();

    /* 流程创建时间 */
	@JsonFormat(shape= JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    protected  transient LocalDateTime createDate;

    /* 流程创建人ID */
    protected  String creatorId;

    /* 流程创建人名称 */
    protected  String creator;

    /* 流程状态 */
    protected  String instStatus;

    protected String leaderIds = ""; /* 共享的领导id集合 */


    protected boolean isGateway_=false;

    /* 计算时间的方式  worktime 工作日  caltime日历日 */
    protected String dueDateType;

    /* 任务到期时间 */
	@JsonFormat(shape= JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    protected LocalDateTime dueExpDate;

    /* 任务用时 */
    protected int dueTaskTime = 0;

    /* 任务已用时间 */
    protected int dueUseTaskTime = 0;

    /* dueStatus 是否进行过延迟申请  */
    protected int dueStatus;

    protected String urgentStateValue;

    // 是否bpm_task表的任务
    protected String isBpmTask;
	@JsonFormat(shape= JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    protected LocalDateTime deadline;

    protected String prop1;

    protected String prop2;

    protected String prop3;

    protected String prop4;

    protected String prop5;

    protected String prop6;


    protected String pcTaskUrl; /*pc端任务地址*/

    protected String mobileTaskUrl; /*mobile端任务地址*/


    /**  任务候选人 */
    protected transient List<DefaultBpmIdentity> identityList = null;

    protected transient SkipResult skipResult = new SkipResult();

    public Short getSuspendState() {
        return suspendState;
    }

    public String getParentId() {
        return parentId;
    }

    public Integer getIsRead() {
        return isRead;
    }

    public void setIsRead(Integer isRead) {
        this.isRead = isRead;
    }

    public Integer getIsRevoke() {
        return isRevoke;
    }

    public void setIsRevoke(Integer isRevoke) {
        this.isRevoke = isRevoke;
    }

    public boolean isGateway_() {
        return isGateway_;
    }

    public void setGateway_(boolean gateway_) {
        isGateway_ = gateway_;
    }

    public String getProp1() {
        return prop1;
    }

    public void setProp1(String prop1) {
        this.prop1 = prop1;
    }

    public String getProp2() {
        return prop2;
    }

    public void setProp2(String prop2) {
        this.prop2 = prop2;
    }

    public String getProp3() {
        return prop3;
    }

    public void setProp3(String prop3) {
        this.prop3 = prop3;
    }

    public String getProp4() {
        return prop4;
    }

    public void setProp4(String prop4) {
        this.prop4 = prop4;
    }

    public String getProp5() {
        return prop5;
    }

    public void setProp5(String prop5) {
        this.prop5 = prop5;
    }

    public String getProp6() {
        return prop6;
    }

    public void setProp6(String prop6) {
        this.prop6 = prop6;
    }

    public String getPcTaskUrl() {
        return pcTaskUrl;
    }

    public void setPcTaskUrl(String pcTaskUrl) {
        this.pcTaskUrl = pcTaskUrl;
    }

    public String getMobileTaskUrl() {
        return mobileTaskUrl;
    }

    public void setMobileTaskUrl(String mobileTaskUrl) {
        this.mobileTaskUrl = mobileTaskUrl;
    }

    public List<DefaultBpmIdentity> getIdentityList() {
        return identityList;
    }

    public void setIdentityList(List<DefaultBpmIdentity> identityList) {
        this.identityList = identityList;
    }

    public SkipResult getSkipResult() {
        return skipResult;
    }

    public void setSkipResult(SkipResult skipResult) {
        this.skipResult = skipResult;
    }

    public void setId(String id) {
        this.id = id;
    }


    /**
     * 返回 任务ID
     *
     * @return
     */
    public String getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    /**
     * 返回 任务名称
     *
     * @return
     */
    public String getName() {
        return this.name;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    /**
     * 返回 待办事项标题
     *
     * @return
     */
    public String getSubject() {
        return this.subject;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    /**
     * 返回 关联的任务ID
     *
     * @return
     */
    public String getTaskId() {
        return this.taskId;
    }

    public void setExecId(String execId) {
        this.execId = execId;
    }

    /**
     * 返回 关联 - 节点执行ID
     *
     * @return
     */
    public String getExecId() {
        return this.execId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    /**
     * 返回 关联 - 任务节点ID
     *
     * @return
     */
    public String getNodeId() {
        return this.nodeId;
    }

    public void setProcInstId(String procInstId) {
        this.procInstId = procInstId;
    }

    /**
     * 返回 关联 - 流程实例ID
     *
     * @return
     */
    public String getProcInstId() {
        return this.procInstId;
    }

    public void setProcDefId(String procDefId) {
        this.procDefId = procDefId;
    }

    /**
     * 返回 关联 - 流程定义ID
     *
     * @return
     */
    public String getProcDefId() {
        return this.procDefId;
    }

    public void setProcDefKey(String procDefKey) {
        this.procDefKey = procDefKey;
    }

    /**
     * 返回  流程定义的Key
     *
     * @return
     */
    public String getProcDefKey() {
        return this.procDefKey;
    }

    public void setProcDefName(String procDefName) {
        this.procDefName = procDefName;
    }

    /**
     * 返回 关联 - 流程名称
     *
     * @return
     */
    public String getProcDefName() {
        return this.procDefName;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    /**
     * 返回 任务所属人ID
     *
     * @return
     */
    public String getOwnerId() {
        return this.ownerId;
    }

    public void setAssigneeId(String assigneeId) {
        this.assigneeId = assigneeId;
    }

    /**
     * 返回 任务执行人ID
     *
     * @return
     */
    public String getAssigneeId() {
        return this.assigneeId;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * 返回 任务状态
     *
     * @return
     */
    public String getStatus() {
        return this.status;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    /**
     * 返回 任务优先级
     *
     * @return
     */
    public Long getPriority() {
        return this.priority;
    }

    public void setDueTime(LocalDateTime dueTime) {
        this.dueTime = dueTime;
    }

    /**
     * 返回 任务到期时间
     *
     * @return
     */
    public LocalDateTime getDueTime() {
        return this.dueTime;
    }

    public void setSuspendState(Short suspendState) {
        this.suspendState = suspendState;
    }


    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getBpmnInstId() {
        return bpmnInstId;
    }

    public void setBpmnInstId(String bpmnInstId) {
        this.bpmnInstId = bpmnInstId;
    }

    public String getBpmnDefId() {
        return bpmnDefId;
    }

    public void setBpmnDefId(String bpmnDefId) {
        this.bpmnDefId = bpmnDefId;
    }



    public String getDueDateType() {
        return dueDateType;
    }

    public void setDueDateType(String dueDateType) {
        this.dueDateType = dueDateType;
    }

    public LocalDateTime getDueExpDate() {
        return dueExpDate;
    }

    public void setDueExpDate(LocalDateTime dueExpDate) {
        this.dueExpDate = dueExpDate;
    }

    public int getDueTaskTime() {
        return dueTaskTime;
    }

    public void setDueTaskTime(int dueTaskTime) {
        this.dueTaskTime = dueTaskTime;
    }

    public int getDueUseTaskTime() {
        return dueUseTaskTime;
    }

    public void setDueUseTaskTime(int dueUseTaskTime) {
        this.dueUseTaskTime = dueUseTaskTime;
    }

    public int getDueStatus() {
        return dueStatus;
    }

    public void setDueStatus(int dueStatus) {
        this.dueStatus = dueStatus;
    }

    public boolean isIdentityEmpty() {
        return isIdentityEmpty;
    }

    public void setIdentityEmpty(boolean isIdentityEmpty) {
        this.isIdentityEmpty = isIdentityEmpty;
    }

    public String getOwnerName() {
        return ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }
    public String getAssigneeName() {
        return assigneeName;
    }

    public void setAssigneeName(String assigneeName) {
        this.assigneeName = assigneeName;
    }
    public LocalDateTime getCreateDate() {
        return createDate;
    }

    public void setCreateDate(LocalDateTime createDate) {
        this.createDate = createDate;
    }


    public String getCreatorId() {
        return creatorId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getInstStatus() {
        return instStatus;
    }

    public void setInstStatus(String instStatus) {
        this.instStatus = instStatus;
    }

    public String getTypeId() {
        return typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public LocalDate getTransDate() {
        return transDate;
    }

    public void setTransDate(LocalDate transDate) {
        this.transDate = transDate;
    }

    public int getSupportMobile() {
        return supportMobile;
    }

    public void setSupportMobile(int supportMobile) {
        this.supportMobile = supportMobile;
    }


    public void setIsGateWay(boolean isGateway) {
        this.isGateway_=isGateway;
    }


    public boolean isGateWay() {
        return isGateway_;
    }

    public String getInstIsForbidden() {
        return instIsForbidden;
    }

    public void setInstIsForbidden(String instIsForbidden) {
        this.instIsForbidden = instIsForbidden;
    }

    public String getUrgentStateValue() {
        return urgentStateValue;
    }


    public void setUrgentStateValue(String urgentStateValue) {
        this.urgentStateValue = urgentStateValue;
    }


    public String getLeaderIds() {
        return leaderIds;
    }


    public void setLeaderIds(String leaderIds) {
        this.leaderIds = leaderIds;
    }


    public String getIsBpmTask() {
        return isBpmTask;
    }


    public void setIsBpmTask(String isBpmTask) {
        this.isBpmTask = isBpmTask;
    }



    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public LocalDateTime getDeadline() {
        return deadline;
    }

    public void setDeadline(LocalDateTime deadline) {
        this.deadline = deadline;
    }

    @Override
    public String toString() {
        return "DefaultBpmTask{" +
                "id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", subject='" + subject + '\'' +
                ", taskId='" + taskId + '\'' +
                ", execId='" + execId + '\'' +
                ", nodeId='" + nodeId + '\'' +
                ", procInstId='" + procInstId + '\'' +
                ", procDefId='" + procDefId + '\'' +
                ", instIsForbidden='" + instIsForbidden + '\'' +
                ", procDefKey='" + procDefKey + '\'' +
                ", procDefName='" + procDefName + '\'' +
                ", ownerId='" + ownerId + '\'' +
                ", assigneeId='" + assigneeId + '\'' +
                ", assigneeName='" + assigneeName + '\'' +
                ", ownerName='" + ownerName + '\'' +
                ", status='" + status + '\'' +
                ", priority=" + priority +
                ", dueTime=" + dueTime +
                ", suspendState=" + suspendState +
                ", parentId='" + parentId + '\'' +
                ", bpmnInstId='" + bpmnInstId + '\'' +
                ", bpmnDefId='" + bpmnDefId + '\'' +
                ", typeId='" + typeId + '\'' +
                ", isRead=" + isRead +
                ", isRevoke=" + isRevoke +
                ", supportMobile=" + supportMobile +
                ", createTime=" + createTime +
                ", transDate=" + transDate +
                ", isIdentityEmpty=" + isIdentityEmpty +
                ", createDate=" + createDate +
                ", creatorId='" + creatorId + '\'' +
                ", creator='" + creator + '\'' +
                ", instStatus='" + instStatus + '\'' +
                ", leaderIds='" + leaderIds + '\'' +
                ", isGateway_=" + isGateway_ +
                ", dueDateType='" + dueDateType + '\'' +
                ", dueExpDate=" + dueExpDate +
                ", dueTaskTime=" + dueTaskTime +
                ", dueUseTaskTime=" + dueUseTaskTime +
                ", dueStatus=" + dueStatus +
                ", urgentStateValue='" + urgentStateValue + '\'' +
                ", isBpmTask='" + isBpmTask + '\'' +
                ", deadline=" + deadline +
                '}';
    }
}
