package ${cfg.basePackage}.${cfg.moduleName}.manager;

import com.hotent.base.model.CommonResult;

import java.util.HashMap;
import java.util.Map;

/**
* 流程数据处理服务
*
<#if cfg.companyName??>
    * @company ${cfg.companyName}
</#if>
* @author ${author}
<#if cfg.authorEmail??>
    * @email ${cfg.authorEmail}
</#if>
* @since ${date}
*/
public interface FlowEntityManager {

    /**
     * 表单数据转流程变量
     *
     * @param formData 表单数据
     * @return 流程变量
     */
    default Map<String, String> getVars(Map<String, Object> formData) {
        Map<String, String> vars = new HashMap<>(1);
        // todo 添加表单数据到流程变量中（key根据流程变量管理的key设置）
        //	if(StringUtil.isNotEmpty(formData.get("account"))){
        //		vars = new HashMap<>(1);
        //		vars.put("account", formData.get("account"));
        //	}
        return vars;
    }

    /**
     * 启动流程
     *
     * @param formData 表单数据
     * @param flowKey  流程key
     * @return 结果
     */
    CommonResult<String> start(Map<String, Object> formData, String flowKey);

    /**
     * 根据实例id获取流程状态
     *
     * @param instId 实例id
     * @return 结果
     * @throws Exception 错误
     */
    CommonResult<String> getStatusByInstId(String instId) throws Exception;

    /**
     * 根据业务主键获取流程状态
     *
     * @param id 业务主键
     * @return 结果
     * @throws Exception 错误
     */
    CommonResult<String> getStatusByBusinessId(String id) throws Exception;

    /**
     * 撤回到发起人
     *
     * @param instId 实例id
     * @return 结果
     * @throws Exception 错误
     */
    CommonResult<?> backToStart(String instId) throws Exception;

    /**
     * 同意流程
     *
     * @param instId 实例id
     * @return 结果
     * @throws Exception 错误
     */
    CommonResult<?> agree(String instId) throws Exception;
}