package ${cfg.basePackage}.${cfg.moduleName}.service;

import com.hotent.base.model.CommonResult;
import ${cfg.basePackage}.${cfg.moduleName}.entity.DefaultBpmProcessInstance;
import ${cfg.basePackage}.${cfg.moduleName}.vo.*;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@FeignClient(name = "eip", url = "<#noparse>${eip.url:http://eip8.hotent.com}</#noparse>")
public interface EipFeignService {
	/**
	 * 客户端启动流程
	 * @param startFlowParamObjectVo 入参
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/runtime/instance/v1/start", method = RequestMethod.POST, produces = { "application/json; charset=utf-8" })
	StartResult start(@RequestBody StartFlowParamObjectVo startFlowParamObjectVo, @RequestHeader("Authorization") String authorization)
		throws Exception;

	@RequestMapping(value = "/runtime/instance/v1/getBpmImage", method = RequestMethod.GET, produces = { "application/json; charset=utf-8" })
	String getBpmImage(@ApiParam(name = "proInstId", value = "proInstId") @RequestParam("proInstId") String proInstId,
					   @ApiParam(name = "isScale", value = "缩放比例") @RequestParam("scalePrcent") Double scalePrcent,
                       @RequestHeader("Authorization") String authorization) throws Exception;

	/**
	 * 获取流程实例明细
	 * @param proInstId 流程实例ID
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/runtime/instance/v1/instanceFlowImage", method = RequestMethod.GET, produces = {
		"application/json; charset=utf-8" })
	FlowImageVo instanceFlowImage(
            @ApiParam(name = "proInstId", value = "流程实例id", required = true) @RequestParam("proInstId") String proInstId,
			@ApiParam(name = "isScale", value = "缩放比例") @RequestParam("scalePrcent") Double scalePrcent,
            @RequestHeader("Authorization") String authorization) throws Exception;

	/**
	 * 获取流程实例中指定节点的审批意见
	 * @param instId 流程实例id
	 * @param nodeId 任务节点id，多个以逗号拼接
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value="/runtime/task/v1/nodeOpinion",method= RequestMethod.GET,produces = {"application/json; charset=utf-8" })
	Map<String, Object> nodeOpinion(@RequestParam(value = "instId", required = true) String instId,
                                    @RequestParam(value = "nodeId", required = true) String nodeId,
                                    @RequestHeader("Authorization") String authorization) throws Exception;

	/**
	 * 流程审批历史（页面数据）
	 * @param instId 流程实例id
	 * @param authorization 用户token
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/openApi/runtime/instance/v1/instanceFlowOpinions", method = RequestMethod.GET, produces = {
		"application/json; charset=utf-8" })
	CommonResult opinionHistory(
            @RequestParam(value = "instId") String instId,
            @RequestHeader("Authorization") String authorization) throws Exception;

	/**
	 * 处理任务（同意）
	 * @param doNextParamObjectVo 流程向下执行参数
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value="/runtime/task/v1/complete",method= RequestMethod.POST,produces = {
		"application/json; charset=utf-8" })
	CommonResult<String> complete(@RequestBody DoNextParamObjectVo doNextParamObjectVo,
                                  @RequestHeader("Authorization") String authorization) throws Exception;
	/**
	 * 通过实例id获取任务列表
	 * @param instId 实例id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value="/openApi/runtime/task/v1/getTasksByInstId",method= RequestMethod.GET,produces = {
		"application/json; charset=utf-8" })
	CommonResult getTasksByInstId(@RequestParam(value = "instId") String instId,
                                  @RequestHeader("Authorization") String authorization) throws Exception;

	@RequestMapping(value="/runtime/instance/v1/getByInstId",method= RequestMethod.GET,produces = {
			"application/json; charset=utf-8" })
	DefaultBpmProcessInstance getByInstId(@RequestParam("id") String id,
										  @RequestHeader("Authorization") String authorization) throws Exception;

	@RequestMapping(value="/runtime/instance/v1/getInstancetByBusinessKey",method= RequestMethod.GET,produces = {
			"application/json; charset=utf-8" })
	DefaultBpmProcessInstance getInstancetByBusinessKey(@RequestParam("businessKey") String businessKey,
										  @RequestHeader("Authorization") String authorization) throws Exception;

	/**
	 * 登录系统
	 * @param userAuthVo 入参
	 * @return
	 */
	@RequestMapping(value = "/auth", method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    ResponseEntity<Map<String,Object>> auth(@RequestBody UserAuthVo userAuthVo);
}
