package ${package.ServiceImpl};

import ${package.Entity}.${entity};
import ${package.Mapper}.${table.mapperName};
import ${package.Service}.${table.serviceName};
import ${superServiceImplClassPackage};
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

<#if cfg.isFlow>
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.hotent.base.model.CommonResult;
import com.hotent.module.entity.DefaultBpmProcessInstance;
import com.hotent.module.manager.FlowEntityManager;
import javax.annotation.Resource;

import com.hotent.module.service.FlowService;
import org.jsoup.helper.StringUtil;
import org.apache.logging.log4j.util.Strings;

import javax.annotation.Resource;
import java.util.Map;
</#if>


<#------------ 子表Manager包引入  ---------->
<#if cfg.boEntList?exists>
	<#list cfg.cgUtil.getSubModelInfo(cfg.boEntList,table.name) as subModel>
import ${package.Entity}.${subModel.className};
import ${package.Service}.${subModel.className}Manager;
	</#list>
</#if>
<#------------ END 子表Manager包引入 ---------->

/**
 * ${table.comment!} 服务实现类
 *
 <#if cfg.companyName??>
 * @company ${cfg.companyName}
 </#if>
 * @author ${author}
 <#if cfg.authorEmail??>
 * @email ${cfg.authorEmail}
 </#if>
 * @since ${date}
 */
@Service
<#if kotlin>
open class ${table.serviceImplName} : ${superServiceImplClass}<${table.mapperName}, ${entity}>(), ${table.serviceName} {

}
<#else>
public class ${table.serviceImplName} extends ${superServiceImplClass}<${table.mapperName}, ${entity}> implements ${table.serviceName} <#if cfg.isFlow>,FlowEntityManager</#if> {
<#if cfg.type != "querySqldef">
<#------------ 子表Manager注入  ---------->
<#if cfg.boEntList?exists>
	<#list cfg.cgUtil.getSubModelInfo(cfg.boEntList,table.name) as subModel>
	
 	@Resource
	${subModel.className}Manager ${subModel.className?uncap_first}Manager;
	</#list>
</#if>
<#------------END 子表Manager注入  ---------->
<#------------ 流程相关方法  ---------->
<#if cfg.isFlow>
	@Resource
	FlowService flowService;
</#if>
<#------------ END 流程相关方法  ---------->

	@Override
	public ${entity} getDetail(String id) {
    	${entity} ${entity?uncap_first} = this.get(id);
    	
<#------------ 子表数据获取  ---------->		
<#if cfg.boEntList?exists>
	<#list cfg.cgUtil.getSubModelInfo(cfg.boEntList,table.name) as subModel>
		// 获取子表 ${subModel.comment}数据
		QueryWrapper<${subModel.className}> ${subModel.className?uncap_first}QueryWrapper = new QueryWrapper<>();
		${subModel.className?uncap_first}QueryWrapper.eq("REF_ID_", id);
		List<${subModel.className}> ${subModel.className?uncap_first}List = ${subModel.className?uncap_first}Manager.list(${subModel.className?uncap_first}QueryWrapper);
		${entity?uncap_first}.set${subModel.propertyName?cap_first}(${subModel.className?uncap_first}List);
		<#if (cfg.cgUtil.getSubModelInfo(cfg.boEntList,subModel.tableName)?size>0) >
		${subModel.className?uncap_first}List.forEach(e->{
			try {
				BeanUtils.copyNotNullProperties(e, ${subModel.className?uncap_first}Manager.getDetail(e.getId()));
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		});
		</#if>
	</#list>
</#if>
<#------------ END 子表数据获取  ---------->	

		return ${entity?uncap_first};
	}
	@Override
	@Transactional
	public void createOrUpdate(${entity} ${entity?uncap_first}) {
		//新建或更新
		this.saveOrUpdate(${entity?uncap_first});
<#------------ 子表数据增删改查  ---------->		
<#if cfg.boEntList?exists>
	<#if cfg.cgUtil.getSubModelInfo(cfg.boEntList,table.name)?? && (cfg.cgUtil.getSubModelInfo(cfg.boEntList,table.name)?size>0) >
		//主表主键
		String refId = ${entity?uncap_first}.getId();
		</#if>
		<#list cfg.cgUtil.getSubModelInfo(cfg.boEntList,table.name) as subModel>
		//删除${subModel.comment}数据
		QueryWrapper<${subModel.className}> ${subModel.className?uncap_first}QueryWrapper = new QueryWrapper<>();
		${subModel.className?uncap_first}QueryWrapper.eq("REF_ID_", refId);
		${subModel.className?uncap_first}Manager.remove(${subModel.className?uncap_first}QueryWrapper);
		List<${subModel.className}> ${subModel.className?uncap_first}List = ${entity?uncap_first}.get${subModel.propertyName?cap_first}();
		if(BeanUtils.isNotEmpty(${subModel.className?uncap_first}List)){
			${subModel.className?uncap_first}List.forEach(item->{
				//设置主表主键
				item.setRefId(refId);
				//保存${subModel.comment}数据
				${subModel.className?uncap_first}Manager.createOrUpdate(item);
			});
		}
	
	</#list>
</#if>
<#------------ END 子表数据增删改查  ---------->		
	}

	<#------------ 流程相关方法  ---------->
	<#if cfg.isFlow>
		@Override
		public CommonResult<String> start(Map<String, Object> formData, String flowKey) {
			${entity} bean = BeanUtil.toBean(formData, ${entity}.class);
			DefaultBpmProcessInstance instance = flowService.start("admin", flowKey, bean.getId(), getVars(formData));
			if(instance == null || StringUtil.isBlank(instance.getId())){
				return CommonResult.error("启动流程返回的实例详情为空！");
			}

			BeanUtil.setProperty(bean, "${cfg.instIdProp}", instance.getId());
			BeanUtil.setProperty(bean, "${cfg.flowStatusProp}", "running");
			this.updateById(bean);

			return CommonResult.success("启动成功：" + instance.getSubject());
		}

		@Override
		public CommonResult<String> getStatusByInstId(String instId) throws Exception {
			String status = flowService.getStatusByInstId(instId);
			// 更新实例状态
			Wrapper<${entity}> wrapper = Wrappers.<${entity}>query().eq("${cfg.instIdProp}", instId);
			${entity} one = this.getOne(wrapper);
			if(one != null){
				BeanUtil.setProperty(one, "${cfg.flowStatusProp}", status);
				this.update(one);
			}
			return CommonResult.success(status);
		}

		@Override
		public CommonResult<String> getStatusByBusinessId(String id) throws Exception {
			// 等待1秒后再获取
			Thread.sleep(2000);
			DefaultBpmProcessInstance instance = flowService.getStatusByBusinessId(id);
			// 更新实例状态
			${entity} one = this.getById(id);
			if(one != null){
				BeanUtil.setProperty(one, "${cfg.flowStatusProp}", instance.getStatus());
				this.update(one);
			}
			return CommonResult.success(instance.getStatus());
		}

		@Override
		public CommonResult<?> backToStart(String instId) throws Exception {
				//获取业务信息
				Wrapper<${entity}> wrapper = Wrappers.<${entity}>query().eq("${cfg.instIdProp}", instId);
				${entity} one = this.getOne(wrapper);
				CommonResult<?> result = flowService.complete(instId, one.getId(), Strings.EMPTY, "backToStart", getVars(BeanUtil.beanToMap(one)));
				if(result.getState()){
					BeanUtil.setProperty(one, "${cfg.flowStatusProp}", "backToStart");
					this.updateById(one);
				}
				return result;
		}

		@Override
		public CommonResult<?> agree(String instId) throws Exception {
			//获取业务信息
			Wrapper<${entity}> wrapper = Wrappers.<${entity}>query().eq("${cfg.instIdProp}", instId);
			${entity} one = this.getOne(wrapper);
			return flowService.complete(instId, one.getId(), Strings.EMPTY, "agree", getVars(BeanUtil.beanToMap(one)));
		}
	</#if>
	<#------------ END 流程相关方法  ---------->
</#if>
}
</#if>
