<#--
Name: 数据列表模板
Desc:数据列表模板

本模板需要通过2次解析才能得到最终的Html
第一次解析：
*************************************************************
*************************************************************
*数据模型:****************************************************
*************************************************************
*************************************************************

tbarTitle：Tool Bar 的标题

********************************************
conditionFields:条件字段
--joinType：	条件联合类型
--name：	列名
--name：完全指定名
--operate：条件类型: =|>=|<=|….
--comment：注释
--type：	类型
--value：值
--valueFrom：值来源

************************************************************
displayFields：显示字段
--name：列名
--name：完全指定名
--label：别名
--index：索引
--comment：注释
--type：类型

******************************************************
tableIdCode:Table ID Code

**************************************************
displayId: 自定义显示的ID

**************************************************
pageHtml：分页的Html 详见pageAjax.xml

*************************************************
pageURL：当前页面的URL

searchFormURL：搜索表单的Action


sortField：当前排序字段

orderSeq：当前的排序类型

***********************************************
pkcols:主键列

deleteBaseURL：删除一行数据的BaseURL
editBaseURL：编辑一行数据的BaseURL
 -->


<#setting number_format="#">
<#assign displayFields=bpmDataTemplate.displayField?eval>
<#assign conditionFields=bpmDataTemplate.conditionField?eval>
<#assign filterFields=bpmDataTemplate.filterField?eval>
<#assign manageFields=bpmDataTemplate.manageField?eval>
<#assign sortFields=bpmDataTemplate.sortField?eval>
<#assign tableConfigure=bpmDataTemplate.tableConfigure?eval>
<#assign treeFields=bpmDataTemplate.treeField?eval>
<#assign summaryFields=bpmDataTemplate.summaryField?eval>
<#assign summaryRegionHtml=bpmDataTemplate.summaryRegionHtml>


<#noparse>
	<#setting number_format="#">
	<#assign displayFields=bpmDataTemplate.displayField?eval>
	<#assign conditionFields=bpmDataTemplate.conditionField?eval>
	<#assign filterFields=bpmDataTemplate.filterField?eval>
	<#assign manageFields=bpmDataTemplate.manageField?eval>
	<#assign sortFields=bpmDataTemplate.sortField?eval>
	<#assign tableConfigure=bpmDataTemplate.tableConfigure?eval>
	<#assign boAlias=bpmDataTemplate.boDefAlias>
	<#assign templateId=bpmDataTemplate.id>
	<#assign templateAlias=bpmDataTemplate.alias>
	<#assign pageSize=bpmDataTemplate.pageSize>
	<#assign urlPre="$">
</#noparse>

<#--日期选择器 日期范围 日期时分秒 普通日期-->
<#macro genQueryDate field>
	<#switch field.qt>
		<#case "between">
			<ht-date-picker
        size="mini"
        v-model="searchForm.${field.colPrefix!}${field.na}"
         <#if field.ctrlType!="">type="${field.ctrlType}"<#else>type="daterange"</#if>
        class="search-item"
        range-separator="至"
        start-placeholder="开始日期"
        end-placeholder="结束日期"
        operation="${field.qt}"
        placeholder="${field.cm}"
        ht-query="${field.colPrefix!}${field.na}"
        name="Q^${field.colPrefix!}${field.na}^${field.qt}"
        <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if>
        <#if field.format>
          value-format="${field.format}"
          format="${field.format}"
        <#else>
          value-format="yyyy-MM-dd HH:mm:ss"
          format="yyyy-MM-dd HH:mm:ss"
        </#if>
        <#if field.option?if_exists>
          format="${field.option.dateFormat}"
          <#if field.option.dateFormat = 'yyyy-MM-dd'></#if>
          :default-time="['00:00:00','23:59:59']"
        </#if>
			></ht-date-picker>
			<#break>
		<#default>
			<ht-date
        size="mini"
        v-model="searchForm.${field.colPrefix!}${field.na}"
       <#if field.ctrlType!="">type="${field.ctrlType}"<#else>type="date"</#if>
        class="search-item"
        placeholder="${field.cm}"
        ht-query="${field.colPrefix!}${field.na}"
        name="Q^${field.colPrefix!}${field.na}^${field.qt}"
        <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if>
        <#if field.option?if_exists>
          format="${field.option.dateFormat}"
          value-format="${field.option.dateFormat}"
          <#if field.option.dateFormat == 'yyyy-MM-dd' && field.qt == 'EQUAL' >
            operation="RIGHT_LIKE"
          <#else>
            operation="${field.qt}"
          </#if>
        <#else>
          <#if field.format>
          value-format="${field.format}"
          format="${field.format}"
        <#else>
          value-format="yyyy-MM-dd"
          format="yyyy-MM-dd"
        </#if>
          operation="${field.qt}"
        </#if>
			></ht-date>
			<#break>
	</#switch>
</#macro>

<#--单选按钮或复选框 -->
<#function getCheckboxOrRadio field>
	<#assign rtn>
		<#if field.controlContent?if_exists>
			<#if field.controlContent?if_exists>
				<#if field.ct=='radio'>
<#--  					<el-radio-group size="mini" v-model="searchForm.${colPrefix}${field.na}" class="search-item" operation="${field.qt}" ht-query="${colPrefix}${field.na}" name="Q^${colPrefix}${field.na}^${field.qt}">
						<#list field.controlContent as opt>
							<el-radio label="${opt.key}">${opt.value}</el-radio>
						</#list>
					</el-radio-group>  -->
           <ht-radio size="mini" v-model="searchForm.${field.colPrefix!}${field.na}" class="search-item" operation="${field.qt}" ht-query="${field.colPrefix!}${field.na}" name="Q^${field.colPrefix!}${field.na}^${field.qt}"
                   <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if>
                   :props="{key:'key',value:'value'}"
                    rdlist='${util.getJsonByPath(field,'controlContent')}'
        >
        </ht-radio>
				<#else>
					<el-checkbox-group size="mini" v-model="searchForm.${field.colPrefix!}${field.na}" class="search-item" operation="${field.qt}" ht-query="${field.colPrefix!}${field.na}" name="Q^${field.colPrefix!}${field.na}^${field.qt}">
						<#list field.controlContent as opt>
							<el-checkbox label="${opt.key}">${opt.value}</el-checkbox>
						</#list>
					</el-checkbox-group>
				<#--<#assign controlContent=util.getJsonByPath(field,'controlContent')>
                <ht-checkbox v-model="searchForm.${colPrefix}${field.na}" cklist='${controlContent}' permission='w' operation="${field.qt}" ht-query="${colPrefix}${field.na}" name="Q^${colPrefix}${field.na}^${field.qt}"  -->
				</#if>
			</#if>
		</#if>
	</#assign>
	<#return rtn>
</#function>

<#-- 获取按钮的主题，没有的话默认为primary -->
<#function getBtnTheme manage>
	<#return 1>
</#function>

<#--获取条件-->
<#function getCondition condition field>
	<#assign rtn="">
	<#list condition as con>
	<#--处理运算符-->
		<#assign operate=con.op >
	<#--处理值-->
		<#assign val=con.val >
		<#if (field.dataType=="varchar") >
			<#assign val="'"+val+"'" >
		</#if>

		<#if con_index==0>
			<#assign rtn="value" + operate + val >
		<#else>
			<#assign rtn=rtn + " && value" + operate + val >
		</#if>
	</#list>
	<#return rtn>
</#function>


<#--根据视图类型返回对应的视图模板 type：视图类型 isTab：是否以tab展示。是则custom-table-height减掉tab页签的高度 -->
<#function getViewByType type isTab>
	<#assign rtn>
		<#if type==1>
			<ht-table
	          ref="multipleTemplateTable"
	          <#noparse>id="${templateAlias}"</#noparse>
	          :data="rows"
	          header-cell-class-name="todo-header-row"
	          row-class-name="todo-row"
	          size="mini"
	          @selection-change="handleSelectionChange"
	          quickSearchPlaceholder="${conditionAllDesc}"
	          :quick-search-props="handleQuickSearchParams('${conditionAllName}','${conditionAllDesc}')"
	          @load="search"
	          :showExport="false"
	          :selectable="false"
			  :defaultQuerys="buildDefaultQuerys(false)"
	          :auto-fix="true"
			  :rowKey="getRowKey"
	           pagination-justify="end"
     		  :page-sizes="pageSizes"
     		  :page-result="pagination"
			  @filter-change="filterChange"
	        >
	          <template v-slot:toolbar>
	            <div class="top_btn_col" v-if="!hideButton">
	              <#noparse>
	              
	              <el-dropdown
                      type="default"
                      size="mini"
                      style="margin-right: 10px ;"
                      class="dropdown-upload__btn data-form-list__top-btn"
                    >
                        <el-button
                          size="mini"
                          type="default"
                        >
                          {{ $td('formTemplate.bdty.button.action', '新增') }}
                          <i class="el-icon-arrow-down el-icon--right"></i>
                        </el-button>
                      <el-dropdown-menu slot="dropdown">

                        <el-dropdown-item>
                          <p @click="scriptClick('add', '', {templateId:'${templateId}',id:'',action:'add',defId:'${bpmDataTemplate.defId}'})">{{ $td('formTemplate.bdty.button.export', '新增') }}</p>
                        </el-dropdown-item>
                        <el-dropdown-item>
                           <p @click="scriptClick('copyRow')" >{{ $td('formTemplate.bdty.button.add', '复制') }}</p>
                        </el-dropdown-item>
                      </el-dropdown-menu>
                    </el-dropdown>
                    
	                <#list manageFields as manage>
	                  <@genToolBar manage=manage managePermission=managePermission actionUrl=actionUrl btnIndex=manage_index/>
	                </#list>
	                
                    <el-dropdown
                      type="default"
                      size="mini"
                      style="margin-left: 10px ;"
                      class="dropdown-upload__btn data-form-list__top-btn"
                    >
                        <el-button
                          size="mini"
                          type="default"
                        >
                          关联查询
                          <i class="el-icon-arrow-down el-icon--right"></i>
                        </el-button>
                      <el-dropdown-menu slot="dropdown">
                      	<el-dropdown-item ><p @click="exports('${manage.exportSettingFields}')">客户工程信息</p></el-dropdown-item>
                      	<el-dropdown-item ><p @click="exports('${manage.exportSettingFields}')">合价合同</p></el-dropdown-item>
                      	<el-dropdown-item ><p @click="exports('${manage.exportSettingFields}')">信用账户</p></el-dropdown-item>
                      </el-dropdown-menu>
                    </el-dropdown>
	                
	                <el-dropdown
                      type="default"
                      size="mini"
                      style="margin-left: 10px ;"
                      class="dropdown-upload__btn data-form-list__top-btn"
                    >
                        <el-button
                          size="mini"
                          type="default"
                        >
                          业务操作
                          <i class="el-icon-arrow-down el-icon--right"></i>
                        </el-button>
                      <el-dropdown-menu slot="dropdown">
                      	<el-dropdown-item ><p @click="scriptClick('updateData','',{value:1})">启用</p></el-dropdown-item>
                      	<el-dropdown-item ><p @click="scriptClick('updateData','',{value:0})">禁用</p></el-dropdown-item>
                      </el-dropdown-menu>
                    </el-dropdown>
	                
	                <el-dropdown
                      type="default"
                      size="mini"
                      style="margin-left: 10px ;"
                      class="dropdown-upload__btn data-form-list__top-btn"
                    >
                        <el-button
                          size="mini"
                          type="default"
                        >
                          {{ $td('formTemplate.bdty.button.action', '选项') }}
                          <i class="el-icon-arrow-down el-icon--right"></i>
                        </el-button>
                      <el-dropdown-menu slot="dropdown">
					    <el-dropdown-item  v-show="hasSearchQuery"><p @click="exports('${manage.exportSettingFields}','searchResult')">{{ $td('formTemplate.bdty.button.export', '导出查询结果') }}</p></el-dropdown-item>
						<el-dropdown-item  v-show="hasSelectedData" ><p @click="exports('${manage.exportSettingFields}','selected')">{{ $td('formTemplate.bdty.button.export', '导出选中数据') }}</p></el-dropdown-item>
                      	<el-dropdown-item><p @click="exports('${manage.exportSettingFields}','all')">{{ $td('formTemplate.bdty.button.export', '导出全部数据') }}</p></el-dropdown-item>
                        <el-dropdown-item><el-upload class="import-upload" action="" :show-file-list="false" :http-request="importMain" accept=".xls,.xlsx" >{{ $td('formTemplate.bdty.button.import', '导入') }}</el-upload></el-dropdown-item>
                      </el-dropdown-menu>
                    </el-dropdown>
                    
	              </#noparse>
	              <#--
	                <#noparse>
								<#list manageFields as manage>
	                    <@myDraftListToolBar manage=manage managePermission=managePermission actionUrl=actionUrl />
	                  </#list>
	                </#noparse>
	              -->
	            </div>
	          </template>
	          <#if conditionFields?if_exists>
	            <template v-slot:search>
	              <ht-table-search-panel v-model="searchForm" :divide="3" :label-width="120">
	                <#list conditionFields as field>
	                  <@genCondition field=field/>
	                </#list>
	              </ht-table-search-panel>
	            </template>
	          </#if>
	          <ht-table-column v-if="getFixed('left') && listSelectable" key="selector"  type="selection" width="55" align="center" <#if summaryFields?if_exists>:reserveSelection="true"</#if>></ht-table-column>
	          <ht-table-column type="index" key="tIndex" width="60" :label="$td('eip.common.index', '序号')" align="center" :fixed="getFixed('left')"></ht-table-column>
	          <#list displayFields as field>
	            ${genElTableColumn(field)}
	          </#list>
	          <#noparse>
	            <#if (manageFields?size > 0) >
	          </#noparse>
	          <ht-table-column
	            :fixed="getFixed('right')"
	            :label="$td('eip.common.operation', '操作')"
	            class-name="right_menu"
	            align="${tableConfigure.opterateAlign}"
	            width="${tableConfigure.operateWidth}"
	            v-if="!notPrint && showRightMenu && !hideButton"
	          >
	            <template slot-scope="scope">

									<#noparse><#if managePermissionState == true> </#noparse>
	                <ht-dropdown v-if="filedList.length > 0">
	                    <div class="template-dropdown-item" slot="genFirstBtn">
	                      <div v-if="false"></div>
	                      <#noparse>
	                      <#list manageFields as manage>
	                          <@genFirstBtn manage=manage managePermission=managePermission actionUrl=actionUrl data=data/>
	                      </#list>
	                      <div v-else class="not_children_dropdown" ></div>
	                      </#noparse>
	                    </div>

	                    <template slot="genManage" v-if="filedList.length > 1">
	                      <el-dropdown-item v-if='isJoinFlow=="true"' @click.native='complete(scope.row,taskType);'  plain>{{$td('eip.common.taskDetails', '任务明细')}}</el-dropdown-item>
	                      <#noparse>
	                        <#list manageFields as manage>
	                          <@genManage manage=manage managePermission=managePermission actionUrl=actionUrl data=data/>
	                        </#list>
	                      </#noparse>
	                    </template>
	                </ht-dropdown>
								<#--  	<el-dropdown  v-if="filedList.length > 0"name="templateDropdown_" size="mini" class="template-dropdown" split-button trigger="click" placement="bottom">
	               <div class="template-dropdown-item">
	                  <div v-if="false"></div>
	                  <#noparse>
	                  <#list manageFields as manage>
	                      <@genFirstBtn manage=manage managePermission=managePermission actionUrl=actionUrl data=data/>
	                  </#list>
	                  <div v-else class="not_children_dropdown" ></div>
	                  </#noparse>
	                </div>
				          <el-dropdown-menu slot="dropdown" v-if="filedList.length > 1">
					          <el-dropdown-item v-if='isJoinFlow=="true"' @click.native='complete(scope.row,taskType);'  plain>{{$td('eip.common.taskDetails', '任务明细')}}</el-dropdown-item>
					          <#noparse>
	                    <#list manageFields as manage>
	                      <@genManage manage=manage managePermission=managePermission actionUrl=actionUrl data=data/>
	                    </#list>
				            </#noparse>
	                </el-dropdown-menu>
				        </el-dropdown>  -->
							<#noparse>	</#if > </#noparse>
	              <#noparse>
	                <#list manageFields as manage>
	                <!-- 开关按钮 -->
	                  <#if manage.name == 'switch' >
	                  <#if util.fieldPermissionValidation('switch', managePermission, manage.desc, manage.switchOn, manage.switchOff)>
	                    <el-tooltip v-show="execScript('${manage.beforeScriptValue}',scope.row)" content="${manage.desc}" effect="dark" >
	                      <el-switch
	                        @change='scriptClick("switch","${manage.afterScriptValue}",{pkField:scope.row.${pkField},switchOn:"${manage.switchOn}",switchOff:"${manage.switchOff}",bind:"${manage.bind}",row:scope.row,switchDefaultTrue:"${manage.switchDefaultTrue}"})'
	                        :value="getBindValue(scope.row,'${manage.bind}')"
	                        active-value="${manage.switchOn}"
	                        inactive-value="${manage.switchOff}"
	                        active-text="${manage.switchOnLabel}"
					                inactive-text="${manage.switchOffLabel}"
	                        v-if="matchBind(scope.row,'${manage.bind}','${manage.switchOn}','${manage.switchOff}')"
	                      >
	                      </el-switch>
	                      <el-switch
	                        @change='scriptClick("switch","${manage.afterScriptValue}",{pkField:scope.row.${pkField},switchOn:"${manage.switchOn}",switchOff:"${manage.switchOff}",bind:"${manage.bind}",row:scope.row,switchDefaultTrue:"${manage.switchDefaultTrue}"})'
	                        active-value="${manage.switchOn}"
	                        inactive-value="${manage.switchOff}"
	                        active-text="${manage.switchOnLabel}"
					                inactive-text="${manage.switchOffLabel}"
	                        :value="'${manage.switchDefaultTrue}'=='true'?'${manage.switchOn}':'${manage.switchOff}'"
	                        v-else
	                      >
	                      </el-switch>
	                    </el-tooltip>
	                  </#if>
	                  </#if>
	                </#list>
	              </#noparse>
	              <#--							<#noparse>-->
	              <#--								<#if (manageFields?size == 1) >-->
	              <#--							</#noparse>-->
	              <#--                            <#noparse>-->
	              <#--		                        <#list manageFields as manage>-->
	              <#--		                           <@genManage manage=manage managePermission=managePermission actionUrl=actionUrl data=data/>-->
	              <#--		                        </#list>-->
	              <#--                                <#list manageFields as manage>-->
	              <#--                                    <#if manage.name == 'startFlow'>-->
	              <#--                                        <el-button size="mini" type="text" v-if='!scope.row.isStartFlow&&"${bpmDataTemplate.defId}"' @click='startFlow(scope.row.${pkField});'  plain>启动流程</el-button>-->
	              <#--                                    </#if>-->
	              <#--                                </#list>-->
	              <#--		                        <el-button size="mini" type="text" v-if='isJoinFlow=="true"' @click='complete(scope.row,taskType);'  plain>任务明细</el-button>-->
	              <#--								<#list manageFields as manage>-->
	              <#--									<#if manage.name == 'startFlow'>-->
	              <#--									<el-button size="mini" type="text" v-if='!scope.row.isStartFlow&&"${bpmDataTemplate.defId}"' @click='startFlow(scope.row.${pkField});'  plain>启动流程</el-button>-->
	              <#--									</#if>-->
	              <#--								</#list>-->
	              <#--		                    </#noparse>-->
	              <#--							<#noparse>-->
	              <#--							</#if>-->
	              <#--							</#noparse>-->
	            </template>
	          </ht-table-column>
	          <#noparse>
	            </#if>
	          </#noparse>
	        </ht-table>
	        

		<#elseif type==2>

			<el-main class="table-main">

		   <span id="printData1">
	        <ht-gantt
	          ref="multipleTemplateTable"
	          <#noparse>id="${templateAlias}"</#noparse>
	          :data="rows"
	          stripe
	          border
	          :custom-table-height="currentTableHeight <#if isTab>-40</#if>"
	          style="width: 100%"
	          header-cell-class-name="todo-header-row"
	          row-class-name="todo-row"
	          size="mini"
	          @selection-change="handleSelectionChange"
	          quickSearchPlaceholder="${conditionAllDesc}"
	          :quick-search-props="handleQuickSearchParams('${conditionAllName}','${conditionAllDesc}')"
	          @load="search"
	          :showExport="false"
	          :selectable="false"
	          :nopagination="true"
						:defaultQuerys="buildDefaultQuerys(false)"
	          :auto-fix="true"
						:rowKey="getRowKey"
	          :isDataTemplateList="true"
	          ganttConfig="${bpmDataTemplate.ganttConfig}"
			  v-loading="multipleTemplateTableloading"
			  :bpmDataTemplate="templateInfo"
			  pkField="${pkField}"
			   <#noparse>managePermission="${base64.getBase64(JsonUtil.toJsonString(managePermission))}"</#noparse>
			  @gantt-task-update="updateTemplateRowData"
			  @gantt-btn-click="scriptClick"
			  @filter-change="filterChange"
	        >
	          <template v-slot:toolbar>
	            <div class="top_btn_col">
	              <#noparse>
	                <#list manageFields as manage>
	                   <#if manage.name == 'add' || manage.name == 'export' || manage.name == 'import'>
			              <@genToolBar manage=manage managePermission=managePermission actionUrl=actionUrl btnIndex=manage_index/>
			           </#if>
	                </#list>
	              </#noparse>
	              <#--
	                <#noparse>
								<#list manageFields as manage>
	                    <@myDraftListToolBar manage=manage managePermission=managePermission actionUrl=actionUrl />
	                  </#list>
	                </#noparse>
	              -->
	            </div>
	          </template>
	          <#if conditionFields?if_exists>
	            <template v-slot:search>
	              <ht-table-search-panel v-model="searchForm" :divide="3" :label-width="120">
	                <#list conditionFields as field>
	                  <@genCondition field=field/>
	                </#list>
	              </ht-table-search-panel>
	            </template>
	          </#if>

	        </ht-gantt>
	      </span>
	    </el-main>

	    <el-footer height="45px" style='display: flex;
    justify-content: flex-end;
    align-items: center;'>
	      <el-row type="flex" justify="end" align="middle">
	        <el-pagination
	          background
	          v-if="templateInfo && templateInfo.needPage && templateInfo.needPage===1"
	          @size-change="handleSizeChange"
	          @current-change="handleCurrentChange"
	          :current-page="pagination.page"
	          :page-sizes="[10, 20, 30, 50, 100, 200, 300]"
	          :page-size="pagination.pageSize"
	          :layout="paginationLayout"
	          :total="total"
	        >
	        </el-pagination>
	      </el-row>
	     </el-footer>
		<#elseif type == 3>
      <div class="table-main" style="width: 100%;">
		        <ht-xmind
		          ref="multipleTemplateTable"
		          <#noparse>id="${templateAlias}"</#noparse>
		          :data="allRows"
		          :custom-table-height="currentTableHeight <#if isTab>-44</#if>"
		          style="width: 100%;height: 100%;"
		          @load="search"
				  v-loading="multipleTemplateTableloading"
				  :bpmDataTemplate="templateInfo"
				  pkField="${pkField}"
				   <#noparse>managePermission="${base64.getBase64(JsonUtil.toJsonString(managePermission))}"</#noparse>
				  @xmind-task-update="updateTemplateRowData"
				  @xmind-btn-click="scriptClick"
		        >
		          <template v-slot:toolbar>
		              <#noparse>
		                <#list manageFields as manage>
		                   <#if manage.name == 'add' || manage.name == 'export' || manage.name == 'import'>
				              <@genToolBar manage=manage managePermission=managePermission actionUrl=actionUrl btnIndex=manage_index/>
				           </#if>
		                </#list>
		              </#noparse>
		          </template>
		        </ht-xmind>
        </div>
		<#else>
			<#assign kanbanConfig=bpmDataTemplate.kanbanConfig?eval>
			<ht-kanban
					ref="multipleTemplateTable"
					:data="allRows"
					:template-info="templateInfo"
					@load="search"
					@add="(param) => scriptClick('add', '', param)"
					@edit="(param) => scriptClick('edit', '', param)"
					@remove="(param) => scriptClick('del', '', param)"
					:quick-search-props="handleQuickSearchParams('${conditionAllName}','${conditionAllDesc}')"
					v-loading="multipleTemplateTableloading"
					@selection-change="handleSelectionChange"
					<#noparse>manage-permission="${base64.getBase64(JsonUtil.toJsonString(managePermission))}"</#noparse>
			>
				<#if conditionFields?if_exists>
					<template v-slot:search>
						<ht-table-search-panel v-model="searchForm" :divide="3" :label-width="120">
							<#list conditionFields as field>
								<@genCondition field=field/>
							</#list>
						</ht-table-search-panel>
					</template>
				</#if>
				<template v-slot:toolbar>
					<#noparse>
						<#list manageFields as manage>
							<#if manage.name != 'print' && manage.name != 'url' && manage.name != 'addFlow' && manage.name != 'addData' && manage.name != 'searchData'&& manage.name != 'startFlow'>
								<@genToolBar manage=manage managePermission=managePermission actionUrl=actionUrl btnIndex=manage_index isKanban=true/>
							</#if>
						</#list>
					</#noparse>
				</template>
			</ht-kanban>
		</#if>
	</#assign>
	<#return rtn>
</#function>

<#--生成格式化函数-->
<#macro genFormaterFunction>
	<#if displayFields?if_exists>
		<#list displayFields as field>
			<#assign alarmSetting=field.alarmSetting >
			<#assign formater=field.formater>
			<#if formater?if_exists>
				function ${field.name}_Formater(value, row, index){
				${formater};
				}
			<#elseif alarmSetting?if_exists>
				<#assign alarm=alarmSetting >
				function ${field.name}_AlarmFormater(value, row, index){
				<#list alarm as item>
					if(${getCondition(item.condition,field)}){
					return "<span style='color:${item.color};font-weight:bold;'>" + value +"</span>";
					}
				</#list>
				return value;
				}

			</#if>
		</#list>
	</#if>
</#macro>

<#--生成查询条件宏 -->
<#macro genCondition field>
	<#assign content=field.controlContent>
	<ht-table-search-field :label="$td('${'formTemplate.${bpmDataTemplate.alias}.search.${field.name}'}', '${field.cm}')" prop="${field.na}" v-model="searchForm.${field.colPrefix!}${field.na}" style="padding-right:10px;" v-if="display('${field.mpDisplay}')" v-show="${!field.isShow}">
		<#if field.vf=="static" >
		<#-- colPrefix如果是外部表，值是返回"",非外部表的话就会有一个前缀，所以这里直接用这个拼接就行 -->
			<#switch field.ct>
				<#case "onetext">
					<#if field.ty == 'number'>
						<ht-input type="number" size="mini" class="search-item" ht-query="${field.colPrefix!}${field.na}" v-model="searchForm.${field.colPrefix!}${field.na}" operation="${field.qt}" :placeholder="$td('${'formTemplate.${bpmDataTemplate.alias}.search.${colPrefix}${field.na}'}', '${field.cm}')"  name="Q^${field.colPrefix!}${field.na}^${field.qt}" <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if> clearable></ht-input>
					<#else>
						<ht-input type="text" size="mini" class="search-item" ht-query="${field.colPrefix!}${field.na}" v-model="searchForm.${field.colPrefix!}${field.na}" operation="${field.qt}" :placeholder="$td('${'formTemplate.${bpmDataTemplate.alias}.search.${colPrefix}${field.na}'}', '${field.cm}')"  name="Q^${field.colPrefix!}${field.na}^${field.qt}" <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if> clearable @keyup.enter.native="searchEnterFun"></ht-input>
					</#if>
					<#break>
				<#-- 自定义对话框 -->
				<#case "customDialog">
					<#assign dg=content>
						<ht-custom-dialog
								v-model="searchForm.${field.colPrefix!}${field.na}"
								model-name="searchForm.${field.na}"
								class="search-item search-custom-dialog"
								isFromList="true"
								ht-query="${field.colPrefix!}${field.na}"
								special-query="${field.colPrefix!}${field.na}"
								operation="${field.qt}"
								:custdialog='${util.getCustDialogAttr(field.colPrefix,field)}'
								permission="w"
               <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if>
								atter="searchForm.${field.colPrefix!}${field.na}">
						</ht-custom-dialog>
					<#break>
				<#case "date"><#--日期选择器 -->
					<@genQueryDate field=field/>
					<#break>
				<#case "select"><#--下拉选项-->
					<#assign options=content>
					<div style="display:inline">
						<#if util.getJsonByPath(field.option,'choiceType')=="dynamic">
							<ht-select v-model="searchForm.${field.colPrefix!}${field.na}" model-name="searchForm.${field.colPrefix!}${field.na}"
              class="search-item" ht-query="${field.colPrefix!}${field.na}" operation="${field.qt}"
             <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if>
                <#if field.cm?if_exists>:placeholder="$td('${'formTemplate.${bpmDataTemplate.alias}.search.${colPrefix}${field.na}'}', '${field.cm}')" </#if>
                :ganged="${util.getSelectQuery(field.option,type!=1)}"
              >
							</ht-select>
						<#else>
							<el-select size="mini" v-model="searchForm.${field.colPrefix!}${field.na}" class="search-item" :placeholder="$td('${'formTemplate.${bpmDataTemplate.alias}.search.${colPrefix}${field.na}'}', '${field.cm}')"  operation="${field.qt}" ht-query="${field.colPrefix!}${field.na}" name="Q^${field.colPrefix!}${field.na}^${field.qt}">
								<el-option :label="$td('${'formTemplate.${bpmDataTemplate.alias}.search.all'}', '全部')" value=""></el-option>
								<#list field.controlContent as opt>
									<el-option  label="${opt.value}" value="${opt.key}"></el-option>
								</#list>
							</el-select>
						</#if>
					</div>
					<#break>
				<#case "dic"><#--数据字典-->
					<#assign dickey=util.getJsonByPath(field.controlContent,'alias')>
					<#assign resultField=util.getJsonByPath(field.controlContent,'resultField')>
					<div style="display:inline-block;" class="col-md-12">
						<div ht-dic='${field.colPrefix!}${field.na}' dickey="${dickey}" resultfield="${resultField}" ht-query="${field.colPrefix!}${field.na}" bind="${field.colPrefix!}${field.na}" :desc="$td('${'formTemplate.${bpmDataTemplate.alias}.search.dic'}', '数据字典')" type="text"  ng-model="${field.colPrefix!}${field.na}" class="form-control"  <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if> ></div>
					</div>
					<#break>
				<#case "radio"><#--单选按钮 -->
				<#case "checkbox"><#--复选框 -->
					${getCheckboxOrRadio(field)}
					<#break>
				<#default>
					<ht-input type="text" size="mini" class="search-item" ht-query="${field.colPrefix!}${field.na}" v-model="searchForm.${field.colPrefix!}${field.na}" operation="${field.qt}" :placeholder="$td('${'formTemplate.${bpmDataTemplate.alias}.search.${colPrefix}${field.na}'}', '${field.cm}')" name="Q^${field.colPrefix!}${field.na}^${field.qt}" <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if> clearable @keyup.enter.native="searchEnterFun"></ht-input>
					<#break>
			</#switch>
		</#if>
	</ht-table-search-field>
</#macro>
<#noparse>
	<#--管理列  以前的模板-->
	<#macro genManageOld manage managePermission actionUrl data>
	<#--编辑-->
	<#if manage.name == 'edit'>
	<#if managePermission.edit>
	<el-button id="${manage.buttonId}"  v-show="execScript('${manage.beforeScriptValue}',scope.row)" v-if="permission.edit && display('${manage.mpDisplay}')"  type="text" @click="scriptClick('edit','${manage.afterScriptValue}',{templateId:'${templateId}',id:scope.row.${pkField},action:'edit',defId:'${bpmDataTemplate.defId}',
			isStartFlow:scope.row.isStartFlow,openType:'${manage.openType}', quitAfterSaving: '${manage.quitAfterSaving}', dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}'})" size="mini" plain>{{$td('eip.common.edit', '${manage.desc}')}}</el-button>
	</#if>
	<#--复制-->
	<#elseif manage.name == 'copy'>
	<#if managePermission.copy>
	<el-button id="${manage.buttonId}" type="text" size="mini"  @click="scriptClick('copyOne','${manage.afterScriptValue}',{pkField:scope.row.${pkField}})" >{{$td('eip.common.copy', '${manage.desc}')}}</el-button>
	</#if>
	<#--打印明细 -->
	<#elseif manage.name == 'printDetail'>
	<#if managePermission.printDetail>
	<el-button id="${manage.buttonId}" type="text" size="mini" @click='printDetail("${templateId}",scope.row.${pkField},"get")'>{{$td('eip.common.printDetail', '${manage.desc}')}}</el-button>
	</#if>
	<#--删除-->
	<#elseif manage.name == 'del' >
	<#if managePermission.del>
	<el-button id="${manage.buttonId}" type="text" v-show="execScript('${manage.beforeScriptValue}',scope.row)"     @click="scriptClick('del','${manage.afterScriptValue}',{pkField:scope.row.${pkField}})" size="mini" plain>{{$td('eip.common.remove', '${manage.desc}' )}}</el-button>
	</#if>

	<#--新增流程-->
	<#elseif manage.name == 'addFlow'>
	<#if managePermission.addFlow>
	<el-button id="${manage.buttonId}" type="text"  @click="scriptClick('addFlow','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}',pkField:scope.row.${pkField}, row:scope.row});" size="mini" plain>{{$td('eip.common.addFlow', '${manage.desc}')}}</el-button>
	</#if>
	<#--新增数据-->
	<#elseif manage.name == 'addData'>
	<#if managePermission.addData>
	<el-button id="${manage.buttonId}" type="text"    @click="scriptClick('addData','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}',pkField:scope.row.${pkField}, row:scope.row});" size="mini" plain>{{$td('eip.common.addData', '${manage.desc}')}}</el-button>
	</#if>
	<#--查询数据-->
	<#elseif manage.name == 'searchData'>
	<#if managePermission.searchData>
	<el-button id="${manage.buttonId}" type="text"    @click="scriptClick('searchData','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}',pkField:scope.row.${pkField}, row:scope.row});" size="mini" plain>{{$td('eip.common.searchData', '${manage.desc}')}}</el-button>
	</#if>

	<#--子表-->
	<#elseif manage.name == 'sub'>
	<#if managePermission.sub && hasSub>
	<el-button
	        id="${manage.buttonId}"
			type="text"
			
			@click='showSubList(scope.row.${pkField}<#if manage.options>
				,{import: ${(manage.options.import)?string('true', 'false')}, export: ${(manage.options.export)?string('true', 'false')}}
			</#if>);'
			size="mini"
			plain
	>{{$td('eip.common.showSubList', '${manage.desc}')}}</el-button>
	</#if>
	<#--生成二维码-->
	<#elseif manage.name == 'produceQRCode' >
	<#if managePermission.produceQRCode>
	<el-button  id="${manage.buttonId}" type="text"   v-if="display('${manage.mpDisplay}') && <#if bpmDataTemplate.mobileFormAlias?exists>true<#else>false</#if>" @click='getQRCode("${templateId}",scope.row.${pkField},"${bpmDataTemplate.mobileFormAlias}",${JsonUtil.toJson(manage.display)},scope.index,${manage.QRCodePattern})' size="mini" plain>{{$td('eip.common.produceQRCode', '${manage.desc}')}}</el-button>
	</#if>
	<#--明细-->
	<#elseif manage.name == 'detail' >
	<#if managePermission.detail>
	<el-button id="${manage.buttonId}"  type="text"   @click='operating("${templateId}",scope.row.${pkField},"get","","","${manage.openType}",scope.row);' size="mini" plain>{{$td('eip.common.detail', '${manage.desc}')}}</el-button>
	</#if>
	<#elseif manage.name == 'url' &&manage.type=='1'>
	<#if util.fieldPermissionValidation('url', managePermission, manage.desc, manage.url, manage.urlParams)>
	<el-button id="${manage.buttonId}" type="text"  @click="openUrl('${manage.url}','new','','')" size="mini" plain>{{$td('eip.common.url', '${manage.desc}')}}</el-button>
	</#if>
	<#--表单修改记录-->
	<#elseif manage.name == 'record' >
	<#if managePermission.record>
	<el-button id="${manage.buttonId}" type="text"  @click="openRecordList(scope.row.${pkField})" size="mini" plain>{{$td('eip.common.record', '${manage.desc}')}}</el-button>
	</#if>
	<#elseif manage.name == 'switch' >
	<#if util.fieldPermissionValidation('switch', managePermission, manage.desc, manage.switchOn, manage.switchOff)>
	<el-tooltip v-show="execScript('${manage.beforeScriptValue}',scope.row)" content="${manage.desc}" effect="dark" >
		<el-switch
      @change='scriptClick("switch","${manage.afterScriptValue}",{pkField:scope.row.${pkField},switchOn:"${manage.switchOn}",switchOff:"${manage.switchOff}",bind:"${manage.bind}",row:scope.row,switchDefaultTrue:"${manage.switchDefaultTrue}"})'
      :value="scope.row.${manage.bind}"
      active-value="${manage.switchOn}"
      inactive-value="${manage.switchOff}"
      v-if="scope.row.${manage.bind} =='${manage.switchOn}' || scope.row.${manage.bind} =='${manage.switchOff}'"
		>
		</el-switch>
		<el-switch
      @change='scriptClick("switch","${manage.afterScriptValue}",{pkField:scope.row.${pkField},switchOn:"${manage.switchOn}",switchOff:"${manage.switchOff}",bind:"${manage.bind}",row:scope.row,switchDefaultTrue:"${manage.switchDefaultTrue}"})'
      active-value="${manage.switchOn}"
      inactive-value="${manage.switchOff}"
      :value="'${manage.switchDefaultTrue}'=='true'?'${manage.switchOn}':'${manage.switchOff}'"
      v-else
		>
		</el-switch>
	</el-tooltip>
	</#if>
	<#elseif manage.name == 'js' >
	<#if util.fieldPermissionValidation('js', managePermission, manage.desc, manage.jsValue)>
	<el-button id="${manage.buttonId}" type="text"    @click='customEvilJS(scope.row,"${manage.jsValue}")' size="small" plain>{{$td('eip.common.js', '${manage.desc}')}}</el-button>
	</#if>
	<#else>
	</#if>
	</#macro>

	<#--管理列-->
	<#macro genManage manage managePermission actionUrl data>
	<#--编辑-->
	<#if manage.name == 'edit'>
	<#if managePermission.edit && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}"
				v-if="'${manage.linePosition}' && permission.edit && display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"  type="text" @click.native="scriptClick('edit','${manage.afterScriptValue}',{templateId:'${templateId}',id:scope.row.${pkField} || scope.row.id,action:'edit',defId:'${bpmDataTemplate.defId}',
				isStartFlow:scope.row.isStartFlow,openType:'${manage.openType}', quitAfterSaving: '${manage.quitAfterSaving}', dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}'})" size="mini" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--复制-->
	<#elseif manage.name == 'copy'>
	<#if managePermission.copy && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}"      size="mini"  @click.native="scriptClick('copyOne','${manage.afterScriptValue}',{pkField:scope.row.${pkField}})" >{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--打印明细 -->
	<#elseif manage.name == 'printDetail'>
	<#if managePermission.printDetail && manage.linePosition>
	<el-dropdown-item  name="${manage.desc}" id="${manage.buttonId}"     size="mini" @click.native='printDetail("${templateId}",scope.row.${pkField},"get")'>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--删除-->
	<#elseif manage.name == 'del'  && manage.linePosition>
	<#if managePermission.del>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-if="permission.del && display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"   @click.native="scriptClick('del','${manage.afterScriptValue}',{pkField:scope.row.${pkField} || scope.row.id})" size="mini" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>

	<#--新增流程-->
	<#elseif manage.name == 'addFlow'>
	<#if util.fieldPermissionValidation('addFlow', managePermission, manage.buttonId, '') && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-if="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"
					  @click.native="scriptClick('addFlow','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}',pkField:scope.row.${pkField}, row:scope.row},'linePosition');" size="mini" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--新增数据-->
	<#elseif manage.name == 'addData'>
	<#if util.fieldPermissionValidation('addData', managePermission, manage.buttonId, '') && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-if="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"
					  @click.native="scriptClick('addData','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}',pkField:scope.row.${pkField}, row:scope.row},'linePosition');" size="mini" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--查询数据-->
	<#elseif manage.name == 'searchData'>
	<#if util.fieldPermissionValidation('searchData', managePermission, manage.buttonId, '') && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-if="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"
					  @click.native="scriptClick('searchData','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}',pkField:scope.row.${pkField}, row:scope.row});" size="mini" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>

	<#--子表-->
	<#elseif manage.name == 'sub'>
	<#if managePermission.sub && hasSub && manage.linePosition>
	<el-dropdown-item
      name="${manage.desc}"
	  id="${manage.buttonId}"
			
			@click.native='showSubList(scope.row.${pkField}
			<#if manage.options>
				,{import: ${(manage.options.import)?string('true', 'false')}, export: ${(manage.options.export)?string('true', 'false')}}
			</#if>
			);'
			size="mini" plain
	>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>

	<#--生成二维码-->
	<#elseif manage.name == 'produceQRCode' >
	<#if managePermission.produceQRCode && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-if="display('${manage.mpDisplay}') && <#if bpmDataTemplate.mobileFormAlias?exists>true<#else>false</#if>" @click.native='getQRCode("${templateId}",scope.row.${pkField},"${bpmDataTemplate.mobileFormAlias}",${JsonUtil.toJson(manage.display)},scope.index,${manage.QRCodePattern})' size="mini" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>

	<#--明细-->
	<#elseif manage.name == 'detail' >
	<#if managePermission.detail && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}"   @click.native='operating("${templateId}",scope.row.${pkField},"get","","","${manage.openType}",scope.row);' size="mini" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>

	<#--url按钮-->
	<#elseif manage.name == 'url'>
	<#if manage.linePosition && util.fieldPermissionValidation('url', managePermission, manage.desc, manage.url, manage.urlParams)>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-if="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"
					  @click.native="scriptClick('url','${manage.afterScriptValue}',{url:'${manage.url}',type:'new',fieldName:'', urlParams:'${manage.urlParams!}',pkField:scope.row.${pkField}, row:scope.row, dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',openType: '${manage.openType}', tokenEnabled:'${manage.tokenEnabled}', tokenType:'${manage.tokenType}', tokenKey:'${manage.tokenKey}', tokenApi:'${manage.tokenApi}'})" size="mini" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>

	<#--表单修改记录-->
	<#elseif manage.name == 'record' >
	<#if managePermission.record && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}"  @click.native="openRecordList(scope.row.${pkField})" size="mini" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>

	<#--js按钮-->
	<#elseif manage.name == 'js' >
	<#if manage.linePosition && util.fieldPermissionValidation('js', managePermission, manage.desc, manage.jsValue)>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}"   @click.native='customEvilJS(scope.row,"${manage.jsValue}", {dialogWidth: "${manage.dialogWidth}",dialogHeight: "${manage.dialogHeight}",openType: "${manage.openType}"})' size="small" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>

	<#elseif manage.name == 'startFlow' && manage.linePosition && managePermission.startFlow>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-if="!scope.row.isStartFlow&& '${bpmDataTemplate.defId}' && display('${manage.mpDisplay}')" @click.native='startFlow(scope.row.${pkField});'  plain> {{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>

	<#--更新数据-->
	<#elseif  manage.name == 'batchUpdate'>
	<#if manage.linePosition && util.fieldPermissionValidation('batchUpdate', managePermission, manage.desc, manage.batchUpdateData, manage.relationConfig)>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-if="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)" size="mini" @click.native="scriptClick('batchUpdate','${manage.afterScriptValue}',{row:scope.row,position:'${manage.linePosition}',desc:'${manage.desc}',batchUpdateData:'${manage.batchUpdateData}',filedsObj:'${manage.filedsObj}',relationConfig: '${manage.relationConfig}'})">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--任务办理-->
	<#elseif manage.name == 'approval' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.approval && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}"  v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].approval && display('${manage.mpDisplay}')" @click.native="handleApproval(scope.row, '${manage.openType}')" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--流程图-->
	<#elseif manage.name == 'taskImage' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.taskImage && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].taskImage && display('${manage.mpDisplay}')" @click.native="showTaskImage(scope.row)" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--审批历史-->
	<#elseif manage.name == 'history' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.history && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].history && display('${manage.mpDisplay}')" @click.native="showInstHistory(scope.row)" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--撤回-->
	<#elseif manage.name == 'revoke' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.revoke && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].revoke && display('${manage.mpDisplay}')" @click.native="handleRevoke(scope.row)" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--任务明细-->
	<#elseif manage.name == 'taskDetail' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.taskDetail && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].taskDetail && display('${manage.mpDisplay}')" @click.native="showTaskDetail(scope.row, '${manage.openType}',{dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}'})" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--传阅-->
	<#elseif manage.name == 'taskToRead' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.taskToRead && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].taskToRead && display('${manage.mpDisplay}')" @click.native="taskToRead(scope.row)" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--删除草稿-->
	<#elseif manage.name == 'phyDelete' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.phyDelete && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].phyDelete && display('${manage.mpDisplay}')" @click.native="phyDelete(scope.row)" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--删除流程-->
	<#elseif manage.name == 'logicDelete' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.logicDelete && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].logicDelete && display('${manage.mpDisplay}')" @click.native="logicDelete(scope.row)" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#else>
	</#if>
	</#macro>

	<#--管理列-->
	<#macro genFirstBtn manage managePermission actionUrl data>
	<#--编辑-->
	<#if manage.name == 'edit'>
	<#if managePermission.edit && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" v-else-if="permission.edit && display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"  type="text" @click="scriptClick('edit','${manage.afterScriptValue}',{templateId:'${templateId}',id:scope.row.${pkField} || scope.row.id,action:'edit',defId:'${bpmDataTemplate.defId}',
				isStartFlow:scope.row.isStartFlow,openType:'${manage.openType}', quitAfterSaving: '${manage.quitAfterSaving}', dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}'})" size="mini" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--复制-->
	<#elseif manage.name == 'copy'>
	<#if managePermission.copy && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" v-else-if="display('${manage.mpDisplay}')" size="mini"  @click="scriptClick('copyOne','${manage.afterScriptValue}',{pkField:scope.row.${pkField}})" >{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--打印明细 -->
	<#elseif manage.name == 'printDetail'>
	<#if managePermission.printDetail && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" v-else-if="display('${manage.mpDisplay}')" size="mini" @click='printDetail("${templateId}",scope.row.${pkField},"get")'>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--删除-->
	<#elseif manage.name == 'del' >
	<#if managePermission.del && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" v-else-if="permission.del && display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"   @click="scriptClick('del','${manage.afterScriptValue}',{pkField:scope.row.${pkField} || scope.row.id})" size="mini" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>

	<#--新增流程-->
	<#elseif manage.name == 'addFlow'>
	<#if util.fieldPermissionValidation('addFlow', managePermission, manage.buttonId, '') && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" v-else-if="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"   @click="scriptClick('addFlow','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}',pkField:scope.row.${pkField}, row:scope.row},'linePosition');" size="mini" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--新增数据-->
	<#elseif manage.name == 'addData'>
	<#if util.fieldPermissionValidation('addData', managePermission, manage.buttonId, '') && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" v-else-if="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"   @click="scriptClick('addData','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}',pkField:scope.row.${pkField}, row:scope.row},'linePosition');" size="mini" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--查询数据-->
	<#elseif manage.name == 'searchData'>
	<#if util.fieldPermissionValidation('searchData', managePermission, manage.buttonId, '') && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" v-else-if="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"   @click="scriptClick('searchData','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}',pkField:scope.row.${pkField}, row:scope.row});" size="mini" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>

	<#--子表-->
	<#elseif manage.name == 'sub'>
	<#if managePermission.sub && hasSub && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" v-else-if="display('${manage.mpDisplay}')"
		  @click='showSubList(scope.row.${pkField}<#if manage.options>
				,{import: ${(manage.options.import)?string('true', 'false')}, export: ${(manage.options.export)?string('true', 'false')}}
			</#if>);'
		  size="mini" plain
	>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>

	<#--生成二维码-->
	<#elseif manage.name == 'produceQRCode' >
	<#if managePermission.produceQRCode && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" v-else-if="display('${manage.mpDisplay}') && <#if bpmDataTemplate.mobileFormAlias?exists>true<#else>false</#if>" @click='getQRCode("${templateId}",scope.row.${pkField},"${bpmDataTemplate.mobileFormAlias}",${JsonUtil.toJson(manage.display)},scope.index,${manage.QRCodePattern})' size="mini" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>

	<#--明细-->
	<#elseif manage.name == 'detail' >
	<#if managePermission.detail && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}"  v-else-if="display('${manage.mpDisplay}')"  @click='operating("${templateId}",scope.row.${pkField},"get","","","${manage.openType}",scope.row);' size="mini" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>

	<#--url按钮-->
	<#elseif manage.name == 'url'>
	<#if manage.linePosition && util.fieldPermissionValidation('url', managePermission, manage.desc, manage.url, manage.urlParams)>
	<span name="${manage.desc}" id="${manage.buttonId}"  v-else-if="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)" @click="scriptClick('url','${manage.afterScriptValue}',{url:'${manage.url}',type:'new',fieldName:'', urlParams:'${manage.urlParams!}',pkField:scope.row.${pkField}, row:scope.row,dialogWidth: '${manage.dialogWidth}',dialogHeight: '${manage.dialogHeight}',openType: '${manage.openType}', tokenEnabled:'${manage.tokenEnabled}', tokenType:'${manage.tokenType}', tokenKey:'${manage.tokenKey}', tokenApi:'${manage.tokenApi}'})" size="mini" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>

	<#--表单修改记录-->
	<#elseif manage.name == 'record' >
	<#if managePermission.record && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" v-else-if="display('${manage.mpDisplay}')" @click="openRecordList(scope.row.${pkField})" size="mini" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>

	<#--js按钮-->
	<#elseif manage.name == 'js' >
	<#if manage.linePosition && util.fieldPermissionValidation('js', managePermission, manage.desc, manage.jsValue)>
	<span name="${manage.desc}" id="${manage.buttonId}" v-else-if="display('${manage.mpDisplay}')"  @click='customEvilJS(scope.row,"${manage.jsValue}",{dialogWidth: "${manage.dialogWidth}",dialogHeight: "${manage.dialogHeight}",openType: "${manage.openType}"})' size="small" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>

	<#elseif manage.name == 'startFlow' && manage.linePosition && managePermission.startFlow>
	<span name="${manage.desc}" id="${manage.buttonId}" v-else-if="!scope.row.isStartFlow&& '${bpmDataTemplate.defId}'" @click='startFlow(scope.row.${pkField});'  plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>

	<#--更新数据-->
	<#elseif manage.name == 'batchUpdate'>
	<#if manage.linePosition && util.fieldPermissionValidation('batchUpdate', managePermission, manage.desc, manage.batchUpdateData, manage.relationConfig)>
	<span name="${manage.desc}" id="${manage.buttonId}" v-else-if="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)" size="mini" @click="scriptClick('batchUpdate','${manage.afterScriptValue}',{row:scope.row,position:'${manage.linePosition}',desc:'${manage.desc}',batchUpdateData:'${manage.batchUpdateData}',filedsObj:'${manage.filedsObj}',relationConfig: '${manage.relationConfig}'})" icon="el-icon-edit">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--任务办理-->
	<#elseif manage.name == 'approval' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.approval && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" v-else-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].approval && display('${manage.mpDisplay}')" @click="handleApproval(scope.row, '${manage.openType}')">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--流程图-->
	<#elseif manage.name == 'taskImage' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.taskImage && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" v-else-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].taskImage && display('${manage.mpDisplay}')" @click="showTaskImage(scope.row)" >{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--审批历史-->
	<#elseif manage.name == 'history' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.history && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" v-else-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].history && display('${manage.mpDisplay}')" @click="showInstHistory(scope.row)">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--撤回-->
	<#elseif manage.name == 'revoke' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.revoke && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" v-else-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].revoke && display('${manage.mpDisplay}')" @click="handleRevoke(scope.row)">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--任务明细-->
	<#elseif manage.name == 'taskDetail' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.taskDetail && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" v-else-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].taskDetail && display('${manage.mpDisplay}')" @click="showTaskDetail(scope.row, '${manage.openType}',{dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}'})">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--传阅-->
	<#elseif manage.name == 'taskToRead' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.taskToRead && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" v-else-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].taskToRead && display('${manage.mpDisplay}')" @click="taskToRead(scope.row)">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--删除草稿-->
	<#elseif manage.name == 'phyDelete' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.phyDelete && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" v-else-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].phyDelete && display('${manage.mpDisplay}')" @click="phyDelete(scope.row)">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--删除流程-->
	<#elseif manage.name == 'logicDelete' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.logicDelete && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" v-else-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].logicDelete && display('${manage.mpDisplay}')" @click="logicDelete(scope.row)">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#else>
	</#if>
	</#macro>

	<#--顶部按钮-->
	<#macro genToolBar manage managePermission actionUrl btnIndex isKanban>

	<#--编辑-->
	<#if manage.name == 'edit'>
	<#if managePermission.edit>
	<el-button class="data-form-list__top-btn" type="${manage.theme!'primary'}"  @click="scriptClick('edit','${manage.afterScriptValue}',{templateId:'${templateId}',id:'',action:'edit',defId:'${bpmDataTemplate.defId}',
							  isStartFlow:'',openType:'${manage.openType}', quitAfterSaving: '${manage.quitAfterSaving}', dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}', isKanban: '${isKanban}' })" size="mini" icon="el-icon-edit">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>
	<#-- 删除 -->
	<#if manage.name == 'del'>
	<#if managePermission.del>
	<el-button class="data-form-list__top-btn" type="${manage.theme!'danger'}"  size="mini" @click="scriptClick('deleted','${manage.afterScriptValue}')"  icon="el-icon-delete">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>


	<#--查询数据-->
	<#if manage.name == 'searchData'>
	<#if util.fieldPermissionValidation('searchData', managePermission, manage.buttonId, '')>
	<el-button class="data-form-list__top-btn" type="${manage.theme!'primary'}" v-show="getButtonShowByJs('${manage.buttonId}', 'searchData')"    @click="scriptClick('searchData','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}'})" size="mini" icon="el-icon-search">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>

	<#--批量新增-->
	<#if manage.name == 'batchSave'>
	<#if util.fieldPermissionValidation('batchSave', managePermission, manage.buttonId, '') >
	<el-button type="${manage.theme!'default'}" v-show="getButtonShowByJs('${manage.buttonId}', 'batchSave')" v-if="permission.add && display('${manage.mpDisplay}')" size="mini" @click="scriptClick('batchSave','${manage.afterScriptValue}',{templateId:'${templateId}',id:'${manage.buttonId}',customDialogjson:'${manage.customDialogjson}',action:'batchSave',defId:'${bpmDataTemplate.defId}',isStartFlow:'',
            openType:'${manage.openType}', quitAfterSaving: '${manage.quitAfterSaving}', dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}'})" icon="el-icon-plus">${manage.desc}</el-button>
	<span style="display: inline-block;"><ht-batch-save-dialog ref="batchSaveDialog" @onConfirm="batchSaveConfirm" :custdialog="'${manage.customDialogjson}'" placeholder="" style="width: 100%"></ht-batch-save-dialog></span>
	</#if>
	</#if>

	<#-- 复制 -->
	<#if manage.name == 'copy'>
	<#if managePermission.copy>
	<el-button class="data-form-list__top-btn" type="${manage.theme!'primary'}" v-show="showScriptButton&&showScriptButton.copy" v-if="permission.copy && display('${manage.mpDisplay}')" size="mini" @click="scriptClick('copyAll')" icon="el-icon-tickets">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>
	<#-- 生成二维码 -->
	<#if manage.name == 'produceQRCode'>
	<#if managePermission.produceQRCode>
	<el-button class="data-form-list__top-btn" type="${manage.theme!'primary'}" v-if="display('${manage.mpDisplay}') && <#if bpmDataTemplate.mobileFormAlias?exists>true<#else>false</#if>" @click='downloadAllQRCode("${templateId}","${bpmDataTemplate.mobileFormAlias}",${JsonUtil.toJson(manage.display)},"${pkField}",${manage.QRCodePattern})' size="mini" icon="el-icon-s-grid">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>

	<#-- 启动流程 -->
	<#if manage.name == 'startFlow'>
	<#if managePermission.startFlow>
	<el-button class="data-form-list__top-btn" type="${manage.theme!'success'}" size="mini"
			   @click="startFlowByTopButton('${pkField}','${manage.afterScriptValue}','${templateId}','${bpmDataTemplate.defId}')"
			   icon="el-icon-success">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>

	<#-- 批量更新数据 -->
	<#if manage.name == 'batchUpdate'>
	<#if manage.topPosition && util.fieldPermissionValidation('batchUpdate', managePermission, manage.desc, manage.batchUpdateData, manage.relationConfig)>
	<el-button class="data-form-list__top-btn" type="${manage.theme!'primary'}" v-show="getButtonShowByJs('${manage.buttonId}', 'batchUpdate')" size="mini" @click="scriptClick('batchUpdate','${manage.afterScriptValue}',{buttonId:'${manage.buttonId}',desc:'${manage.desc}',batchUpdateData:'${manage.batchUpdateData}',filedsObj:'${manage.filedsObj}',relationConfig: '${manage.relationConfig}'})" icon="el-icon-edit">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>

	<#-- url按钮 -->
	<#if manage.name == 'url'>
	<#if manage.topPosition && util.fieldPermissionValidation('url', managePermission, manage.desc, manage.url, manage.urlParams)>
	<el-button class="data-form-list__top-btn" type="${manage.theme!'info'}" v-show="getButtonShowByJs('${manage.buttonId}', 'url')"   size="mini" @click="scriptClick('url','${manage.afterScriptValue}',{url:'${manage.url}',type:'new',fieldName:'', urlParams:'${manage.urlParams!}',dialogWidth: '${manage.dialogWidth}',dialogHeight: '${manage.dialogHeight}',openType: '${manage.openType}', tokenEnabled:'${manage.tokenEnabled}', tokenType:'${manage.tokenType}', tokenKey:'${manage.tokenKey}', tokenApi:'${manage.tokenApi}'})"  icon="el-icon-share">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>

	<#-- js按钮 -->
	<#if manage.name == 'js' >
	<#if manage.topPosition && util.fieldPermissionValidation('js', managePermission, manage.desc, manage.jsValue)>
    <el-button class="data-form-list__top-btn" type="${manage.theme!'primary'}"   @click="scriptClick('js','${manage.afterScriptValue}',{jsValue:'${manage.jsValue}',dialogWidth:'${manage.dialogWidth}',dialogHeight:'${manage.dialogHeight}',openType:'${manage.openType}',needValidateSelect:'${manage.needValidateSelect}'})" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>

	</#macro>

	<#--我的草稿按钮-->
	<#macro myDraftListToolBar manage managePermission actionUrl>
	<#if manage.name == 'add'>
	<#if managePermission.add>
	<el-button class="data-form-list__top-btn" type="${manage.theme!'primary'}" v-show="showScriptButton&&showScriptButton.add" v-if="permission.add && display('2')  && showDraftList" @click="myDraftList"  size="mini" > <i class="icon-caogao my-draft__icon"></i>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.myDraftList"}', '我的草稿')}}</el-button>
	</#if>
	</#if>
	</#macro>
</#noparse>


<#--过滤条件
<#noparse><#if filterFields?if_exists>
<div class="panel" ajax="ajax"  displayId="${bpmDataTemplate.id}" filterKey="${filterKey}" >
<#if filterFields?size gt 1>
<div class='panel-nav'>
	<div class="l-tab-links">
		<ul style="left: 0px; ">
			<#list filterFields as field>
			<li tabid="${field.key}" <#if field.key ==filterKey> class="l-selected"</#if>>
				<a href="${field.url}" title="${field.name}">${field.desc}</a>
			</li>
			</#list>
		</ul>
	</div>
</div>
</#if>
</#noparse> -->

<#-- 主体内容 start  -->
 <#if (showViews?size = 1) >
	 <#list showViews as view>
          ${getViewByType(view.type,false)}
      </#list>
 </#if >
<#-- 主体内容 end  -->
<#--
<#noparse>
<#else>
   <div style="padding:6px 0px 12px 0px;">当前用户没有满足的过滤条件,请设置过滤条件。<div>
</#if>
</#noparse>
-->

<#function genElTableColumn field>
	<#assign rtn>
		<#if field.name??>
			<#assign fieldType=field.type>
			<#assign fieldName=field.name>
			<#noparse><#if permission.</#noparse>${field.name}<#noparse>></#noparse>
			<ht-table-column
					:key="notPrint?Math.random():null"
			:prop="isPropTable('${field.name}','${field.tableName}','${field.oldTableField}')"
			column-key="${field.name}"
      :label="$td('${'formTemplate.${bpmDataTemplate.alias}.display.${field.name}'}', '${field.desc}')"
			<#if util.getJsonByPath(filteringFieldMap,fieldName) != "" >
			:filters='${util.getJsonByPath(filteringFieldMap,fieldName)}'
			</#if>
			<#if util.getJsonByPathNew(field,"defaultValue",filteringDefaultValue) !="">

			:filtered-value='${util.getJsonByPathNew(field,"defaultValue",filteringDefaultValue)}'
			</#if>
			<#if util.getJsonByPath(sortFieldMap,fieldName) != "" >:sortable="isSortable('${field.name}')"</#if>
      <#if !field.isDesensitization>show-overflow-tooltip</#if>
      v-if="display('${field.mpDisplay}')" <#if field.width!=0>width="${field.width}px"</#if>
			align="${field.align!'center'}">
				<template slot-scope="scope">
					<#if field.proSetting>
					<#--进度条-->
						<el-progress :percentage="getProValue(scope.row.${field.name},${field.ruleSetting})"
									 :color="getProColor('${util.toJsonStr(field.ruleSettings)}',scope.row)"></el-progress>
					<#elseif field.urlType=='edit'>
						<el-link
								type="primary"
								class="follow-theme-color"
								@click='operating("${templateId}",scope.row.${pkField},"select","","","${field.openType}",scope.row);'
								:title="$td('eip.common.showDetails', '查看详情')"
								<#if field.ruleSettings?if_exists>
									:style="getColor('${util.toJsonStr(field.ruleSettings)}',scope.row)"
								</#if>
						>
							<#if field.formatterData?if_exists>
								<span>{{queryFormatterData(scope.row.${field.name},'${util.toJsonStr(field.formatterData)}')}}</span>
							<#else>
								<#if field.isDesensitization>
              <el-tooltip class="item" effect="dark" :content="scope.row.${field.name}+''" placement="top">
     	          <span>
									{{desensitization(scope.row.${field.name},${field.desensitizationRules.startPosition},${field.desensitizationRules.endPosition},`${field.desensitizationRules.pad}`)}}
								</span>
              </el-tooltip>
                  <#else>
                  <span>
									{{scope.row.${field.name}}}
								</span>
                	</#if>
							</#if>
						</el-link>
					<#elseif field.urlType=='reportForm'>
						<el-link
								type="primary"
								class="follow-theme-color"
								@click='viewReport(scope.row,"${util.toJsonStr(field.reportNameConfigure)}","${field.openType}");'
								:title="$td('eip.common.showReport', '查看报表')"
								<#if field.ruleSettings?if_exists>
									:style="getColor('${util.toJsonStr(field.ruleSettings)}',scope.row)"
								</#if>
						>
							<#if field.formatterData?if_exists>
								<span>{{queryFormatterData(scope.row.${field.name},'${util.toJsonStr(field.formatterData)}')}}</span>
							<#else>
								<#if field.isDesensitization>
              <el-tooltip class="item" effect="dark" :content="scope.row.${field.name}+''" placement="top">
     	          <span>
									{{desensitization(scope.row.${field.name},${field.desensitizationRules.startPosition},${field.desensitizationRules.endPosition},`${field.desensitizationRules.pad}`)}}
								</span>
              </el-tooltip>
                  <#else>
                  <span>
									{{scope.row.${field.name}}}
								</span>
                	</#if>
							</#if>
						</el-link>
					<#elseif field.urlType=='url'>
						<el-link
								type="primary"
								@click='openUrl("${field.url}","${field.openType}",scope.row,"${field.name}");'
								class="follow-theme-color"
								:title="$td('eip.common.jumpToOtherURL', '跳转到其他URL地址')"
								<#if field.ruleSettings?if_exists>
									:style="getColor('${util.toJsonStr(field.ruleSettings)}',scope.row)"
								</#if>
						>
							<#if field.formatterData?if_exists>
								<span>{{queryFormatterData(scope.row.${field.name},'${util.toJsonStr(field.formatterData)}')}}</span>
							<#else>
								<#if field.isDesensitization>
              <el-tooltip class="item" effect="dark" :content="scope.row.${field.name}+''" placement="top">
     	          <span>
									{{desensitization(scope.row.${field.name},${field.desensitizationRules.startPosition},${field.desensitizationRules.endPosition},`${field.desensitizationRules.pad}`)}}
								</span>
              </el-tooltip>
                  <#else>
                  <span>
									{{scope.row.${field.name}}}
								</span>
                	</#if>
							</#if>
						</el-link>
					<#else>
						<span
							<#if field.ruleSettings?if_exists>
								:style="getColor('${util.toJsonStr(field.ruleSettings)}',scope.row)"
							</#if>
						>
							<#if field.formatterType=="1" || field.formatterType=="4"> <#--格式化设置-->

								<#if field.formatterData?if_exists>
									<span>{{queryFormatterData(scope.row.${field.name},'${util.toJsonStr(field.formatterData)}')}}</span>
								<#else>
									<span v-if="display('0') && switchMap.${field.name}">
									<span v-if="scope.row.${field.name} == switchMap.${field.name}.on">
										{{switchMap.${field.name}.onLabel}}
									</span>
									<span v-else-if="scope.row.${field.name} == switchMap.${field.name}.off">
										{{switchMap.${field.name}.offLabel}}
									</span>
									<span v-else>
									<#if field.isDesensitization>
              <el-tooltip class="item" effect="dark" :content="scope.row.${field.name}+''" placement="top">
     	          <span>
									{{desensitization(scope.row.${field.name},${field.desensitizationRules.startPosition},${field.desensitizationRules.endPosition},`${field.desensitizationRules.pad}`)}}
								</span>
              </el-tooltip>
                  <#else>
                  <span>
									{{scope.row.${field.name}}}
								</span>
                	</#if>
									</span>
								</span>
								<span v-else>
								<#if field.isDesensitization>
              <el-tooltip class="item" effect="dark" :content="scope.row.${field.name}+''" placement="top">
     	          <span>
									{{desensitization(scope.row.${field.name},${field.desensitizationRules.startPosition},${field.desensitizationRules.endPosition},`${field.desensitizationRules.pad}`)}}
								</span>
              </el-tooltip>
                  <#else>
                  <span>
									{{scope.row.${field.name}}}
								</span>
                	</#if>
								</span>
								</#if>

							<#elseif field.formatterType=="2"><#--附件-->
								<HtTemplatePreviewFile v-model="scope.row.${field.name}" :key="scope.row.${pkField} + '_' + scope.row.${field.name}"></HtTemplatePreviewFile>
							<#elseif field.formatterType=="3"><#--图片-->
								<HtTemplatePreviewImage  v-model="scope.row.${field.name}" :key="scope.row.${pkField} + '_' + scope.row.${field.name}"></HtTemplatePreviewImage>
							<#else>
                <#if field.isDesensitization>
                <el-tooltip class="item" effect="dark" :content="{{formatCascade(scope.row,'${field.oldTableField}+''" placement="top">
     	            <span>
                  	{{desensitization(formatCascade(scope.row.${field.name}),${field.desensitizationRules.startPosition},${field.desensitizationRules.endPosition},`${field.desensitizationRules.pad}`)}}
					</span>
                </el-tooltip>
                <#else>
                <span>
					{{formatCascade(scope.row,'${field.oldTableField}')}}
				</span>
                </#if>
              </#if>
						</span>
					</#if>
				</template>

			</ht-table-column>

			<#noparse></#if></#noparse>
		<#else>
			<el-table-column
					label="${field.desc}"
					v-if="display('${field.mpDisplay}','${util.getChildrenFieldName(field)}')"
					align="${field.align!'center'}">
				<#list field.children as item>
					${genElTableColumn(item)}
				</#list>
			</el-table-column>
		</#if>
	</#assign>
	<#return rtn>
</#function>