<#--
Name: 数据列表模板
Desc:数据列表模板

本模板需要通过2次解析才能得到最终的Html
第一次解析：
*************************************************************
*************************************************************
*数据模型:****************************************************
*************************************************************
*************************************************************

tbarTitle：Tool Bar 的标题

********************************************
conditionFields:条件字段
--joinType：	条件联合类型
--name：	列名
--name：完全指定名
--operate：条件类型: =|>=|<=|….
--comment：注释
--type：	类型
--value：值
--valueFrom：值来源

************************************************************
displayFields：显示字段
--name：列名
--name：完全指定名
--label：别名
--index：索引
--comment：注释
--type：类型

******************************************************
tableIdCode:Table ID Code

**************************************************
displayId: 自定义显示的ID

**************************************************
pageHtml：分页的Html 详见pageAjax.xml

*************************************************
pageURL：当前页面的URL

searchFormURL：搜索表单的Action


sortField：当前排序字段

orderSeq：当前的排序类型

***********************************************
pkcols:主键列

deleteBaseURL：删除一行数据的BaseURL
editBaseURL：编辑一行数据的BaseURL
 -->


<#setting number_format="#">
<#assign displayFields=bpmDataTemplate.displayField?eval>
<#assign conditionFields=bpmDataTemplate.conditionField?eval>
<#assign filterFields=bpmDataTemplate.filterField?eval>
<#assign manageFields=bpmDataTemplate.manageField?eval>
<#assign sortFields=bpmDataTemplate.sortField?eval>
<#assign tableConfigure=bpmDataTemplate.tableConfigure?eval>
<#assign treeFields=bpmDataTemplate.treeField?eval>
<#assign summaryFields=bpmDataTemplate.summaryField?eval>
<#assign summaryRegionHtml=bpmDataTemplate.summaryRegionHtml>
<#assign treeListConfig = bpmDataTemplate.treeListConfig!"" />
<#if treeListConfig?if_exists>
	<#assign treeListConfig = treeListConfig?eval />
<#else>
	<#assign treeListConfig = {} />
</#if>

<#assign displayMode=bpmDataTemplate.displayMode>
<#assign conditionExpend=bpmDataTemplate.conditionExpend>
<#assign initialLoading=bpmDataTemplate.initialLoading>

<#noparse>
	<#setting number_format="#">
	<#assign displayFields=bpmDataTemplate.displayField?eval>
	<#assign conditionFields=bpmDataTemplate.conditionField?eval>
	<#assign filterFields=bpmDataTemplate.filterField?eval>
	<#assign manageFields=bpmDataTemplate.manageField?eval>
	<#assign sortFields=bpmDataTemplate.sortField?eval>
	<#assign tableConfigure=bpmDataTemplate.tableConfigure?eval>
	<#assign boAlias=bpmDataTemplate.boDefAlias>
	<#assign templateId=bpmDataTemplate.id>
	<#assign templateAlias=bpmDataTemplate.alias>
	<#assign pageSize=bpmDataTemplate.pageSize>
	<#assign urlPre="$">
	<#assign treeListConfig = bpmDataTemplate.treeListConfig!"" />
	<#if treeListConfig?if_exists>
	<#assign treeListConfig = treeListConfig?eval />
	<#else>
	<#assign treeListConfig = {} />
	</#if>
	<#assign displayMode=bpmDataTemplate.displayMode>
	<#assign conditionExpend=bpmDataTemplate.conditionExpend>
	<#assign initialLoading=bpmDataTemplate.initialLoading>
</#noparse>

<#--日期选择器 日期范围 日期时分秒 普通日期-->
<#macro genQueryDate field>
	<#switch field.qt>
		<#case "between">
			<ht-date-picker
        size="small"
        v-model="searchForm.${field.colPrefix!}${field.na}"
         <#if field.ctrlType!="">type="${field.ctrlType}"<#else>type="daterange"</#if>
        class="search-item"
        range-separator="至"
        start-placeholder="开始日期"
        end-placeholder="结束日期"
        operation="${field.qt}"
        placeholder="${field.cm}"
        ht-query="${field.colPrefix!}${field.na}"
        name="Q^${field.colPrefix!}${field.na}^${field.qt}"
        <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if>
        <#if field.format>
          value-format="${field.format}"
          format="${field.format}"
        <#else>
          value-format="yyyy-MM-dd HH:mm:ss"
          format="yyyy-MM-dd HH:mm:ss"
        </#if>
        <#if field.option?if_exists>
          format="${field.option.dateFormat}"
          <#if field.option.dateFormat = 'yyyy-MM-dd'></#if>
          :default-time="['00:00:00','23:59:59']"
        </#if>
			></ht-date-picker>
			<#break>
		<#default>
			<ht-date
        size="small"
        v-model="searchForm.${field.colPrefix!}${field.na}"
       <#if field.ctrlType!="">type="${field.ctrlType}"<#else>type="date"</#if>
        class="search-item"
        placeholder="${field.cm}"
        ht-query="${field.colPrefix!}${field.na}"
        name="Q^${field.colPrefix!}${field.na}^${field.qt}"
        <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if>
        <#if field.option?if_exists>
          format="${field.option.dateFormat}"
          value-format="${field.option.dateFormat}"
          <#if field.option.dateFormat == 'yyyy-MM-dd' && field.qt == 'EQUAL' >
            operation="RIGHT_LIKE"
          <#else>
            operation="${field.qt}"
          </#if>
        <#else>
          <#if field.format>
          value-format="${field.format}"
          format="${field.format}"
        <#else>
          value-format="yyyy-MM-dd"
          format="yyyy-MM-dd"
        </#if>
          operation="${field.qt}"
        </#if>
			></ht-date>
			<#break>
	</#switch>
</#macro>

<#--单选按钮或复选框 -->
<#function getCheckboxOrRadio field>
	<#assign rtn>
		<#if field.controlContent?if_exists>
			<#if field.controlContent?if_exists>
				<#if field.ct=='radio'>
<#--  					<el-radio-group size="small" v-model="searchForm.${colPrefix}${field.na}" class="search-item" operation="${field.qt}" ht-query="${colPrefix}${field.na}" name="Q^${colPrefix}${field.na}^${field.qt}">
						<#list field.controlContent as opt>
							<el-radio label="${opt.key}">${opt.value}</el-radio>
						</#list>
					</el-radio-group>  -->
           <ht-radio size="small" v-model="searchForm.${field.colPrefix!}${field.na}" class="search-item" operation="${field.qt}" ht-query="${field.colPrefix!}${field.na}" name="Q^${field.colPrefix!}${field.na}^${field.qt}"
                   <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if>
                   :props="{key:'key',value:'value'}"
                    rdlist='${util.getJsonByPath(field,'controlContent')}'
        >
        </ht-radio>
				<#else>
					<el-checkbox-group size="small" v-model="searchForm.${field.colPrefix!}${field.na}" class="search-item" operation="${field.qt}" ht-query="${field.colPrefix!}${field.na}" name="Q^${field.colPrefix!}${field.na}^${field.qt}">
						<#list field.controlContent as opt>
							<el-checkbox label="${opt.key}">${opt.value}</el-checkbox>
						</#list>
					</el-checkbox-group>
				<#--<#assign controlContent=util.getJsonByPath(field,'controlContent')>
                <ht-checkbox v-model="searchForm.${colPrefix}${field.na}" cklist='${controlContent}' permission='w' operation="${field.qt}" ht-query="${colPrefix}${field.na}" name="Q^${colPrefix}${field.na}^${field.qt}"  -->
				</#if>
			</#if>
		</#if>
	</#assign>
	<#return rtn>
</#function>

<#-- 获取按钮的主题，没有的话默认为primary -->
<#function getBtnTheme manage>
	<#return 1>
</#function>

<#--获取条件-->
<#function getCondition condition field>
	<#assign rtn="">
	<#list condition as con>
	<#--处理运算符-->
		<#assign operate=con.op >
	<#--处理值-->
		<#assign val=con.val >
		<#if (field.dataType=="varchar") >
			<#assign val="'"+val+"'" >
		</#if>

		<#if con_index==0>
			<#assign rtn="value" + operate + val >
		<#else>
			<#assign rtn=rtn + " && value" + operate + val >
		</#if>
	</#list>
	<#return rtn>
</#function>


<#--根据视图类型返回对应的视图模板 type：视图类型 isTab：是否以tab展示。是则custom-table-height减掉tab页签的高度 -->
<#function getViewByType type isTab>
	<#assign rtn>
		<#if type==1>
			<el-main class="table-main">
			<div id="printData" ref="printData" style="page-break-inside: avoid;height:100%">
	        <ht-table
	          ref="multipleTemplateTable"
	          <#noparse>id="${templateAlias}"</#noparse>
	          :data="rows"
			  :autofocus="autofocus"
	          stripe
	          border
	          :custom-table-height="currentTableHeight <#if isTab>-40</#if>-summaryTableHeight"
	          :custom-table-max-height="currentTableMaxHeight"
	          style="width: 100%"
			  :quick-search-width="280"
	          header-cell-class-name="todo-header-row"
			  :row-class-name="tableRowClassName"
	          size="small"
			  <#if displayMode> 
			   :lazy="'${treeListConfig.treeDataMode}'== 1? true : false"
              @load-children="handleLoadChildren"
			  parentIdField="${treeListConfig.id}"
              :tree-props="{children: 'children', hasChildren: 'hasChildren'}"
			  </#if>
			  <#if conditionExpend> 
			   :defaultShowSearch = "'${conditionExpend}'== 1? true : false"
			  </#if>
			  <#if initialLoading> 
			   :isLoadTable = "'${initialLoading}'== 1? true : false"
			  </#if>	
	          @selection-change="handleSelectionChange"
	          quickSearchPlaceholder="${conditionAllDesc}"
	          :quick-search-props="handleQuickSearchParams('${conditionAllName}','${conditionAllDesc}')"
	          @load="search"
	          :showExport="false"
	          :selectable="false"
	          :nopagination="true"
			  :defaultQuerys="buildDefaultQuerys(false)"
	          :auto-fix="true"
			  :rowKey="getRowKey"
			  :show-select-type="showSelectType"
			  :hasOftenUsed='true'
			  <#noparse>onlyOftenUsedKey="ht-Template-${templateId}"</#noparse>
	          :isDataTemplateList="true"
			  v-loading="multipleTemplateTableloading"
			 @filter-change="filterChange"
			 @row-dblclick="rowDBClick"
			  @row-click="rowClick"
	        >
	          <template v-slot:toolbar>
	            <div class="top_btn_col" >
                <#noparse>
				<#assign manageFieldsTop=util.getPermissionManageFields(manageFields,managePermission,'topPosition',hasSub)>									
				 <#if (manageFieldsTop?size>5)>				 
				   <#list manageFieldsTop[0..3] as manage>	                 
				   <@genToolBar manage=manage managePermission=managePermission actionUrl=actionUrl btnIndex=manage_index/>
				   </#list>
						      
		         <el-button @click='handleShowMore'  :icon="
                    showMoreButtom
                      ? 'el-icon-caret-top'
                      : 'el-icon-caret-bottom'"
                   style='position: relative;'  class='templatePreview-more-buttom'>
				
				   更多
				    <div v-show='showMoreButtom' class='templatePreview-more-buttom-div'>
				           <#list manageFieldsTop[4..] as manage>	                 
				                 <@genToolBar manage=manage managePermission=managePermission actionUrl=actionUrl btnIndex=manage_index/>
				           </#list>
					</div>				 
				 </el-button>		        
			      <#else>				  
	                <#list manageFieldsTop as manage >
	                  <@genToolBar manage=manage managePermission=managePermission actionUrl=actionUrl btnIndex=manage_index/>
	                </#list>	       
				  </#if>	
				   <#if (manageFieldsTop?size>0)>		
				    <div style='width:12px'> </div>
				   </#if>	
              </#noparse> 
                     <#--
	              <#noparse>
	                <#list manageFields as manage >
	                  <@genToolBar manage=manage managePermission=managePermission actionUrl=actionUrl btnIndex=manage_index/>
	                </#list>
	              </#noparse
				     -->
	              <#--
	                <#noparse>
					  <#list manageFields as manage>
	                    <@myDraftListToolBar manage=manage managePermission=managePermission actionUrl=actionUrl />
	                  </#list>
	                </#noparse>
	              -->
	            </div>
	          </template>
	          <#if conditionFields?if_exists>
	            <template v-slot:search>
	              <ht-table-search-panel v-model="searchForm" :divide="3" :label-width="120">
	                <#list conditionFields as field>
	                  <@genCondition field=field/>
	                </#list>
	              </ht-table-search-panel>
	            </template>
	          </#if>
	          <ht-table-column v-if="getFixed('left') && listSelectable && showSelectType!=='none'" key="selector"  type="selection" width="55" align="center" <#if summaryFields?if_exists>:reserveSelection="true"</#if>></ht-table-column>
	          <ht-table-column type="index" key="tIndex" width="60" :label="$td('eip.common.index', '序号')" align="center" :fixed="getFixed('left')"></ht-table-column>
	          <#list displayFields as field>
	            ${genElTableColumn(field)}
	          </#list>
	          <#noparse>
	            <#if (manageFields?size > 0) >
	          </#noparse>
	          <ht-table-column
	            :fixed="getFixed('right')"
	            :label="$td('eip.common.operation', '操作')"
	            class-name="right_menu"
	            align="${tableConfigure.opterateAlign}"
	            width="${tableConfigure.operateWidth}"
	            v-if="!notPrint && showRightMenu"
	          >
	            <template slot-scope="scope">

									<#noparse><#if managePermissionState == true> </#noparse>
								<#if tableConfigure.expansionMethod == "expandPart">
									<#assign manageFieldsFiltered = []>
									<#assign manageFieldsFiltered1 = []>
									<#-- 遍历 manageFields，将符合条件的项放入 manageFieldsFiltered，否则放入 manageFieldsFiltered1 -->
									<#noparse>
									<#list manageFields as manage>
											<#if manage.buttonId?if_exists && tableConfigure.expandDisplay?if_exists && util.includes(tableConfigure.expandDisplay, manage.buttonId)>
												<#assign manageFieldsFiltered = (manageFieldsFiltered![]) + [manage]>
											<#else>
												<#assign manageFieldsFiltered1 = (manageFieldsFiltered1![]) + [manage]>
											</#if>
									</#list>
									</#noparse>
									<#-- 渲染 manageFieldsFiltered 中的项 -->
									<#noparse>
										<#list manageFieldsFiltered as manage>
											<@genManageExpand manage=manage managePermission=managePermission actionUrl=actionUrl data=data/>
										</#list>
									</#noparse>
									<#-- 如果 manageFieldsFiltered1 不为空，渲染更多按钮及其内容 -->
									<ht-dropdown :ref="'ht-dropdown_' + scope.index" v-if="filedList.length > 0" trigger='hover' @visible-change='val=>operationVisibleChange(val,scope.index)' :class="{
						'is-show-operation-dropdown':Number(operationDropdownBol) ===Number(scope.index)+1
					}">
	                    <div class="template-dropdown-item" slot="genFirstBtn">
	                      <div v-if="false"></div>
	                      <#noparse>
	                      <#list manageFieldsFiltered1 as manage>
	                          <@genFirstBtn manage=manage managePermission=managePermission actionUrl=actionUrl data=data/>
	                      </#list>
	                      <div v-else class="not_children_dropdown" ></div>
	                      </#noparse>
	                    </div>

	                    <template slot="genManage" v-if="filedList.length > 1">
	                      <el-dropdown-item v-if='isJoinFlow=="true"' @click.native='complete(scope.row,taskType);'  plain>{{$td('eip.common.taskDetails', '任务明细')}}</el-dropdown-item>
	                      <#noparse>
	                        <#list manageFieldsFiltered1 as manage>
	                          <@genManage manage=manage managePermission=managePermission actionUrl=actionUrl data=data/>
	                        </#list>
	                      </#noparse>
	                    </template>
	                </ht-dropdown>
								<#elseif tableConfigure.expansionMethod=="allUp">
	              <ht-dropdown :ref="'ht-dropdown_' + scope.index" v-if="filedList.length > 0" trigger='hover' @visible-change='val=>operationVisibleChange(val,scope.index)' :class="{
						'is-show-operation-dropdown':Number(operationDropdownBol) ===Number(scope.index)+1
					}">
	                    <div class="template-dropdown-item template-dropdown-item_checkaxzite0df1" slot="genFirstBtn"
                             style="width: 80px;overflow: hidden;">

	                      <#noparse>
	                      <#list manageFields as manage>
	                          <@genFirstBtn manage=manage managePermission=managePermission actionUrl=actionUrl data=data dataButtonGroup="operationButtons"/>
	                      </#list>
	                      </#noparse>
	                    </div>

	                    <template slot="genManage" class="gen-manage-content" v-if="filedList.length > 1">
	                      <el-dropdown-item v-if='isJoinFlow=="true"' @click.native='complete(scope.row,taskType);'  plain>{{$td('eip.common.taskDetails', '任务明细')}}</el-dropdown-item>
	                      <#noparse>
	                        <#list manageFields as manage>
	                          <@genManage manage=manage managePermission=managePermission actionUrl=actionUrl data=data/>
	                        </#list>
	                      </#noparse>
	                    </template>
	                </ht-dropdown>
								<#else>	
									<#noparse>
										<#list manageFields as manage>
											<@genManageExpand manage=manage managePermission=managePermission actionUrl=actionUrl data=data/>
										</#list>
									</#noparse>
								</#if>
							<#noparse>	</#if > </#noparse>
	              <#noparse>
	                <#list manageFields as manage>
	                <!-- 开关按钮 -->
	                  <#if manage.name == 'switch' >
	                  <#if util.fieldPermissionValidation('switch', managePermission, manage.desc, manage.switchOn, manage.switchOff)>
	                    <el-tooltip v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" content="${manage.desc}" effect="dark" v-if="display('${manage.mpDisplay}')">
	                      <el-switch
	                        @change='scriptClick("switch","${manage.afterScriptValue}",{pkField:scope.row.${pkField},switchOn:"${manage.switchOn}",switchOff:"${manage.switchOff}",bind:"${manage.bind}",row:scope.row,switchDefaultTrue:"${manage.switchDefaultTrue}"})'
	                        :value="getBindValue(scope.row,'${manage.bind}')"
	                        active-value="${manage.switchOn}"
	                        inactive-value="${manage.switchOff}"
	                        active-text="${manage.switchOnLabel}"
					                inactive-text="${manage.switchOffLabel}"
	                        v-if="matchBind(scope.row,'${manage.bind}','${manage.switchOn}','${manage.switchOff}')"
	                      >
	                      </el-switch>
	                      <el-switch
	                        @change='scriptClick("switch","${manage.afterScriptValue}",{pkField:scope.row.${pkField},switchOn:"${manage.switchOn}",switchOff:"${manage.switchOff}",bind:"${manage.bind}",row:scope.row,switchDefaultTrue:"${manage.switchDefaultTrue}"})'
	                        active-value="${manage.switchOn}"
	                        inactive-value="${manage.switchOff}"
	                        active-text="${manage.switchOnLabel}"
					                inactive-text="${manage.switchOffLabel}"
	                        :value="'${manage.switchDefaultTrue}'=='true'?'${manage.switchOn}':'${manage.switchOff}'"
	                        v-else
	                      >
	                      </el-switch>
	                    </el-tooltip>
	                  </#if>
	                  </#if>
	                </#list>
	              </#noparse>
	            </template>
	          </ht-table-column>
	          <#noparse>
	            </#if>
	          </#noparse>
	        </ht-table>
	      </div>
	    </el-main>

	    <el-footer height="45px">
	      <el-row type="flex" justify="end">
	        <el-pagination
	          background
	          v-if="templateInfo && templateInfo.needPage && templateInfo.needPage===1"
	          @size-change="handleSizeChange"
	          @current-change="handleCurrentChange"
	          :current-page="pagination.page"
	          :page-sizes="[10, 20, 30, 50, 100, 200, 300]"
	          :page-size="pagination.pageSize"
	          :layout="paginationLayout"
	          :total="total"
	        >
	        </el-pagination>
	      </el-row>
	    </el-footer>
      		<#--汇总设置-->
		<#if summaryFields?if_exists>
				<@genSummaryField/>
		</#if>
    <div id="QRCodeAndDescAll" style="Opacity:0"></div>

		<#elseif type==2>

			<el-main class="table-main">

		   <span id="printData1">
	        <ht-gantt
	          ref="multipleTemplateTable"
	          <#noparse>id="${templateAlias}"</#noparse>
	          :data="rows"
	          stripe
	          border
	          :custom-table-height="currentTableHeight <#if isTab>-40</#if>"
			  :custom-table-max-height="currentTableMaxHeight"
	          style="width: 100%"
	          header-cell-class-name="todo-header-row"
	          row-class-name="todo-row"
	          size="small"
	          @selection-change="handleSelectionChange"
	          quickSearchPlaceholder="${conditionAllDesc}"
	          :quick-search-props="handleQuickSearchParams('${conditionAllName}','${conditionAllDesc}')"
	          @load="search"
	          :showExport="false"
	          :selectable="false"
	          :nopagination="true"
			  :defaultQuerys="buildDefaultQuerys(false)"
	          :auto-fix="true"
			  :rowKey="getRowKey"
	          :isDataTemplateList="true"
	          ganttConfig="${bpmDataTemplate.ganttConfig}"
			  v-loading="multipleTemplateTableloading"
			  :bpmDataTemplate="templateInfo"
			  pkField="${pkField}"
			   <#noparse>managePermission="${base64.getBase64(JsonUtil.toJsonString(managePermission))}"</#noparse>
			  @gantt-task-update="updateTemplateRowData"
			  @gantt-btn-click="scriptClick"
			  @filter-change="filterChange"
	        >
	          <template v-slot:toolbar>
	            <div class="top_btn_col">
	              <#noparse>
	                <#list manageFields as manage>
	                   <#if manage.name == 'add' || manage.name == 'export' || manage.name == 'import'>
			              <@genToolBar manage=manage managePermission=managePermission actionUrl=actionUrl btnIndex=manage_index/>
			           </#if>
	                </#list>
	              </#noparse>
	              <#--
	                <#noparse>
								<#list manageFields as manage>
	                    <@myDraftListToolBar manage=manage managePermission=managePermission actionUrl=actionUrl />
	                  </#list>
	                </#noparse>
	              -->
	            </div>
	          </template>
	          <#if conditionFields?if_exists>
	            <template v-slot:search>
	              <ht-table-search-panel v-model="searchForm" :divide="3" :label-width="120">
	                <#list conditionFields as field>
	                  <@genCondition field=field/>
	                </#list>
	              </ht-table-search-panel>
	            </template>
	          </#if>

	        </ht-gantt>
	      </span>
	    </el-main>

	    <el-footer height="45px" style='display: flex;
    justify-content: flex-end;
    align-items: center;'>
	      <el-row type="flex" justify="end" align="middle">
	        <el-pagination
	          background
	          v-if="templateInfo && templateInfo.needPage && templateInfo.needPage===1"
	          @size-change="handleSizeChange"
	          @current-change="handleCurrentChange"
	          :current-page="pagination.page"
	          :page-sizes="[10, 20, 30, 50, 100, 200, 300]"
	          :page-size="pagination.pageSize"
	          :layout="paginationLayout"
	          :total="total"
	        >
	        </el-pagination>
	      </el-row>
	     </el-footer>
		<#elseif type == 3>
      <div class="table-main" style="width: 100%;">
		        <ht-xmind
		          ref="multipleTemplateTable"
		          <#noparse>id="${templateAlias}"</#noparse>
		          :data="allRows"
		          :custom-table-height="currentTableHeight <#if isTab>-44</#if>"
				  :custom-table-max-height="currentTableMaxHeight"
		          style="width: 100%;height: 100%;"
		          @load="search"
				  v-loading="multipleTemplateTableloading"
				  :bpmDataTemplate="templateInfo"
				  pkField="${pkField}"
				   <#noparse>managePermission="${base64.getBase64(JsonUtil.toJsonString(managePermission))}"</#noparse>
				  @xmind-task-update="updateTemplateRowData"
				  @xmind-btn-click="scriptClick"
		        >
		          <template v-slot:toolbar>
		              <#noparse>
		                <#list manageFields as manage>
		                   <#if manage.name == 'add' || manage.name == 'export' || manage.name == 'import'>
				              <@genToolBar manage=manage managePermission=managePermission actionUrl=actionUrl btnIndex=manage_index/>
				           </#if>
		                </#list>
		              </#noparse>
		          </template>
		        </ht-xmind>
        </div>
		<#else>
			<#assign kanbanConfig=bpmDataTemplate.kanbanConfig?eval>
			<ht-kanban
					ref="kanban"
					:data="allRows"
					:template-info="templateInfo"
					:custom-table-height="currentTableHeight <#if isTab>-44</#if>"
					:custom-table-max-height="currentTableMaxHeight"
					@load="search"
					@add="(param) => scriptClick('add', '', param)"
					@edit="(param) => scriptClick('edit', '', param)"
					@remove="(param) => scriptClick('del', '', param)"
					:quick-search-props="handleQuickSearchParams('${conditionAllName}','${conditionAllDesc}')"
					v-loading="multipleTemplateTableloading"
					@selection-change="handleSelectionChange"
					<#noparse>manage-permission="${base64.getBase64(JsonUtil.toJsonString(managePermission))}"</#noparse>
			>
				<#if conditionFields?if_exists>
					<template v-slot:search>
						<ht-table-search-panel v-model="searchForm" :divide="3" :label-width="120">
							<#list conditionFields as field>
								<@genCondition field=field/>
							</#list>
						</ht-table-search-panel>
					</template>
				</#if>
				<template v-slot:toolbar>
					<#noparse>
						<#list manageFields as manage>
							<#if manage.name != 'print' && manage.name != 'url' && manage.name != 'addFlow' && manage.name != 'addData' && manage.name != 'searchData'&& manage.name != 'startFlow'>
								<@genToolBar manage=manage managePermission=managePermission actionUrl=actionUrl btnIndex=manage_index isKanban=true/>
							</#if>
						</#list>
					</#noparse>
				</template>
			</ht-kanban>
		</#if>
	</#assign>
	<#return rtn>
</#function>

<#--生成格式化函数-->
<#macro genFormaterFunction>
	<#if displayFields?if_exists>
		<#list displayFields as field>
			<#assign alarmSetting=field.alarmSetting >
			<#assign formater=field.formater>
			<#if formater?if_exists>
				function ${field.name}_Formater(value, row, index){
				${formater};
				}
			<#elseif alarmSetting?if_exists>
				<#assign alarm=alarmSetting >
				function ${field.name}_AlarmFormater(value, row, index){
				<#list alarm as item>
					if(${getCondition(item.condition,field)}){
					return "<span style='color:${item.color};font-weight:bold;'>" + value +"</span>";
					}
				</#list>
				return value;
				}

			</#if>
		</#list>
	</#if>
</#macro>

<#--生成查询条件宏 -->
<#macro genCondition field>
	<#assign content=field.controlContent>
	<ht-table-search-field :label="$td('${'formTemplate.${bpmDataTemplate.alias}.search.${field.name}'}', '${field.cm}')" prop="${field.na}"
	v-model="searchForm.${field.colPrefix!}${field.na}"
	operation="${field.qt}"
	style="padding-right:10px;"
	v-if="display('${field.mpDisplay}')"
	v-show="${!field.isShow}"
	<#if !field.isShow && field.validate?if_exists && field.validate?length gt 0 && field.validate?contains('required')> :isRequired="true"</#if>
	>
		<#if field.vf=="static" >
		<#-- colPrefix如果是外部表，值是返回"",非外部表的话就会有一个前缀，所以这里直接用这个拼接就行 -->
			<#switch field.ct>
				<#case "onetext">
					<#if field.ty == 'number'>
						<ht-input type="number" size="small" class="search-item" ht-query="${field.colPrefix!}${field.na}" v-model="searchForm.${field.colPrefix!}${field.na}" operation="${field.qt}" :placeholder="$td('${'formTemplate.${bpmDataTemplate.alias}.search.${colPrefix}${field.na}'}', '${field.cm}')"  name="Q^${field.colPrefix!}${field.na}^${field.qt}" <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if> clearable></ht-input>
					<#else>
						<ht-input type="text" size="small" class="search-item" ht-query="${field.colPrefix!}${field.na}" v-model="searchForm.${field.colPrefix!}${field.na}" operation="${field.qt}" :placeholder="$td('${'formTemplate.${bpmDataTemplate.alias}.search.${colPrefix}${field.na}'}', '${field.cm}')"  name="Q^${field.colPrefix!}${field.na}^${field.qt}" <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if> clearable @keyup.enter.native="searchEnterFun"></ht-input>
					</#if>
					<#break>
				<#-- 自定义对话框 -->
				<#case "customDialog">
					<#assign dg=content>
						<ht-custom-dialog
								v-model="searchForm.${field.colPrefix!}${field.na}"
								model-name="searchForm.${field.na}"
								class="search-item search-custom-dialog"
								isFromList="true"
								ht-query="${field.colPrefix!}${field.na}"
								special-query="${field.colPrefix!}${field.na}"
								operation="${field.qt}"
								:custdialog='${util.getCustDialogAttr(field.colPrefix,field)}'
								permission="w"
                                <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if>
								atter="searchForm.${field.colPrefix!}${field.na}">
						</ht-custom-dialog>
					<#break>
				<#case "date"><#--日期选择器 -->
					<@genQueryDate field=field/>
					<#break>
				<#case "select"><#--下拉选项-->
					<#assign options=content>
					<#assign otherOptionType=util.getJsonByPath(field.option,'otherOptionType','')>
					<#assign selectNum=util.getJsonByPath(field.option,'selectNum')>
			        <#if field.controlContent?if_exists>	
			        <#assign controlContent=util.getJsonByPath(field,'controlContent','')>
			        </#if>
				  <div style="display:inline">
				    <ht-select v-model="searchForm.${field.colPrefix!}${field.na}" model-name="searchForm.${field.colPrefix!}${field.na}"
					  filterable 
					  <#if selectNum=-1> multiple </#if>
					  class="search-item"
					  ht-query="${field.colPrefix!}${field.na}"
					  operation="${field.qt}"
                      <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if>
                      <#if field.cm?if_exists>:placeholder="$td('${'formTemplate.${bpmDataTemplate.alias}.search.${colPrefix}${field.na}'}', '${field.cm}')" </#if>
			           otherOptionType='${otherOptionType}'
		              <#if field.controlContent?if_exists>	     
		 	          :selectlist='${controlContent}' 	
				      </#if>
                      :ganged="${util.getSelectQuery(field.option,type!=1)}">		
				    </ht-select>								 
				  </div>
				<#break>
				<#case "dropdown"><#--下拉树选项-->
				    <#assign selectNum=util.getJsonByPath(field.option,'selectNum')>
					<#assign treeDataMode=util.getJsonByPath(field.option,'treeDataMode')>
				    <ht-select-tree 
					v-model="searchForm.${field.colPrefix!}${field.na}"
					model-name="searchForm.${field.colPrefix!}${field.na}"
					class="search-item"
					ht-query="${field.colPrefix!}${field.na}"
					operation="${field.qt}"
					:ganged="${util.getSelectQuery(field.option,type!=1)}"
                    filterable
					<#if field.cm?if_exists>:placeholder="$td('${'formTemplate.${bpmDataTemplate.alias}.search.${colPrefix}${field.na}'}', '${field.cm}')" </#if>
					<#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if>
					<#if selectNum=-1> multiple </#if>
					  :treeDataMode="${treeDataMode}">
                    </ht-select-tree>
				<#break>
				<#case "dic"><#--数据字典-->
					<#assign dickey=util.getJsonByPath(field.controlContent,'alias')>
					<#assign resultField=util.getJsonByPath(field.controlContent,'resultField')>
					<div style="display:inline-block;" class="col-md-12">
						<div ht-dic='${field.colPrefix!}${field.na}' dickey="${dickey}" resultfield="${resultField}" ht-query="${field.colPrefix!}${field.na}" bind="${field.colPrefix!}${field.na}" :desc="$td('${'formTemplate.${bpmDataTemplate.alias}.search.dic'}', '数据字典')" type="text"  ng-model="${field.colPrefix!}${field.na}" class="form-control"  <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if> ></div>
					</div>
					<#break>
				<#case "radio"><#--单选按钮 -->
				<#case "checkbox"><#--复选框 -->
					${getCheckboxOrRadio(field)}
					<#break>
				<#default>
					<ht-input type="text" size="small" class="search-item" ht-query="${field.colPrefix!}${field.na}" v-model="searchForm.${field.colPrefix!}${field.na}" operation="${field.qt}" :placeholder="$td('${'formTemplate.${bpmDataTemplate.alias}.search.${colPrefix}${field.na}'}', '${field.cm}')" name="Q^${field.colPrefix!}${field.na}^${field.qt}" <#if !field.isShow && field.validate?if_exists && field.validate?length gt 0> :validate="${field.validate}"</#if> clearable @keyup.enter.native="searchEnterFun"></ht-input>
					<#break>
			</#switch>
		</#if>
	</ht-table-search-field>
</#macro>
<#noparse>
	<#--管理列  以前的模板-->
	<#macro genManageOld manage managePermission actionUrl data>
	<#--编辑-->
	<#if manage.name == 'edit'>
	<#if util.fieldPermissionValidation('edit', managePermission, manage.buttonId, '')>
	<el-button id="${manage.buttonId}"  v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="permission.edit && display('${manage.mpDisplay}')"  type="text" @click="scriptClick('edit','${manage.afterScriptValue}',{templateId:'${templateId}',id:scope.row.${pkField}, buttonId:'${manage.buttonId}', action:'edit', defId:'${bpmDataTemplate.defId}',
			isStartFlow:scope.row.isStartFlow,openType:'${manage.openType}', quitAfterSaving: '${manage.quitAfterSaving}', dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',row: scope.row})" size="small" plain>{{$td('eip.common.edit', '${manage.desc}')}}</el-button>
	</#if>
	<#--复制-->
	<#elseif manage.name == 'copy'>
	<#if managePermission.copy>
	<el-button id="${manage.buttonId}" type="text" v-if="display('${manage.mpDisplay}')"    size="small"  @click="scriptClick('copyOne','${manage.afterScriptValue}',{pkField:scope.row.${pkField}})" >{{$td('eip.common.copy', '${manage.desc}')}}</el-button>
	</#if>
	<#--打印明细 -->
	<#elseif manage.name == 'printDetail'>
	<#if managePermission.printDetail>
	<el-button id="${manage.buttonId}" type="text" v-if="display('${manage.mpDisplay}')"    size="small" @click='printDetail("${templateId}",scope.row.${pkField},"get", scope.row.${"bpm_proc_inst_id_"})'>{{$td('eip.common.printDetail', '${manage.desc}')}}</el-button>
	</#if>
	<#--删除-->
	<#elseif manage.name == 'del' >
	<#if managePermission.del>
	<el-button id="${manage.buttonId}" type="text" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}"  v-if="permission.del && display('${manage.mpDisplay}')"   @click="scriptClick('del','${manage.afterScriptValue}',{pkField:scope.row.${pkField}})" size="small" plain>{{$td('eip.common.remove', '${manage.desc}' )}}</el-button>
	</#if>

	<#--新增流程-->
	<#elseif manage.name == 'addFlow'>
	<#if managePermission.addFlow>
	<el-button id="${manage.buttonId}" type="text" v-if="display('${manage.mpDisplay}')"   @click="scriptClick('addFlow','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}',pkField:scope.row.${pkField}, row:scope.row,dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',openType: '${manage.openType}'});" size="small" plain>{{$td('eip.common.addFlow', '${manage.desc}')}}</el-button>
	</#if>
	<#--新增数据-->
	<#elseif manage.name == 'addData'>
	<#if managePermission.addData>
	<el-button id="${manage.buttonId}" type="text" v-if="display('${manage.mpDisplay}')"   @click="scriptClick('addData','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}',pkField:scope.row.${pkField}, row:scope.row,dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',});" size="small" plain>{{$td('eip.common.addData', '${manage.desc}')}}</el-button>
	</#if>
	<#--查询数据-->
	<#elseif manage.name == 'searchData'>
	<#if managePermission.searchData>
	<el-button id="${manage.buttonId}" type="text" v-if="display('${manage.mpDisplay}')"   @click="scriptClick('searchData','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}',pkField:scope.row.${pkField}, row:scope.row,dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',openType: '${manage.openType}'});" size="small" plain>{{$td('eip.common.searchData', '${manage.desc}')}}</el-button>
	</#if>

	<#--子表-->
	<#elseif manage.name == 'sub'>
	<#if managePermission.sub && hasSub>
	<el-button
	        id="${manage.buttonId}"
			type="text"
				v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}"
			v-if="display('${manage.mpDisplay}')"
			@click='showSubList(scope.row.${pkField}<#if manage.options>
				,{import: ${(manage.options.import)?string('true', 'false')}, export: ${(manage.options.export)?string('true', 'false')},subOpenType:"${manage.subOpenType}",dialogWidth:"${manage.dialogWidth}",dialogHeight:"${manage.dialogHeight}"}
					<#else>
			,""
			</#if>,
			scope.row,"${manage.afterScriptValue}"    );'
			size="small"
			plain
	>{{$td('eip.common.showSubList', '${manage.desc}')}}</el-button>
	</#if>
	<#--生成二维码-->
	<#elseif manage.name == 'produceQRCode' >
	<#if managePermission.produceQRCode>
	<el-button  id="${manage.buttonId}" type="text"   v-if="display('${manage.mpDisplay}')" @click='getQRCode("${templateId}",scope.row.${pkField},"${bpmDataTemplate.mobileFormAlias}",${JsonUtil.toJson(manage.display)},scope.index,"${manage.title}","${manage.modelType}","${manage.valueType}","${manage.defaultValue}","${manage.formulasDiyJs}",${manage.QRCodePattern})' size="small" plain>{{$td('eip.common.produceQRCode', '${manage.desc}')}}</el-button>
	</#if>
	<#--明细-->
	<#elseif manage.name == 'detail' >
	<#if managePermission.detail>
	<el-button id="${manage.buttonId}"  type="text" v-if="display('${manage.mpDisplay}')"  @click='operating("${templateId}",scope.row.${pkField},"get","","","${manage.openType}",false,"",false,false,scope.row,"detail");' size="small" plain>{{$td('eip.common.detail', '${manage.desc}')}}</el-button>
	</#if>
	<#elseif manage.name == 'url' &&manage.type=='1'>
	<#if util.fieldPermissionValidation('url', managePermission, manage.desc, manage.url, manage.urlParams)>
	<el-button id="${manage.buttonId}" type="text" v-if="display('${manage.mpDisplay}')" @click="openUrl('${manage.url}','new','','')" size="small" plain>{{$td('eip.common.url', '${manage.desc}')}}</el-button>
	</#if>
	<#--表单修改记录-->
	<#elseif manage.name == 'record' >
	<#if managePermission.record>
	<el-button id="${manage.buttonId}" type="text" 	v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="display('${manage.mpDisplay}')" @click="openRecordList(scope.row.${pkField}, scope.row.${'bpm_proc_inst_id_'})" size="small" plain>{{$td('eip.common.record', '${manage.desc}')}}</el-button>
	</#if>
	<#elseif manage.name == 'switch' >
	<#if util.fieldPermissionValidation('switch', managePermission, manage.desc, manage.switchOn, manage.switchOff)>
	<el-tooltip v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" content="${manage.desc}" effect="dark" v-if="display('${manage.mpDisplay}')">
		<el-switch
      @change='scriptClick("switch","${manage.afterScriptValue}",{pkField:scope.row.${pkField},switchOn:"${manage.switchOn}",switchOff:"${manage.switchOff}",bind:"${manage.bind}",row:scope.row,switchDefaultTrue:"${manage.switchDefaultTrue}"})'
      :value="scope.row.${manage.bind}"
      active-value="${manage.switchOn}"
      inactive-value="${manage.switchOff}"
      v-if="scope.row.${manage.bind} =='${manage.switchOn}' || scope.row.${manage.bind} =='${manage.switchOff}'"
		>
		</el-switch>
		<el-switch
      @change='scriptClick("switch","${manage.afterScriptValue}",{pkField:scope.row.${pkField},switchOn:"${manage.switchOn}",switchOff:"${manage.switchOff}",bind:"${manage.bind}",row:scope.row,switchDefaultTrue:"${manage.switchDefaultTrue}"})'
      active-value="${manage.switchOn}"
      inactive-value="${manage.switchOff}"
      :value="'${manage.switchDefaultTrue}'=='true'?'${manage.switchOn}':'${manage.switchOff}'"
      v-else
		>
		</el-switch>
	</el-tooltip>
	</#if>
	<#elseif manage.name == 'js' >
	<#if util.fieldPermissionValidation('js', managePermission, manage.desc, manage.jsValue)>
	<el-button id="${manage.buttonId}" type="text"  v-if="display('${manage.mpDisplay}')"  @click='customEvilJS(scope.row,"${manage.jsValue}")' size="small" plain>{{$td('eip.common.js', '${manage.desc}')}}</el-button>
	</#if>
	<#else>
	</#if>
	</#macro>
<#--管理列展开-->
	<#macro genManageExpand manage managePermission actionUrl data>
	<#--编辑-->
	<#if manage.name == 'edit'>
	<#if util.fieldPermissionValidation('edit', managePermission, manage.buttonId, '') && manage.linePosition>
	<el-button  type="${manage.theme!'primary'}"  name="${manage.desc}" id="${manage.buttonId}"
	            v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}"
				v-if="'${manage.linePosition}' && permission.edit && display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"  @click.native="scriptClick('edit','${manage.afterScriptValue}',{templateId:'${templateId}',id:scope.row.${pkField} || scope.row.id, buttonId:'${manage.buttonId}', action:'edit',defId:'${bpmDataTemplate.defId}',
				isStartFlow:scope.row.isStartFlow,openType:'${manage.openType}', quitAfterSaving: '${manage.quitAfterSaving}', sizeType: '${manage.sizeType}', dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',row: scope.row})" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	<#--复制-->
	<#elseif manage.name == 'copy'>
	<#if managePermission.copy && manage.linePosition>
	<el-button  type="${manage.theme!'primary'}"  name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" size="mini" @click.native="scriptClick('copyOne','${manage.afterScriptValue}',{pkField:scope.row.${pkField}})" >{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	<#--打印明细 -->
	<#elseif manage.name == 'print'>
	<#if managePermission.print && manage.linePosition>
	<el-button  type="${manage.theme!'primary'}"   name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" size="mini" @click.native='printDetail("${templateId}",scope.row.${pkField},"get", scope.row.${"bpm_proc_inst_id_"},"${manage.printTemplateVal}","${bpmDataTemplate.boDefAlias}","${manage.afterScriptValue}",{row:scope.row,id:scope.row.${pkField} || scope.row.id})'>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	<#--删除-->
	<#elseif manage.name == 'del'  && manage.linePosition>
	<#if managePermission.del>
	<el-button  type="${manage.theme!'primary'}"  name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="permission.del && display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"   @click.native="scriptClick('del','${manage.afterScriptValue}',{pkField:scope.row.${pkField} || scope.row.id})" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>

	<#--新增流程-->
	<#elseif manage.name == 'addFlow'>
	<#if util.fieldPermissionValidation('addFlow', managePermission, manage.buttonId, '') && manage.linePosition>
	<el-button  type="${manage.theme!'primary'}"  name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"
					  @click.native="scriptClick('addFlow','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}',pkField:scope.row.${pkField}, row:scope.row,dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',openType: '${manage.openType}'},'linePosition');" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	<#--新增数据-->
	<#elseif manage.name == 'addData'>
	<#if util.fieldPermissionValidation('addData', managePermission, manage.buttonId, '') && manage.linePosition>
	<el-button  type="${manage.theme!'primary'}"  name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"
					  @click.native="scriptClick('addData','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}',pkField:scope.row.${pkField}, row:scope.row, sizeType: '${manage.sizeType}',dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',openType: '${manage.openType}'},'linePosition');" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	<#--查询数据-->
	<#elseif manage.name == 'searchData'>
	<#if util.fieldPermissionValidation('searchData', managePermission, manage.buttonId, '') && manage.linePosition>
	<el-button  type="${manage.theme!'primary'}"  name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"
					  @click.native="scriptClick('searchData','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}',pkField:scope.row.${pkField}, row:scope.row,sizeType: '${manage.sizeType}',dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',openType: '${manage.openType}'});" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>

	<#--子表-->
	<#elseif manage.name == 'sub'>
	<#if managePermission.sub && hasSub && manage.linePosition>
	<el-button
      name="${manage.desc}"
      type="${manage.theme!'primary'}"
	  id="${manage.buttonId}"
	        v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}"
			v-if="display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)"
			@click.native='showSubList(scope.row.${pkField}
			<#if manage.options>
				,{import: ${(manage.options.import)?string('true', 'false')}, export: ${(manage.options.export)?string('true', 'false')},subOpenType:"${manage.subOpenType}",dialogWidth:"${manage.dialogWidth}",dialogHeight:"${manage.dialogHeight}"}
					<#else>
			,""
			</#if>,
			scope.row,"${manage.afterScriptValue}"    
			);'
			size="mini"
	>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>

	<#--生成二维码-->
	<#elseif manage.name == 'produceQRCode' >
	<#if managePermission.produceQRCode && manage.linePosition>
	<el-button  type="${manage.theme!'primary'}"  name="${manage.desc}" id="${manage.buttonId}" v-if="display('${manage.mpDisplay}')" @click.native='getQRCode("${templateId}",scope.row.${pkField},"${bpmDataTemplate.mobileFormAlias}",${JsonUtil.toJson(manage.display)},scope.index,"${manage.title}","${manage.modelType}","${manage.valueType}","${manage.defaultValue}","${manage.formulasDiyJs}",${manage.QRCodePattern})' size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>

	<#--明细-->
	<#elseif manage.name == 'detail' >
	<#if managePermission.detail && manage.linePosition>
	<el-button  type="${manage.theme!'primary'}"  name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)"  @click.native='operating("${templateId}",scope.row.${pkField},"get","","","${manage.openType}",false,"",false,false,scope.row,"detail","${manage.afterScriptValue}","","${util.toJsonStr(manage)}");' size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>

	<#--url按钮-->
	<#elseif manage.name == 'url'>
	<#if manage.linePosition && util.fieldPermissionValidation('url', managePermission, manage.desc, manage.url, manage.urlParams)>
	<el-button  type="${manage.theme!'primary'}"  name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"
					  @click.native="scriptClick('url','${manage.afterScriptValue}',{url:'${manage.url}',type:'new',fieldName:'', urlParams:'${manage.urlParams!}',pkField:scope.row.${pkField}, row:scope.row, sizeType: '${manage.sizeType}', dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',openType: '${manage.openType}', tokenEnabled:'${manage.tokenEnabled}', tokenType:'${manage.tokenType}', tokenKey:'${manage.tokenKey}', tokenApi:'${manage.tokenApi}', buttonId: '${manage.buttonId}'})" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>

	<#--表单修改记录-->
	<#elseif manage.name == 'record' >
	<#if managePermission.record && manage.linePosition>
	<el-button  type="${manage.theme!'primary'}"  name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click.native="openRecordList(scope.row.${pkField}, scope.row.${'bpm_proc_inst_id_'},
			scope.row,'${manage.afterScriptValue}' )" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>

	<#--js按钮-->
	<#elseif manage.name == 'js' >
	<#if manage.linePosition && util.fieldPermissionValidation('js', managePermission, manage.desc, manage.jsValue)>
	<el-button  type="${manage.theme!'primary'}"  name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)"  @click.native='customEvilJS(scope.row,"${manage.jsValue}", {dialogWidth: "${manage.dialogWidth}",dialogHeight: "${manage.dialogHeight}",openType: "${manage.openType}"},"${manage.afterScriptValue}")' size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>

	<#elseif manage.name == 'startFlow' && manage.linePosition && managePermission.startFlow>
	<el-button  type="${manage.theme!'primary'}" size="mini" name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="!scope.row.isStartFlow&& '${bpmDataTemplate.defId}' && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click.native='startFlow(scope.row.${pkField},"${manage.afterScriptValue}",{row:scope.row,id:scope.row.${pkField} || scope.row.id}
	);'> {{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>

	<#--更新数据-->
	<#elseif  manage.name == 'batchUpdate'>
	<#if manage.linePosition && util.fieldPermissionValidation('batchUpdate', managePermission, manage.desc, manage.batchUpdateData, manage.relationConfig)>
	<el-button  type="${manage.theme!'primary'}"  name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)" size="mini" @click.native="scriptClick('batchUpdate','${manage.afterScriptValue}',{row:scope.row,position:'${manage.linePosition}',desc:'${manage.desc}', buttonId: '${manage.buttonId}', batchUpdateData:'${manage.batchUpdateData}',filedsObj:'${manage.filedsObj}',relationConfig: '${manage.relationConfig}'})">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	<#--任务办理-->
	<#elseif manage.name == 'approval' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.approval && manage.linePosition>
	<el-button  type="${manage.theme!'primary'}"  name="${manage.desc}" id="${manage.buttonId}"  v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].approval && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click.native="handleApproval(scope.row, '${manage.openType}','${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id, sizeType:'${manage.sizeType}', dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}'})" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	<#--流程图-->
	<#elseif manage.name == 'taskImage' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.taskImage && manage.linePosition>
	<el-button  type="${manage.theme!'primary'}"  name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}"  v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].taskImage && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click.native="showTaskImage(scope.row,'${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id})" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	<#--审批历史-->
	<#elseif manage.name == 'history' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.history && manage.linePosition>
	<el-button  type="${manage.theme!'primary'}"  name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].history && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click.native="showInstHistory(scope.row,'${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id})" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	<#--撤回-->
	<#elseif manage.name == 'revoke' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.revoke && manage.linePosition>
	<el-button  type="${manage.theme!'primary'}"  name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].revoke && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click.native="handleRevoke(scope.row,'${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id})" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	<#--任务明细-->
	<#elseif manage.name == 'taskDetail' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.taskDetail && manage.linePosition>
	<el-button  type="${manage.theme!'primary'}"  name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}"  v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].taskDetail && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)"" @click.native="showTaskDetail(scope.row, '${manage.openType}',{sizeType:'${manage.sizeType}',dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}'},'${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id})" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	<#--传阅-->
	<#elseif manage.name == 'taskToRead' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.taskToRead && manage.linePosition>
	<el-button  type="${manage.theme!'primary'}"  name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].taskToRead && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click.native="taskToRead(scope.row,'${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id})" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	<#--删除草稿-->
	<#elseif manage.name == 'phyDelete' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.phyDelete && manage.linePosition>
	<el-button  type="${manage.theme!'primary'}"  name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].phyDelete && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click.native="phyDelete(scope.row,'${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id})" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	<#--删除流程-->
	<#elseif manage.name == 'logicDelete' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.logicDelete && manage.linePosition>
	<el-button  type="${manage.theme!'primary'}"  name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].logicDelete && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click.native="logicDelete(scope.row,'${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id})" size="mini">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	<#else>
	</#if>
	</#macro>



	<#--管理列-->
	<#macro genManage manage managePermission actionUrl data>
	<#--编辑-->
	<#if manage.name == 'edit'>
	<#if util.fieldPermissionValidation('edit', managePermission, manage.buttonId, '') && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}"
	            v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}"
				v-if="'${manage.linePosition}' && permission.edit && display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"  type="text" @click.native="scriptClick('edit','${manage.afterScriptValue}',{templateId:'${templateId}',id:scope.row.${pkField} || scope.row.id, buttonId:'${manage.buttonId}', action:'edit',defId:'${bpmDataTemplate.defId}',
				isStartFlow:scope.row.isStartFlow,openType:'${manage.openType}', quitAfterSaving: '${manage.quitAfterSaving}', sizeType: '${manage.sizeType}', dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',row: scope.row})" size="small" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--复制-->
	<#elseif manage.name == 'copy'>
	<#if managePermission.copy && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" size="small" @click.native="scriptClick('copyOne','${manage.afterScriptValue}',{pkField:scope.row.${pkField}})" >{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--打印明细 -->
	<#elseif manage.name == 'print'>
	<#if managePermission.print && manage.linePosition>
	<el-dropdown-item  name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" size="small" @click.native='printDetail("${templateId}",scope.row.${pkField},"get", scope.row.${"bpm_proc_inst_id_"},"${manage.printTemplateVal}","${bpmDataTemplate.boDefAlias}","${manage.afterScriptValue}",{row:scope.row,id:scope.row.${pkField} || scope.row.id})'>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--删除-->
	<#elseif manage.name == 'del'  && manage.linePosition>
	<#if managePermission.del>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="permission.del && display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"   @click.native="scriptClick('del','${manage.afterScriptValue}',{pkField:scope.row.${pkField} || scope.row.id})" size="small" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>

	<#--新增流程-->
	<#elseif manage.name == 'addFlow'>
	<#if util.fieldPermissionValidation('addFlow', managePermission, manage.buttonId, '') && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"
					  @click.native="scriptClick('addFlow','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}',pkField:scope.row.${pkField}, row:scope.row,dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',openType: '${manage.openType}'},'linePosition');" size="small" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--新增数据-->
	<#elseif manage.name == 'addData'>
	<#if util.fieldPermissionValidation('addData', managePermission, manage.buttonId, '') && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"
					  @click.native="scriptClick('addData','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}',pkField:scope.row.${pkField}, row:scope.row, sizeType: '${manage.sizeType}',dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',openType: '${manage.openType}'},'linePosition');" size="small" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--查询数据-->
	<#elseif manage.name == 'searchData'>
	<#if util.fieldPermissionValidation('searchData', managePermission, manage.buttonId, '') && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"
					  @click.native="scriptClick('searchData','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}',pkField:scope.row.${pkField}, row:scope.row,sizeType: '${manage.sizeType}',dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',openType: '${manage.openType}'});" size="small" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>

	<#--子表-->
	<#elseif manage.name == 'sub'>
	<#if managePermission.sub && hasSub && manage.linePosition>
	<el-dropdown-item
      name="${manage.desc}"
	  id="${manage.buttonId}"
	        v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}"
			v-if="display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)"
			@click.native='showSubList(scope.row.${pkField}
			<#if manage.options>
				,{import: ${(manage.options.import)?string('true', 'false')}, export: ${(manage.options.export)?string('true', 'false')},subOpenType:"${manage.subOpenType}",dialogWidth:"${manage.dialogWidth}",dialogHeight:"${manage.dialogHeight}"}
					<#else>
			,""
			</#if>,
			scope.row,"${manage.afterScriptValue}"    
			);'
			size="small" plain
	>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>

	<#--生成二维码-->
	<#elseif manage.name == 'produceQRCode' >
	<#if managePermission.produceQRCode && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="display('${manage.mpDisplay}')" @click.native='getQRCode("${templateId}",scope.row.${pkField},"${bpmDataTemplate.mobileFormAlias}",${JsonUtil.toJson(manage.display)},scope.index,"${manage.title}","${manage.modelType}","${manage.valueType}","${manage.defaultValue}","${manage.formulasDiyJs}",${manage.QRCodePattern})' size="small" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>

	<#--明细-->
	<#elseif manage.name == 'detail' >
	<#if managePermission.detail && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)"  @click.native='operating("${templateId}",scope.row.${pkField},"get","","","${manage.openType}",false,"",false,false,scope.row,"detail","${manage.afterScriptValue}","","${util.toJsonStr(manage)}");' size="small" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>

	<#--url按钮-->
	<#elseif manage.name == 'url'>
	<#if manage.linePosition && util.fieldPermissionValidation('url', managePermission, manage.desc, manage.url, manage.urlParams)>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"
					  @click.native="scriptClick('url','${manage.afterScriptValue}',{url:'${manage.url}',type:'new',fieldName:'', urlParams:'${manage.urlParams!}',pkField:scope.row.${pkField}, row:scope.row, sizeType: '${manage.sizeType}', dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',openType: '${manage.openType}', tokenEnabled:'${manage.tokenEnabled}', tokenType:'${manage.tokenType}', tokenKey:'${manage.tokenKey}', tokenApi:'${manage.tokenApi}', buttonId: '${manage.buttonId}'})" size="small" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>

	<#--表单修改记录-->
	<#elseif manage.name == 'record' >
	<#if managePermission.record && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click.native="openRecordList(scope.row.${pkField}, scope.row.${'bpm_proc_inst_id_'},
			scope.row,'${manage.afterScriptValue}' )" size="small" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>

	<#--js按钮-->
	<#elseif manage.name == 'js' >
	<#if manage.linePosition && util.fieldPermissionValidation('js', managePermission, manage.desc, manage.jsValue)>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)"  @click.native='customEvilJS(scope.row,"${manage.jsValue}", {dialogWidth: "${manage.dialogWidth}",dialogHeight: "${manage.dialogHeight}",openType: "${manage.openType}"},"${manage.afterScriptValue}")' size="small" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>

	<#elseif manage.name == 'startFlow' && manage.linePosition && managePermission.startFlow>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="!scope.row.isStartFlow&& '${bpmDataTemplate.defId}' && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click.native='startFlow(scope.row.${pkField},"${manage.afterScriptValue}",{row:scope.row,id:scope.row.${pkField} || scope.row.id}
	);'  plain> {{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>

	<#--更新数据-->
	<#elseif  manage.name == 'batchUpdate'>
	<#if manage.linePosition && util.fieldPermissionValidation('batchUpdate', managePermission, manage.desc, manage.batchUpdateData, manage.relationConfig)>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)" size="small" @click.native="scriptClick('batchUpdate','${manage.afterScriptValue}',{row:scope.row,position:'${manage.linePosition}',desc:'${manage.desc}', buttonId: '${manage.buttonId}', batchUpdateData:'${manage.batchUpdateData}',filedsObj:'${manage.filedsObj}',relationConfig: '${manage.relationConfig}'})">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--任务办理-->
	<#elseif manage.name == 'approval' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.approval && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}"  v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].approval && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click.native="handleApproval(scope.row, '${manage.openType}','${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id ,sizeType:'${manage.sizeType}', dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}'})" size="small">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--流程图-->
	<#elseif manage.name == 'taskImage' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.taskImage && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}"  v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].taskImage && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click.native="showTaskImage(scope.row,'${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id})" size="small">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--审批历史-->
	<#elseif manage.name == 'history' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.history && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].history && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click.native="showInstHistory(scope.row,'${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id})" size="small">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--撤回-->
	<#elseif manage.name == 'revoke' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.revoke && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].revoke && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click.native="handleRevoke(scope.row,'${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id})" size="small">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--任务明细-->
	<#elseif manage.name == 'taskDetail' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.taskDetail && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}"  v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].taskDetail && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)"" @click.native="showTaskDetail(scope.row, '${manage.openType}',{sizeType:'${manage.sizeType}',dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}'},'${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id})" size="small">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--传阅-->
	<#elseif manage.name == 'taskToRead' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.taskToRead && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].taskToRead && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click.native="taskToRead(scope.row,'${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id})" size="small">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--删除草稿-->
	<#elseif manage.name == 'phyDelete' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.phyDelete && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].phyDelete && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click.native="phyDelete(scope.row,'${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id})" size="small">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#--删除流程-->
	<#elseif manage.name == 'logicDelete' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.logicDelete && manage.linePosition>
	<el-dropdown-item name="${manage.desc}" id="${manage.buttonId}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" v-if="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].logicDelete && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click.native="logicDelete(scope.row,'${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id})" size="small">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-dropdown-item>
	</#if>
	<#else>
	</#if>
	</#macro>

	<#--管理列-->
	<#macro genFirstBtn manage managePermission actionUrl data dataButtonGroup>
	<#--编辑-->
	<#if manage.name == 'edit'>
	<#if util.fieldPermissionValidation('edit', managePermission, manage.buttonId, '') && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" data-button-group="${dataButtonGroup}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}"
        <#if dataButtonGroup?if_exists>style="width: 60px"</#if>
		<#if dataButtonGroup?if_exists> v-if <#else> v-else-if </#if>
		  ="permission.edit && display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"
		  type="text" @click="scriptClick('edit','${manage.afterScriptValue}',{templateId:'${templateId}',id:scope.row.${pkField} || scope.row.id, buttonId:'${manage.buttonId}', action:'edit',defId:'${bpmDataTemplate.defId}',
				isStartFlow:scope.row.isStartFlow,openType:'${manage.openType}', quitAfterSaving: '${manage.quitAfterSaving}', sizeType: '${manage.sizeType}', dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',row: scope.row})" size="small" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--复制-->
	<#elseif manage.name == 'copy'>
	<#if managePermission.copy && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" data-button-group="${dataButtonGroup}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}"
    <#if dataButtonGroup?if_exists>style="width: 60px"</#if>
    <#if dataButtonGroup?if_exists> v-if <#else> v-else-if </#if>
	="display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" size="small"  @click="scriptClick('copyOne','${manage.afterScriptValue}',{pkField:scope.row.${pkField}})" >{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--打印明细 -->
	<#elseif manage.name == 'print'>
	<#if managePermission.print && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" data-button-group="${dataButtonGroup}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}"
    <#if dataButtonGroup?if_exists>style="width: 60px"</#if>
    <#if dataButtonGroup?if_exists> v-if <#else> v-else-if </#if>
	="display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" size="small" @click='printDetail("${templateId}",scope.row.${pkField},"get", scope.row.${"bpm_proc_inst_id_"},"${manage.printTemplateVal}","${bpmDataTemplate.boDefAlias}","${manage.afterScriptValue}",{row:scope.row,id:scope.row.${pkField} || scope.row.id})'>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--删除-->
	<#elseif manage.name == 'del' >
	<#if managePermission.del && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" data-button-group="${dataButtonGroup}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}"
    <#if dataButtonGroup?if_exists>style="width: 60px"</#if>
    <#if dataButtonGroup?if_exists> v-if <#else> v-else-if </#if>
	="permission.del && display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"   @click="scriptClick('del','${manage.afterScriptValue}',{pkField:scope.row.${pkField} || scope.row.id})" size="small" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>

	<#--新增流程-->
	<#elseif manage.name == 'addFlow'>
	<#if util.fieldPermissionValidation('addFlow', managePermission, manage.buttonId, '') && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" data-button-group="${dataButtonGroup}" v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}"
    <#if dataButtonGroup?if_exists>style="width: 60px"</#if>
    <#if dataButtonGroup?if_exists> v-if <#else> v-else-if </#if>
    ="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"   @click="scriptClick('addFlow','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}',pkField:scope.row.${pkField}, row:scope.row,dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',openType: '${manage.openType}'},'linePosition');" size="small" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--新增数据-->
	<#elseif manage.name == 'addData'>
	<#if util.fieldPermissionValidation('addData', managePermission, manage.buttonId, '') && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" data-button-group="${dataButtonGroup}" <#if dataButtonGroup?if_exists>style="width: 60px"</#if> v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" <#if dataButtonGroup?if_exists> v-if <#else> v-else-if </#if>="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"   @click="scriptClick('addData','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}',pkField:scope.row.${pkField}, row:scope.row, sizeType: '${manage.sizeType}',dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',openType: '${manage.openType}'},'linePosition');" size="small" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--查询数据-->
	<#elseif manage.name == 'searchData'>
	<#if util.fieldPermissionValidation('searchData', managePermission, manage.buttonId, '') && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" data-button-group="${dataButtonGroup}" <#if dataButtonGroup?if_exists>style="width: 60px"</#if> v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" <#if dataButtonGroup?if_exists> v-if <#else> v-else-if </#if>="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)"   @click="scriptClick('searchData','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}',pkField:scope.row.${pkField}, row:scope.row,sizeType: '${manage.sizeType}',dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',openType: '${manage.openType}'});" size="small" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>

	<#--子表-->
	<#elseif manage.name == 'sub'>
	<#if managePermission.sub && hasSub && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" data-button-group="${dataButtonGroup}" <#if dataButtonGroup?if_exists>style="width: 60px"</#if> v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" <#if dataButtonGroup?if_exists> v-if <#else> v-else-if </#if>="display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)"
		  @click='showSubList(scope.row.${pkField}<#if manage.options>
				,{import: ${(manage.options.import)?string('true', 'false')}, export: ${(manage.options.export)?string('true', 'false')}}
					<#else>
			,""
			</#if>,
			scope.row,"${manage.afterScriptValue}"    );'
		  size="small" plain
	>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>

	<#--生成二维码-->
	<#elseif manage.name == 'produceQRCode' >
	<#if managePermission.produceQRCode && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" data-button-group="${dataButtonGroup}" <#if dataButtonGroup?if_exists>style="width: 60px"</#if> <#if dataButtonGroup?if_exists> v-if <#else> v-else-if </#if>="display('${manage.mpDisplay}')" @click='getQRCode("${templateId}",scope.row.${pkField},"${bpmDataTemplate.mobileFormAlias}",${JsonUtil.toJson(manage.display)},scope.index,"${manage.title}","${manage.modelType}","${manage.valueType}","${manage.defaultValue}","${manage.formulasDiyJs}",${manage.QRCodePattern})' size="small" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>

	<#--明细-->
	<#elseif manage.name == 'detail' >
	<#if managePermission.detail && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" data-button-group="${dataButtonGroup}" <#if dataButtonGroup?if_exists>style="width: 60px"</#if> v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" <#if dataButtonGroup?if_exists> v-if <#else> v-else-if </#if>="display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)"  @click='operating("${templateId}",scope.row.${pkField},"get","","","${manage.openType}",false,"",false,false,scope.row,"detail","${manage.afterScriptValue}","","${util.toJsonStr(manage)}");' size="small" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>

	<#--url按钮-->
	<#elseif manage.name == 'url'>
	<#if manage.linePosition && util.fieldPermissionValidation('url', managePermission, manage.desc, manage.url, manage.urlParams)>
	<span name="${manage.desc}" id="${manage.buttonId}" data-button-group="${dataButtonGroup}" <#if dataButtonGroup?if_exists>style="width: 60px"</#if> v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" <#if dataButtonGroup?if_exists> v-if <#else> v-else-if </#if>="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)" @click="scriptClick('url','${manage.afterScriptValue}',{url:'${manage.url}',type:'new',fieldName:'', urlParams:'${manage.urlParams!}',pkField:scope.row.${pkField}, row:scope.row, sizeType: '${manage.sizeType}',dialogWidth: '${manage.dialogWidth}',dialogHeight: '${manage.dialogHeight}',openType: '${manage.openType}', tokenEnabled:'${manage.tokenEnabled}', tokenType:'${manage.tokenType}', tokenKey:'${manage.tokenKey}', tokenApi:'${manage.tokenApi}', buttonId: '${manage.buttonId}'})" size="small" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>

	<#--表单修改记录-->
	<#elseif manage.name == 'record' >
	<#if managePermission.record && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" data-button-group="${dataButtonGroup}" <#if dataButtonGroup?if_exists>style="width: 60px"</#if> v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" <#if dataButtonGroup?if_exists> v-if <#else> v-else-if </#if>="display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click="openRecordList(scope.row.${pkField}, scope.row.${'bpm_proc_inst_id_'},
			scope.row,'${manage.afterScriptValue}' )" size="small" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>

	<#--js按钮-->
	<#elseif manage.name == 'js' >
	<#if manage.linePosition && util.fieldPermissionValidation('js', managePermission, manage.desc, manage.jsValue)>
	<span name="${manage.desc}" id="${manage.buttonId}" data-button-group="${dataButtonGroup}" <#if dataButtonGroup?if_exists>style="width: 60px"</#if> v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" <#if dataButtonGroup?if_exists> v-if <#else> v-else-if </#if>="display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)"  @click='customEvilJS(scope.row,"${manage.jsValue}",{dialogWidth: "${manage.dialogWidth}",dialogHeight: "${manage.dialogHeight}",openType: "${manage.openType}"},"${manage.afterScriptValue}")' size="small" plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>

	<#elseif manage.name == 'startFlow' && manage.linePosition && managePermission.startFlow>
	<span name="${manage.desc}" id="${manage.buttonId}" data-button-group="${dataButtonGroup}" <#if dataButtonGroup?if_exists>style="width: 60px"</#if> v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" <#if dataButtonGroup?if_exists> v-if <#else> v-else-if </#if>="!scope.row.isStartFlow&& '${bpmDataTemplate.defId}'&& execScript('${manage.beforeScriptValue}',scope.row)" @click='startFlow(scope.row.${pkField},"${manage.afterScriptValue}",{row:scope.row,id:scope.row.${pkField} || scope.row.id})'  plain>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>

	<#--更新数据-->
	<#elseif manage.name == 'batchUpdate'>
	<#if manage.linePosition && util.fieldPermissionValidation('batchUpdate', managePermission, manage.desc, manage.batchUpdateData, manage.relationConfig)>
	<span name="${manage.desc}" id="${manage.buttonId}" data-button-group="${dataButtonGroup}" <#if dataButtonGroup?if_exists>style="width: 60px"</#if> v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" <#if dataButtonGroup?if_exists> v-if <#else> v-else-if </#if>="display('${manage.mpDisplay}') && execScript('${manage.beforeScriptValue}',scope.row)" size="small" @click="scriptClick('batchUpdate','${manage.afterScriptValue}',{row:scope.row,position:'${manage.linePosition}',desc:'${manage.desc}', buttonId: '${manage.buttonId}',batchUpdateData:'${manage.batchUpdateData}',filedsObj:'${manage.filedsObj}',relationConfig: '${manage.relationConfig}'})" icon="el-icon-edit">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--任务办理-->
	<#elseif manage.name == 'approval' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.approval && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" data-button-group="${dataButtonGroup}" <#if dataButtonGroup?if_exists>style="width: 60px"</#if> v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" <#if dataButtonGroup?if_exists> v-if <#else> v-else-if </#if>="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].approval && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click="handleApproval(scope.row, '${manage.openType}','${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id,sizeType:'${manage.sizeType}',dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}'})">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--流程图-->
	<#elseif manage.name == 'taskImage' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.taskImage && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" data-button-group="${dataButtonGroup}" <#if dataButtonGroup?if_exists>style="width: 60px"</#if> v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" <#if dataButtonGroup?if_exists> v-if <#else> v-else-if </#if>="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].taskImage && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click="showTaskImage(scope.row,'${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id})" >{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--审批历史-->
	<#elseif manage.name == 'history' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.history && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" data-button-group="${dataButtonGroup}" <#if dataButtonGroup?if_exists>style="width: 60px"</#if> v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" <#if dataButtonGroup?if_exists> v-if <#else> v-else-if </#if>="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].history && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click="showInstHistory(scope.row,'${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id})">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--撤回-->
	<#elseif manage.name == 'revoke' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.revoke && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" data-button-group="${dataButtonGroup}" <#if dataButtonGroup?if_exists>style="width: 60px"</#if> v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" <#if dataButtonGroup?if_exists> v-if <#else> v-else-if </#if>="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].revoke && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click="handleRevoke(scope.row,'${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id})">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--任务明细-->
	<#elseif manage.name == 'taskDetail' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.taskDetail && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" data-button-group="${dataButtonGroup}" <#if dataButtonGroup?if_exists>style="width: 60px"</#if> v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" <#if dataButtonGroup?if_exists> v-if <#else> v-else-if </#if>="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].taskDetail && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click="showTaskDetail(scope.row, '${manage.openType}',{sizeType:'${manage.sizeType}',dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}'},'${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id})">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--传阅-->
	<#elseif manage.name == 'taskToRead' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.taskToRead && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" data-button-group="${dataButtonGroup}" <#if dataButtonGroup?if_exists>style="width: 60px"</#if> v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" <#if dataButtonGroup?if_exists> v-if <#else> v-else-if </#if>="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].taskToRead && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click="taskToRead(scope.row,'${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id})">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--删除草稿-->
	<#elseif manage.name == 'phyDelete' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.phyDelete && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" data-button-group="${dataButtonGroup}" <#if dataButtonGroup?if_exists>style="width: 60px"</#if> v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" <#if dataButtonGroup?if_exists> v-if <#else> v-else-if </#if>="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].phyDelete && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click="phyDelete(scope.row,'${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id})">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#--删除流程-->
	<#elseif manage.name == 'logicDelete' && bpmDataTemplate.defId?if_exists>
	<#if managePermission.logicDelete && manage.linePosition>
	<span name="${manage.desc}" id="${manage.buttonId}" data-button-group="${dataButtonGroup}" <#if dataButtonGroup?if_exists>style="width: 60px"</#if> v-btnShow="{beforeScriptValue:'${manage.beforeScriptValue}',row: scope.row,visual_formVar:'${manage.visual_formVar!''}',visual_customQuery:'${manage.visual_customQuery!''}'}" <#if dataButtonGroup?if_exists> v-if <#else> v-else-if </#if>="flowBtnPermission[scope.row['bpm_proc_inst_id_']] && flowBtnPermission[scope.row['bpm_proc_inst_id_']].logicDelete && display('${manage.mpDisplay}')&& execScript('${manage.beforeScriptValue}',scope.row)" @click="logicDelete(scope.row,'${manage.afterScriptValue}',{row:scope.row,id:scope.row.${pkField} || scope.row.id})">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</span>
	</#if>
	<#else>
	</#if>
	</#macro>

	<#--顶部按钮-->
	<#macro genToolBar manage managePermission actionUrl btnIndex isKanban>
	<#-- 新增 -->
	<#if manage.name == 'add'>
	<#if managePermission.add>
	<el-button
	class="data-form-list__top-btn data-form-list__top-btn__new-add"
	type="${manage.theme!'default'}" v-show="showScriptButton && showScriptButton.add" v-if="permission.add && display('${manage.mpDisplay}')" size="small" @click="scriptClick('add','${manage.afterScriptValue}',{templateId:'${templateId}',id:'', buttonId:'${manage.buttonId}', action:'add',defId:'${bpmDataTemplate.defId}',isStartFlow:'',
            openType:'${manage.openType}', quitAfterSaving: '${manage.quitAfterSaving}', sizeType: '${manage.sizeType}', dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}', initSubData: '${manage.initSubData}', isKanban: '${isKanban}'})" icon="el-icon-plus">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>
	<#--编辑-->
	<#if manage.name == 'edit'>
	<#assign fieldPermission= util.fieldPermissionValidation('edit', managePermission, manage.buttonId, '')>
	<#if fieldPermission && manage.topPosition>
	<el-button class="data-form-list__top-btn"   type="${manage.theme!'primary'}" v-show="showScriptButton&&showScriptButton.edit"
	 v-if="permission.edit && display('${manage.mpDisplay}')" 
	 :ref="setButtonRef('${util.toJsonStr(manage)}','${tableConfigure.selectType}')"
	 @click="scriptClick('edit','${manage.afterScriptValue}',{templateId:'${templateId}',id:'', buttonId:'${manage.buttonId}', action:'edit',defId:'${bpmDataTemplate.defId}',
	 isStartFlow:'',openType:'${manage.openType}', quitAfterSaving: '${manage.quitAfterSaving}', sizeType: '${manage.sizeType}', dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}', isKanban: '${isKanban}' })" size="small" icon="el-icon-edit">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>
	<#-- 删除 -->
	<#if manage.name == 'del'>
	<#if managePermission.del && manage.topPosition>
	<el-button class="data-form-list__top-btn" type="${manage.theme!'danger'}" v-show="showScriptButton&&showScriptButton.del" v-if="permission.del && display('${manage.mpDisplay}')" size="small" 
	 :ref="setButtonRef('${util.toJsonStr(manage)}','${tableConfigure.selectType}')"
	 @click="scriptClick('deleted','${manage.afterScriptValue}')"  icon="el-icon-delete">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>

	<#--明细-->
	<#if manage.name == 'detail' >
	<#if managePermission.detail && manage.topPosition>
	<el-button class="data-form-list__top-btn" type="${manage.theme!'primary'}" v-show="showScriptButton&&showScriptButton.detail" v-if="display('${manage.mpDisplay}')" 
	 :ref="setButtonRef('${util.toJsonStr(manage)}','${tableConfigure.selectType}')"
	 @click="scriptClick('edit','${manage.afterScriptValue}',{templateId:'${templateId}',id:'',action:'get',defId:'',isStartFlow:'',openType:'${manage.openType}', sizeType: '${manage.sizeType}', dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',quitAfterSaving:''})" size="small">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>

	<#--表单修改记录-->
	<#if manage.name == 'record' >
	<#if managePermission.record && manage.topPosition>
	<el-button class="data-form-list__top-btn" type="${manage.theme!'primary'}" v-show="showScriptButton&&showScriptButton.record"   v-if="display('${manage.mpDisplay}')"
	 :ref="setButtonRef('${util.toJsonStr(manage)}','${tableConfigure.selectType}')"
	 @click="scriptClick('record','${manage.afterScriptValue}')" size="small">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>	

	<#--打印-->
	<#if manage.name == 'print'>
	<#if managePermission.print && manage.topPosition >
	<el-button class="data-form-list__top-btn notprint" type="${manage.theme!'primary'}" v-show="showScriptButton && showScriptButton.print" v-if="permission.print && display('${manage.mpDisplay}')" size="small" 
	 :ref="setButtonRef('${util.toJsonStr(manage)}','${tableConfigure.selectType}')"
	 @click="scriptClick('print','${manage.afterScriptValue}','${manage.printTemplateVal}','${bpmDataTemplate.boDefAlias}')" icon="el-icon-printer">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>

	<#--新增流程-->
	<#if manage.name == 'addFlow'>
	<#if util.fieldPermissionValidation('addFlow', managePermission, manage.buttonId, '') && manage.topPosition>
	<el-button class="data-form-list__top-btn" type="${manage.theme!'primary'}" v-show="getButtonShowByJs('${manage.buttonId}', 'addFlow')" v-if="display('${manage.mpDisplay}')"   
	 :ref="setButtonRef('${util.toJsonStr(manage)}','${tableConfigure.selectType}')"
	 @click="scriptClick('addFlow','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}',dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',openType: '${manage.openType}'},'topPosition')" size="small" icon="el-icon-plus">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>

	<#--新增数据-->
	<#if manage.name == 'addData'>
	<#if util.fieldPermissionValidation('addData', managePermission, manage.buttonId, '') && manage.topPosition>
	<el-button class="data-form-list__top-btn" type="${manage.theme!'primary'}"  v-show="getButtonShowByJs('${manage.buttonId}', 'addData')" v-if="display('${manage.mpDisplay}')"   
	 :ref="setButtonRef('${util.toJsonStr(manage)}','${tableConfigure.selectType}')"
	 @click="scriptClick('addData','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}', sizeType: '${manage.sizeType}',dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',openType: '${manage.openType}'},'topPosition')" size="small" icon="el-icon-plus">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>

	<#--查询数据-->
	<#if manage.name == 'searchData'>
	<#if util.fieldPermissionValidation('searchData', managePermission, manage.buttonId, '') && manage.topPosition>
	<el-button class="data-form-list__top-btn" type="${manage.theme!'primary'}" v-show="getButtonShowByJs('${manage.buttonId}', 'searchData')" v-if="display('${manage.mpDisplay}')"   
	 :ref="setButtonRef('${util.toJsonStr(manage)}','${tableConfigure.selectType}')"
	 @click="scriptClick('searchData','${manage.afterScriptValue}',{flowFormData:'${manage.flowFormData}',openType:'${manage.openType}', sizeType: '${manage.sizeType}',dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}',openType: '${manage.openType}'})" size="small" icon="el-icon-search">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>

	<#--批量新增-->
	<#if manage.name == 'batchSave'>
	<#if util.fieldPermissionValidation('batchSave', managePermission, manage.buttonId, '') >
	<el-button  class="data-form-list__top-btn"  type="${manage.theme!'default'}" v-show="getButtonShowByJs('${manage.buttonId}', 'batchSave')" v-if="permission.add && display('${manage.mpDisplay}')" size="small" @click="scriptClick('batchSave','${manage.afterScriptValue}',{templateId:'${templateId}',id:'${manage.buttonId}',customDialogjson:'${manage.customDialogjson}',action:'batchSave',defId:'${bpmDataTemplate.defId}',isStartFlow:'',
            openType:'${manage.openType}', quitAfterSaving: '${manage.quitAfterSaving}', dialogWidth: '${manage.dialogWidth}', dialogHeight: '${manage.dialogHeight}'})" icon="el-icon-plus">${manage.desc}</el-button>
	<span style="display: inline-block;"><ht-batch-save-dialog ref="batchSaveDialog" @onConfirm="batchSaveConfirm" :custdialog="'${manage.customDialogjson}'" placeholder="" style="width: 100%"></ht-batch-save-dialog></span>
	</#if>
	</#if>

	<#--子表数据-->
	<#if manage.name == 'sub'>
	<#if managePermission.sub && hasSub && manage.topPosition>
	<el-button
	class="data-form-list__top-btn"
			type="${manage.theme!'primary'}"
			v-show="showScriptButton && showScriptButton.sub"
			v-if="display('${manage.mpDisplay}')"
			:ref="setButtonRef('${util.toJsonStr(manage)}','${tableConfigure.selectType}')"
			@click="scriptClick('sub','${manage.afterScriptValue}'
			<#if manage.options>
				,{import: ${(manage.options.import)?string('true', 'false')}, export: ${(manage.options.export)?string('true', 'false')},subOpenType:'${manage.subOpenType}', sizeType: '${manage.sizeType}',dialogWidth:'${manage.dialogWidth}',dialogHeight:'${manage.dialogHeight}'}
		  <#else>
		,{subOpenType:'${manage.subOpenType}', sizeType: '${manage.sizeType}',dialogWidth:'${manage.dialogWidth}',dialogHeight:'${manage.dialogHeight}'}
			</#if>)"
			size="small"
	>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>

	<#-- 复制 -->
	<#if manage.name == 'copy'>
	<#if managePermission.copy && manage.topPosition>
	<el-button class="data-form-list__top-btn" type="${manage.theme!'primary'}" v-show="showScriptButton&&showScriptButton.copy" v-if="permission.copy && display('${manage.mpDisplay}')" size="small" 
	 :ref="setButtonRef('${util.toJsonStr(manage)}','${tableConfigure.selectType}')"
	 @click="scriptClick('copyAll','${manage.afterScriptValue}')" icon="el-icon-tickets">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>
	<#-- 生成二维码 -->
	<#if manage.name == 'produceQRCode'>
	<#if managePermission.produceQRCode && manage.topPosition>
	<el-button class="data-form-list__top-btn" type="${manage.theme!'primary'}" v-if="display('${manage.mpDisplay}')" @click='downloadAllQRCode("${templateId}","${bpmDataTemplate.mobileFormAlias}",${JsonUtil.toJson(manage.display)},"${pkField}","${manage.title}","${manage.modelType}","${manage.valueType}","${manage.defaultValue}","${manage.formulasDiyJs}",${manage.QRCodePattern})' size="small" icon="el-icon-s-grid">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>

	<#-- 启动流程 发起流程-->
	<#if manage.name == 'startFlow'>
	<#if managePermission.startFlow && manage.topPosition>
	<el-button class="data-form-list__top-btn" type="${manage.theme!'success'}" v-show="getButtonShowByJs('${manage.buttonId}', 'startFlow')" size="small"
	           :ref="setButtonRef('${util.toJsonStr(manage)}','${tableConfigure.selectType}')"
			   @click="startFlowByTopButton('${pkField}','${manage.afterScriptValue}','${templateId}','${bpmDataTemplate.defId}')"
			   icon="el-icon-success">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>

	<#-- 批量更新数据 -->
	<#if manage.name == 'batchUpdate'>
	<#if manage.topPosition && util.fieldPermissionValidation('batchUpdate', managePermission, manage.desc, manage.batchUpdateData, manage.relationConfig)>
	<el-button class="data-form-list__top-btn" type="${manage.theme!'primary'}" v-show="getButtonShowByJs('${manage.buttonId}', 'batchUpdate')" size="small" 
	 :ref="setButtonRef('${util.toJsonStr(manage)}','${tableConfigure.selectType}')"
	 @click="scriptClick('batchUpdate','${manage.afterScriptValue}',{buttonId:'${manage.buttonId}',desc:'${manage.desc}',batchUpdateData:'${manage.batchUpdateData}',filedsObj:'${manage.filedsObj}',relationConfig: '${manage.relationConfig}'})" icon="el-icon-edit">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>

	<#-- 导出 -->
	<#if manage.name == 'export'>
	<#if managePermission.export>
	<template v-if="permission.export && display('${manage.mpDisplay}')">
		<el-dropdown v-if="hasSearchQuery || hasSelectedData" type="${manage.theme!'success'}" v-show="showScriptButton&&showScriptButton.export" size="small" 
		:ref="setButtonRef('${util.toJsonStr(manage)}','${tableConfigure.selectType}')"
		@command="exportCommand" class="dropdown-upload__btn data-form-list__top-btn">
			<template>
				<el-button size="small" icon="el-icon-upload2" type="${manage.theme!'primary'}">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}<i class="el-icon-arrow-down el-icon--right"></i></el-button>
				<el-dropdown-menu slot="dropdown" class="template-dropdown-menu">
					<el-dropdown-item :command="{command:'searchResult',afterScriptValue:'${manage.afterScriptValue}'}" v-show="hasSearchQuery">{{$td('eip.common.button.exportSearchResult', '导出查询结果')}}</el-dropdown-item>
					<el-dropdown-item :command="{command:'selected',afterScriptValue:'${manage.afterScriptValue}'}" v-show="hasSelectedData">{{$td('eip.common.button.exportSelected', '导出选中数据')}}</el-dropdown-item>
					<el-dropdown-item :command="{command:'all',afterScriptValue:'${manage.afterScriptValue}'}">{{$td('eip.common.button.exportAllResult', '导出全部数据')}}</el-dropdown-item>
				</el-dropdown-menu>
			</template>
		</el-dropdown>
		<el-button size="small" v-else v-show="showScriptButton&&showScriptButton.export" class="just-export data-form-list__top-btn"  type="${manage.theme!'primary'}" 
		:ref="setButtonRef('${util.toJsonStr(manage)}','${tableConfigure.selectType}')"
		@click="exports('${manage.exportSettingFields}','${manage.afterScriptValue}')" icon="el-icon-upload2">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</template>
	</#if>
	</#if>
	<#-- 导入 -->
	<#if manage.name == 'import'>
	<#if managePermission.import>
	<el-dropdown type="${manage.theme!'success'}" v-show="showScriptButton&&showScriptButton.import"   v-if="permission.add  && display('${manage.mpDisplay}')" size="small"  @command="importCommand" class="dropdown-upload__btn data-form-list__top-btn">
	       <el-button icon="el-icon-download" size="small" type="${manage.theme!'primary'}"  @click=" elUploadChange('${manage.afterScriptValue}')"  >
					{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}<i class="el-icon-arrow-down el-icon--right"></i>
				</el-button>
		<el-upload
		        v-show='false'
				class="import-upload"
				action=""
				:show-file-list="false"
				:http-request="importMain"
			
				accept=".xls,.xlsx">
				 <el-button      ref='templatePreview_top_upload' icon="el-icon-download" size="small" type="${manage.theme!'primary'}">
					{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}<i class="el-icon-arrow-down el-icon--right"></i>
				</el-button>
		</el-upload>
		<el-dropdown-menu slot="dropdown">
			<el-dropdown-item :command="{command:'downloadTempFile',afterScriptValue:'${manage.afterScriptValue}'}">{{$td('eip.common.button.downloadTempFile', '下载模板')}}</el-dropdown-item>
			<el-dropdown-item :command="{command:'showImportLog',afterScriptValue:'${manage.afterScriptValue}'}">{{$td('eip.common.button.showImportLog', '导入日志')}}</el-dropdown-item>
			<el-dropdown-item v-if="importCacheKey" :command="{command:'showImportResult',afterScriptValue:'${manage.afterScriptValue}'}">{{$td('eip.common.button.showImportResult', '导入结果')}}</el-dropdown-item>
			<el-dropdown-item v-if="dataView && dataView.refIdValue" :command="{command:'log',afterScriptValue:'${manage.afterScriptValue}'}">{{$td('eip.common.button.showErrorLog', '查看异常日志')}}</el-dropdown-item>
		</el-dropdown-menu>
	</el-dropdown>
	</#if>
	</#if>

	<#-- url按钮 -->
	<#if manage.name == 'url'>
	<#if manage.topPosition && util.fieldPermissionValidation('url', managePermission, manage.desc, manage.url, manage.urlParams)>
	<el-button class="data-form-list__top-btn" type="${manage.theme!'info'}" v-show="getButtonShowByJs('${manage.buttonId}', 'url')" v-if="display('${manage.mpDisplay}')"  size="small" 
	 :ref="setButtonRef('${util.toJsonStr(manage)}','${tableConfigure.selectType}')"
	 @click="scriptClick('url','${manage.afterScriptValue}',{url:'${manage.url}',type:'new',fieldName:'', urlParams:'${manage.urlParams!}', sizeType: '${manage.sizeType}',dialogWidth: '${manage.dialogWidth}',dialogHeight: '${manage.dialogHeight}',openType: '${manage.openType}', tokenEnabled:'${manage.tokenEnabled}', tokenType:'${manage.tokenType}', tokenKey:'${manage.tokenKey}', tokenApi:'${manage.tokenApi}', buttonId: '${manage.buttonId}'})"  icon="el-icon-share">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>

	<#-- js按钮 -->
	<#if manage.name == 'js' >
	<#if manage.topPosition && util.fieldPermissionValidation('js', managePermission, manage.desc, manage.jsValue)>
    <el-button class="data-form-list__top-btn" type="${manage.theme!'primary'}" v-show="getButtonShowByJs('${manage.buttonId}', 'js')" v-if="display('${manage.mpDisplay}')"  
	:ref="setButtonRef('${util.toJsonStr(manage)}','${tableConfigure.selectType}')"
	 @click="scriptClick('js','${manage.afterScriptValue}',{jsValue:'${manage.jsValue}',dialogWidth:'${manage.dialogWidth}',dialogHeight:'${manage.dialogHeight}',openType:'${manage.openType}',needValidateSelect:'${manage.needValidateSelect}'})" size="small">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
	</#if>
	</#if>

	</#macro>

	<#--我的草稿按钮-->
	<#macro myDraftListToolBar manage managePermission actionUrl>
	<#if manage.name == 'add'>
	<#if managePermission.add>
	<el-button class="data-form-list__top-btn" type="${manage.theme!'primary'}" v-show="showScriptButton&&showScriptButton.add" v-if="permission.add && display('2')  && showDraftList" @click="myDraftList"  size="small" > <i class="icon-caogao my-draft__icon"></i>{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.myDraftList"}', '我的草稿')}}</el-button>
	</#if>
	</#if>
	</#macro>
</#noparse>


<#--过滤条件
<#noparse><#if filterFields?if_exists>
<div class="panel" ajax="ajax"  displayId="${bpmDataTemplate.id}" filterKey="${filterKey}" >
<#if filterFields?size gt 1>
<div class='panel-nav'>
	<div class="l-tab-links">
		<ul style="left: 0px; ">
			<#list filterFields as field>
			<li tabid="${field.key}" <#if field.key ==filterKey> class="l-selected"</#if>>
				<a href="${field.url}" title="${field.name}">${field.desc}</a>
			</li>
			</#list>
		</ul>
	</div>
</div>
</#if>
</#noparse> -->

<#-- 主体内容 start  -->
<el-container v-loading="loading" class="fullheight">
	<el-dialog
    title="表单内容"
    :close-on-click-modal="false"
    :visible.sync="dataViewDialogVisible"
    :width="dialogWidth"
    :height="dialogHeight"
    custom-class="data-view-dialog"
    top="6vh"
    ref="dataViewDialog"
    :before-close="handleClose"
    v-if="display('2')"
	>
		<div class="iframe-wrap">
			<iframe
        style="width:100%"
        frameborder="0"
        class="fullheight"
        allowtransparency="0"
        :src="srcUrl"
			></iframe>
		</div>
	</el-dialog>

<el-dialog
:visible.sync="QRCodeDialog"
width="340px"
@opened="foundQRCode"
:before-close="QRCodeDialogClose"
:append-to-body=true
:center=true
>
<div id="QRCodeAndDesc" style="text-align:center">
     <h2 v-if="qrcodeObj.title" style="margin:8px;">{{ qrcodeObj.title}}</h2>
   <div :style="qrcodeStyle">			
     <canvas id="QRCode" v-show="QRCodeShow"></canvas>
	 <div v-show="QRCodeShow":style="qrcodeDescStyle"><div v-for="(item,index) in QRCodeDesc" :key="index">{{item}}</div></div>
  </div>
</div>
<span slot="footer"  v-show="QRCodeShow">
  <el-button type="primary" v-clipboard:copy="QRCodeurl" v-clipboard:success="onCopy" v-clipboard:error="onError" >复制URL</el-button>
  <el-button type="success" @click="downloadQRCode">下载二维码</el-button>
</span>
</el-dialog>

	<el-dialog title="导出设置" :visible.sync="dialogExportVisible" width="750px" id="exportDialogs" :before-close="exportCancel">
		<el-form :model="exportData" status-icon ref="exportData" label-width="100px">
			<el-row type="flex" class="row-bg" justify="start" style="height:48px;border: 1px solid #eee;text-align:center;">
				<el-col :span="6" style="padding:15px 0px 0px 15px;">
					导出类型
				</el-col>
				<el-col :span="18" style="border-left: 1px solid #eee;padding:15px 0px 0px 15px;">
					<el-switch
            v-model="exportData.getType"
            active-text="查询结果"
            active-value="all"
            inactive-text="当前页数据"
            inactive-value="page"
          >
					</el-switch>
				</el-col>
			</el-row>
			<el-row type="flex" class="row-bg" justify="start" style="border: 1px solid #eee;text-align:center;">
				<el-col :span="6" style="padding:15px 0px 0px 15px;">
					导出字段
				</el-col>
				<el-col :span="18" style="border-left: 1px solid #eee;padding:5px 0px 0px 5px;max-height:420px;overflow:auto;">
					<ht-table
            ref="multipleExportTable"
            @load="(param, cb)=>{cb && cb()}"
            :data="displayFields"
            style="width:100%"
            @select-all="handleExportSelectAll"
            tooltip-effect="dark"
            @selection-change="handleExportSelectionChange"
			:nopagination="true"
          >
						<ht-table-column
              prop="desc"
              label="字段描述"
              width="180"
            >
						</ht-table-column>
						<ht-table-column :label="$td('eip.common.operation', '操作')" width="160">
							<template slot-scope="scope">
								<el-button @click='sort(scope.index,"down");' size="small" icon="el-icon-arrow-down" plain></el-button>
								<el-button @click='sort(scope.index,"up");' size="small" icon="el-icon-arrow-up" plain></el-button>
							</template>
						</ht-table-column>
					</ht-table>
				</el-col>
			</el-row>
			<el-row type="flex" class="row-bg" justify="start" style="border: 1px solid #eee;text-align:center;" v-for="(item,index) in subDisplayFieldsList" :key="index">
				<el-col :span="6" style="padding:15px 0px 0px 15px;">
					子表{{item.comment}}导出字段
				</el-col>
				<el-col :span="18" style="border-left: 1px solid #eee;padding:15px 0px 0px 15px;">
					<ht-table
            ref="subExportTable"
            :data="item.fields"
            style="width:100%"
            tooltip-effect="dark"
			:nopagination="true"
          >
						<ht-table-column
              prop="name"
              label="字段名称"
              width="100"
            >
						</ht-table-column>
						<ht-table-column
              prop="desc"
              label="字段描述"
              width="180"
            >
						</ht-table-column>
						<ht-table-column :label="$td('eip.common.operation', '操作')" width="160">
							<template slot-scope="scope">
								<el-button @click='sort(scope.index,"down");' size="small" icon="el-icon-arrow-down" plain></el-button>
								<el-button @click='sort(scope.index,"up");' size="small" icon="el-icon-arrow-up" plain></el-button>
							</template>
						</ht-table-column>
					</ht-table>
				</el-col>
			</el-row>
		</el-form>
		<div slot="footer" class="dialog-footer">
			<el-button type="primary" @click="submitExport()" size="small">确 定</el-button>
			<el-button @click="exportCancel()" size="small">取 消</el-button>
		</div>
	</el-dialog>

	<el-dialog
    title="异常日志"
    :visible.sync="dialogVisible"
    width="80%"
    top="8vh"
    class="log_dialog"
    v-if="dialogVisible"
	>
		<ht-table
      @load="loadImportLogData"
      :data="logData"
      :selectable="false"
      :pageResult="pageResult"
      :show-export="false"
      :show-custom-column="false"
      size="small"
      quick-search-props="rowNumber,columnName,errorMsg"
      ref="htTable"
		>
			<ht-table-column type="index" width="50" align="center" label="序号" />
			<ht-table-column prop="rowNumber" label="EXCEL行号" width="120" />
			<ht-table-column prop="columnName" label="EXCEL列名" width="120" />
			<ht-table-column prop="errorMsg" align="left" label="异常描述" />
		</ht-table>
	</el-dialog>

	<#if treeFields?if_exists && treeFields.querys?if_exists>
    <el-aside width="200px"  style="border-right: 1px solid #e6e6e6;" v-show="asideShow && activeViewName==1">
			<el-scrollbar>
				<ht-tree
          :data="tree"
          :expand-on-click-node="false"
          :props='{children: "children",label: "${treeFields.showField}"}'
          @node-click="nodeClick"
          :load="loadTree"
          ref="filterTree"
          lazy
        />
			</el-scrollbar>
		</el-aside>
      <div
	  v-show='activeViewName==1'
      class="navbar-collapse"
      :class="{'navbar-collapse-right': !asideShow}"
      :style="navbarCollapseStyle"
      @click="asideShow = !asideShow"
    >
      <div class="navbar-collapse-bg">
        <i
          class="navbar-collapse-arrow"
          :class="{
            'el-icon-arrow-left': asideShow,
            'el-icon-arrow-right': !asideShow
          }"
        ></i>
      </div>
    </div>
	</#if>

	<ht-template-subtable  :visible.sync="dialogSubVisible" v-if="dialogSubVisible" :options="subDialogOptions" @before-close="subCancel">
<#--	<el-dialog :title="$td('${'formTemplate.${bpmDataTemplate.alias}.subTable.title'}', '查看子表数据')" :visible.sync="dialogSubVisible" :close-on-click-modal="false" width="60%" id="subDialogs" :before-close="subCancel" v-if="dialogSubVisible">-->
		<el-tabs type="border-card" v-model="currentTabName" v-if="showTabsList.length > 0">
			<el-tab-pane v-for="(tab, index) in showTabsList" :label="tab.comment" :key="index" :name="tab.comment">
				<el-container v-if="currentTabName === tab.comment">
					<el-main style="padding:0px;">
						<el-input style="width:400px" :placeholder="$td('${'formTemplate.${bpmDataTemplate.alias}.subTable.search'}', '请输入字段内容查询')" v-model="querySubValue" clearable>
						   <template #append>
                            <i class="el-icon-search" @click="querySubTable(tab)"></i>
                           </template>
						</el-input>
						<el-upload
          style="display: inline"
          action=""
          :http-request="importSub"
          :show-file-list="false"
          accept=".xls,.xlsx"
        >
          <el-button @click="importButton(tab)" v-if="subDialogOptions.import" size="small">{{$td('eip.common.import', '导入')}}</el-button>
						</el-upload>

						<el-button size="small" @click="exportSub(tab)" v-if="subDialogOptions.export">{{$td('eip.common.export', '导出')}}</el-button>
						<ht-table
          v-loading="subTableLoading"
          :data="tab.dataList"
          style="width:100%"
          border
          stripe
          tooltip-effect="dark"
          header-cell-class-name="todo-header-row"
          row-class-name="todo-row"
          size="small"
		  :nopagination="true"
		  @load="(param, cb)=>{cb && cb()}"
        >
							<ht-table-column
          :label="$td('eip.common.index', '序号')"
            type="index"
            width="50"
            align="center"
          >
							</ht-table-column>
							<ht-table-column
            v-for="attributes in tab.attributeList"
            :key="attributes.id"
            :prop="attributes.fieldName"
            :label="attributes.comment"
							>
								<template slot-scope="scope">
              <span v-if="attributes.format && attributes.format=='yyyy-MM-dd'">
                {{ scope.row[attributes.fieldName] | dateformat('yyyy-MM-DD') }}
              </span>
									<span v-if="(!attributes.format || (attributes.format && attributes.format!='yyyy-MM-dd'))">
                {{scope.row[attributes.fieldName]}}
              </span>
								</template>
							</ht-table-column>
							<ht-table-column
          :label="$td('eip.common.operation', '操作')"
            v-if="tab.childEnts.length>0"
            width="100"
          >
								<template slot-scope="scope">
									<#--查看孙表-->
									<#noparse>
                <#list manageFields as manage>
                  <#if manage.name == 'sun'&&managePermission.sun>
                    <el-button type="text" size="small"  v-show="showScriptButton&&showScriptButton.sun"  @click="getSunData(tab,scope.row,'${manage.afterScriptValue}')">{{$td('${"formTemplate.${bpmDataTemplate.alias}.button.${manage.name}${manage.btnKey}"}', '${manage.desc}')}}</el-button>
                  </#if>
                </#list>
							    </#noparse>
							  </template>
							</ht-table-column>
						</ht-table>
					</el-main>
					<el-footer>
						<el-pagination
          background
          @current-change="handleSubCurrentChange($event,tab)"
		  @size-change="handleSubSizeChange($event, tab)"
          :current-page="tab.pagination.pageBean.page"
          :page-size="tab.pagination.pageBean.pageSize"
          layout="total, sizes,  prev, pager, next, jumper"
          :total="tab.pagination.pageBean.total"
        >
						</el-pagination>
					</el-footer>
				</el-container>
			</el-tab-pane>
		</el-tabs>
		<el-empty v-else :image-size="380" :image="noDataImg" description="暂无查看子表权限"> </el-empty>
	</ht-template-subtable>

	<!-- 应用端特有 -->
	<template v-if="client === 'front'">
		<approval-dialog
				ref="approvalDialog"
				:current-task-id="currentTaskId"
				:current-inst-id="currentInstId"
		></approval-dialog>

		<approval-drawer
				ref="approvalDrawer"
				:current-task-id="currentTaskId"
				:current-inst-id="currentInstId"
		></approval-drawer>
	</template>

	<#--查看孙表数据对话框-->
	<el-dialog :title="$td('${'formTemplate.${bpmDataTemplate.alias}.subTable.sun.title'}', '查看孙表数据')" :visible.sync="dialogSunVisible" width="60%" :close-on-click-modal="false" :before-close="sunCancel">
		<el-tabs type="border-card" >
			<el-tab-pane v-for="tab in sunTabs" :label="$td('${'formTemplate.${bpmDataTemplate.alias}.subTable.comment'}', tab.comment)" :key="tab.id">
				<el-container>
					<el-main style="padding:0px;">
						<ht-input :placeholder="$td('${'formTemplate.${bpmDataTemplate.alias}.subTable.sun.search'}', '请输入字段内容查询')" v-model="querySunValue" clearable>
							 <template #append>
                               <i class="el-icon-search" @click="querySubTable(tab,querySunValue)"></i>
                              </template>
						</ht-input>
						<ht-table
          v-loading="subTableLoading"
          :data="tab.dataList"
          style="width:100%"
          border
          stripe
          tooltip-effect="dark"
          header-cell-class-name="todo-header-row"
          row-class-name="todo-row"
          size="small"
		  @load="(param, cb) => {cb && cb()}"
		  :nopagination="true"
        >
							<ht-table-column
            :label="$td('eip.common.index', '序号')"
            type="index"
            width="50"
            align="center"
          >
							</ht-table-column>
							<ht-table-column
            v-for="attributes in tab.attributeList"
            :key="attributes.id"
            :prop="attributes.fieldName"
            :label="attributes.comment"
							>
								<template slot-scope="scope">
              <span v-if="attributes.format && attributes.format=='yyyy-MM-dd'">
                {{ scope.row[attributes.fieldName] | dateformat('yyyy-MM-DD') }}
              </span>
									<span v-if="!attributes.format || (attributes.format && attributes.format!='yyyy-MM-dd')">
                {{scope.row[attributes.fieldName]}}
              </span>
								</template>
							</ht-table-column>
						</ht-table>
					</el-main>
					<el-footer>
						<el-pagination
          background
          @current-change="handleSubCurrentChange($event,tab)"
		  @size-change="handleSubSizeChange($event, tab)"
          :current-page="tab.pagination.pageBean.page"
          :page-size="tab.pagination.pageBean.pageSize"
          layout="total, sizes, prev, pager, next, jumper"
          :total="tab.pagination.pageBean.total"
        >
						</el-pagination>
					</el-footer>
				</el-container>
			</el-tab-pane>
		</el-tabs>
	</el-dialog>

	<#--修改记录对话框-->
		<el-dialog
		v-if="dialogRecordVisible"
		title="查看修改记录"
		:visible.sync="dialogRecordVisible"
		width="65%"
		:before-close="recordCancel"
			>
			<el-container>
				<el-main style="padding:0px;">
			 <ht-table
		      v-loading="recordTableLoading"
		      size="small"
		      :data="recordList"
		      style="width:100%"
		      border
		      stripe
		      tooltip-effect="dark"
			  :nopagination="true"
		      header-cell-class-name="todo-header-row"
		      row-class-name="todo-row"
		    >
					<ht-table-column label="序号" type="index" width="50" align="center" />
					<ht-table-column prop="userName" label="修改人"  width="100" />
					<ht-table-column prop="taskName" label="任务名称"  width="100" show-overflow-tooltip />
					<ht-table-column prop="reason" label="审批意见" width="160" show-overflow-tooltip />
					<ht-table-column prop="modifyTime" label="修改时间" width="160" show-overflow-tooltip />
					<ht-table-column prop="detail" label="修改详情" show-overflow-tooltip>
						<template slot-scope="scope">
							<el-link @click="openModifyDetail(scope.row)" title="查看明细" >{{scope.row.detail}}</el-link>
						</template>
					</ht-table-column>
					<ht-table-column fixed="right" :label="$td('eip.common.operation', '操作')"  width="100" align="left">
						<template slot-scope="scope">
							<el-button type="text" @click="showModifyRecord(scope.row.id, scope.row.refId)">查看详情</el-button>
						</template>
					</ht-table-column>
				</ht-table>
			</el-main>
			 <el-footer>
            <el-row
              type="flex"
              justify="end"
              style="padding-top:15px;"
            >
              <el-pagination
                background
			    @current-change="handleRecordCurrentChange($event,modifyRecord)"
                @size-change="handleRecordSizeChange($event,modifyRecord)"
                :current-page.sync="modifyRecord.pagination.pageBean.page"
                :page-sizes="[10, 20, 50, 100]"
                :page-size="modifyRecord.pagination.pageBean.pageSize"
                layout="total, sizes, prev, pager, next, jumper"
                :total="modifyRecord.pagination.pageBean.total"
              >
              </el-pagination>
             </el-row>
          </el-footer>
			<el-dialog
			    width="60%"
			    title="修改明细"
			    :visible.sync="modifyDetailDialogVisible"
			    top="8vh"
			    :append-to-body="true"
			    :close-on-click-modal="false"
						>
							<el-form v-if="modifyDetailDialogVisible" v-model="currentModify" data-vv-scope="editModifyForm">
								<ht-input style="width:100%" type="textarea" v-model="currentModify.detail" :rows="20" :readonly="true" />
							</el-form>
						</el-dialog>
					</el-container>
				</el-dialog>
				<#--导入日志对话框-->
				<el-dialog
				title="导入日志"
				:visible.sync="importLogVisible"
				:before-close="handleCloseImportLogDialog"
				width="70%"
				custom-class="import-log-dialog"
					>
			<ht-table
				ref="importLogTable"
				:data="importLogTableData"
				:pageResult="pageResult"
				:quick-search-props="quickSearchProps"
				:show-export="false"
				:default-sorter="[{direction: 'DESC', property: 'import_time_'}]"
				:default-querys="importLogDefaultQuery"
				:showCustomColumn="false"
				:is-load-table="false"
				:custom-table-height="500"
				:header-cell-class-name="headerCellClassName"
				@load="loadData"
			>
				<template>
					<ht-table-column type="index" width="50" align="center" label="序号" />
					<ht-table-column
						prop="importName"
						label="导入人"
						:sortable="true"
						:show-overflow-tooltip="true"
					/>
					<ht-table-column prop="importAccount" label="导入账号" />
					<ht-table-column
						prop="importTime"
						label="导入时间"
						:sortable="true"
					/>
					<ht-table-column
						prop="status"
						label="导入状态"
						:render-header="renderHeaderMethod"
						:filters="tableHeaderFilters"
					>
						<template v-slot="{row}">
							<span :class="[row.status == '1'?'green-color':'red-color']">{{
								statusMap[row.status]
							}}</span>
						</template>
					</ht-table-column>
					<ht-table-column
					width="120"
						 :label="$td('eip.common.operation', '操作')"
					>
						<template v-slot="{row}">
							<el-button v-if="row.status !== '1'" type="text" @click="checkFailureReason(row)">查看失败原因</el-button>
						</template>
					</ht-table-column>
				</template>
		</ht-table>
			<span slot="footer" class="dialog-footer">
				<el-button @click="handleCloseImportLogDialog" type="primary">关闭</el-button>
			</span>
		</el-dialog>
		<#--  导入日志失败原因弹窗  -->
		<el-dialog
			title="失败原因"
			:visible.sync="failureReasonVisible"
			:before-close="handleCloseFailureReasonDialog"
			custom-class="failure-reason-dialog"
		>
		<div class="error-info">{{errorInfo}}</div>
	 </el-dialog>


	<el-container class="fullheight">
		<HtTemplateBatchUpdateDialog ref="templateBatchUpdateDialog" @onConfirm="onConfirm"></HtTemplateBatchUpdateDialog>
		<HtTemplateBatchPrintDialog ref="templateBatchPrintDialog" @wordPrint="wordPrint"></HtTemplateBatchPrintDialog>
		<ht-template-form-dialog ref="templateFormDialog" @close="templateFormClose"></ht-template-form-dialog>
		<ht-template-form-drawer ref="templateFormDrawer" @close="templateFormClose"></ht-template-form-drawer>
		<ht-template-iframe-dialog ref="templateIframeDialog"></ht-template-iframe-dialog>
		<ht-template-iframe-drawer ref="templateIframeDrawer"></ht-template-iframe-drawer>
		<#-- 临时注释掉
		<TemplateStartFlow v-if="display('2') && templateInfo.defId" :defKey="templateInfo.defId" ref="templateStartFlow" @onSucess="startFlowSucess" ></TemplateStartFlow>
		<ProcessRecordDialog ref="processRecordDialog" :instId="selectedInstId" :defId="selectedDefId" :taskId="selectedTaskId"></ProcessRecordDialog>
		<TaskToRevoke ref="taskToRevoke" :instId="selectedInstId" :taskId="selectedTaskId" :afterClose="()=>{search('find')}" />
		-->
		<ht-flow-chart ref="taskImage" :defId="selectedDefId" :inst-id="selectedInstId"></ht-flow-chart>

		<process-record ref="processRecord" :inst-id="selectedInstId" :def-id="selectedDefId" :task-id="selectedTaskId"></process-record>

		<template-import-result ref="importResult" :template-info="templateInfo" @after-save="afterImportSave"></template-import-result>
		<template-task-circulate ref="templateTaskCirculate"></template-task-circulate>
		<div class="search-and-btn__wrap">

        <#--查询条件-->
	    </div>

		 <#if (showViews?size > 1) >
			 <el-tabs style="width: 100%;" class="template-view_change" v-model="activeViewName" @tab-click="handleTabClick">
		 	    <#list showViews as view>
                  <el-tab-pane label="${view.desc}" name="${view.type}"><span v-if="activeViewName == ${view.type}">${getViewByType(view.type,true)}</span></el-tab-pane>
                </#list>
			  </el-tabs>
		 </#if>

	     <#if (showViews?size = 1) >
			 <#list showViews as view>
                  ${getViewByType(view.type,false)}
              </#list>
		 </#if >

		<#macro genSummaryField>
			<#if summaryRegionHtml?if_exists>
				<div id="summaryDiv" class="custom-summary" v-html="customSummary"></div>
				<#else>
				<div id="summaryDiv" class="summary-table" v-if="summaryTableData.length > 0">
						<el-table
							:data="summaryTableData"
							border
							style="width: 100%">
							<el-table-column
								prop="project"
								label=""
								width="120"
								class-name="project-column"
								show-overflow-tooltip
								align="center"
								>
							</el-table-column>
							<el-table-column
								v-for = "item in summaryFields"
								:prop="item.field"
								:label="item.name"
								:key="item.field"
								align="center"
								show-overflow-tooltip
								class-name="summary-num"
								>
								<template slot-scope="{row}">
								<span class="summary-table-field">{{row[item.field]?row[item.field]: row[item.field] == 0 ? 0 :'-'}}</span>
								</template>
							</el-table-column>
						</el-table>
				</div>
				</#if>
		</#macro>
  </el-container>
</el-container>




<#-- 主体内容 end  -->
<#--
<#noparse>
<#else>
   <div style="padding:6px 0px 12px 0px;">当前用户没有满足的过滤条件,请设置过滤条件。<div>
</#if>
</#noparse>
-->

<#function genElTableColumn field>

	<#assign rtn>
		<#if field.name??>
			<#assign fieldType=field.type>
			<#assign fieldName=field.name>
			<#noparse><#if permission.</#noparse>${field.name}<#noparse>></#noparse>
			<ht-table-column
			<#if field.frozen==1>fixed="left"</#if>
			:key="notPrint?Math.random():null"
			:prop="isPropTable('${field.name}','${field.tableName}','${field.oldTableField}','${field.rawId}')"
			column-key="${field.name}"
            :label="$td('${'formTemplate.${bpmDataTemplate.alias}.display.${field.name}'}', '${field.desc}')"
			<#if util.getJsonByPath(filteringFieldMap,fieldName) != "" >
			:filters='${util.getJsonByPath(filteringFieldMap,fieldName)}'
			</#if>
			<#if util.getJsonByPathNew(field,"defaultValue",filteringDefaultValue) !="">
			:filtered-value='${util.getJsonByPathNew(field,"defaultValue",filteringDefaultValue)}'
			</#if>
			<#if util.getJsonByPath(sortFieldMap,fieldName) != "" >:sortable="isSortable('${field.name}')"</#if>
            <#if !field.isDesensitization>show-overflow-tooltip</#if>
            v-if="display('${field.mpDisplay}')" <#if field.width!=0>width="${field.width}px"</#if>
			align="${field.align!'center'}">
				<template slot-scope="scope">
					<#if field.proSetting>
					<#--进度条-->
						<el-progress :percentage="getProValue(scope.row.${field.name},${field.ruleSetting})"
									 :color="getProColor('${util.toJsonStr(field.ruleSettings)}',scope.row)"></el-progress>
					<#elseif field.urlType=='edit'>
						<el-link
								type="primary"
								class="follow-theme-color"
								@click.stop='operating("${templateId}",scope.row.${pkField},"select","","","${field.openType}",false,"",false,false,scope.row,"","","", "${util.toJsonStr(field)}");'
								:title="$td('eip.common.showDetails', '查看详情')"
								<#if field.ruleSettings?if_exists>
									:style="getColor('${util.toJsonStr(field.ruleSettings)}',scope.row)"
								</#if>
						>
							<#if field.formatterData?if_exists>
								<span>{{queryFormatterData(scope.row.${field.name},'${util.toJsonStr(field.formatterData)}')}}</span>
							<#else>
								<#if field.isDesensitization>
              <el-tooltip class="item" effect="dark" :content="scope.row.${field.name}+''" placement="top">
     	          <span>
									{{desensitization(scope.row.${field.name},${field.desensitizationRules.startPosition},${field.desensitizationRules.endPosition},`${field.desensitizationRules.pad}`)}}
								</span>
              </el-tooltip>
                  <#else>
                  <span>
									{{scope.row.${field.name}}}
								</span>
                	</#if>
							</#if>
						</el-link>
					<#elseif field.urlType=='reportForm'>
						<#if field.listType?if_exists && field.listType=='view'>
							<el-link
									type="primary"
									class="follow-theme-color"
									@click.stop='viewDataList(scope.row,"${util.toJsonStr(field.reportNameConfigure)}","${field.openType}","${util.toJsonStr(field)}");'
									:title="$td('eip.common.showReport', '查看报表')"
									<#if field.ruleSettings?if_exists>
										:style="getColor('${util.toJsonStr(field.ruleSettings)}',scope.row)"
									</#if>
							>
								<#if field.formatterData?if_exists>
									<span>{{queryFormatterData(scope.row.${field.name},'${util.toJsonStr(field.formatterData)}')}}</span>
								<#else>
									<#if field.isDesensitization>
										<el-tooltip class="item" effect="dark" :content="scope.row.${field.name}+''" placement="top">
											<span>{{desensitization(scope.row.${field.name},${field.desensitizationRules.startPosition},${field.desensitizationRules.endPosition},`${field.desensitizationRules.pad}`)}}</span>
										</el-tooltip>
									<#else>
										<span>{{scope.row.${field.name}}}</span>
									</#if>
								</#if>
							</el-link>
						<#else>
							<el-link
									type="primary"
									class="follow-theme-color"
									@click.stop='viewReport(scope.row,"${util.toJsonStr(field.reportNameConfigure)}","${field.openType}","${util.toJsonStr(field)}");'
									:title="$td('eip.common.showReport', '查看报表')"
									<#if field.ruleSettings?if_exists>
										:style="getColor('${util.toJsonStr(field.ruleSettings)}',scope.row)"
									</#if>
							>
								<#if field.formatterData?if_exists>
									<span>{{queryFormatterData(scope.row.${field.name},'${util.toJsonStr(field.formatterData)}')}}</span>
								<#else>
									<#if field.isDesensitization>
										<el-tooltip class="item" effect="dark" :content="scope.row.${field.name}+''" placement="top">
											<span>{{desensitization(scope.row.${field.name},${field.desensitizationRules.startPosition},${field.desensitizationRules.endPosition},`${field.desensitizationRules.pad}`)}}</span>
										</el-tooltip>
									<#else>
										<span>{{scope.row.${field.name}}}</span>
									</#if>
								</#if>
							</el-link>
						</#if>

					<#elseif field.urlType=='url'>
						<el-link
								type="primary"
								@click.stop='openUrl("${field.url}","${field.openType}",scope.row,"${field.name}","","","","","","","","${util.toJsonStr(field)}");'
								class="follow-theme-color"
								:title="$td('eip.common.jumpToOtherURL', '跳转到其他URL地址')"
								<#if field.ruleSettings?if_exists>
									:style="getColor('${util.toJsonStr(field.ruleSettings)}',scope.row)"
								</#if>
						>
							<#if field.formatterData?if_exists>
								<span>{{queryFormatterData(scope.row.${field.name},'${util.toJsonStr(field.formatterData)}')}}</span>
							<#else>
								<#if field.isDesensitization>
              <el-tooltip class="item" effect="dark" :content="scope.row.${field.name}+''" placement="top">
     	          <span>
									{{desensitization(scope.row.${field.name},${field.desensitizationRules.startPosition},${field.desensitizationRules.endPosition},`${field.desensitizationRules.pad}`)}}
								</span>
              </el-tooltip>
                  <#else>
                  <span>
									{{scope.row.${field.name}}}
								</span>
                	</#if>
							</#if>
						</el-link>
					<#else>
						<span
							<#if field.ruleSettings?if_exists>
								:style="getColor('${util.toJsonStr(field.ruleSettings)}',scope.row)"
							</#if>
						>
							<#if field.formatterType=="1" || field.formatterType=="4"> <#--格式化设置-->

								<#if field.formatterData?if_exists>
									<span>{{queryFormatterData(scope.row.${field.name},'${util.toJsonStr(field.formatterData)}')}}</span>
								<#else>
									<span v-if="display('0') && switchMap.${field.name}">
									<span v-if="scope.row.${field.name} == switchMap.${field.name}.on">
										{{switchMap.${field.name}.onLabel}}
									</span>
									<span v-else-if="scope.row.${field.name} == switchMap.${field.name}.off">
										{{switchMap.${field.name}.offLabel}}
									</span>
									<span v-else>
									<#if field.isDesensitization>
              <el-tooltip class="item" effect="dark" :content="scope.row.${field.name}+''" placement="top">
     	          <span>
									{{desensitization(scope.row.${field.name},${field.desensitizationRules.startPosition},${field.desensitizationRules.endPosition},`${field.desensitizationRules.pad}`)}}
								</span>
              </el-tooltip>
                  <#else>
                  <span>
									{{scope.row.${field.name}}}
								</span>
                	</#if>
									</span>
								</span>
								<span v-else>
								<#if field.isDesensitization>
              <el-tooltip class="item" effect="dark" :content="scope.row.${field.name}+''" placement="top">
     	          <span>
									{{desensitization(scope.row.${field.name},${field.desensitizationRules.startPosition},${field.desensitizationRules.endPosition},`${field.desensitizationRules.pad}`)}}
								</span>
              </el-tooltip>
                  <#else>
                  <span>
									{{scope.row.${field.name}}}
								</span>
                	</#if>
								</span>
								</#if>

							<#elseif field.formatterType=="2"><#--附件-->
								<HtTemplatePreviewFile v-model="scope.row.${field.name}" :key="scope.row.${pkField} + '_' + scope.row.${field.name}"></HtTemplatePreviewFile>
							<#elseif field.formatterType=="3"><#--图片-->
								<HtTemplatePreviewImage  v-model="scope.row.${field.name}" :key="scope.row.${pkField} + '_' + scope.row.${field.name}"></HtTemplatePreviewImage>
							<#else>
                <#if field.isDesensitization>
                <el-tooltip class="item" effect="dark" :content="formatCascade(scope.row.${field.name})+''" placement="top">
     	            <span>
                  	{{desensitization(formatCascade(scope.row.${field.name}),${field.desensitizationRules.startPosition},${field.desensitizationRules.endPosition},`${field.desensitizationRules.pad}`)}}
					</span>
                </el-tooltip>
                <#else>
                <span>
					{{formatCascade(scope.row.${field.name})}}
				</span>
                </#if>
              </#if>
						</span>
					</#if>
				</template>

			</ht-table-column>

			<#noparse></#if></#noparse>
		<#else>
			<el-table-column
			    <#if field.frozen==1>fixed="left"</#if>
				label="${field.desc}"
				v-if="display('${field.mpDisplay}','${util.getChildrenFieldName(field)}')"
				align="${field.align!'center'}">
				<#list field.children as item>
					${genElTableColumn(item)}
				</#list>
			</el-table-column>
		</#if>
	</#assign>
	<#return rtn>
</#function>