<#macro sunDiv layout>
<#assign subTablePath=layout.options.subTablePath>
<#assign sunTablePath=util.getSunTablePath(layout.options.subTablePath,"$index")>
<#assign subName=util.getSubName(layout.options.subTablePath,"$index")>
<#assign hasLinkage=util.getHasLinkage(layout.list)>
<el-container v-if="!permission.table.${layout.options.boSubEntity}.hidden"

 class="sun-div-container">
  <#if !isMobile>
    <el-header
     :style="handleTableStyle('${layout.tableBorderColor}','${layout.tableHeaderBgColor}','${layout.options.headerStyle}',0.1)"
     style="height:30px;line-height:30px;background:var(--headerBgColor) !important; font-weight: bold;font-size: 14px;<#if layout.tableTitleColor>color:${layout.tableTitleColor};
      <#elseif formSetting && formSetting.fontColor>color:${formSetting.fontColor?replace('\"','')};</#if>"

    >
        ${layout.desc}
      <div v-if="!isView && permission.table.${layout.options.boSubEntity}.del && '${layout.options.relation}'!='onetoone'"  :style="{display:'inline-block',float:'right'}">
	    <el-button type="text" icon="el-icon-delete" size="small" :style="{padding:'0px 5px'}" @click="clearAll({'subTablePath':'${subTablePath}','index': $index})">
	      	清空
    	</el-button>
      </div>
  	 <#if layout.subtableBackfill>
         ${getSunDialog(layout)}
     </#if>
      <#if layout.options.relation!='onetoone'>
            <div v-if="!isView && permission.table.${layout.options.boSubEntity}.add" :style="{display:'inline-block',float:'right'}">
              <el-button
                      size="small"
                      type="text"
                      icon="el-icon-circle-plus-outline"
                      @click="addSunTab('data.${subTablePath}',$index)"
                      <#if layout.options.maxRow>
                        :disabled="isShowAddButton('data.${subTablePath}',${layout.options.maxRow},$index)"
                    </#if>
              >添加孙表</el-button>
            </div>
      </#if>
      <#if layout.options.relation=='onetoone'>
                <div
                  v-if="!isView"
                  v-show="'${layout.options.relation}'=='onetoone' && data.${sunTablePath} && data.${sunTablePath}.length<1"
                  :style="{display:'inline-block',float:'right'}">
                  <el-button
                          size="small"
                          type="text"
                          icon="el-icon-circle-plus-outline"
                          @click="addSunTab('data.${subTablePath}',$index)"
                  >添加孙表</el-button>
                </div>
      </#if>
    </el-header>
  </#if>
  <#if isMobile>
     <el-header style="display: flex;justify-content: space-between;padding: 0;align-items: center;height: 44px;">
        <span style="color:#222222;font-size:15px;font-weight:bold;">${layout.desc}</span>
        <div style="display:flex;align-items:center;">
           <#if layout.subtableBackfill>
              ${getSunDialog(layout)}
          </#if>
          <el-button v-if="!isView && permission.table.${layout.options.boSubEntity}.del && '${layout.options.relation}'!='onetoone'"
            type="text" icon="el-input__icon el-icon-delete" size="small" @click="clearAll({'subTablePath':'${subTablePath}','index': $index})">
          </el-button>
        </div>
     </el-header>
  </#if>
    <el-main
     :style="handleTableStyle('${layout.tableBorderColor}','${layout.tableHeaderBgColor}','${layout.options.headerStyle}',0.05)"
    >
    	<#assign orgConfigStr = util.getJsonByPath(layout,'customDialogjson.orgConfig')>
      	<#assign orgConfigJson = util.getJsonStr(orgConfigStr)>
        <#if !isMobile>
        <ht-collapse :ref="'sunDivCollapseRef'+ $index" class="sun-collapse" :openDefault="getExpandArr(data.${sunTablePath},'${layout.options.dataExpand}')">
              <ht-collapse-item v-for="(item, sunIndex) in data.${sunTablePath}" :name="item.sub_guid" :key="sunIndex" class="sun-collapse-item">
                 <div slot="title" class="sun-collapse-item-title">
                     <#if layout.fieldTitle?if_exists && layout.fieldTitle?length gt 0>
                         <span v-if="item.${layout.fieldTitle} && item.${layout.fieldTitle} != ''" class="${'sub-div-title'}">
                             <i class="el-icon-caret-right" style="margin-right: 6px;"></i>
                             {{item['${layout.fieldTitle}']}}
                         </span>
                         <span v-else class="${'sub-div-title'}"><i class="el-icon-caret-right" style="margin-right: 6px;"></i>${layout.desc}{{sunIndex + 1}}</span>
                     <#else>
                         <span class="${'sub-div-title'}"><i class="el-icon-caret-right" style="margin-right: 6px;"></i>${layout.desc}{{sunIndex + 1}}</span>
                     </#if>
                    <div v-if="!isView && !(!permission.table.${layout.options.boSubEntity}.del &&
                          !permission.table.${layout.options.boSubEntity}.add) && '${layout.options.relation}'!='onetoone'" @click="transitionIndex = -1">
                         <#--  <#if !isMobile>
                            <el-button
                                v-if="permission.table.${layout.options.boSubEntity}.add"
                                size="small"
                                type="text"
                                icon="el-icon-plus"
                                @click.stop="addSunTab('data.${subTablePath}',$index)"
                                <#if layout.options.maxRow>
                                    :disabled="isShowAddButton('data.${subTablePath}',${layout.options.maxRow},$index)"
                                </#if>
                              ></el-button>
                         </#if>  -->
                        <el-button size="small" type="text" icon="el-icon-copy-document" v-if="permission.table.${layout.options.boSubEntity}.add" @click.stop="copy(data.${sunTablePath},item,'data.${sunTablePath}')">复制</el-button>
                        <el-button size="small" type="text" icon="el-icon-delete" v-if="permission.table.${layout.options.boSubEntity}.del" @click.stop="deleteSunRow('${subTablePath}',item,$index)">删除</el-button>
                    </div>
                  </div>
                <table class="form-table" :onload='initFill("${subListPath}",${orgConfigJson})' cellspacing="0" cellpadding="0" border="0" :key="item.sub_guid || sunIndex" :data-index="sunIndex" :data-subname="'data.${subName}'">
                    <tbody>
                    <tr>
                        <td colspan="30">
                      <#list layout.list as field>
                                  <#if field.ctrlType=='grid'>
                                    <template 
                                     <#if field.permissionPath?if_exists>
                                      v-if="permission.fields.${field.permissionPath}!='n'"
                                      :isShow="permission.fields.${field.permissionPath}!='n'"
                                     </#if>
                                     > 
                                  <el-row type="flex"
                                   :style="handleTableStyle('${field.options.lableColor}','${field.options.gridDescBagColor}','${field.options.borderStyle}')"
                                   class="${field.options.aBorder}${field.options.lineType} gridMargin"   
													          lineStyle="${field.options.aBorder}${field.options.lineType}"
													          :class="{'is-columns-span-all':isColumnsSpanAll('${field.options.span}','${field.options.justify}'),'is-hasGridBorderission':hasGridBorderission('${field.options.aBorder}${field.options.lineType}'), 'is-noGridBorderission':noGridBorderission('${field.options.aBorder}${field.options.lineType}')}" 
													          style='border-color:var(--borderColor);background-color:${field.options.gridBackgroundColor}'
									                  <#if hasLinkage==true> v-if="(!permission || !permission.subFields) ||(permission.subFields && !(${util.getSubRowPermission(field.columns)}) )" </#if> :gutter="${field.options.gutter?number+24}" justify="${field.options.justify}" >
                                          <#list field.columns as gridGroup>
                                              <el-col class="ht-el-col-${field.options.align}" :span="${gridGroup.span}" style="${gridGroup.style}"   >
                                                  <#list gridGroup.list as gridField>
                                                      ${getFormItem(gridField,3,hasLinkage)}
                                                  </#list>
                                              </el-col>
                                          </#list>
                                      </el-row>
                                      </template>
                                  <#else>
                                      <el-row <#if !field.options.noBindModel || util.isNoAttrField(field)> v-if="${getPermission(field,true)}!='n' && !(permission.sub_${field.tableName} && permission.sub_${field.tableName}.${field.name}sunIndex !='n')" </#if>>
                                          ${getFormItem(field,3,hasLinkage)}
                                      </el-row>
                                  </#if>
                      </#list>
                        </td>
                    </tr>
                    </tbody>

                </table>
              </ht-collapse-item>
        </ht-collapse>
         <#if layout.options.relation!='onetoone'>
            <div v-if="!isView && permission.table.${layout.options.boSubEntity}.add">
              <el-button
                  size="small"
                  plain
                  style="margin:8px 0;width: calc(100% - 0px); borderColor:var(--borderColor)!important;color: var(--themeColor);"
                  icon="el-icon-circle-plus-outline"
                  @click="addSunTab('data.${subTablePath}',$index)"
                  <#if layout.options.maxRow>
                    :disabled="isShowAddButton('data.${subTablePath}',${layout.options.maxRow},$index)"
                  </#if>
              >添加孙表</el-button>
            </div>
      </#if>
      <#if layout.options.relation=='onetoone'>
                <div
                  v-if="!isView"
                  v-show="'${layout.options.relation}'=='onetoone' && data.${sunTablePath} && data.${sunTablePath}.length<1">
                  <el-button
                     size="small"
                     plain                 
                     style="margin:8px 0;width: calc(100% - 0px); borderColor:var(--borderColor)!important;color: var(--themeColor);"
                     icon="el-icon-circle-plus-outline"
                     @click="addSunTab('data.${subTablePath}',$index)"
                  >添加孙表</el-button>
                </div>
      </#if>
        </#if>
         <#--  移动端底部添加子表按钮  -->
        <#if isMobile>
        <div><van-cell class="sun-record-title-mobile" v-for="(item, sunIndex) in data.${sunTablePath}" :name="item.sub_guid" :key="sunIndex" style="background: #F9F9F9;margin-bottom: 12px;padding: 12px 16px;display: flex;align-items: center;"  :title="sunTabletitle('${layout.desc}',sunIndex, '${layout.fieldTitle}', item)" @click="ShowSunTab('${subTablePath}',item,sunIndex,'edit')" is-link >
        <van-popup v-model="item.isShowSundiv" position="bottom" round :ref="'mobilePopup'+ sunIndex" style='width:100vw;height:80vh' get-container="body" :close-on-click-overlay='false' :overlay="true">
          <div class="pop-header mobile-sun-table__header" style="height: 30px;">
            <span class="cancel" @click.stop="cancelMobilePopup('${subTablePath}',item,$index)">取消</span>
            <span class="title ${'sub-div-title-mobile'}">
                ${getSunRecordTitle(layout, sunIndex)}
            </span>
            <span v-if="!isView && !(!permission.table.${layout.options.boSubEntity}.del &&
                          !permission.table.${layout.options.boSubEntity}.add) && '${layout.options.relation}'!='onetoone'" class="confirm" @click.stop="deleteMobileSunRow('${subTablePath}',item,$index)">删除</span>
            <span v-else class="confirm">&#12288;&#12288;</span>
          </div>
           <div class="mobile-sunpop-content">
        <table class="form-table" style="width:100%" :onload='initFill("${subListPath}",${orgConfigJson})' cellspacing="0" cellpadding="0" border="0" :key="item.sub_guid || sunIndex" :data-index="sunIndex" :data-subname="'data.${subName}'">
                    <tbody>
                    <tr>
                        <td colspan="30">
                      <#list layout.list as field>
                       <el-form
                        v-form
                        :data-vv-scope="'mobileSunDivForm'+ sunIndex " ref="mobile-form">
                                  <#if field.ctrlType=='grid'>
                                    <template 
                                     <#if field.permissionPath?if_exists>
                                      v-if="permission.fields.${field.permissionPath}!='n'"
                                      :isShow="permission.fields.${field.permissionPath}!='n'"
                                     </#if>
                                     >
                                      <el-row type="flex"
                                       :style="handleTableStyle('${field.options.lableColor}','${field.options.gridDescBagColor}','${field.options.borderStyle}')"
                                       class="${field.options.aBorder}${field.options.lineType} gridMargin"   
													             lineStyle="${field.options.aBorder}${field.options.lineType}"
													             :class="{'is-hasGridBorderission':hasGridBorderission('${field.options.aBorder}${field.options.lineType}'), 'is-noGridBorderission':noGridBorderission('${field.options.aBorder}${field.options.lineType}')}"
													             style='border-color:var(--borderColor);background-color:${field.options.gridBackgroundColor}'
									                              <#if hasLinkage==true> v-if="(!permission || !permission.subFields) ||(permission.subFields && !(${util.getSubRowPermission(field.columns)}) )" </#if> :gutter="${field.options.gutter?number+24}" justify="${field.options.justify}" align="${field.options.align}">
                                          <#list field.columns as gridGroup>
                                              <el-col class="ht-el-col-${field.options.align}" :span="${gridGroup.span}" style="${gridGroup.style}" >
                                                  <#list gridGroup.list as gridField>
                                                      ${getFormItem(gridField,3,hasLinkage)}
                                                  </#list>
                                              </el-col>
                                          </#list>
                                      </el-row>
                                      </template>
                                  <#else>
                                      <el-row <#if !field.options.noBindModel || util.isNoAttrField(field)> v-if="${getPermission(field,true)}!='n' && !(permission.sub_${field.tableName} && permission.sub_${field.tableName}.${field.name}sunIndex !='n')" </#if>>
                                          ${getFormItem(field,3,hasLinkage)}
                                      </el-row>
                                  </#if>
                      </el-form>
                      </#list>

                        </td>
                    </tr>
                    </tbody>
          </table>
          </div>
          <div class="footer-btn" 
          style="background:#fff;height:64px;display:flex;justify-content: space-between;
            align-items: center; padding:0 16px"
            >
          <van-button v-if="!isView" type="info" 
          style="flex:1;background:#409EFF;borderColor:#409EFF;borderRadius:8px" block 
          @click.stop="saveMobileSunTab('data.${subTablePath}',sunIndex,item)">保存</van-button>
          </div>
         </van-popup>
         </van-cell>
          </div>
          <#if layout.options.relation!='onetoone'>
              <el-button
                      class="add-sun-btn"
                      v-if="!isView && permission.table.${layout.options.boSubEntity}.add"
                      size="small"
                      type="text"
                      icon="el-icon-circle-plus-outline"
                      @click="addMobileSunTab('data.${subTablePath}',$index,'add')"
                      <#if layout.options.maxRow>
                      :disabled="isShowAddButton('data.${subTablePath}',${layout.options.maxRow},$index)"
                    </#if>
              >添加孙表</el-button>
          </#if>
          <#if layout.options.relation=='onetoone'>
                <el-button
                        class="add-sun-btn"
                        v-if="!isView"
                        v-show="'${layout.options.relation}'=='onetoone' && data.${sunTablePath} && data.${sunTablePath}.length<1"
                        size="small"
                        type="text"
                        icon="el-icon-circle-plus-outline"
                        @click="addMobileSunTab('data.${subTablePath}',$index,'add')"
                >添加孙表</el-button>
          </#if>
        </#if>
    </el-main>   
</el-container>
</#macro>

<#function getSunDialog layout >
    <#assign custdialogConf  = util.getStringConf(layout.customDialogjson)>
    <#assign rtn>
    	<ht-sub-dialog
    	  v-if="!isView"
          relation="${layout.options.relation}"
    	  :custdialog='${custdialogConf}'
    	  init-fill-data="${layout.initTemplateData}"
    	  init-fill-data-type="${layout.initTemplateDataType}"
          :max-row="${util.getNumber(layout.options.maxRow, 0)}"
          :sub-index="$index"
        />
    </#assign>
    <#return rtn>
</#function>
<#function getSunRecordTitle layout sunIndex >

    <#assign title>
        <#if layout.fieldTitle?if_exists && layout.fieldTitle?length gt 0>
            <span v-if="item.${layout.fieldTitle} && item.${layout.fieldTitle} != ''">
                             {{item['${layout.fieldTitle}']}}
                         </span>
            <span v-else>${layout.desc}{{sunIndex + 1}}</span>
        <#else>
            <span>${layout.desc}${sunIndex + 1}</span>
        </#if>
    </#assign>
    <#return title>
</#function>
