/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.i18n.util;

import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.i18n.support.service.MessageService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.context.i18n.LocaleContextHolder;

public class I18nUtil {
    private static MessageService messageService;

    private static void initService() {
        if (BeanUtils.isEmpty((Object)messageService)) {
            messageService = (MessageService)AppUtil.getBean(MessageService.class);
        }
    }

    public static void initMessage() {
        I18nUtil.initService();
        messageService.initMessage();
    }

    public static String getMessage(String code, Locale locale) {
        I18nUtil.initService();
        String message = messageService.getMessage(code, I18nUtil.getLocaleTag(locale));
        return message;
    }

    private static String getLocaleTag(Locale locale) {
        return locale.toLanguageTag();
    }

    public static String getCode(String temp, String rep) {
        String rtn = "";
        Pattern regex = Pattern.compile(rep);
        Matcher regexMatcher = regex.matcher(temp);
        while (regexMatcher.find()) {
            rtn = regexMatcher.group(1);
        }
        return rtn;
    }

    public static Map<String, String> getMessages(List<String> codes, Locale locale) {
        I18nUtil.initService();
        return messageService.getMessages(codes, I18nUtil.getLocaleTag(locale));
    }

    public static List<String> getCodes(String temp, String rep) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern regex = Pattern.compile(rep);
        Matcher regexMatcher = regex.matcher(temp);
        while (regexMatcher.find()) {
            result.add(regexMatcher.group(1));
        }
        return result;
    }

    public static String replaceTemp(String temp, String rep, Locale locale) {
        if (StringUtil.isEmpty((String)temp)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        List<String> codes = I18nUtil.getCodes(temp, rep);
        Map<String, String> messages = I18nUtil.getMessages(codes, locale);
        Pattern regex = Pattern.compile(rep);
        Matcher regexMatcher = regex.matcher(temp);
        while (regexMatcher.find()) {
            String key = regexMatcher.group(1);
            regexMatcher.appendReplacement(sb, messages.get(key) == null ? key : messages.get(key));
        }
        regexMatcher.appendTail(sb);
        return sb.toString();
    }

    public static String replaceTempForFramemaker(String temp, String rep) {
        StringBuffer sb = new StringBuffer();
        Pattern regex = Pattern.compile(rep);
        Matcher regexMatcher = regex.matcher(temp);
        while (regexMatcher.find()) {
            regexMatcher.appendReplacement(sb, "\uffe5{" + regexMatcher.group(1) + "}");
        }
        regexMatcher.appendTail(sb);
        return sb.toString();
    }

    public static String handleI18nMessage(String i18nKey, String defaultValue, Locale locale) {
        String i18nMessage = I18nUtil.getMessage(i18nKey, locale);
        return StringUtil.isEmpty((String)i18nMessage) || Objects.equals(i18nKey, i18nMessage) ? defaultValue : i18nMessage;
    }

    public static String handleI18nMessage(String i18nKey, String defaultValue) {
        return I18nUtil.handleI18nMessage(i18nKey, defaultValue, LocaleContextHolder.getLocale());
    }

    public static String getI18nFormat(String i18nKey, String defaultValue, Object ... args) {
        String i18nMessage = I18nUtil.handleI18nMessage(i18nKey, defaultValue, LocaleContextHolder.getLocale());
        return String.format(i18nMessage, args);
    }
}

