/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.system.consts;

import com.hotent.base.util.AppUtil;
import com.hotent.system.enums.BaseUrlEnum;
import com.hotent.system.model.SysExternalUnite;
import com.hotent.system.persistence.manager.SysExternalUniteManager;
import com.hotent.system.util.DingTalkTokenUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class DingTalkConsts {
    private static final String DT_URL = "https://oapi.dingtalk.com";
    private static final String DT_URL_NEW = "https://oapi.dingtalk.com/topapi/v2";

    public static SysExternalUnite getUnite() {
        SysExternalUniteManager manager = (SysExternalUniteManager)AppUtil.getBean(SysExternalUniteManager.class);
        return manager.getDingtalk();
    }

    public static String getUserUrl() throws IOException {
        String url = "https://oapi.dingtalk.com/user/get?access_token=" + DingTalkTokenUtil.getToken() + "&userid=";
        return url;
    }

    public static String getTokenUrl() {
        return "https://oapi.dingtalk.com/gettoken?appkey=" + DingTalkConsts.getUnite().getCorpId() + "&appsecret=" + DingTalkConsts.getUnite().getCorpSecret();
    }

    public static String getCreateUserUrl() throws IOException {
        String url = "https://oapi.dingtalk.com/user/create?access_token=" + DingTalkTokenUtil.getToken();
        return url;
    }

    public static String getOrgUrl() throws IOException {
        String url = "https://oapi.dingtalk.com/department/get?access_token=" + DingTalkTokenUtil.getToken();
        return url;
    }

    public static String getCreateOrgUrl() throws IOException {
        String url = "https://oapi.dingtalk.com/topapi/v2/department/create";
        return url;
    }

    public static String getUpdateOrgUrl() throws IOException {
        String url = "https://oapi.dingtalk.com/department/update?access_token=" + DingTalkTokenUtil.getToken();
        return url;
    }

    public static String getDeleteOrgUrl() throws IOException {
        String url = "https://oapi.dingtalk.com/department/delete?access_token=" + DingTalkTokenUtil.getToken() + "&dept_id=";
        return url;
    }

    public static String generateMenuUrl(String baseUrl, String corpId, BaseUrlEnum baseUrlEnum) throws UnsupportedEncodingException {
        String path;
        String string = path = BaseUrlEnum.PC.equals((Object)baseUrlEnum) ? "index" : "home";
        if (!baseUrl.endsWith("/")) {
            path = "/" + path;
        }
        String redirect_uri = baseUrl + path;
        String url = baseUrl + "/dingTalk?corpid=" + corpId + "&redirect_uri=" + URLEncoder.encode(redirect_uri, "UTF-8");
        return url;
    }

    public static String getUserInfo(String code) throws IOException {
        return "https://oapi.dingtalk.com/user/getuserinfo?access_token=" + DingTalkTokenUtil.getToken() + "&code=" + code;
    }

    public static String getMsgSendUrl() {
        return "https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2";
    }

    public static String getAuthorize(String paramStr) {
        return DingTalkConsts.getUnite().getBaseUrl() + "/dingTalk?corpid=" + DingTalkConsts.getUnite().getAgentKey() + "&params=" + paramStr;
    }

    public static String getDepartmentListUrl() throws IOException {
        String url = "https://oapi.dingtalk.com/department/list";
        return url;
    }

    public static String getUsersByDepartmentId() {
        String url = "https://oapi.dingtalk.com/user/listbypage";
        return url;
    }

    public static String getParentByDept() throws IOException {
        return "https://oapi.dingtalk.com/topapi/v2/department/listparentbydept";
    }
}

