/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.system.model.msg.schedule;

import com.hotent.base.util.StringUtil;
import com.hotent.system.model.msg.schedule.Attendees;
import com.hotent.system.model.msg.schedule.Reminders;
import com.hotent.system.model.msg.schedule.Schedule;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WXScheduleMsg {
    private Schedule schedule;
    private String agentid;

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public void setAgentid(String agentid) {
        this.agentid = agentid;
    }

    public String getAgentid() {
        return this.agentid;
    }

    public static WXScheduleMsg builder(String agentId, String wxWorkIds, String subject, String desc) {
        if (StringUtil.isEmpty((String)wxWorkIds)) {
            return null;
        }
        List<String> users = Arrays.asList(wxWorkIds.split(","));
        List<String> admins = users.size() > 3 ? users.subList(0, 2) : users;
        ArrayList<Attendees> attendees = new ArrayList<Attendees>();
        users.forEach(u -> {
            Attendees attendee = new Attendees();
            attendee.setUserid((String)u);
            attendees.add(attendee);
        });
        LocalDateTime today = LocalDateTime.now();
        LocalDateTime lastMomentOfTheDay = LocalDateTime.of(today.toLocalDate(), LocalTime.MAX);
        WXScheduleMsg scheduleMsg = new WXScheduleMsg();
        scheduleMsg.setAgentid(agentId);
        Schedule schedule = new Schedule();
        scheduleMsg.setSchedule(schedule);
        schedule.setAdmins(admins);
        schedule.setAttendees(attendees);
        schedule.setSummary(subject);
        schedule.setDescription(desc);
        schedule.setReminders(new Reminders());
        schedule.setStartTime(today.plusMinutes(2L).toEpochSecond(ZoneOffset.of("+8")));
        schedule.setEndTime(lastMomentOfTheDay.toEpochSecond(ZoneOffset.of("+8")));
        return scheduleMsg;
    }
}

