/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.system.persistence.manager.impl;

import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiDepartmentGetRequest;
import com.dingtalk.api.request.OapiDepartmentListRequest;
import com.dingtalk.api.request.OapiUserListbypageRequest;
import com.dingtalk.api.request.OapiV2DepartmentListparentbydeptRequest;
import com.dingtalk.api.response.OapiDepartmentGetResponse;
import com.dingtalk.api.response.OapiDepartmentListResponse;
import com.dingtalk.api.response.OapiUserListbypageResponse;
import com.dingtalk.api.response.OapiV2DepartmentListparentbydeptResponse;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.system.consts.DingTalkConsts;
import com.hotent.system.enums.ExterUniEnum;
import com.hotent.system.enums.WxBindTypeEnum;
import com.hotent.system.model.SysExternalUnite;
import com.hotent.system.model.WxUser;
import com.hotent.system.persistence.manager.DingTalkOrgService;
import com.hotent.system.persistence.manager.HtOrgService;
import com.hotent.system.persistence.manager.IUserService;
import com.hotent.system.persistence.manager.impl.WxOrgService;
import com.hotent.system.util.DingTalkHttpUtil;
import com.hotent.system.util.DingTalkTokenUtil;
import com.hotent.system.util.OrgConvertUtil;
import com.hotent.system.util.ThreadMessageUtil;
import com.taobao.api.TaobaoRequest;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DtUserService
implements IUserService {
    protected Logger logger = LoggerFactory.getLogger(WxOrgService.class);
    @Resource
    UCFeignService uCFeignService;
    @Autowired
    private DingTalkOrgService dingTalkOrgService;
    @Resource
    private HtOrgService htOrgService;

    @Override
    public void create(ObjectNode user) throws IOException {
        String resultJson;
        String fullname = user.get("fullname").asText();
        user.put("department", this.htOrgService.getDeptIdByUserId(user.get("userId").asText(), ExterUniEnum.Dingtalk));
        WxUser wxUser = OrgConvertUtil.userToWxUser((JsonNode)user);
        try {
            resultJson = DingTalkHttpUtil.sendHttpsRequest(DingTalkConsts.getCreateUserUrl(), wxUser.toString(), "POST");
        }
        catch (Exception e) {
            this.logger.error("\u540c\u6b65\u9489\u9489\u7528\u6237\u6570\u636e\u5f02\u5e38\uff01", (Throwable)e);
            throw e;
        }
        JsonNode result = JsonUtil.toJsonNode((String)resultJson);
        String errcode = result.get("errcode").asText();
        if ("0".equals(errcode)) {
            ObjectNode userUnite = JsonUtil.getMapper().createObjectNode();
            userUnite.set("userId", user.get("userId"));
            userUnite.set("dingtalkId", user.get("account"));
            this.uCFeignService.updateUserUnite(userUnite);
            return;
        }
        if ("60102".equals(errcode)) {
            ObjectNode userUnite = JsonUtil.getMapper().createObjectNode();
            userUnite.set("userId", user.get("userId"));
            userUnite.set("dingtalkId", user.get("account"));
            this.uCFeignService.updateUserUnite(userUnite);
            return;
        }
        if ("60104".equals(errcode)) {
            ObjectNode userUnite = JsonUtil.getMapper().createObjectNode();
            userUnite.set("userId", user.get("userId"));
            String errmsg = result.get("errmsg").asText();
            String userid = errmsg.substring(errmsg.indexOf(":") + 1);
            userUnite.put("dingtalkId", userid);
            this.uCFeignService.updateUserUnite(userUnite);
            return;
        }
        String account = user.get("account").asText();
        ThreadMessageUtil.addMapMsg(fullname + "[" + account + "]", result.get("errmsg").asText());
    }

    public boolean queryUser(ObjectNode user) throws IOException {
        String account = user.get("account").asText();
        String getUserUrl = DingTalkConsts.getUserUrl() + account;
        String resultJsonUser = HttpUtil.sendHttpsRequest((String)getUserUrl, (String)"", (String)"GET");
        JsonNode userJson = JsonUtil.toJsonNode((String)resultJsonUser);
        return "0".equals(userJson.get("errcode").asText());
    }

    @Override
    public void update(ObjectNode user) throws IOException {
    }

    @Override
    public void delete(String userId) {
    }

    @Override
    public void deleteAll(String userIds) {
    }

    @Override
    public void addAll(JsonNode users) throws IOException {
        for (JsonNode user : users) {
            ObjectNode node = (ObjectNode)user;
            String mobile = user.get("mobile").asText();
            if ("null".equals(mobile) || StringUtil.isEmpty((String)mobile)) continue;
            this.create(node);
        }
    }

    @Override
    public void syncUser(String[] lAryId) throws IOException {
        ArrayNode userList = JsonUtil.getMapper().createArrayNode();
        if (BeanUtils.isNotEmpty((Object)lAryId)) {
            for (int i = 0; i < lAryId.length; ++i) {
                ObjectNode user = (ObjectNode)this.uCFeignService.getUserById(lAryId[i]).getValue();
                if (user == null) continue;
                userList.add((JsonNode)user);
            }
        } else {
            userList = this.uCFeignService.getUsersNotYetSyncDingtalk(Collections.singletonList("1"));
        }
        this.addAll((JsonNode)userList);
    }

    public void pullOrgAndUser(String orgId) throws Exception {
        this.pullRootDepartment(orgId);
        this.pullUserByDepartmentId(orgId);
        this.pullUser(orgId, "");
    }

    private void pullRootDepartment(String orgId) throws Exception {
        DefaultDingTalkClient client = new DefaultDingTalkClient(DingTalkConsts.getOrgUrl());
        OapiDepartmentGetRequest req = new OapiDepartmentGetRequest();
        req.setId(orgId);
        req.setLang("zh_CN");
        req.setHttpMethod("GET");
        OapiDepartmentGetResponse response = (OapiDepartmentGetResponse)client.execute((TaobaoRequest)req);
        if (Long.valueOf(0L).equals(response.getErrcode())) {
            ObjectNode exist = this.uCFeignService.getOrgByIdOrCode(orgId);
            if (exist == null) {
                exist = JsonUtil.getMapper().createObjectNode();
                exist.put("id", response.getId());
                exist.put("code", UUID.randomUUID().toString().replaceAll("-", ""));
                exist.put("name", response.getName());
                exist.put("parentId", response.getParentid());
                CommonResult orgRsl = this.uCFeignService.addOrgFromExterUni(exist);
                if (!orgRsl.getState().booleanValue()) {
                    throw new RuntimeException("\u5199\u5165\u7ec4\u7ec7\u67b6\u6784\u5931\u8d25\uff1a" + orgRsl.getMessage());
                }
            }
        } else {
            throw new RuntimeException("\u83b7\u53d6\u9489\u9489\u6839\u7ec4\u7ec7[id=" + orgId + "]\u5931\u8d25\uff1a" + response.getErrmsg());
        }
    }

    public void pullUser(String parentDeptId, String parentPathName) throws Exception {
        DefaultDingTalkClient client = new DefaultDingTalkClient(DingTalkConsts.getDepartmentListUrl());
        OapiDepartmentListRequest request = new OapiDepartmentListRequest();
        request.setId(parentDeptId);
        request.setFetchChild(Boolean.valueOf(false));
        request.setHttpMethod("GET");
        OapiDepartmentListResponse response = (OapiDepartmentListResponse)client.execute((TaobaoRequest)request, DingTalkTokenUtil.getToken());
        if (Long.valueOf(0L).equals(response.getErrcode())) {
            List departmentList = response.getDepartment();
            for (OapiDepartmentListResponse.Department o : departmentList) {
                String deptId = String.valueOf(o.getId());
                String pathName = parentPathName + "/" + o.getName();
                ObjectNode orgNew = JsonUtil.getMapper().createObjectNode();
                orgNew.put("id", o.getId());
                orgNew.put("code", UUID.randomUUID().toString().replaceAll("-", ""));
                orgNew.put("name", o.getName());
                orgNew.put("parentId", o.getParentid());
                orgNew.put("dingtalkId", deptId);
                orgNew.set("pathName", JsonUtil.toJsonNode((String)JsonUtil.toJson((Object)pathName)));
                CommonResult orgRsl = this.uCFeignService.addOrgFromExterUni(orgNew);
                if (!orgRsl.getState().booleanValue()) {
                    throw new RuntimeException("\u5199\u5165\u7ec4\u7ec7\u67b6\u6784\u5931\u8d25\uff1a" + orgRsl.getMessage());
                }
                this.pullUserByDepartmentId(deptId);
                this.pullUser(deptId, pathName);
            }
        } else {
            throw new RuntimeException("\u83b7\u53d6\u9489\u9489\u901a\u8baf\u5f55\u7684\u7ec4\u7ec7\u67b6\u6784\u5931\u8d25\uff1a" + response.getErrmsg());
        }
    }

    private void pullUserOnly(String parentDeptId) throws Exception {
        DefaultDingTalkClient client = new DefaultDingTalkClient(DingTalkConsts.getDepartmentListUrl());
        OapiDepartmentListRequest request = new OapiDepartmentListRequest();
        request.setId(parentDeptId);
        request.setFetchChild(Boolean.valueOf(false));
        request.setHttpMethod("GET");
        OapiDepartmentListResponse response = (OapiDepartmentListResponse)client.execute((TaobaoRequest)request, DingTalkTokenUtil.getToken());
        if (Long.valueOf(0L).equals(response.getErrcode())) {
            List departmentList = response.getDepartment();
            for (OapiDepartmentListResponse.Department o : departmentList) {
                String deptId = String.valueOf(o.getId());
                this.pullUserByDepartmentId(deptId);
                this.pullUserOnly(deptId);
            }
        } else {
            throw new RuntimeException("\u83b7\u53d6\u9489\u9489\u901a\u8baf\u5f55\u7684\u7ec4\u7ec7\u67b6\u6784\u5931\u8d25\uff1a" + response.getErrmsg());
        }
    }

    private ObjectNode getDepartmentById(String deptId) throws Exception {
        DefaultDingTalkClient client = new DefaultDingTalkClient(DingTalkConsts.getOrgUrl());
        OapiDepartmentGetRequest req = new OapiDepartmentGetRequest();
        req.setId(deptId);
        req.setLang("zh_CN");
        req.setHttpMethod("GET");
        OapiDepartmentGetResponse response = (OapiDepartmentGetResponse)client.execute((TaobaoRequest)req);
        if (!Long.valueOf(0L).equals(response.getErrcode())) {
            return null;
        }
        ObjectNode node = JsonUtil.getMapper().createObjectNode();
        node.put("id", deptId);
        node.put("code", UUID.randomUUID().toString().replaceAll("-", ""));
        node.put("name", response.getName());
        node.put("parentId", response.getParentid());
        node.put("dingtalkId", deptId);
        return node;
    }

    private void pullDataByDepartment(String deptId) throws Exception {
        DefaultDingTalkClient client = new DefaultDingTalkClient(DingTalkConsts.getParentByDept());
        OapiV2DepartmentListparentbydeptRequest req = new OapiV2DepartmentListparentbydeptRequest();
        req.setDeptId(Long.valueOf(NumberUtils.toLong((String)deptId)));
        OapiV2DepartmentListparentbydeptResponse response = (OapiV2DepartmentListparentbydeptResponse)client.execute((TaobaoRequest)req, DingTalkTokenUtil.getToken());
        ArrayNode arrayNode = JsonUtil.getMapper().createArrayNode();
        if (Long.valueOf(0L).equals(response.getErrcode())) {
            List idList = response.getResult().getParentIdList();
            if (!CollectionUtils.isEmpty((Collection)idList)) {
                for (Long l : idList) {
                    String tempDeptId = String.valueOf(l);
                    ObjectNode node = this.getDepartmentById(tempDeptId);
                    if (node == null) continue;
                    arrayNode.add((JsonNode)node);
                }
            }
        } else {
            throw new RuntimeException("\u83b7\u53d6\u9489\u9489\u901a\u8baf\u5f55\u7684\u7236\u7ec4\u7ec7\u5931\u8d25\uff1a" + response.getErrmsg());
        }
        ObjectNode currentNode = this.getDepartmentById(deptId);
        if (currentNode != null) {
            arrayNode.add((JsonNode)currentNode);
        }
        String parentId = "1";
        String parentPathName = "";
        parentPathName = this.pullDepartmentByParentId(parentId, parentPathName, arrayNode);
        this.pullUserByDepartmentId(deptId);
        this.pullUser(deptId, parentPathName);
    }

    private String pullDepartmentByParentId(String parentId, String parentPathName, ArrayNode arrayNode) throws Exception {
        for (JsonNode node : arrayNode) {
            String id = node.get("id").asText();
            String parentIdTemp = node.get("parentId").asText();
            if (!StringUtil.isNotEmpty((String)parentIdTemp) || !Objects.equals(parentId, parentIdTemp)) continue;
            ObjectNode objectNode = (ObjectNode)node;
            parentPathName = parentPathName + "/" + node.get("name").asText();
            objectNode.set("pathName", JsonUtil.toJsonNode((String)JsonUtil.toJson((Object)parentPathName)));
            CommonResult orgRsl = this.uCFeignService.addOrgFromExterUni(objectNode);
            if (!orgRsl.getState().booleanValue()) {
                throw new RuntimeException("\u5199\u5165\u7ec4\u7ec7\u67b6\u6784\u5931\u8d25\uff1a" + orgRsl.getMessage());
            }
            parentPathName = this.pullDepartmentByParentId(id, parentPathName, arrayNode);
        }
        return parentPathName;
    }

    @Override
    public void pullData(SysExternalUnite sysExternalUnite) throws Exception {
        String deptParentApp = "1";
        if (Objects.equals(0, sysExternalUnite.getSyncScope())) {
            this.pullUserByDepartmentId(deptParentApp);
            this.pullUser(deptParentApp, "");
        } else if (Objects.equals(1, sysExternalUnite.getSyncScope())) {
            this.pullUserByDepartmentId(deptParentApp);
            this.pullUserOnly(deptParentApp);
        } else if (Objects.equals(2, sysExternalUnite.getSyncScope())) {
            if (StringUtil.isEmpty((String)sysExternalUnite.getSyncOrgId())) {
                return;
            }
            String deptId = sysExternalUnite.getSyncOrgId();
            this.pullDataByDepartment(deptId);
        }
    }

    @Override
    public void pushData(SysExternalUnite sysExternalUnite) throws Exception {
        if (Objects.equals(0, sysExternalUnite.getSyncScope())) {
            this.dingTalkOrgService.syncAllOrg();
            ArrayNode userList = this.uCFeignService.getUsersNotYetSyncDingtalk(null);
            this.addAll((JsonNode)userList);
        } else if (Objects.equals(1, sysExternalUnite.getSyncScope())) {
            ArrayNode userList = this.uCFeignService.getUsersNotYetSyncDingtalk(null);
            this.addAll((JsonNode)userList);
        } else if (Objects.equals(2, sysExternalUnite.getSyncScope())) {
            if (StringUtil.isEmpty((String)sysExternalUnite.getSyncOrgId())) {
                return;
            }
            this.dingTalkOrgService.syncAllOrg();
            ArrayNode userList = this.uCFeignService.getUsersNotYetSyncDingtalk(Collections.singletonList(sysExternalUnite.getSyncOrgId()));
            this.addAll((JsonNode)userList);
        }
    }

    private void pullUserByDepartmentId(String deptId) throws Exception {
        DefaultDingTalkClient client = new DefaultDingTalkClient(DingTalkConsts.getUsersByDepartmentId());
        OapiUserListbypageRequest request = new OapiUserListbypageRequest();
        Long offset = 0L;
        Long size = 100L;
        boolean hasNextData = true;
        while (hasNextData) {
            request.setDepartmentId(Long.valueOf(deptId));
            request.setHttpMethod("GET");
            request.setOffset(offset);
            request.setSize(size);
            request.setOrder("entry_desc");
            OapiUserListbypageResponse execute = (OapiUserListbypageResponse)client.execute((TaobaoRequest)request, DingTalkTokenUtil.getToken());
            List userlist = execute.getUserlist();
            if (userlist == null || userlist.size() == 0) {
                hasNextData = false;
            }
            if (BeanUtils.isNotEmpty((Object)userlist)) {
                ArrayNode arrayNode = JsonUtil.listToArrayNode((List)userlist);
                this.uCFeignService.batchUpdateUsersFromExterUni(ExterUniEnum.Dingtalk.getKey(), (JsonNode)arrayNode);
            }
            Long l = offset;
            Long l2 = offset = Long.valueOf(offset + 1L);
        }
    }

    @Override
    public void bindMobile(WxBindTypeEnum bindTypeEnum) throws Exception {
    }
}

