/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.system.persistence.manager.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.system.enums.ExterUniEnum;
import com.hotent.system.persistence.manager.HtOrgService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HtOrgServiceImpl
implements HtOrgService {
    @Resource
    UCFeignService ucFeignService;

    @Override
    public List<String> getAllOrgIds(String orgId) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(orgId);
        List orgs = this.ucFeignService.getOrgsByparentId(orgId);
        if (orgs != null && orgs.size() > 0) {
            for (ObjectNode rootOrg : orgs) {
                String id = rootOrg.get("id").asText();
                result.addAll(this.getAllOrgIds(id));
            }
        }
        return result;
    }

    @Override
    public void updateLocalDbExternal(String orgId, String deptId, ExterUniEnum exterUniEnum) {
        String key = this.getKey(exterUniEnum);
        ObjectNode unite = JsonUtil.getMapper().createObjectNode();
        unite.put("orgId", orgId);
        unite.put(key, deptId);
        this.ucFeignService.updateOrgUnite(unite);
    }

    @Override
    public String getDeptIdByUserId(String userId, ExterUniEnum exterUniEnum) {
        String dingRootDeptId = "1";
        ArrayNode department = this.ucFeignService.getOrgListByUserId(userId);
        if (BeanUtils.isEmpty((Object)department)) {
            return dingRootDeptId;
        }
        String key = this.getKey(exterUniEnum);
        ArrayList<String> arr = new ArrayList<String>();
        for (JsonNode node : department) {
            ObjectNode dept = (ObjectNode)node;
            if (dept.get(key) == null || !StringUtil.isNotEmpty((String)dept.get(key).asText())) continue;
            arr.add(dept.get(key).asText());
        }
        return CollectionUtils.isEmpty(arr) ? dingRootDeptId : StringUtil.join(arr, (String)",");
    }

    private String getKey(ExterUniEnum exterUniEnum) {
        String key = "dingtalkId";
        if (exterUniEnum == ExterUniEnum.Dingtalk) {
            key = "dingtalkId";
        } else if (exterUniEnum == ExterUniEnum.WeChatWork) {
            key = "wxWorkId";
        } else if (exterUniEnum == ExterUniEnum.FlyBook) {
            key = "flybookId";
        }
        return key;
    }

    @Override
    public String getDeptIdByOrgId(String orgId, List<ObjectNode> orgUnitList, ExterUniEnum exterUniEnum) {
        if (Objects.equals(orgId, "0")) {
            return "1";
        }
        String key = this.getKey(exterUniEnum);
        if (CollectionUtils.isEmpty(orgUnitList)) {
            return "";
        }
        ObjectNode unite = orgUnitList.stream().filter(o -> o.get("orgId") != null && Objects.equals(orgId, o.get("orgId").asText())).findFirst().orElse(null);
        if (unite == null || unite.get(key) == null) {
            return "";
        }
        return unite.get(key).asText();
    }

    @Override
    public String getOrgIdByDeptId(String deptId, List<ObjectNode> orgUnitList, ExterUniEnum exterUniEnum) {
        if (Objects.equals(deptId, "1")) {
            return "0";
        }
        String key = this.getKey(exterUniEnum);
        if (CollectionUtils.isEmpty(orgUnitList)) {
            return "";
        }
        ObjectNode unite = orgUnitList.stream().filter(o -> o.get(key) != null && Objects.equals(deptId, o.get(key).asText())).findFirst().orElse(null);
        if (unite == null || unite.get(key) == null) {
            return "";
        }
        return unite.get("orgId").asText();
    }

    @Override
    public ArrayNode userDeptId2OrgId(ArrayNode arrayNode, List<ObjectNode> orgUnitList, String defaultDeptId, ExterUniEnum exterUniEnum) throws Exception {
        if (arrayNode == null) {
            return arrayNode;
        }
        ArrayList<ObjectNode> jsonNodeList = new ArrayList<ObjectNode>();
        for (Object userObj : arrayNode) {
            ObjectNode user = (ObjectNode)JsonUtil.toJsonNode(userObj);
            if (user != null && user.get("department") != null) {
                if (user.get("department").isArray()) {
                    ArrayList<String> orgIdList = new ArrayList<String>();
                    ArrayNode deptArrayNode = (ArrayNode)user.get("department");
                    for (JsonNode deptNode : deptArrayNode) {
                        if (deptNode == null || !StringUtil.isNotEmpty((String)deptNode.asText())) continue;
                        String tempId = deptNode.asText();
                        String orgId = "0";
                        if (!Objects.equals("1", tempId)) {
                            orgId = this.getOrgIdByDeptId(tempId, orgUnitList, exterUniEnum);
                        }
                        orgId = StringUtil.isEmpty((String)orgId) ? "0" : orgId;
                        orgIdList.add(orgId);
                    }
                    user.set("department", (JsonNode)JsonUtil.listToArrayNode(orgIdList));
                } else {
                    String orgId = this.getOrgIdByDeptId(defaultDeptId, orgUnitList, exterUniEnum);
                    user.set("department", JsonUtil.toJsonNode((String)orgId));
                }
            }
            jsonNodeList.add(user);
        }
        return JsonUtil.listToArrayNode(jsonNodeList);
    }
}

