/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.system.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.annotation.AsyncThreadClean;
import com.hotent.base.exception.BaseException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.system.consts.DingTalkConsts;
import com.hotent.system.consts.FlyBookConsts;
import com.hotent.system.consts.WeChatOffAccConsts;
import com.hotent.system.consts.WeChatWorkConsts;
import com.hotent.system.enums.BaseUrlEnum;
import com.hotent.system.enums.ExterUniEnum;
import com.hotent.system.enums.WxBindTypeEnum;
import com.hotent.system.model.SysExternalUnite;
import com.hotent.system.model.WxOrg;
import com.hotent.system.persistence.dao.SysExternalUniteDao;
import com.hotent.system.persistence.manager.DingTalkOrgService;
import com.hotent.system.persistence.manager.FlybookOrgService;
import com.hotent.system.persistence.manager.SysExternalUniteManager;
import com.hotent.system.persistence.manager.impl.DtUserService;
import com.hotent.system.persistence.manager.impl.FlybookUserService;
import com.hotent.system.persistence.manager.impl.WxOrgService;
import com.hotent.system.persistence.manager.impl.WxUserService;
import com.hotent.system.util.DingTalkTokenUtil;
import com.hotent.system.util.ThreadMessageUtil;
import com.hotent.system.util.WechatOffAccTokenUtil;
import com.hotent.system.util.WechatWorkTokenUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="sysExternalUniteManager")
public class SysExternalUniteManagerImpl
extends BaseManagerImpl<SysExternalUniteDao, SysExternalUnite>
implements SysExternalUniteManager {
    @Resource
    WxUserService wxUserService;
    @Resource
    DtUserService dtUserService;
    @Resource
    FlybookUserService flybookUserService;
    @Resource
    SysExternalUniteDao sysExternalUniteDao;
    @Resource
    FlybookOrgService flybookOrgService;
    @Resource
    DingTalkOrgService dingTalkOrgService;
    @Resource
    WxOrgService wxOrgService;

    @Override
    public boolean isTypeExists(String type, String id) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", type);
        if (StringUtil.isNotEmpty((String)id)) {
            map.put("id", id);
        }
        return BeanUtils.isNotEmpty((Object)((Object)this.sysExternalUniteDao.isTypeExists(map)));
    }

    @Override
    public SysExternalUnite getWechatWork() {
        return this.sysExternalUniteDao.getOneByType(ExterUniEnum.WeChatWork.getKey());
    }

    @Override
    public SysExternalUnite getFlyBook() {
        return this.sysExternalUniteDao.getOneByType(ExterUniEnum.FlyBook.getKey());
    }

    @Override
    public SysExternalUnite getDingtalk() {
        return this.sysExternalUniteDao.getOneByType(ExterUniEnum.Dingtalk.getKey());
    }

    @Override
    public SysExternalUnite getWeChatOfficialAccounts() {
        return this.sysExternalUniteDao.getOneByType(ExterUniEnum.WeChatOfficialAccounts.getKey());
    }

    @Override
    public SysExternalUnite getMiniprogram() {
        return this.sysExternalUniteDao.getOneByType(ExterUniEnum.MiniProgram.getKey());
    }

    @Override
    public void syncUser(String uniteId) throws IOException {
        SysExternalUnite entity = (SysExternalUnite)this.get((Serializable)((Object)uniteId));
        if (BeanUtils.isEmpty((Object)((Object)entity))) {
            throw new RuntimeException("\u67e5\u65e0\u6b64\u96c6\u6210\u4fe1\u606f");
        }
        if (ExterUniEnum.WeChatWork.getKey().equals(entity.getType())) {
            this.wxUserService.syncUser(null);
        } else if (ExterUniEnum.Dingtalk.getKey().equals(entity.getType())) {
            this.dtUserService.syncUser(null);
        }
    }

    @Override
    public void saveAgent(SysExternalUnite unite) throws IOException {
        this.update((Model)unite);
        if ("1".equals(unite.getIsPublish()) && ExterUniEnum.WeChatWork.getKey().equals(unite.getType())) {
            String url = WeChatWorkConsts.getCreateAgentMenuUrl(unite.getAgentId());
            String button = "{\"button\":[{\"type\":\"view\",\"name\":\"$name\",\"url\":\"$url\"}]}";
            button = button.replace("$name", unite.getMenuName()).replace("$url", unite.getMenuUrl());
            String rtn = HttpUtil.sendHttpsRequest((String)url, (String)button, (String)"POST");
            JsonNode jsonObj = JsonUtil.toJsonNode((String)rtn);
            System.out.println(jsonObj);
            if (!"0".equals(jsonObj.get("errcode").asText())) {
                throw new RuntimeException("\u53d1\u5e03\u83dc\u5355\u5931\u8d25\uff1a" + jsonObj.get("errmsg").asText());
            }
        }
    }

    @Override
    @Async(value="asyncExecutor")
    @AsyncThreadClean
    public void pullUser(String uniteId) throws Exception {
        SysExternalUnite entity = (SysExternalUnite)this.get((Serializable)((Object)uniteId));
        if (BeanUtils.isEmpty((Object)((Object)entity))) {
            throw new RuntimeException("\u67e5\u65e0\u6b64\u96c6\u6210\u4fe1\u606f");
        }
        if (ExterUniEnum.WeChatWork.getKey().equals(entity.getType())) {
            this.wxUserService.pullUser("1", null);
        } else if (ExterUniEnum.Dingtalk.getKey().equals(entity.getType())) {
            if (StringUtil.isEmpty((String)entity.getCorpId()) || StringUtil.isEmpty((String)entity.getCorpSecret())) {
                throw new RuntimeException("\u8bf7\u5148\u914d\u7f6e\u5e94\u7528\uff0c\u5e76\u4e14\u4fdd\u8bc1\u5e94\u7528\u6709\u6743\u9650\u8bbf\u95ee\u901a\u8baf\u5f55\u76f8\u5173\u6743\u9650\uff01");
            }
            this.dtUserService.pullOrgAndUser("1");
        }
    }

    @Override
    public void syncContacts(SysExternalUnite sysExternalUnite) throws Exception {
        if (sysExternalUnite == null || !sysExternalUnite.getSyncFlag().booleanValue()) {
            return;
        }
        if (StringUtil.isEmpty((String)sysExternalUnite.getCorpId()) || StringUtil.isEmpty((String)sysExternalUnite.getCorpSecret())) {
            throw new RuntimeException("\u8bf7\u5148\u914d\u7f6e\u5e94\u7528\uff0c\u5e76\u4e14\u4fdd\u8bc1\u5e94\u7528\u6709\u6743\u9650\u8bbf\u95ee\u901a\u8baf\u5f55\u76f8\u5173\u6743\u9650\uff01");
        }
        if (ExterUniEnum.WeChatWork.getKey().equals(sysExternalUnite.getType())) {
            if (Objects.equals(1, sysExternalUnite.getSyncDirection())) {
                this.wxUserService.pushData(sysExternalUnite);
            } else {
                this.wxUserService.pullData(sysExternalUnite);
            }
        } else if (ExterUniEnum.Dingtalk.getKey().equals(sysExternalUnite.getType())) {
            if (Objects.equals(1, sysExternalUnite.getSyncDirection())) {
                this.dtUserService.pushData(sysExternalUnite);
            } else {
                this.dtUserService.pullData(sysExternalUnite);
            }
        } else if (ExterUniEnum.FlyBook.getKey().equals(sysExternalUnite.getType())) {
            if (Objects.equals(1, sysExternalUnite.getSyncDirection())) {
                this.flybookUserService.pushData(sysExternalUnite);
            } else {
                this.flybookUserService.pullData(sysExternalUnite);
            }
        }
    }

    @Override
    public Map<String, Object> getScanAppList(String tenantId) {
        List externalUniteList = StringUtil.isEmpty((String)tenantId) ? this.getAll() : this.list((Wrapper)Wrappers.lambdaQuery().eq(SysExternalUnite::getTenantId, (Object)tenantId));
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (SysExternalUnite ite : externalUniteList) {
            HashMap<String, String> map;
            if (ExterUniEnum.WeChatWork.getKey().equals(ite.getType())) {
                map = new HashMap<String, String>(2);
                map.put("corpId", ite.getCorpId());
                map.put("agentId", ite.getAgentId());
                result.put(ExterUniEnum.WeChatWork.getKey(), map);
            }
            if (ExterUniEnum.Dingtalk.getKey().equals(ite.getType())) {
                map = new HashMap(1);
                map.put("corpId", ite.getCorpId());
                result.put(ExterUniEnum.Dingtalk.getKey(), map);
            }
            if (!ExterUniEnum.FlyBook.getKey().equals(ite.getType())) continue;
            map = new HashMap(1);
            map.put("corpId", ite.getCorpId());
            result.put(ExterUniEnum.FlyBook.getKey(), map);
        }
        return result;
    }

    @Override
    public List<WxOrg> getDepartmentTree(String type) throws Exception {
        if (ExterUniEnum.WeChatWork.getKey().equals(type)) {
            return this.wxOrgService.getDepartmentTree();
        }
        if (ExterUniEnum.Dingtalk.getKey().equals(type)) {
            return this.dingTalkOrgService.getDepartmentTree();
        }
        if (ExterUniEnum.FlyBook.getKey().equals(type)) {
            return this.flybookOrgService.getDepartmentTree();
        }
        return new ArrayList<WxOrg>();
    }

    @Override
    public void bingMobile(String uniteId) throws Exception {
        SysExternalUnite entity = (SysExternalUnite)this.get((Serializable)((Object)uniteId));
        if (BeanUtils.isEmpty((Object)((Object)entity))) {
            throw new BaseException("\u67e5\u65e0\u6b64\u96c6\u6210\u4fe1\u606f");
        }
        if (!ExterUniEnum.WeChatWork.getKey().equals(entity.getType())) {
            throw new BaseException("\u6682\u4e0d\u652f\u6301\u8be5\u529f\u80fd\uff01");
        }
        WxBindTypeEnum bindTypeEnum = StringUtil.isEmpty((String)entity.getBindType()) ? WxBindTypeEnum.MOBILE : WxBindTypeEnum.getByKey(entity.getBindType());
        ThreadMessageUtil.setBindType(entity.getBindType());
        this.wxUserService.bindMobile(bindTypeEnum);
    }

    @Override
    public String generateMenuUrl(String id, String corpId, String baseUrl, BaseUrlEnum baseUrlEnum) throws Exception {
        String currCorpId;
        SysExternalUnite sysExternalUnite = (SysExternalUnite)this.get((Serializable)((Object)id));
        if (StringUtil.isNotEmpty((String)baseUrl)) {
            sysExternalUnite.setBaseUrl(baseUrl);
        }
        String menuUrl = "-1";
        String type = sysExternalUnite.getType();
        String string = currCorpId = StringUtil.isEmpty((String)corpId) ? sysExternalUnite.getCorpId() : corpId;
        if (StringUtil.isEmpty((String)currCorpId)) {
            throw new BaseException("AgentId\u6216\u8005CorpId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ExterUniEnum.WeChatWork.getKey().equals(type)) {
            menuUrl = WeChatWorkConsts.generateMenuUrl(sysExternalUnite.getBaseUrl(), currCorpId, baseUrlEnum);
        } else if (ExterUniEnum.Dingtalk.getKey().equals(type)) {
            currCorpId = StringUtil.isEmpty((String)corpId) ? sysExternalUnite.getAgentKey() : corpId;
            menuUrl = DingTalkConsts.generateMenuUrl(sysExternalUnite.getBaseUrl(), currCorpId, baseUrlEnum);
        } else if (ExterUniEnum.WeChatOfficialAccounts.getKey().equals(type)) {
            menuUrl = WeChatOffAccConsts.generateMenuUrl(sysExternalUnite.getBaseUrl(), currCorpId, baseUrlEnum);
        } else if (ExterUniEnum.FlyBook.getKey().equals(type)) {
            menuUrl = FlyBookConsts.generateMenuUrl(sysExternalUnite.getBaseUrl(), currCorpId, baseUrlEnum);
        }
        return menuUrl;
    }

    @Override
    public void clearToken(String type) {
        boolean clearAll = BeanUtils.isEmpty((Object)type);
        if (ExterUniEnum.WeChatWork.getKey().equals(type) || clearAll) {
            WechatWorkTokenUtil.clearToken();
        }
        if (ExterUniEnum.Dingtalk.getKey().equals(type) || clearAll) {
            DingTalkTokenUtil.clearToken();
        }
        if (ExterUniEnum.WeChatOfficialAccounts.getKey().equals(type) || clearAll) {
            WechatOffAccTokenUtil.clearToken();
        }
    }
}

