/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.system.persistence.manager.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.system.consts.WeChatWorkConsts;
import com.hotent.system.enums.ExterUniEnum;
import com.hotent.system.model.WxOrg;
import com.hotent.system.persistence.manager.HtOrgService;
import com.hotent.system.persistence.manager.IWXOrgService;
import com.hotent.system.util.OrgConvertUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WxOrgService
implements IWXOrgService {
    protected Logger logger = LoggerFactory.getLogger(WxOrgService.class);
    @Resource
    UCFeignService orgManager;
    @Autowired
    private HtOrgService htOrgService;

    @Override
    public void create(ObjectNode org) {
        WxOrg wxorg = OrgConvertUtil.sysOrgToWxOrg((JsonNode)org);
        if (wxorg == null) {
            return;
        }
        wxorg.setId("");
        ObjectNode result = null;
        try {
            String resultJson = HttpUtil.sendHttpsRequest((String)WeChatWorkConsts.getCreateOrgUrl(), (String)wxorg.toStringIndent(), (String)"POST");
            result = (ObjectNode)JsonUtil.toJsonNode((String)resultJson);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        String errcode = result.get("errcode").asText();
        if ("0".equals(errcode)) {
            this.logger.info("\u4e0a\u4f20\u7ec4\u7ec7\u6570\u636e\u6210\u529f\uff01\uff08\u5fae\u4fe1\uff09");
            if (result.get("id") == null && result.get("id") == null) {
                this.logger.error("\u4e0a\u4f20\u7ec4\u7ec7\u4fe1\u606f\u65e0\u8fd4\u56de\u90e8\u95e8ID\u503c\uff01");
                return;
            }
            String deptId = result.get("id").asText();
            this.htOrgService.updateLocalDbExternal(org.get("id").asText(), deptId, ExterUniEnum.WeChatWork);
            return;
        }
        this.logger.debug(wxorg.toString());
        if ("60008".equals(errcode)) {
            return;
        }
        if ("60004".equals(errcode)) {
            return;
        }
        throw new RuntimeException(org.get("name").asText() + " \u6dfb\u52a0\u5fae\u4fe1\u901a\u8baf\u5f55\u7ec4\u7ec7\u5931\u8d25 \uff1a " + result.get("errmsg").asText());
    }

    @Override
    public void update(ObjectNode org) {
        WxOrg wxorg = OrgConvertUtil.sysOrgToWxOrg((JsonNode)org);
        ObjectNode result = null;
        try {
            String resultJson = HttpUtil.sendHttpsRequest((String)WeChatWorkConsts.getUpdateOrgUrl(), (String)wxorg.toString(), (String)"POST");
            result = (ObjectNode)JsonUtil.toJsonNode((String)resultJson);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        String errcode = result.get("errcode").asText();
        if ("0".equals(errcode)) {
            return;
        }
        throw new RuntimeException(org.get("name").asText() + "\u6dfb\u52a0\u5fae\u4fe1\u901a\u8baf\u5f55\u7ec4\u7ec7\u5931\u8d25 \uff1a " + result.get("errmsg").asText());
    }

    @Override
    public void delete(String orgId) {
        ObjectNode result = null;
        try {
            String url = WeChatWorkConsts.getDeleteOrgUrl() + orgId;
            String resultJson = HttpUtil.sendHttpsRequest((String)url, (String)"", (String)"POST");
            result = (ObjectNode)JsonUtil.toJsonNode((String)resultJson);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        if ("0".equals(result.get("errcode").asText())) {
            return;
        }
        if ("60003".equals(result.get("errcode").asText())) {
            this.logger.error(orgId + "\u5220\u9664\u5fae\u4fe1\u901a\u8baf\u5f55\u5931\u8d25 \uff1a " + result.get("errmsg").asText());
            return;
        }
        throw new RuntimeException(orgId + "\u5220\u9664\u5fae\u4fe1\u901a\u8baf\u5f55\u5931\u8d25 \uff1a " + result.get("errmsg").asText());
    }

    @Override
    public void deleteAll(String orgIds) {
        ObjectNode result = null;
        try {
            String delUrl = WeChatWorkConsts.getDeleteAllUserUrl();
            HashMap<String, String[]> users = new HashMap<String, String[]>();
            users.put("useridlist", orgIds.split(","));
            String resultJson = HttpUtil.sendHttpsRequest((String)delUrl, (String)JsonUtil.toJson(users), (String)"POST");
            result = (ObjectNode)JsonUtil.toJsonNode((String)resultJson);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        if ("0".equals(result.get("errcode").asText())) {
            return;
        }
        throw new RuntimeException("\u6279\u91cf\u5220\u9664\u5fae\u4fe1\u901a\u8baf\u5f55\u7528\u6237\u5931\u8d25 \uff1a " + result.get("errmsg").asText());
    }

    @Override
    public String getDepartmentUser(String orgCode) {
        ObjectNode departmentResult = null;
        try {
            String departmentUrl = WeChatWorkConsts.getDepartmentUrl(orgCode);
            String departmentJson = HttpUtil.sendHttpsRequest((String)departmentUrl, (String)"", (String)"GET");
            departmentResult = (ObjectNode)JsonUtil.toJsonNode((String)departmentJson);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        if ("0".equals(departmentResult.get("errcode").asText())) {
            ArrayNode users = departmentResult.putArray("userlist");
            Object[] userAccounts = new String[users.size()];
            for (int i = 0; i < users.size(); ++i) {
                ObjectNode user = null;
                try {
                    user = (ObjectNode)JsonUtil.toJsonNode((Object)i);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                userAccounts[i] = user.get("userid").asText();
            }
            return StringUtils.join((Object[])userAccounts, (String)",");
        }
        throw new RuntimeException("\u6279\u91cf\u5220\u9664\u5fae\u4fe1\u901a\u8baf\u5f55\u7528\u6237\u5931\u8d25 \uff1a " + departmentResult.get("errmsg").asText());
    }

    @Override
    public void addAll(List<ObjectNode> orgList, List<ObjectNode> orgUnitList) {
        for (ObjectNode org : orgList) {
            String parentOrgId = org.get("parentId").asText();
            String nodeParentId = this.htOrgService.getDeptIdByOrgId(parentOrgId, orgUnitList, ExterUniEnum.WeChatWork);
            if (StringUtil.isEmpty((String)nodeParentId)) {
                this.logger.info("\u5fae\u4fe1\u7ec4\u7ec7\u7236ID\u672a\u540c\u6b65\u6216\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u63a8\u9001\uff01");
                return;
            }
            try {
                org.set("parentId", JsonUtil.toJsonNode((String)nodeParentId));
            }
            catch (Exception e) {
                this.logger.error("\u8f6c\u6362\u5fae\u4fe1\u7ec4\u7ec7\u7236ID\u5931\u8d25\uff01", (Throwable)e);
            }
            this.create(org);
        }
    }

    @Override
    public List<String> syncAllOrg(String orgId, List<ObjectNode> orgUnitList) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(orgId);
        List orgs = this.orgManager.getOrgsByparentId(orgId);
        if (orgs.size() > 0) {
            this.addAll(orgs, orgUnitList);
            for (ObjectNode rootOrg : orgs) {
                String id = rootOrg.get("id").asText();
                result.addAll(this.syncOrgsByParentId(id, orgUnitList));
            }
        }
        return result;
    }

    public List<String> syncOrgsByParentId(String parentId, List<ObjectNode> orgUnitList) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(parentId);
        List orgs = this.orgManager.getChildOrg(parentId);
        if (BeanUtils.isNotEmpty((Object)orgs) && orgs.size() > 0) {
            this.addAll(orgs, orgUnitList);
            for (ObjectNode org : orgs) {
                String id = org.get("id").asText();
                result.addAll(this.syncOrgsByParentId(id, orgUnitList));
            }
        }
        return result;
    }

    @Override
    public List<WxOrg> getDepartmentTree() throws Exception {
        String rootDeptId = "1";
        return this.getDepartmentList(rootDeptId);
    }

    private List<WxOrg> getDepartmentList(String parentDeptId) throws Exception {
        String url = WeChatWorkConsts.getDepartmentListUrl(parentDeptId);
        String resultJson = HttpUtil.sendHttpsRequest((String)url, (String)"", (String)"GET");
        JsonNode result = JsonUtil.toJsonNode((String)resultJson);
        ArrayList<WxOrg> wxOrgList = new ArrayList<WxOrg>();
        String errcode = result.get("errcode").asText();
        if (!"0".equals(errcode)) {
            return wxOrgList;
        }
        JsonNode departmentList = result.get("department");
        ArrayList<WxOrg> orgList = new ArrayList<WxOrg>();
        for (JsonNode o : departmentList) {
            ObjectNode node = (ObjectNode)o;
            WxOrg org = new WxOrg();
            org.setId(node.get("id").asText());
            org.setName(node.get("name").asText());
            org.setParentid(node.get("parentid").asText());
            orgList.add(org);
        }
        return BeanUtils.listToTree(orgList);
    }
}

