/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.system.persistence.manager.impl;

import cn.hutool.core.collection.CollUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.service.PropertyService;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.system.consts.WeChatWorkConsts;
import com.hotent.system.enums.ExterUniEnum;
import com.hotent.system.enums.WxBindTypeEnum;
import com.hotent.system.model.SysExternalUnite;
import com.hotent.system.model.WxOrg;
import com.hotent.system.model.WxUser;
import com.hotent.system.model.WxUserV2;
import com.hotent.system.persistence.manager.HtOrgService;
import com.hotent.system.persistence.manager.IUserService;
import com.hotent.system.persistence.manager.IWXOrgService;
import com.hotent.system.util.OrgConvertUtil;
import com.hotent.system.util.ThreadMessageUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WxUserService
implements IUserService {
    protected Logger logger = LoggerFactory.getLogger(WxUserService.class);
    @Resource
    UCFeignService uCFeignService;
    @Resource
    IWXOrgService iwxOrgService;
    @Resource
    PropertyService propertyService;
    @Resource
    private HtOrgService htOrgService;

    @Override
    public void create(ObjectNode user) throws IOException {
        String fullname = user.get("fullname").asText();
        String department = this.htOrgService.getDeptIdByUserId(user.get("userId").asText(), ExterUniEnum.WeChatWork);
        if (department == null || BeanUtils.isEmpty((Object)department)) {
            user.put("department", "1");
        } else {
            user.put("department", department);
        }
        WxUserV2 wxUser = OrgConvertUtil.userToWxUserV2((JsonNode)user);
        if (BeanUtils.isEmpty((Object)wxUser.getDepartment())) {
            return;
        }
        String resultJson = HttpUtil.sendHttpsRequest((String)WeChatWorkConsts.getCreateUserUrl(), (String)wxUser.toString(), (String)"POST");
        JsonNode result = JsonUtil.toJsonNode((String)resultJson);
        String errcode = result.get("errcode").asText();
        if ("0".equals(errcode)) {
            ObjectNode userUnite = JsonUtil.getMapper().createObjectNode();
            userUnite.set("userId", user.get("userId"));
            userUnite.set("wxWorkId", user.get("account"));
            this.uCFeignService.updateUserUnite(userUnite);
            return;
        }
        if ("60102".equals(errcode)) {
            ObjectNode userUnite = JsonUtil.getMapper().createObjectNode();
            userUnite.set("userId", user.get("userId"));
            userUnite.set("wxWorkId", user.get("account"));
            this.uCFeignService.updateUserUnite(userUnite);
            return;
        }
        if ("60104".equals(errcode)) {
            ObjectNode userUnite = JsonUtil.getMapper().createObjectNode();
            userUnite.set("userId", user.get("userId"));
            String errmsg = result.get("errmsg").asText();
            String userid = errmsg.substring(errmsg.indexOf(":") + 1);
            userUnite.put("wxWorkId", userid);
            this.uCFeignService.updateUserUnite(userUnite);
            return;
        }
        String account = user.get("account").asText();
        ThreadMessageUtil.addMapMsg(fullname + "[" + account + "]", result.get("errmsg").asText());
    }

    @Override
    public void update(ObjectNode user) throws IOException {
        WxUser wxUser = OrgConvertUtil.userToWxUser((JsonNode)user);
        String url = WeChatWorkConsts.getUpdateUserUrl();
        String resultJson = HttpUtil.sendHttpsRequest((String)url, (String)wxUser.toString(), (String)"POST");
        JsonNode result = JsonUtil.toJsonNode((String)resultJson);
        if (!"0".equals(result.get("errcode").asText())) {
            throw new RuntimeException(wxUser.getName() + "\u66f4\u65b0\u5fae\u4fe1\u901a\u8baf\u5f55\u5931\u8d25 \uff1a " + result.get("errmsg").asText());
        }
    }

    @Override
    public void delete(String userId) throws IOException {
        String url = WeChatWorkConsts.getDeleteUserUrl() + userId;
        String resultJson = HttpUtil.sendHttpsRequest((String)url, (String)"", (String)"POST");
        JsonNode result = JsonUtil.toJsonNode((String)resultJson);
        if ("0".equals(result.get("errcode").asText())) {
            return;
        }
        throw new RuntimeException(userId + "\u5220\u9664\u5fae\u4fe1\u901a\u8baf\u5f55\u5931\u8d25 \uff1a " + result.get("errmsg").asText());
    }

    @Override
    public void deleteAll(String userIds) throws IOException {
    }

    @Override
    public void addAll(JsonNode users) throws IOException {
        for (JsonNode user : users) {
            ObjectNode node = (ObjectNode)user;
            String mobile = user.get("mobile").asText();
            if ("null".equals(mobile) || StringUtil.isEmpty((String)mobile)) continue;
            this.create(node);
        }
    }

    public boolean queryUser(ObjectNode user) throws IOException {
        String getUserUrl = WeChatWorkConsts.getUserUrl() + user.get("account").asText();
        String resultJsonUser = HttpUtil.sendHttpsRequest((String)getUserUrl, (String)"", (String)"POST");
        JsonNode userJson = JsonUtil.toJsonNode((String)resultJsonUser);
        return "0".equals(userJson.get("errcode").asText());
    }

    @Override
    public void syncUser(String[] lAryId) throws IOException {
        this.iwxOrgService.syncAllOrg("1", null);
        ArrayNode userList = (ArrayNode)this.uCFeignService.getUsersNotYetSyncWxWork(null, null);
        this.addAll((JsonNode)userList);
    }

    public void pullUser(String pOrgId, List<ObjectNode> orgUnitList) throws Exception {
        this.pullDepartment(pOrgId, "");
        this.pullUserByDepartmentId(pOrgId);
    }

    @Override
    public void pullData(SysExternalUnite sysExternalUnite) throws Exception {
        String deptParentApp = "1";
        if (Objects.equals(0, sysExternalUnite.getSyncScope())) {
            this.pullDepartment(deptParentApp, "");
            this.pullUserByDepartmentId(deptParentApp);
        } else if (Objects.equals(1, sysExternalUnite.getSyncScope())) {
            this.pullUserByDepartmentId(deptParentApp);
        } else if (Objects.equals(2, sysExternalUnite.getSyncScope())) {
            if (StringUtil.isEmpty((String)sysExternalUnite.getSyncOrgId())) {
                return;
            }
            String deptId = sysExternalUnite.getSyncOrgId();
            this.pullDataByDepartment(deptId);
        }
    }

    @Override
    public void pushData(SysExternalUnite sysExternalUnite) throws Exception {
        String orgParentId = "0";
        List orgUnitList = this.uCFeignService.getOrgUniteByType(ExterUniEnum.WeChatWork.getType());
        if (Objects.equals(0, sysExternalUnite.getSyncScope())) {
            List<String> orgIdList = this.iwxOrgService.syncAllOrg(orgParentId, orgUnitList);
            ArrayNode userList = (ArrayNode)this.uCFeignService.getUsersNotYetSyncWxWork(orgIdList, null);
            this.addAll((JsonNode)userList);
        } else if (Objects.equals(1, sysExternalUnite.getSyncScope())) {
            List<String> orgIdList = this.htOrgService.getAllOrgIds(orgParentId);
            ArrayNode userList = (ArrayNode)this.uCFeignService.getUsersNotYetSyncWxWork(orgIdList, null);
            this.addAll((JsonNode)userList);
        } else if (Objects.equals(2, sysExternalUnite.getSyncScope())) {
            if (StringUtil.isEmpty((String)sysExternalUnite.getSyncOrgId())) {
                return;
            }
            List<String> orgIdList = this.iwxOrgService.syncAllOrg(sysExternalUnite.getSyncOrgId(), orgUnitList);
            ArrayNode userList = (ArrayNode)this.uCFeignService.getUsersNotYetSyncWxWork(orgIdList, null);
            this.addAll((JsonNode)userList);
        }
    }

    private List<WxOrg> getDeptAllParent(String deptId) throws Exception {
        ArrayList<WxOrg> wxOrgList = new ArrayList<WxOrg>();
        String url = WeChatWorkConsts.getDepartmentDetailUrl(deptId);
        String resultJson = HttpUtil.sendHttpsRequest((String)url, (String)"", (String)"GET");
        JsonNode result = JsonUtil.toJsonNode((String)resultJson);
        String errcode = result.get("errcode").asText();
        if (!"0".equals(errcode) || result.get("department") == null) {
            return wxOrgList;
        }
        ObjectNode node = (ObjectNode)result.get("department");
        String parentDeptId = node.get("parentid").asText();
        WxOrg org = new WxOrg();
        org.setId(node.get("id").asText());
        org.setName(node.get("name").asText());
        org.setParentid(parentDeptId);
        Integer order = node.get("order").asInt();
        BigDecimal subtract = BigDecimal.valueOf(Integer.MAX_VALUE).subtract(BigDecimal.valueOf(order.intValue()));
        org.setOrder(subtract.intValue());
        org.setDeptId(node.get("id").asText());
        wxOrgList.add(org);
        if (!Objects.equals("1", parentDeptId)) {
            List<WxOrg> tempList = this.getDeptAllParent(parentDeptId);
            wxOrgList.addAll(tempList);
        }
        return wxOrgList;
    }

    private void pullDataByDepartment(String deptId) throws Exception {
        List<WxOrg> wxOrgList = this.getDeptAllParent(deptId);
        String parentId = "1";
        String parentPathName = "";
        this.pullDepartmentByParentId(parentId, parentPathName, wxOrgList);
        this.pullUserByDepartmentId(deptId);
    }

    private String pullDepartmentByParentId(String parentId, String parentPathName, List<WxOrg> wxOrgList) throws Exception {
        for (WxOrg wxOrg : wxOrgList) {
            String id = wxOrg.getId();
            String parentIdTemp = wxOrg.getParentid();
            if (!StringUtil.isNotEmpty((String)parentIdTemp) || !Objects.equals(parentId, parentIdTemp)) continue;
            parentPathName = this.addOrg(wxOrg, parentPathName);
            parentPathName = this.pullDepartmentByParentId(id, parentPathName, wxOrgList);
        }
        return parentPathName;
    }

    private void pullDepartment(String parentDeptId, String parentPathName) throws IOException {
        ArrayList<WxOrg> orgList;
        String url = WeChatWorkConsts.getDepartmentListUrl(parentDeptId);
        String resultJson = HttpUtil.sendHttpsRequest((String)url, (String)"", (String)"GET");
        JsonNode result = JsonUtil.toJsonNode((String)resultJson);
        String errcode = result.get("errcode").asText();
        if ("0".equals(errcode)) {
            JsonNode departmentList = result.get("department");
            orgList = new ArrayList<WxOrg>();
            for (JsonNode o : departmentList) {
                ObjectNode node = (ObjectNode)o;
                String deptId = node.get("id").asText();
                WxOrg org = new WxOrg();
                org.setId(deptId);
                org.setName(node.get("name").asText());
                org.setParentid(node.get("parentid").asText());
                Integer order = node.get("order").asInt();
                BigDecimal subtract = BigDecimal.valueOf(Integer.MAX_VALUE).subtract(BigDecimal.valueOf(order.intValue()));
                org.setOrder(subtract.intValue());
                org.setDeptId(deptId);
                orgList.add(org);
            }
        } else {
            throw new RuntimeException("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u901a\u8baf\u5f55\u7684\u7ec4\u7ec7\u67b6\u6784\u5931\u8d25\uff1a" + result.get("errmsg").asText());
        }
        List listToTree = BeanUtils.listToTree(orgList);
        this.addOrgList(listToTree, parentPathName);
    }

    public void addOrgList(List<WxOrg> list, String parentPathName) {
        for (WxOrg wxOrg : list) {
            parentPathName = this.addOrg(wxOrg, parentPathName);
            List children = wxOrg.getChildren();
            if (!BeanUtils.isNotEmpty((Object)children)) continue;
            this.addOrgList(children, parentPathName);
        }
    }

    public String addOrg(WxOrg wxOrg, String parentPathName) {
        if (Objects.equals("1", wxOrg.getId()) || Objects.equals("0", wxOrg.getId())) {
            return parentPathName;
        }
        ObjectNode exist = JsonUtil.getMapper().createObjectNode();
        exist.put("id", wxOrg.getId());
        exist.put("code", UUID.randomUUID().toString().replaceAll("-", ""));
        exist.put("name", wxOrg.getName());
        exist.put("parentId", wxOrg.getParentId());
        exist.put("orderNo", wxOrg.getOrder());
        exist.put("wxWorkId", wxOrg.getDeptId());
        String pathName = parentPathName + "/" + wxOrg.getName();
        exist.put("pathName", pathName);
        CommonResult orgRsl = this.uCFeignService.addOrgFromExterUni(exist);
        if (!orgRsl.getState().booleanValue()) {
            throw new RuntimeException("\u5199\u5165\u7ec4\u7ec7\u67b6\u6784\u5931\u8d25\uff1a" + orgRsl.getMessage());
        }
        return pathName;
    }

    private void pullUserByDepartmentId(String deptId) throws Exception {
        String url = WeChatWorkConsts.getUsersByDepartmentId(deptId, "5");
        String resultJson = HttpUtil.sendHttpsRequest((String)url, (String)"", (String)"GET");
        JsonNode result = JsonUtil.toJsonNode((String)resultJson);
        String errcode = result.get("errcode").asText();
        if ("0".equals(errcode)) {
            JsonNode userlist = result.get("userlist");
            if (userlist != null && !userlist.isEmpty()) {
                ArrayNode arrayNode = (ArrayNode)userlist;
                this.uCFeignService.batchUpdateUsersFromExterUni(ExterUniEnum.WeChatWork.getKey(), (JsonNode)arrayNode);
            }
        } else {
            throw new RuntimeException("\u5168\u91cf\u62c9\u53d6\u6210\u5458\u5931\u8d25\uff1a" + result.get("errmsg").asText());
        }
    }

    @Override
    public void bindMobile(WxBindTypeEnum bindTypeEnum) throws Exception {
        ArrayNode userList = (ArrayNode)this.uCFeignService.getUsersNotYetSyncWxWork(null, bindTypeEnum.getKey());
        if (bindTypeEnum == WxBindTypeEnum.ACCOUNT) {
            String eipAccount;
            String cursor = "";
            ArrayList<String> listAccountMatch = new ArrayList<String>();
            do {
                ArrayList<String> wxUserIdList = new ArrayList<String>();
                cursor = this.getUserIdList(cursor, wxUserIdList);
                if (!CollUtil.isNotEmpty(wxUserIdList)) continue;
                for (JsonNode user : userList) {
                    eipAccount = JsonUtil.getString((JsonNode)user, (String)"account", (String)"");
                    String userId = JsonUtil.getString((JsonNode)user, (String)"userId", (String)"");
                    if (!StringUtil.isNotEmpty((String)eipAccount) || !StringUtil.isNotEmpty((String)userId) || !wxUserIdList.contains(eipAccount)) continue;
                    listAccountMatch.add(eipAccount);
                    this.updateUserUnite(eipAccount, userId);
                }
            } while (StringUtil.isNotEmpty((String)cursor));
            String msg = "\u4f01\u4e1a\u5fae\u4fe1\u901a\u8baf\u5f55\u4e2d\u672a\u67e5\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\u8d26\u53f7";
            for (JsonNode user : userList) {
                eipAccount = JsonUtil.getString((JsonNode)user, (String)"account", (String)"");
                if (listAccountMatch.contains(eipAccount)) continue;
                ThreadMessageUtil.addMapMsg(eipAccount, msg);
            }
        } else {
            for (JsonNode user : userList) {
                String userIdWx;
                String mobile;
                if (user.get("mobile") == null || user.get("userId") == null || "null".equals(mobile = user.get("mobile").asText()) || StringUtil.isEmpty((String)mobile) || !StringUtil.isNotEmpty((String)(userIdWx = this.getUserIdByMobile(mobile)))) continue;
                ObjectNode userUnite = JsonUtil.getMapper().createObjectNode();
                userUnite.set("userId", user.get("userId"));
                userUnite.put("wxWorkId", userIdWx);
                this.uCFeignService.updateUserUnite(userUnite);
            }
        }
    }

    private void updateUserUnite(String userIdWx, String userIdEip) {
        if (StringUtil.isEmpty((String)userIdWx) || StringUtil.isEmpty((String)userIdEip)) {
            return;
        }
        ObjectNode userUnite = JsonUtil.getMapper().createObjectNode();
        userUnite.put("userId", userIdEip);
        userUnite.put("wxWorkId", userIdWx);
        this.uCFeignService.updateUserUnite(userUnite);
    }

    private String getUserIdByMobile(String mobile) throws IOException {
        String userId = "";
        if (StringUtil.isEmpty((String)mobile)) {
            return userId;
        }
        ObjectNode mobileNode = JsonUtil.getMapper().createObjectNode();
        mobileNode.put("mobile", mobile);
        String url = WeChatWorkConsts.getUserIdUrl();
        String resultJson = HttpUtil.sendHttpsRequest((String)url, (String)JsonUtil.toJson((Object)mobileNode), (String)"POST");
        JsonNode result = JsonUtil.toJsonNode((String)resultJson);
        if (result.get("errcode") != null && result.get("userid") != null && "0".equals(result.get("errcode").asText())) {
            userId = result.get("userid").asText();
        } else {
            this.logger.error(String.format("\u6839\u636e\u624b\u673a\u53f7[%s]\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u7528\u6237ID\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a%s", mobile, result.toString()));
            ThreadMessageUtil.addMapMsg(mobile, result.toString());
        }
        return userId;
    }

    private String getUserIdList(String cursor, List<String> userIdList) throws IOException {
        String url;
        String resultJson;
        JsonNode result;
        String resultCursor = "";
        ObjectNode node = JsonUtil.getMapper().createObjectNode();
        if (StringUtil.isNotEmpty((String)cursor)) {
            node.put("cursor", cursor);
        }
        if ((result = JsonUtil.toJsonNode((String)(resultJson = HttpUtil.sendHttpsRequest((String)(url = WeChatWorkConsts.getUserIdListUrl()), (String)JsonUtil.toJson((Object)node), (String)"POST")))).get("errcode") != null && result.get("dept_user") != null && "0".equals(result.get("errcode").asText())) {
            resultCursor = JsonUtil.getString((JsonNode)result, (String)"next_cursor", (String)"");
            JsonNode nodeDeptUserList = result.get("dept_user");
            for (JsonNode userNode : nodeDeptUserList) {
                if (!userNode.has("userid")) continue;
                String userId = userNode.get("userid").asText();
                userIdList.add(userId);
            }
        } else {
            this.logger.error(String.format("\u83b7\u53d6\u6210\u5458ID\u5217\u8868\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a%s", result.toString()));
            String errcode = JsonUtil.getString((JsonNode)result, (String)"errcode");
            if ("60020".equals(errcode)) {
                throw new BaseException(result.toString());
            }
        }
        return resultCursor;
    }
}

