/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.system.controller;

import cn.hutool.core.collection.CollUtil;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.exception.BaseException;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.StringUtil;
import com.hotent.system.enums.BaseUrlEnum;
import com.hotent.system.manager.PortalSysExternalAppManager;
import com.hotent.system.model.PortalSysExternalApp;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/portal/app/v1/"})
@Api(tags={"\u7b2c\u4e09\u65b9\u96c6\u6210\u5e94\u7528\u63a7\u5236\u5668"})
@ApiGroup(group={"group_portal"})
public class PortalSysExternalAppController
extends BaseController<PortalSysExternalAppManager, PortalSysExternalApp> {
    @GetMapping(value={"/getByUnitId"})
    @ApiOperation(value="\u6839\u636e\u5173\u8054\u7684\u5916\u90e8ID\u83b7\u53d6\u5e94\u7528\u914d\u7f6e\u8868\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u6839\u636e\u5173\u8054\u7684\u5916\u90e8ID\u83b7\u53d6\u5e94\u7528\u914d\u7f6e\u8868\u6570\u636e\u8be6\u60c5")
    public List<PortalSysExternalApp> getByUnitId(@ApiParam(name="unitId", value="\u5916\u90e8ID", required=true) @RequestParam(required=true) String unitId) throws Exception {
        return ((PortalSysExternalAppManager)this.baseService).getByUnitId(unitId);
    }

    @PostMapping(value={"/saveOrUpdate"})
    @ApiOperation(value="\u6279\u91cf\u4fdd\u5b58\u5e94\u7528\u5217\u8868", httpMethod="GET", notes="\u6279\u91cf\u4fdd\u5b58\u5e94\u7528\u5217\u8868")
    public CommonResult<Boolean> saveByUnitId(@ApiParam(name="appList", value="\u5e94\u7528\u5217\u8868", required=true) @RequestBody List<PortalSysExternalApp> appList) throws Exception {
        if (CollUtil.isEmpty(appList)) {
            throw new BaseException("\u5e94\u7528\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return CommonResult.ok().value((Object)((PortalSysExternalAppManager)this.baseService).saveOrUpdateBatch(appList));
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u5e94\u7528\u914d\u7f6e\u8868\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u5e94\u7528\u914d\u7f6e\u8868\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="PortalSysExternalApp", value="\u5e94\u7528\u914d\u7f6e\u8868\u5bf9\u8c61", required=true) @RequestBody PortalSysExternalApp portalSysExternalApp) throws Exception {
        String msg = StringUtil.isEmpty((String)portalSysExternalApp.getId()) ? "\u6dfb\u52a0\u5e94\u7528\u914d\u7f6e\u8868\u6210\u529f" : "\u66f4\u65b0\u5e94\u7528\u914d\u7f6e\u8868\u6210\u529f";
        ((PortalSysExternalAppManager)this.baseService).createOrUpdate(portalSysExternalApp);
        return CommonResult.ok().message(msg);
    }

    @RequestMapping(value={"generateMenuUrl"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u751f\u6210\u5e94\u7528\u83dc\u5355url", httpMethod="GET", notes="\u751f\u6210\u5e94\u7528\u83dc\u5355url")
    public CommonResult<String> generateMenuUrl(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id, @ApiParam(name="corpId", value="\u7b2c\u4e09\u65b9\u4f01\u4e1aID") @RequestParam(required=false) String corpId, @ApiParam(name="baseUrl", value="\u672c\u7cfb\u7edf\u5730\u5740") @RequestParam(required=false) String baseUrl, @ApiParam(name="baseUrlType", value="\u9996\u9875\u5730\u5740\u7c7b\u578b\uff0cmobile-\u79fb\u52a8\u7aef\u9996\u9875\uff1bpc-PC\u7aef\u9996\u9875") @RequestParam(required=false) String baseUrlType) throws Exception {
        if (StringUtil.isEmpty((String)baseUrlType)) {
            baseUrl = BaseUrlEnum.MOBILE.value();
        }
        String menuUrl = ((PortalSysExternalAppManager)this.baseService).generateMenuUrl(id, corpId, baseUrl, BaseUrlEnum.fromValue(baseUrlType));
        return new CommonResult(true, "", (Object)menuUrl);
    }
}

