/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.system.manager.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.util.JsonUtil;
import com.hotent.system.consts.FlyBookConsts;
import com.hotent.system.manager.FlyBookManager;
import com.hotent.system.util.FlybookTokenUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class FlyBookManagerImpl
implements FlyBookManager {
    @Autowired
    private RestTemplate restTemplate;

    private String getAccessToken(String code, String redirectUri) throws Exception {
        String url = FlyBookConsts.getTokenUrl();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap<String, String> formParams = this.getAccessTokenInput(FlyBookConsts.getUnite().getCorpId(), FlyBookConsts.getUnite().getCorpSecret(), code, redirectUri);
        HttpEntity httpEntity = new HttpEntity(formParams, (MultiValueMap)headers);
        String response = (String)this.restTemplate.postForObject(url, (Object)httpEntity, String.class, new Object[0]);
        ObjectNode jsonNode = (ObjectNode)JsonUtil.toJsonNode((String)response);
        return jsonNode.get("access_token").asText();
    }

    @Override
    public String getUserInfo(String code, String redirectUri) throws Exception {
        String accessToken = this.getAccessToken(code, redirectUri);
        String url = FlyBookConsts.getUserInfoUrl();
        HttpHeaders headers = new HttpHeaders();
        headers.setBearerAuth(accessToken);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, String.class, new Object[0]);
        if (!Objects.equals(responseEntity.getStatusCode(), HttpStatus.OK)) {
            throw new RuntimeException(String.format("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01%s", responseEntity.getBody()));
        }
        ObjectNode jsonNode = (ObjectNode)JsonUtil.toJsonNode((String)((String)responseEntity.getBody()));
        return jsonNode.get("user_id").asText();
    }

    @Override
    public String getAccessUserId(String code) throws Exception {
        String url = FlyBookConsts.getAuthAccessToken();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(FlybookTokenUtil.getToken());
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("grant_type", "authorization_code");
        map.put("code", code);
        HttpEntity httpEntity = new HttpEntity(map, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        if (!HttpStatus.OK.equals((Object)responseEntity.getStatusCode())) {
            throw new RuntimeException(String.format("\u98de\u4e66\u83b7\u53d6\u767b\u5f55\u7528\u6237\u8eab\u4efd\u5931\u8d25\uff01%s", responseEntity.getBody()));
        }
        ObjectNode jsonNode = (ObjectNode)JsonUtil.toJsonNode((String)((String)responseEntity.getBody()));
        if (jsonNode == null || !jsonNode.has("code") || jsonNode.get("code").asInt() != 0) {
            throw new RuntimeException("\u98de\u4e66\u8bbf\u95ee\u83b7\u53d6\u767b\u5f55\u7528\u6237\u8eab\u4efdAPI\u8fd4\u56de\u9519\u8bef\u4ee3\u7801\uff01");
        }
        JsonNode dataNode = jsonNode.get("data");
        if (dataNode == null || !dataNode.has("user_id")) {
            throw new RuntimeException("\u98de\u4e66\u8bbf\u95ee\u83b7\u53d6\u767b\u5f55\u7528\u6237\u8eab\u4efdAPI\u8fd4\u56de\u9519\u8bef\u6570\u636e\uff01");
        }
        return dataNode.get("user_id").asText();
    }

    private MultiValueMap<String, String> getAccessTokenInput(String clientId, String clientSecret, String code, String redirectUri) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.put((Object)"grant_type", Collections.singletonList("authorization_code"));
        map.put((Object)"client_id", Collections.singletonList(clientId));
        map.put((Object)"client_secret", Collections.singletonList(clientSecret));
        map.put((Object)"code", Collections.singletonList(code));
        map.put((Object)"redirect_uri", Collections.singletonList(redirectUri));
        return map;
    }
}

