/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.system.persistence.manager.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.util.StringUtil;
import com.hotent.system.enums.ExterUniEnum;
import com.hotent.system.model.WxOrg;
import com.hotent.system.persistence.manager.ContactHttpManager;
import com.hotent.system.persistence.manager.FlybookOrgService;
import com.hotent.system.persistence.manager.HtOrgService;
import com.hotent.system.util.ThreadMessageUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FlybookOrgServiceImpl
implements FlybookOrgService {
    protected Logger logger = LoggerFactory.getLogger(FlybookOrgServiceImpl.class);
    @Resource
    UCFeignService orgManager;
    @Resource
    private ContactHttpManager contactHttpManager;
    @Resource
    private HtOrgService htOrgService;

    @Override
    public void create(ObjectNode org) {
        this.create(org, "0");
    }

    private String create(ObjectNode org, String parentDeptId) {
        if (org == null) {
            return "";
        }
        parentDeptId = StringUtil.isEmpty((String)parentDeptId) ? "0" : parentDeptId;
        ObjectNode result = null;
        try {
            result = this.contactHttpManager.createDepartment(org.get("id").asText(), org.get("name").asText(), parentDeptId);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        if (result == null) {
            this.logger.error("\u4e0a\u4f20\u7ec4\u7ec7\u4fe1\u606f\u65e0\u8fd4\u56de\u503c\uff01");
            return "";
        }
        int errcode = result.get("code").asInt();
        if (errcode == 0 || errcode == 401 || errcode == 40018) {
            this.logger.info("\u4e0a\u4f20\u7ec4\u7ec7\u6570\u636e\u6210\u529f\uff01\uff08\u98de\u4e66\uff09");
            String deptId = result.get("department_id") != null ? result.get("department_id").asText() : org.get("id").asText();
            this.htOrgService.updateLocalDbExternal(org.get("id").asText(), deptId, ExterUniEnum.FlyBook);
            return deptId;
        }
        if (org.get("code") != null && org.get("name") != null) {
            ThreadMessageUtil.addMapMsg(org.get("code").asText() + "[" + org.get("name").asText() + "]", result.get("msg").asText());
        }
        return "";
    }

    @Override
    public void update(ObjectNode org) {
    }

    @Override
    public void delete(String orgId) {
    }

    @Override
    public void syncAllOrg() {
        String rootOrgId = "0";
        String rootDeptId = "0";
        List orgUnitList = this.orgManager.getOrgUniteByType(ExterUniEnum.FlyBook.getType());
        this.syncOrg(rootOrgId, rootDeptId, orgUnitList);
    }

    private void syncOrg(String parentOrgId, String parentDeptId, List<ObjectNode> orgUnitList) {
        List orgList = this.orgManager.getOrgsByparentId(parentOrgId);
        if (CollectionUtils.isEmpty((Collection)orgList)) {
            return;
        }
        for (ObjectNode node : orgList) {
            String id = node.get("id").asText();
            String nodeParentId = this.htOrgService.getDeptIdByOrgId(id, orgUnitList, ExterUniEnum.FlyBook);
            if (StringUtil.isEmpty((String)nodeParentId)) {
                nodeParentId = this.create(node, parentDeptId);
            }
            this.syncOrg(id, nodeParentId, orgUnitList);
        }
    }

    @Override
    public List<WxOrg> getDepartmentTree() throws Exception {
        String rootDeptId = "0";
        return this.getDepartmentList(rootDeptId);
    }

    private List<WxOrg> getDepartmentList(String rootDeptId) throws Exception {
        ArrayList<WxOrg> wxOrgList = new ArrayList<WxOrg>();
        ArrayNode arrayNode = this.contactHttpManager.getDepartmentChildren(rootDeptId, "");
        for (JsonNode node : arrayNode) {
            String subDeptId = node.get("id").asText();
            WxOrg wxOrg = new WxOrg();
            wxOrg.setId(node.get("id").asText());
            wxOrg.setName(node.get("name").asText());
            wxOrg.setParentid(node.get("parentId").asText());
            List<WxOrg> subNodeList = this.getDepartmentList(subDeptId);
            wxOrg.setChildren(CollectionUtils.isEmpty(subNodeList) ? null : subNodeList);
            wxOrgList.add(wxOrg);
        }
        return wxOrgList;
    }
}

