/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.system.persistence.manager.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.system.enums.ExterUniEnum;
import com.hotent.system.enums.WxBindTypeEnum;
import com.hotent.system.model.SysExternalUnite;
import com.hotent.system.persistence.manager.ContactHttpManager;
import com.hotent.system.persistence.manager.FlybookOrgService;
import com.hotent.system.persistence.manager.HtOrgService;
import com.hotent.system.persistence.manager.IUserService;
import com.hotent.system.util.ThreadMessageUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlybookUserService
implements IUserService {
    protected Logger logger = LoggerFactory.getLogger(FlybookUserService.class);
    @Resource
    UCFeignService ucFeignService;
    @Autowired
    private FlybookOrgService flybookOrgService;
    @Resource
    private HtOrgService htOrgService;
    @Resource
    private ContactHttpManager contactHttpManager;

    @Override
    public void create(ObjectNode user) throws IOException {
        ObjectNode result;
        String fullname = user.get("fullname").asText();
        String departments = this.htOrgService.getDeptIdByUserId(user.get("userId").asText(), ExterUniEnum.FlyBook);
        departments = StringUtil.isEmpty((String)departments) ? "0" : departments;
        String[] deptList = departments.split(",");
        for (int i = 0; i < deptList.length; ++i) {
            String deptId = deptList[i];
            deptList[i] = "1".equals(deptId) ? "0" : deptId;
        }
        try {
            result = this.contactHttpManager.createUser(user.get("account").asText(), fullname, user.get("mobile").asText(), Arrays.asList(deptList));
        }
        catch (Exception e) {
            this.logger.error("\u540c\u6b65\u98de\u4e66\u7528\u6237\u6570\u636e\u5f02\u5e38\uff01", (Throwable)e);
            throw new RuntimeException("\u540c\u6b65\u98de\u4e66\u7528\u6237\u6570\u636e\u5f02\u5e38\uff01");
        }
        if (result == null) {
            this.logger.error("\u4e0a\u4f20\u7528\u6237\u4fe1\u606f\u65e0\u8fd4\u56de\u503c\uff01");
            return;
        }
        int errcode = result.get("code").asInt();
        if (errcode == 0 || errcode == 409 || errcode == 41001 || errcode == 400) {
            ObjectNode userUnite = JsonUtil.getMapper().createObjectNode();
            userUnite.set("userId", user.get("userId"));
            userUnite.set("flybookId", user.get("account"));
            this.ucFeignService.updateUserUnite(userUnite);
            return;
        }
        String account = user.get("account").asText();
        ThreadMessageUtil.addMapMsg(fullname + "[" + account + "]", result.get("msg").asText());
    }

    @Override
    public void update(ObjectNode user) throws IOException {
    }

    @Override
    public void delete(String userId) {
    }

    @Override
    public void deleteAll(String userIds) {
    }

    @Override
    public void addAll(JsonNode users) throws IOException {
        for (JsonNode user : users) {
            ObjectNode node = (ObjectNode)user;
            String mobile = user.get("mobile").asText();
            if ("null".equals(mobile) || StringUtil.isEmpty((String)mobile)) continue;
            this.create(node);
        }
    }

    @Override
    public void syncUser(String[] lAryId) throws IOException {
    }

    @Override
    public void pullData(SysExternalUnite sysExternalUnite) throws Exception {
        String deptParentApp = "0";
        if (Objects.equals(0, sysExternalUnite.getSyncScope())) {
            this.pullDepartmentAndUser(deptParentApp, "", false);
        } else if (Objects.equals(1, sysExternalUnite.getSyncScope())) {
            this.pullDepartmentAndUser(deptParentApp, "", true);
        } else if (Objects.equals(2, sysExternalUnite.getSyncScope())) {
            if (StringUtil.isEmpty((String)sysExternalUnite.getSyncOrgId())) {
                return;
            }
            this.pullByDepartment(sysExternalUnite.getSyncOrgId());
        }
    }

    @Override
    public void pushData(SysExternalUnite sysExternalUnite) throws Exception {
        if (Objects.equals(0, sysExternalUnite.getSyncScope())) {
            this.flybookOrgService.syncAllOrg();
            ArrayNode userList = this.ucFeignService.getUsersNotYetSyncFlybook(null);
            this.addAll((JsonNode)userList);
        } else if (Objects.equals(1, sysExternalUnite.getSyncScope())) {
            ArrayNode userList = this.ucFeignService.getUsersNotYetSyncDingtalk(null);
            this.addAll((JsonNode)userList);
        } else if (Objects.equals(2, sysExternalUnite.getSyncScope())) {
            if (StringUtil.isEmpty((String)sysExternalUnite.getSyncOrgId())) {
                return;
            }
            this.flybookOrgService.syncAllOrg();
            ArrayNode userList = this.ucFeignService.getUsersNotYetSyncFlybook(Collections.singletonList(sysExternalUnite.getSyncOrgId()));
            this.addAll((JsonNode)userList);
        }
    }

    private void pullByDepartment(String deptId) throws Exception {
        ArrayNode arrayNode = this.contactHttpManager.getDepartmentParent(deptId);
        String parentId = "0";
        String parentPathName = "";
        parentPathName = this.pullDepartmentByParentId(parentId, parentPathName, arrayNode);
        parentPathName = this.pullCurrentDeptAndUser(deptId, parentPathName);
        this.pullDepartmentAndUser(deptId, parentPathName, false);
    }

    private String pullDepartmentByParentId(String parentId, String parentPathName, ArrayNode arrayNode) throws Exception {
        for (JsonNode node : arrayNode) {
            String id = node.get("id").asText();
            String parentIdTemp = node.get("parentId").asText();
            if (!StringUtil.isNotEmpty((String)parentIdTemp) || !Objects.equals(parentId, parentIdTemp)) continue;
            ObjectNode objectNode = (ObjectNode)node;
            parentPathName = parentPathName + "/" + node.get("name").asText();
            objectNode.set("pathName", JsonUtil.toJsonNode((String)JsonUtil.toJson((Object)parentPathName)));
            CommonResult orgRsl = this.ucFeignService.addOrgFromExterUni(objectNode);
            if (!orgRsl.getState().booleanValue()) {
                throw new RuntimeException("\u5199\u5165\u7ec4\u7ec7\u67b6\u6784\u5931\u8d25\uff1a" + orgRsl.getMessage());
            }
            parentPathName = this.pullDepartmentByParentId(id, parentPathName, arrayNode);
        }
        return parentPathName;
    }

    private String pullCurrentDeptAndUser(String deptId, String parentPathName) throws Exception {
        ArrayNode arrayNodeUser;
        if (!Objects.equals("0", deptId)) {
            ObjectNode node = this.contactHttpManager.getDepartment(deptId);
            parentPathName = parentPathName + "/" + node.get("name").asText();
            node.set("pathName", JsonUtil.toJsonNode((String)JsonUtil.toJson((Object)parentPathName)));
            CommonResult orgRsl = this.ucFeignService.addOrgFromExterUni(node);
            if (!orgRsl.getState().booleanValue()) {
                throw new RuntimeException("\u5199\u5165\u7ec4\u7ec7\u67b6\u6784\u5931\u8d25\uff1a" + orgRsl.getMessage());
            }
        }
        if ((arrayNodeUser = this.contactHttpManager.getUserListByDeptId(deptId)) != null && arrayNodeUser.size() > 0) {
            this.ucFeignService.batchUpdateUsersFromExterUni(ExterUniEnum.FlyBook.getKey(), (JsonNode)arrayNodeUser);
        }
        return parentPathName;
    }

    private void pullDepartmentAndUser(String parentDeptId, String parentPathName, boolean onlyUser) throws Exception {
        ArrayNode arrayNodeUser;
        if (Objects.equals("0", parentDeptId) && (arrayNodeUser = this.contactHttpManager.getUserListByDeptId(parentDeptId)) != null && arrayNodeUser.size() > 0) {
            this.ucFeignService.batchUpdateUsersFromExterUni(ExterUniEnum.FlyBook.getKey(), (JsonNode)arrayNodeUser);
        }
        ArrayNode arrayNode = this.contactHttpManager.getDepartmentChildren(parentDeptId, parentPathName);
        for (JsonNode node : arrayNode) {
            CommonResult orgRsl;
            String deptId = node.get("id").asText();
            String pathName = node.get("pathName").asText();
            if (!onlyUser && !(orgRsl = this.ucFeignService.addOrgFromExterUni((ObjectNode)node)).getState().booleanValue()) {
                throw new RuntimeException("\u5199\u5165\u7ec4\u7ec7\u67b6\u6784\u5931\u8d25\uff1a" + orgRsl.getMessage());
            }
            ArrayNode arrayNodeUser2 = this.contactHttpManager.getUserListByDeptId(deptId);
            if (arrayNodeUser2 != null && arrayNodeUser2.size() > 0) {
                this.ucFeignService.batchUpdateUsersFromExterUni(ExterUniEnum.FlyBook.getKey(), (JsonNode)arrayNodeUser2);
            }
            this.pullDepartmentAndUser(deptId, pathName, onlyUser);
        }
    }

    @Override
    public void bindMobile(WxBindTypeEnum bindTypeEnum) throws Exception {
    }
}

