/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.system.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.util.StringUtil;
import com.hotent.system.model.WxOrg;
import com.hotent.system.model.WxUser;
import com.hotent.system.model.WxUserV2;
import java.math.BigDecimal;
import java.util.Objects;

public class OrgConvertUtil {
    public static WxUser userToWxUser(JsonNode user) {
        WxUser wxUser = new WxUser();
        String mobile = user.get("mobile").asText();
        String fullname = user.get("fullname").asText();
        String account = user.get("account").asText();
        String deptStr = user.get("department") == null || StringUtil.isEmpty((String)user.get("department").asText()) ? "1" : user.get("department").asText();
        String[] department = deptStr.split(",");
        wxUser.setDepartment(department);
        wxUser.setMobile(mobile);
        wxUser.setName(fullname);
        wxUser.setUserid(account);
        return wxUser;
    }

    public static WxUserV2 userToWxUserV2(JsonNode user) {
        WxUserV2 wxUser = new WxUserV2();
        String mobile = user.get("mobile").asText();
        String fullname = user.get("fullname").asText();
        String account = user.get("account").asText();
        String deptStr = user.get("department") == null || StringUtil.isEmpty((String)user.get("department").asText()) ? "1" : user.get("department").asText();
        Integer[] arrDepartment = null;
        if (StringUtil.isNotEmpty((String)deptStr)) {
            String[] department = deptStr.split(",");
            arrDepartment = new Integer[department.length];
            for (int i = 0; i < department.length; ++i) {
                arrDepartment[i] = Integer.parseInt(department[i]);
            }
        }
        wxUser.setDepartment(arrDepartment);
        wxUser.setMobile(mobile);
        wxUser.setName(fullname);
        wxUser.setUserid(account);
        return wxUser;
    }

    public static WxOrg sysOrgToWxOrg(JsonNode org) {
        WxOrg wxorg = new WxOrg();
        wxorg.setId(OrgConvertUtil.rootOrgId2DeptId(org.get("id").asText()));
        wxorg.setParentid(OrgConvertUtil.rootOrgId2DeptId(org.get("parentId").asText()));
        wxorg.setName(org.get("name").asText());
        if (org.get("orderNo") != null) {
            wxorg.setOrder(BigDecimal.valueOf(Integer.MAX_VALUE).subtract(BigDecimal.valueOf(org.get("orderNo").asInt())).intValue());
        }
        return wxorg;
    }

    public static String rootOrgId2DeptId(String orgId) {
        return Objects.equals("0", orgId) ? "1" : orgId;
    }

    public static String rootDeptId2OrgId(String deptId) {
        return Objects.equals("1", deptId) ? "0" : deptId;
    }
}

