/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.system.util;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ContextThread;
import com.hotent.base.util.StringUtil;
import com.hotent.system.enums.WxBindTypeEnum;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class ThreadMessageUtil
implements ContextThread {
    private static ThreadLocal<Map<String, String>> localMapMsg = new ThreadLocal();
    private static ThreadLocal<String> localBindType = new ThreadLocal();

    public static void setBindType(String bindType) {
        localBindType.set(bindType);
    }

    public static String getBindType() {
        String result = localBindType.get();
        return StringUtil.isEmpty((String)result) ? WxBindTypeEnum.MOBILE.getKey() : result;
    }

    public static void addMapMsg(String key, String msg) {
        Map<String, String> map = localMapMsg.get();
        if (BeanUtils.isEmpty(map)) {
            map = new HashMap<String, String>();
        }
        map.put(key, msg);
        localMapMsg.set(map);
    }

    public static String getMapMsg(String key) {
        Map<String, String> map = localMapMsg.get();
        if (BeanUtils.isEmpty(map)) {
            return null;
        }
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return null;
    }

    public static Map<String, String> getMapMsg(boolean clean) {
        Map<String, String> map = localMapMsg.get();
        if (clean) {
            localMapMsg.remove();
        }
        return map;
    }

    public static String getMapMsg(String key, boolean clean) {
        Map<String, String> map = localMapMsg.get();
        if (BeanUtils.isEmpty(map)) {
            return null;
        }
        if (map.containsKey(key)) {
            String msg = map.get(key);
            if (clean) {
                map.remove(key);
            }
            return msg;
        }
        return null;
    }

    public static void cleanMapMsg() {
        localMapMsg.remove();
        localBindType.remove();
    }

    public void cleanAll() {
        ThreadMessageUtil.cleanMapMsg();
    }
}

