/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.system.consts;

import com.hotent.base.util.AppUtil;
import com.hotent.system.enums.BaseUrlEnum;
import com.hotent.system.model.SysExternalUnite;
import com.hotent.system.persistence.manager.SysExternalUniteManager;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class FlyBookConsts {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    private static final String OAUTH_URL = "https://passport.feishu.cn/suite/passport/oauth";
    private static final String OPEN_APIS_AUTH_URL = "https://open.feishu.cn/open-apis/auth/v3";
    private static final String OPEN_APIS_CONTACT_URL = "https://open.feishu.cn/open-apis/contact/v3";
    private static final String OPEN_APIS_MESSAGE_URL = "https://open.feishu.cn/open-apis/message/v4";
    private static final String OPEN_AUTH_URL = "https://open.feishu.cn/open-apis/authen/v1";

    public static SysExternalUnite getUnite() {
        SysExternalUniteManager manager = (SysExternalUniteManager)AppUtil.getBean(SysExternalUniteManager.class);
        return manager.getFlyBook();
    }

    public static String getTokenUrl() {
        return String.format("%s/token", OAUTH_URL);
    }

    public static String getUserInfoUrl() {
        return String.format("%s/userinfo", OAUTH_URL);
    }

    public static String getTenantTokenUrl() {
        return String.format("%s/tenant_access_token/internal", OPEN_APIS_AUTH_URL);
    }

    public static String getDepartmentChildrenUrl(String departmentId) {
        return String.format("%s/departments/%s/children?user_id_type=user_id&department_id_type=department_id&page_size=50", OPEN_APIS_CONTACT_URL, departmentId);
    }

    public static String getDepartmentParentUrl(String departmentId) {
        return String.format("%s/departments/parent?department_id=%s&user_id_type=user_id&department_id_type=department_id&page_size=50", OPEN_APIS_CONTACT_URL, departmentId);
    }

    public static String getDepartmentUrl(String departmentId) {
        return String.format("%s/departments/%s?user_id_type=user_id&department_id_type=department_id", OPEN_APIS_CONTACT_URL, departmentId);
    }

    public static String getUserListByDeptIdUrl(String departmentId) {
        return String.format("%s/users/find_by_department?department_id=%s&user_id_type=user_id&department_id_type=department_id&page_size=50", OPEN_APIS_CONTACT_URL, departmentId);
    }

    public static String createDeptUrl() {
        return String.format("%s/departments?user_id_type=user_id&department_id_type=department_id", OPEN_APIS_CONTACT_URL);
    }

    public static String createUserUrl() {
        return String.format("%s/users?user_id_type=user_id&department_id_type=department_id", OPEN_APIS_CONTACT_URL);
    }

    public static String batchSendCardUrl() {
        return String.format("%s/batch_send", OPEN_APIS_MESSAGE_URL);
    }

    public static String generateMenuUrl(String baseUrl, String corpId, BaseUrlEnum baseUrlEnum) throws UnsupportedEncodingException {
        String path;
        String string = path = BaseUrlEnum.PC.equals((Object)baseUrlEnum) ? "index" : "home";
        if (!baseUrl.endsWith("/")) {
            path = "/" + path;
        }
        String redirectUri = baseUrl + "/flyBook?redirect=" + baseUrl + path;
        return "https://open.feishu.cn/open-apis/authen/v1/index?redirect_uri=" + URLEncoder.encode(redirectUri, "UTF-8") + "&app_id=" + corpId + "&state=hotent";
    }

    public static String getAuthorize(String paramStr) throws UnsupportedEncodingException {
        SysExternalUnite unite = FlyBookConsts.getUnite();
        String corpId = unite.getCorpId();
        String redirectUri = unite.getBaseUrl() + "/flyBook?params=" + paramStr;
        return "https://open.feishu.cn/open-apis/authen/v1/index?redirect_uri=" + URLEncoder.encode(redirectUri, "UTF-8") + "&app_id=" + corpId + "&state=hotent";
    }

    public static String getAuthAccessToken() {
        return String.format("%s/access_token", OPEN_AUTH_URL);
    }
}

