/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.system.consts;

import com.hotent.base.util.AppUtil;
import com.hotent.system.enums.BaseUrlEnum;
import com.hotent.system.model.SysExternalUnite;
import com.hotent.system.persistence.manager.SysExternalUniteManager;
import com.hotent.system.util.WechatWorkTokenUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class WeChatWorkConsts {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    private static final String QIYE_URL = "https://qyapi.weixin.qq.com/cgi-bin";
    private static final String OPEN_AUTHORIZE_URL = "https://open.weixin.qq.com/connect/oauth2/authorize";

    public static SysExternalUnite getUnite() {
        SysExternalUniteManager manager = (SysExternalUniteManager)AppUtil.getBean(SysExternalUniteManager.class);
        return manager.getWechatWork();
    }

    public static String getTokenUrl() {
        SysExternalUnite unite = WeChatWorkConsts.getUnite();
        return "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=" + (unite == null ? "" : unite.getCorpId()) + "&corpsecret=" + (unite == null ? "" : unite.getCorpSecret());
    }

    public static String getAgentToKenUrl() {
        SysExternalUnite unite = WeChatWorkConsts.getUnite();
        return "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=" + (unite == null ? "" : unite.getCorpId()) + "&corpsecret=" + (unite == null ? "" : unite.getAgentSecret());
    }

    public static String generateMenuUrl(String baseUrl, String corpId, BaseUrlEnum baseUrlEnum) throws UnsupportedEncodingException {
        String path;
        String string = path = BaseUrlEnum.PC.equals((Object)baseUrlEnum) ? "index" : "home";
        if (!baseUrl.endsWith("/")) {
            path = "/" + path;
        }
        String redirectUri = baseUrl + "/weChat?redirect=" + baseUrl + path;
        return "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + corpId + "&redirect_uri=" + URLEncoder.encode(redirectUri, "UTF-8") + "&response_type=code&scope=snsapi_base&state=#wechat_redirect";
    }

    public static String getQyWxUserInfo(String code) throws IOException {
        String accessToken = WechatWorkTokenUtil.getAgentToken();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/getuserinfo?access_token=" + accessToken + "&code=" + code;
        return url;
    }

    public static String getUserUrl() throws IOException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=" + WechatWorkTokenUtil.getToken() + "&userid=";
        return url;
    }

    public static String getDeleteUserUrl() throws IOException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/delete?access_token=" + WechatWorkTokenUtil.getToken() + "&userid=";
        return url;
    }

    public static String getCreateUserUrl() throws IOException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/create?access_token=" + WechatWorkTokenUtil.getToken();
        return url;
    }

    public static String getUpdateUserUrl() throws IOException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/update?access_token=" + WechatWorkTokenUtil.getToken();
        return url;
    }

    public static String getDeleteAllUserUrl() throws IOException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/batchdelete?access_token=" + WechatWorkTokenUtil.getToken();
        return url;
    }

    public static String getInviteUserUrl() throws IOException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/invite/send?access_token=" + WechatWorkTokenUtil.getToken();
        return url;
    }

    public static String getCreateAgentMenuUrl(String agentId) throws IOException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/menu/create?access_token=" + WechatWorkTokenUtil.getAgentToken() + "&agentid=" + agentId;
        return url;
    }

    public static String getCreateOrgUrl() throws IOException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/create?access_token=" + WechatWorkTokenUtil.getToken();
        return url;
    }

    public static String getUpdateOrgUrl() throws IOException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/update?access_token=" + WechatWorkTokenUtil.getToken();
        return url;
    }

    public static String getDeleteOrgUrl() throws IOException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/delete?access_token=" + WechatWorkTokenUtil.getToken() + "&id=";
        return url;
    }

    public static String getDepartmentUrl(String department_id) throws IOException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/simplelist?access_token=" + WechatWorkTokenUtil.getToken() + "&department_id=" + department_id;
        return url;
    }

    public static String getSendMsgUrl() throws IOException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=" + WechatWorkTokenUtil.getAgentToken();
        return url;
    }

    public static String getScheduleMsgUrl() throws IOException {
        return "https://qyapi.weixin.qq.com/cgi-bin/oa/schedule/add?access_token=" + WechatWorkTokenUtil.getAgentToken();
    }

    public static String getDepartmentListUrl(String department_id) throws IOException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/list?access_token=" + WechatWorkTokenUtil.getToken() + "&id=" + department_id;
        return url;
    }

    public static String getUsersByDepartmentId(String department_id, String fetch_child) throws IOException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/list?access_token=" + WechatWorkTokenUtil.getToken() + "&department_id=" + department_id + "&fetch_child=" + fetch_child;
        return url;
    }

    public static String getDepartmentDetailUrl(String departmentId) throws IOException {
        return "https://qyapi.weixin.qq.com/cgi-bin/department/get?access_token=" + WechatWorkTokenUtil.getToken() + "&id=" + departmentId;
    }

    public static String getWxAuthorize(String paramStr) throws UnsupportedEncodingException {
        SysExternalUnite unite = WeChatWorkConsts.getUnite();
        String corpId = unite.getCorpId();
        String agentid = unite.getAgentId();
        String baseUrl = unite.getBaseUrl() + "/weChat?params=" + paramStr;
        String redirect = URLEncoder.encode(baseUrl, "utf-8");
        String url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + corpId + "&redirect_uri=" + redirect + "&agentid=" + agentid + "&response_type=code&scope=snsapi_base#wechat_redirect";
        return url;
    }

    public static String getUserIdUrl() throws IOException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/getuserid?access_token=" + WechatWorkTokenUtil.getToken();
        return url;
    }

    public static String getUserIdListUrl() throws IOException {
        return "https://qyapi.weixin.qq.com/cgi-bin/user/list_id?access_token=" + WechatWorkTokenUtil.getToken();
    }
}

