/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.system.controller;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiSnsGetuserinfoBycodeRequest;
import com.dingtalk.api.request.OapiUserGetbyunionidRequest;
import com.dingtalk.api.response.OapiSnsGetuserinfoBycodeResponse;
import com.dingtalk.api.response.OapiUserGetbyunionidResponse;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.system.consts.DingTalkConsts;
import com.hotent.system.consts.WeChatOffAccConsts;
import com.hotent.system.consts.WeChatWorkConsts;
import com.hotent.system.enums.BaseUrlEnum;
import com.hotent.system.enums.ExterUniEnum;
import com.hotent.system.enums.WxBindTypeEnum;
import com.hotent.system.manager.FlyBookManager;
import com.hotent.system.model.SysExternalUnite;
import com.hotent.system.model.WxOrg;
import com.hotent.system.persistence.manager.SysExternalUniteManager;
import com.hotent.system.util.DingTalkTokenUtil;
import com.hotent.system.util.ThreadMessageUtil;
import com.hotent.system.util.WechatWorkTokenUtil;
import com.taobao.api.TaobaoRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import poi.util.ExcelUtil;

@RestController
@RequestMapping(value={"/portal/sysExternalUnite/v1"})
@Api(tags={"\u7b2c\u4e09\u65b9\u96c6\u6210"})
@ApiGroup(group={"group_portal"})
public class SysExternalUniteController
extends BaseController<SysExternalUniteManager, SysExternalUnite> {
    @Resource
    SysExternalUniteManager sysExternalUniteManager;
    @Autowired
    private FlyBookManager flyBookManager;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7b2c\u4e09\u65b9\u7cfb\u7edf\u96c6\u6210\u5217\u8868", httpMethod="POST", notes="\u7b2c\u4e09\u65b9\u7cfb\u7edf\u96c6\u6210\u5217\u8868")
    public PageList<SysExternalUnite> list(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysExternalUnite> queryFilter) {
        return this.sysExternalUniteManager.query(queryFilter);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u5f97\u96c6\u6210\u5bf9\u8c61", httpMethod="GET", notes="\u83b7\u5f97\u96c6\u6210\u5bf9\u8c61")
    public SysExternalUnite getJson(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id) throws Exception {
        if (StringUtil.isEmpty((String)id)) {
            return new SysExternalUnite();
        }
        SysExternalUnite sysExternalUnite = (SysExternalUnite)this.sysExternalUniteManager.get((Serializable)((Object)id));
        return sysExternalUnite;
    }

    @RequestMapping(value={"generateMenuUrl"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u751f\u6210\u5e94\u7528\u83dc\u5355url", httpMethod="GET", notes="\u751f\u6210\u5e94\u7528\u83dc\u5355url")
    public CommonResult<String> generateMenuUrl(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id, @ApiParam(name="corpId", value="\u7b2c\u4e09\u65b9\u4f01\u4e1aID") @RequestParam(required=false) String corpId, @ApiParam(name="baseUrl", value="\u672c\u7cfb\u7edf\u5730\u5740") @RequestParam(required=false) String baseUrl, @ApiParam(name="baseUrlType", value="\u9996\u9875\u5730\u5740\u7c7b\u578b\uff0cmobile-\u79fb\u52a8\u7aef\u9996\u9875\uff1bpc-PC\u7aef\u9996\u9875") @RequestParam(required=false) String baseUrlType) throws Exception {
        if (StringUtil.isEmpty((String)baseUrlType)) {
            baseUrl = BaseUrlEnum.MOBILE.value();
        }
        String menuUrl = this.sysExternalUniteManager.generateMenuUrl(id, corpId, baseUrl, BaseUrlEnum.fromValue(baseUrlType));
        return new CommonResult(true, "", (Object)menuUrl);
    }

    @PostMapping(value={"save"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u7cfb\u7edf\u7b2c\u4e09\u65b9\u96c6\u6210\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u7cfb\u7edf\u7b2c\u4e09\u65b9\u96c6\u6210\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="sysExternalUnite", value="\u7b2c\u4e09\u65b9\u96c6\u6210\u4fe1\u606f") @RequestBody SysExternalUnite sysExternalUnite) throws Exception {
        CommonResult resultMsg;
        String id = sysExternalUnite.getId();
        try {
            boolean isTypeExists = this.sysExternalUniteManager.isTypeExists(sysExternalUnite.getType(), sysExternalUnite.getId());
            if (isTypeExists) {
                for (ExterUniEnum en : ExterUniEnum.values()) {
                    if (!en.getKey().equals(sysExternalUnite.getType())) continue;
                    return new CommonResult(false, "\u3010" + en.getLabel() + "\u3011\u5df2\u96c6\u6210,\u65e0\u9700\u91cd\u590d\u6dfb\u52a0\uff01");
                }
            }
            if (StringUtil.isEmpty((String)id)) {
                sysExternalUnite.setId(UniqueIdUtil.getSuid());
                sysExternalUnite.setCorpName(ExterUniEnum.getLabelByKey(sysExternalUnite.getType()));
                this.sysExternalUniteManager.create((Model)sysExternalUnite);
                resultMsg = new CommonResult(true, "\u6dfb\u52a0\u6210\u529f");
            } else {
                this.sysExternalUniteManager.update((Model)sysExternalUnite);
                ((SysExternalUniteManager)this.baseService).clearToken(sysExternalUnite.getType());
                resultMsg = new CommonResult(true, "\u66f4\u65b0\u6210\u529f");
            }
        }
        catch (Exception e) {
            resultMsg = new CommonResult(false, "\u5bf9\u7b2c\u4e09\u65b9\u96c6\u6210\u64cd\u4f5c\u5931\u8d25");
        }
        return resultMsg;
    }

    @RequestMapping(value={"removes"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u7b2c\u4e09\u65b9\u96c6\u6210\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u7b2c\u4e09\u65b9\u96c6\u6210\u8bb0\u5f55")
    public CommonResult<String> batchRemove(String ... ids) throws Exception {
        try {
            this.sysExternalUniteManager.removeByIds(Arrays.asList(ids));
            return new CommonResult("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"syncUser"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5c06\u672c\u7cfb\u7edf\u7684\u7528\u6237\u540c\u6b65\u5230\u7b2c\u4e09\u65b9\u5e73\u53f0", httpMethod="GET", notes="\u5c06\u672c\u7cfb\u7edf\u7684\u7528\u6237\u540c\u6b65\u5230\u7b2c\u4e09\u65b9\u5e73\u53f0")
    public void syncUser(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id, HttpServletResponse response) throws Exception {
        boolean state = true;
        String errMsg = "\u4e0a\u4f20\u901a\u8baf\u5f55\u6210\u529f";
        try {
            this.sysExternalUniteManager.syncUser(id);
        }
        catch (Exception e) {
            state = false;
            errMsg = e.getMessage();
            e.printStackTrace();
        }
        finally {
            Map<String, String> mapMsg = ThreadMessageUtil.getMapMsg(true);
            if (BeanUtils.isNotEmpty(mapMsg)) {
                Iterator<Map.Entry<String, String>> iterator = mapMsg.entrySet().iterator();
                LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
                exportMap.put("fullname", "\u8d26\u53f7");
                exportMap.put("errmsg", "\u5f02\u5e38\u4fe1\u606f");
                ArrayList data = new ArrayList();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> next = iterator.next();
                    HashMap<String, String> item = new HashMap<String, String>();
                    item.put("fullname", next.getKey());
                    item.put("errmsg", next.getValue());
                    data.add(item);
                }
                HSSFWorkbook book = ExcelUtil.exportExcel((String)"\u5f02\u5e38\u8d26\u53f7", (int)24, exportMap, data);
                ExcelUtil.downloadExcel((Workbook)book, (String)"\u4e0a\u4f20\u901a\u8baf\u5f55\u5f02\u5e38\u7684\u8d26\u53f7\u4fe1\u606f", (HttpServletResponse)response);
            } else {
                response.setHeader("content-type", "text/html;charset=UTF-8");
                response.setCharacterEncoding("UTF-8");
                CommonResult commonResult = new CommonResult(state, errMsg);
                PrintWriter out = response.getWriter();
                out.write(JsonUtil.toJsonString((Object)commonResult));
                out.flush();
                out.close();
            }
            ThreadMessageUtil.cleanMapMsg();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"bindMobile"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u624b\u673a\u53f7\u7ed1\u5b9a\u5e73\u53f0\u7528\u6237\u8d26\u53f7", httpMethod="GET", notes="\u4ece\u7b2c\u4e09\u65b9\u7cfb\u7edf\u62c9\u53d6\u901a\u8baf\u5f55\u81f3\u672c\u7cfb\u7edf")
    public void bindMobile(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id, HttpServletResponse response) throws Exception {
        boolean state = true;
        String errMsg = "\u7ed1\u5b9a\u6210\u529f";
        try {
            this.sysExternalUniteManager.bingMobile(id);
        }
        catch (Exception e) {
            try {
                state = false;
                errMsg = e.getMessage();
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Map<String, String> mapMsg = ThreadMessageUtil.getMapMsg(true);
                if (BeanUtils.isNotEmpty(mapMsg)) {
                    Iterator<Map.Entry<String, String>> iterator = mapMsg.entrySet().iterator();
                    String bindType = ThreadMessageUtil.getBindType();
                    String label = WxBindTypeEnum.MOBILE.getKey().equals(bindType) ? "\u624b\u673a\u53f7" : "\u7528\u6237\u8d26\u53f7";
                    LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
                    exportMap.put("mobile", label);
                    exportMap.put("warning", "\u5f02\u5e38\u8bf4\u660e");
                    exportMap.put("errmsg", "\u5f02\u5e38\u4fe1\u606f");
                    ArrayList data = new ArrayList();
                    while (iterator.hasNext()) {
                        Map.Entry<String, String> next = iterator.next();
                        String warning = WxBindTypeEnum.ACCOUNT.getKey().equals(bindType) ? next.getValue() : (StringUtil.isNotEmpty((String)next.getValue()) && next.getValue().contains("user no exist") ? "\u4f01\u4e1a\u5fae\u4fe1\u65e0\u6cd5\u6839\u636e\u624b\u673a\u53f7\u7801\u627e\u5230\u5bf9\u5e94\u7528\u6237" : "\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                        HashMap<String, String> item = new HashMap<String, String>(3);
                        item.put("mobile", next.getKey());
                        item.put("warning", warning);
                        item.put("errmsg", next.getValue());
                        data.add(item);
                    }
                    HSSFWorkbook book = ExcelUtil.exportExcel((String)"\u5f02\u5e38\u8d26\u53f7", (int)24, exportMap, data);
                    ExcelUtil.downloadExcel((Workbook)book, (String)("\u901a\u8baf\u5f55\u7ed1\u5b9a" + label + "\u5f02\u5e38\u4fe1\u606f"), (HttpServletResponse)response);
                } else {
                    response.setHeader("content-type", "text/html;charset=UTF-8");
                    response.setCharacterEncoding("UTF-8");
                    CommonResult commonResult = new CommonResult(state, errMsg);
                    PrintWriter out = response.getWriter();
                    out.write(JsonUtil.toJsonString((Object)commonResult));
                    out.flush();
                    out.close();
                }
                ThreadMessageUtil.cleanMapMsg();
                throw throwable;
            }
            Map<String, String> mapMsg = ThreadMessageUtil.getMapMsg(true);
            if (BeanUtils.isNotEmpty(mapMsg)) {
                Iterator<Map.Entry<String, String>> iterator = mapMsg.entrySet().iterator();
                String bindType = ThreadMessageUtil.getBindType();
                String label = WxBindTypeEnum.MOBILE.getKey().equals(bindType) ? "\u624b\u673a\u53f7" : "\u7528\u6237\u8d26\u53f7";
                LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
                exportMap.put("mobile", label);
                exportMap.put("warning", "\u5f02\u5e38\u8bf4\u660e");
                exportMap.put("errmsg", "\u5f02\u5e38\u4fe1\u606f");
                ArrayList data = new ArrayList();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> next = iterator.next();
                    String warning = WxBindTypeEnum.ACCOUNT.getKey().equals(bindType) ? next.getValue() : (StringUtil.isNotEmpty((String)next.getValue()) && next.getValue().contains("user no exist") ? "\u4f01\u4e1a\u5fae\u4fe1\u65e0\u6cd5\u6839\u636e\u624b\u673a\u53f7\u7801\u627e\u5230\u5bf9\u5e94\u7528\u6237" : "\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                    HashMap<String, String> item = new HashMap<String, String>(3);
                    item.put("mobile", next.getKey());
                    item.put("warning", warning);
                    item.put("errmsg", next.getValue());
                    data.add(item);
                }
                HSSFWorkbook book = ExcelUtil.exportExcel((String)"\u5f02\u5e38\u8d26\u53f7", (int)24, exportMap, data);
                ExcelUtil.downloadExcel((Workbook)book, (String)("\u901a\u8baf\u5f55\u7ed1\u5b9a" + label + "\u5f02\u5e38\u4fe1\u606f"), (HttpServletResponse)response);
            } else {
                response.setHeader("content-type", "text/html;charset=UTF-8");
                response.setCharacterEncoding("UTF-8");
                CommonResult commonResult = new CommonResult(state, errMsg);
                PrintWriter out = response.getWriter();
                out.write(JsonUtil.toJsonString((Object)commonResult));
                out.flush();
                out.close();
            }
            ThreadMessageUtil.cleanMapMsg();
        }
        Map<String, String> mapMsg = ThreadMessageUtil.getMapMsg(true);
        if (BeanUtils.isNotEmpty(mapMsg)) {
            Iterator<Map.Entry<String, String>> iterator = mapMsg.entrySet().iterator();
            String bindType = ThreadMessageUtil.getBindType();
            String label = WxBindTypeEnum.MOBILE.getKey().equals(bindType) ? "\u624b\u673a\u53f7" : "\u7528\u6237\u8d26\u53f7";
            LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
            exportMap.put("mobile", label);
            exportMap.put("warning", "\u5f02\u5e38\u8bf4\u660e");
            exportMap.put("errmsg", "\u5f02\u5e38\u4fe1\u606f");
            ArrayList data = new ArrayList();
            while (iterator.hasNext()) {
                Map.Entry<String, String> next = iterator.next();
                String warning = WxBindTypeEnum.ACCOUNT.getKey().equals(bindType) ? next.getValue() : (StringUtil.isNotEmpty((String)next.getValue()) && next.getValue().contains("user no exist") ? "\u4f01\u4e1a\u5fae\u4fe1\u65e0\u6cd5\u6839\u636e\u624b\u673a\u53f7\u7801\u627e\u5230\u5bf9\u5e94\u7528\u6237" : "\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                HashMap<String, String> item = new HashMap<String, String>(3);
                item.put("mobile", next.getKey());
                item.put("warning", warning);
                item.put("errmsg", next.getValue());
                data.add(item);
            }
            HSSFWorkbook book = ExcelUtil.exportExcel((String)"\u5f02\u5e38\u8d26\u53f7", (int)24, exportMap, data);
            ExcelUtil.downloadExcel((Workbook)book, (String)("\u901a\u8baf\u5f55\u7ed1\u5b9a" + label + "\u5f02\u5e38\u4fe1\u606f"), (HttpServletResponse)response);
        } else {
            response.setHeader("content-type", "text/html;charset=UTF-8");
            response.setCharacterEncoding("UTF-8");
            CommonResult commonResult = new CommonResult(state, errMsg);
            PrintWriter out = response.getWriter();
            out.write(JsonUtil.toJsonString((Object)commonResult));
            out.flush();
            out.close();
        }
        ThreadMessageUtil.cleanMapMsg();
    }

    @RequestMapping(value={"pullUser"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4ece\u7b2c\u4e09\u65b9\u7cfb\u7edf\u62c9\u53d6\u901a\u8baf\u5f55\u81f3\u672c\u7cfb\u7edf", httpMethod="GET", notes="\u4ece\u7b2c\u4e09\u65b9\u7cfb\u7edf\u62c9\u53d6\u901a\u8baf\u5f55\u81f3\u672c\u7cfb\u7edf")
    public CommonResult<String> pullUser(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id) throws Exception {
        try {
            this.sysExternalUniteManager.pullUser(id);
            return new CommonResult("\u62c9\u53d6\u901a\u8baf\u5f55\u6210\u529f");
        }
        catch (IOException e) {
            return new CommonResult(false, "\u62c9\u53d6\u901a\u8baf\u5f55\u5931\u8d25" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"syncContacts"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u624b\u52a8\u540c\u6b65\u901a\u8baf\u5f55", httpMethod="POST", notes="\u624b\u52a8\u540c\u6b65\u901a\u8baf\u5f55")
    public void syncContacts(@ApiParam(name="sysExternalUnite", value="\u7b2c\u4e09\u65b9\u5e94\u7528\u914d\u7f6e\u4fe1\u606f") @RequestBody SysExternalUnite sysExternalUnite, HttpServletResponse response) throws Exception {
        boolean state = true;
        String errMsg = "\u540c\u6b65\u901a\u8baf\u5f55\u6210\u529f";
        try {
            if (sysExternalUnite == null || !sysExternalUnite.getSyncFlag().booleanValue()) {
                errMsg = "\u8bf7\u5148\u4fee\u6539\u901a\u8baf\u5f55\u540c\u6b65\u914d\u7f6e\uff0c\u5e76\u542f\u7528\u540c\u6b65\u7ec4\u7ec7\u67b6\u6784";
            } else {
                this.sysExternalUniteManager.syncContacts(sysExternalUnite);
            }
        }
        catch (Exception e) {
            state = false;
            errMsg = e.getMessage();
        }
        finally {
            Map<String, String> mapMsg = ThreadMessageUtil.getMapMsg(true);
            if (BeanUtils.isNotEmpty(mapMsg)) {
                Iterator<Map.Entry<String, String>> iterator = mapMsg.entrySet().iterator();
                LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>(2);
                exportMap.put("fullname", "\u8d26\u53f7");
                exportMap.put("errmsg", "\u5f02\u5e38\u4fe1\u606f");
                ArrayList data = new ArrayList();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> next = iterator.next();
                    HashMap<String, String> item = new HashMap<String, String>(2);
                    item.put("fullname", next.getKey());
                    item.put("errmsg", next.getValue());
                    data.add(item);
                }
                String title = "\u901a\u8baf\u5f55\u540c\u6b65\u5f02\u5e38\u4fe1\u606f";
                ExcelUtil.exportCSV((String)title, exportMap, data, (HttpServletResponse)response);
            } else {
                response.setHeader("content-type", "application/json");
                response.setCharacterEncoding("UTF-8");
                response.setContentType("application/json;charset=UTF-8");
                CommonResult commonResult = new CommonResult(state, errMsg);
                PrintWriter out = response.getWriter();
                out.write(JsonUtil.toJsonString((Object)commonResult));
                out.flush();
                out.close();
            }
            ThreadMessageUtil.cleanMapMsg();
        }
    }

    @RequestMapping(value={"saveAgent"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u7cfb\u7edf\u7b2c\u4e09\u65b9\u96c6\u6210\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u7cfb\u7edf\u7b2c\u4e09\u65b9\u96c6\u6210\u4fe1\u606f")
    public CommonResult<String> saveAgent(@ApiParam(name="sysExternalUnite", value="\u7b2c\u4e09\u65b9\u96c6\u6210\u4fe1\u606f") @RequestBody SysExternalUnite sysExternalUnite) throws Exception {
        CommonResult resultMsg = null;
        try {
            this.sysExternalUniteManager.saveAgent(sysExternalUnite);
            resultMsg = new CommonResult("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            resultMsg = new CommonResult(false, "\u5bf9\u7b2c\u4e09\u65b9\u96c6\u6210\u64cd\u4f5c\u5931\u8d25:" + e.getMessage());
        }
        return resultMsg;
    }

    @RequestMapping(value={"getToken"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6getToken", httpMethod="GET", notes="\u83b7\u53d6getToken")
    public String getToken(String type) throws IOException {
        String token = "";
        if (ExterUniEnum.WeChatWork.getKey().equals(type)) {
            token = WechatWorkTokenUtil.getToken();
        } else if (ExterUniEnum.Dingtalk.getKey().equals(type)) {
            token = DingTalkTokenUtil.getToken();
        }
        return token;
    }

    @RequestMapping(value={"getUserInfoUrl"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6getUserInfoUrl", httpMethod="GET", notes="\u83b7\u53d6getUserInfoUrl")
    public String getUserInfoUrl(@ApiParam(name="type", value="\u7b2c\u4e09\u65b9\u96c6\u6210\u7c7b\u578b") @RequestParam String type, @ApiParam(name="code", value="\u5e94\u7528code") @RequestParam String code) throws Exception {
        String url = "";
        if (ExterUniEnum.WeChatWork.getKey().equals(type)) {
            url = WeChatWorkConsts.getQyWxUserInfo(code);
        } else if (ExterUniEnum.Dingtalk.getKey().equals(type)) {
            url = DingTalkConsts.getUserInfo(code);
        } else if (ExterUniEnum.WeChatOfficialAccounts.getKey().equals(type)) {
            url = WeChatOffAccConsts.getWxAccessToken(code);
        } else if (ExterUniEnum.MiniProgram.getKey().equals(type)) {
            url = WeChatOffAccConsts.code2SessionUrl(code);
        }
        return url;
    }

    @GetMapping(value={"/getQrCodeInfo"})
    @ApiOperation(value="\u83b7\u53d6\u751f\u6210\u4f01\u5fae\u9489\u9489\u4e8c\u7ef4\u7801\u7684\u4fe1\u606f", httpMethod="GET")
    public Object getScanAppId(@ApiParam(name="tenantId", value="\u79df\u6237\u7f16\u7801") @RequestParam String tenantId) {
        return ((SysExternalUniteManager)this.baseService).getScanAppList(tenantId);
    }

    @GetMapping(value={"getDingtalkIdFromScanCode"})
    @ApiOperation(value="\u6839\u636e\u9489\u9489App\u626b\u7801\u5f97\u5230\u7684code\u83b7\u53d6dingtalkId", httpMethod="GET")
    public CommonResult<String> getDingtalkIdFromScanCode(@ApiParam(name="code", value="\u9489\u9489App\u626b\u7801\u5f97\u5230\u7684code") @RequestParam String code) throws Exception {
        SysExternalUnite dingtalk = ((SysExternalUniteManager)this.baseService).getDingtalk();
        if (BeanUtils.isEmpty((Object)((Object)dingtalk))) {
            return new CommonResult(false, "\u7cfb\u7edf\u67e5\u65e0\u9489\u9489\u96c6\u6210\u4fe1\u606f\uff01");
        }
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/sns/getuserinfo_bycode");
            OapiSnsGetuserinfoBycodeRequest req = new OapiSnsGetuserinfoBycodeRequest();
            req.setTmpAuthCode(code);
            OapiSnsGetuserinfoBycodeResponse rsp = (OapiSnsGetuserinfoBycodeResponse)client.execute((TaobaoRequest)req, dingtalk.getCorpId(), dingtalk.getCorpSecret());
            System.out.println(rsp.getBody());
            if (rsp.getErrcode() != 0L) {
                return new CommonResult(false, rsp.getBody());
            }
            DefaultDingTalkClient client2 = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/user/getbyunionid");
            OapiUserGetbyunionidRequest req2 = new OapiUserGetbyunionidRequest();
            req2.setUnionid(rsp.getUserInfo().getUnionid());
            OapiUserGetbyunionidResponse rsp2 = (OapiUserGetbyunionidResponse)client2.execute((TaobaoRequest)req2, DingTalkTokenUtil.getToken());
            System.out.println(rsp2.getBody());
            if (rsp2.getErrcode() != 0L) {
                return new CommonResult(false, rsp2.getErrmsg());
            }
            return new CommonResult(true, "\u83b7\u53d6\u9489\u9489dingtalkId\u6210\u529f", (Object)rsp2.getResult().getUserid());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u6839\u636e\u9489\u9489App\u626b\u7801\u5f97\u5230\u7684code\u83b7\u53d6dingtalkId\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @GetMapping(value={"getWxWorkIdFromScanCode"})
    @ApiOperation(value="\u6839\u636e\u4f01\u4e1a\u5fae\u4fe1App\u626b\u7801\u5f97\u5230\u7684code\u83b7\u53d6wxWorkId", httpMethod="GET")
    public CommonResult<String> getWxWorkIdFromScanCode(@ApiParam(name="code", value="\u4f01\u4e1a\u5fae\u4fe1App\u626b\u7801\u5f97\u5230\u7684code") @RequestParam String code) throws Exception {
        SysExternalUnite weChatWork = ((SysExternalUniteManager)this.baseService).getWechatWork();
        if (BeanUtils.isEmpty((Object)((Object)weChatWork))) {
            return new CommonResult(false, "\u7cfb\u7edf\u67e5\u65e0\u4f01\u4e1a\u5fae\u4fe1\u96c6\u6210\u4fe1\u606f\uff01");
        }
        try {
            String url = WeChatWorkConsts.getQyWxUserInfo(code);
            String response = HttpUtil.sendHttpsRequest((String)url, (String)"", (String)"POST");
            ObjectNode jsonNode = (ObjectNode)JsonUtil.toJsonNode((String)response);
            if (!"0".equals(jsonNode.get("errcode").asText())) {
                return new CommonResult(false, response);
            }
            return new CommonResult(true, "\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1wxWorkId\u6210\u529f", (Object)jsonNode.get("UserId").asText());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u6839\u636e\u4f01\u4e1a\u5fae\u4fe1App\u626b\u7801\u5f97\u5230\u7684code\u83b7\u53d6wxWorkId\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @GetMapping(value={"getFlyBookIdFromScanCode"})
    @ApiOperation(value="\u6839\u636e\u98de\u4e66App\u626b\u7801\u5f97\u5230\u7684code\u83b7\u53d6FLYBOOK_ID_", httpMethod="GET")
    public CommonResult<String> getFlyBookIdFromScanCode(@ApiParam(name="code", value="\u98de\u4e66App\u626b\u7801\u5f97\u5230\u7684code") @RequestParam String code, @ApiParam(name="redirectUri", value="\u524d\u7aef\u56de\u8c03\u5730\u5740") @RequestParam(value="redirectUri", required=false) String redirectUri) throws Exception {
        SysExternalUnite flyBook = ((SysExternalUniteManager)this.baseService).getFlyBook();
        if (BeanUtils.isEmpty((Object)((Object)flyBook))) {
            return new CommonResult(false, "\u7cfb\u7edf\u67e5\u65e0\u98de\u4e66\u96c6\u6210\u4fe1\u606f\uff01");
        }
        try {
            String userId = this.flyBookManager.getUserInfo(code, redirectUri);
            return new CommonResult(true, "\u83b7\u53d6\u7528\u6237ID\u6210\u529f", (Object)userId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u6839\u636eApp\u626b\u7801\u5f97\u5230\u7684code\u83b7\u53d6\u7528\u6237ID\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @GetMapping(value={"getFlyBookIdByCode"})
    @ApiOperation(value="\u98de\u4e66\u83b7\u53d6\u767b\u5f55\u9884\u6388\u6743\u7801 code \u5bf9\u5e94\u7684\u767b\u5f55\u7528\u6237\u8eab\u4efd", httpMethod="GET")
    public CommonResult<String> getFlyBookIdByCode(@ApiParam(name="code", value="\u98de\u4e66\u767b\u5f55\u9884\u6388\u6743\u7801code") @RequestParam String code) throws Exception {
        SysExternalUnite flyBook = ((SysExternalUniteManager)this.baseService).getFlyBook();
        if (BeanUtils.isEmpty((Object)((Object)flyBook))) {
            return new CommonResult(false, "\u7cfb\u7edf\u67e5\u65e0\u98de\u4e66\u96c6\u6210\u4fe1\u606f\uff01");
        }
        String userId = this.flyBookManager.getAccessUserId(code);
        return new CommonResult(true, "\u83b7\u53d6\u7528\u6237ID\u6210\u529f", (Object)userId);
    }

    @RequestMapping(value={"clearToken"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6e05\u9664token\u7f13\u5b58", httpMethod="GET", notes="\u6e05\u9664token\u7f13\u5b58")
    public CommonResult<String> clearToken(@ApiParam(name="type", value="\u7b2c\u4e09\u65b9\u96c6\u6210\u7c7b\u578b") @RequestParam(required=false) String type) throws Exception {
        ((SysExternalUniteManager)this.baseService).clearToken(type);
        return CommonResult.ok();
    }

    @RequestMapping(value={"getDepartmentTree"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u5f97\u96c6\u6210\u5bf9\u8c61", httpMethod="GET", notes="\u83b7\u5f97\u96c6\u6210\u5bf9\u8c61")
    public List<WxOrg> getDepartmentTree(@ApiParam(name="type", value="\u7b2c\u4e09\u65b9\u7c7b\u578b\uff0c\u5fae\u4fe1-weChatWork\uff1bdingtalk-\u9489\u9489\uff1bflyBook-\u98de\u4e66") @RequestParam String type) throws Exception {
        return this.sysExternalUniteManager.getDepartmentTree(type);
    }
}

