/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.system.persistence.manager.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.system.consts.FlyBookConsts;
import com.hotent.system.persistence.manager.ContactHttpManager;
import com.hotent.system.util.FlybookTokenUtil;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class ContactHttpManagerImpl
implements ContactHttpManager {
    protected Logger logger = LoggerFactory.getLogger(ContactHttpManagerImpl.class);
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public ArrayNode getDepartmentChildren(String departmentIdParent, String parentPathName) throws Exception {
        ResponseEntity responseEntity;
        String url = FlyBookConsts.getDepartmentChildrenUrl(departmentIdParent);
        try {
            responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, this.getDefaultEntity(), String.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            if (Objects.equals(400, e.getRawStatusCode()) && StringUtil.isNotEmpty((String)e.getMessage()) && e.getMessage().contains("these ids not existed")) {
                this.logger.info("\u672a\u627e\u5230\u90e8\u95e8ID\uff01");
                return JsonUtil.getMapper().createArrayNode();
            }
            this.logger.error("\u83b7\u53d6\u5b50\u90e8\u95e8\u5217\u8868\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
            return JsonUtil.getMapper().createArrayNode();
        }
        if (!Objects.equals(responseEntity.getStatusCode(), HttpStatus.OK)) {
            throw new RuntimeException(String.format("\u83b7\u53d6\u5b50\u90e8\u95e8\u5217\u8868\u4fe1\u606f\u5931\u8d25\uff01%s", responseEntity.getBody()));
        }
        JsonNode response = JsonUtil.toJsonNode((String)((String)responseEntity.getBody()));
        if (response == null || response.get("code").asInt() != 0 || response.get("data") == null) {
            throw new RuntimeException("\u83b7\u53d6\u5b50\u90e8\u95e8\u63a5\u53e3code\u5931\u8d25:" + (response == null ? "" : response.get("msg").asText()));
        }
        JsonNode items = response.get("data").get("items");
        if (items == null || items.isEmpty()) {
            return JsonUtil.getMapper().createArrayNode();
        }
        ArrayNode arrayNode = (ArrayNode)items;
        ArrayNode result = JsonUtil.getMapper().createArrayNode();
        for (JsonNode item : arrayNode) {
            String pathName = parentPathName + "/" + item.get("name").asText();
            ObjectNode orgNode = JsonUtil.getMapper().createObjectNode();
            orgNode.set("id", item.get("department_id"));
            orgNode.set("code", JsonUtil.toJsonNode((String)JsonUtil.toJson((Object)UUID.randomUUID().toString().replaceAll("-", ""))));
            orgNode.set("name", item.get("name"));
            orgNode.set("parentId", item.get("parent_department_id"));
            orgNode.set("flybookId", item.get("department_id"));
            orgNode.set("pathName", JsonUtil.toJsonNode((String)JsonUtil.toJson((Object)pathName)));
            result.add((JsonNode)orgNode);
        }
        return result;
    }

    @Override
    public ArrayNode getDepartmentParent(String departmentId) throws Exception {
        ResponseEntity responseEntity;
        String url = FlyBookConsts.getDepartmentParentUrl(departmentId);
        try {
            responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, this.getDefaultEntity(), String.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            if (Objects.equals(400, e.getRawStatusCode()) && StringUtil.isNotEmpty((String)e.getMessage()) && e.getMessage().contains("these ids not existed")) {
                this.logger.info("\u672a\u627e\u5230\u90e8\u95e8ID\uff01");
                return JsonUtil.getMapper().createArrayNode();
            }
            this.logger.error("\u83b7\u53d6\u7236\u90e8\u95e8\u5217\u8868\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
            return JsonUtil.getMapper().createArrayNode();
        }
        if (!Objects.equals(responseEntity.getStatusCode(), HttpStatus.OK)) {
            throw new RuntimeException(String.format("\u83b7\u53d6\u7236\u90e8\u95e8\u5217\u8868\u4fe1\u606f\u5931\u8d25\uff01%s", responseEntity.getBody()));
        }
        JsonNode response = JsonUtil.toJsonNode((String)((String)responseEntity.getBody()));
        if (response == null || response.get("code").asInt() != 0 || response.get("data") == null) {
            throw new RuntimeException("\u83b7\u53d6\u7236\u90e8\u95e8\u63a5\u53e3code\u5931\u8d25:" + (response == null ? "" : response.get("msg").asText()));
        }
        JsonNode items = response.get("data").get("items");
        if (items == null || items.isEmpty()) {
            return JsonUtil.getMapper().createArrayNode();
        }
        ArrayNode arrayNode = (ArrayNode)items;
        ArrayNode result = JsonUtil.getMapper().createArrayNode();
        for (JsonNode item : arrayNode) {
            ObjectNode orgNode = JsonUtil.getMapper().createObjectNode();
            orgNode.set("id", item.get("department_id"));
            orgNode.set("code", JsonUtil.toJsonNode((String)JsonUtil.toJson((Object)UUID.randomUUID().toString().replaceAll("-", ""))));
            orgNode.set("name", item.get("name"));
            orgNode.set("parentId", item.get("parent_department_id"));
            orgNode.set("flybookId", item.get("department_id"));
            result.add((JsonNode)orgNode);
        }
        return result;
    }

    @Override
    public ObjectNode getDepartment(String departmentId) throws Exception {
        ResponseEntity responseEntity;
        String url = FlyBookConsts.getDepartmentUrl(departmentId);
        try {
            responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, this.getDefaultEntity(), String.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            if (Objects.equals(400, e.getRawStatusCode()) && StringUtil.isNotEmpty((String)e.getMessage()) && e.getMessage().contains("these ids not existed")) {
                this.logger.info("\u672a\u627e\u5230\u90e8\u95e8ID\uff01");
                return JsonUtil.getMapper().createObjectNode();
            }
            this.logger.error("\u83b7\u53d6\u90e8\u95e8\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
            return JsonUtil.getMapper().createObjectNode();
        }
        if (!Objects.equals(responseEntity.getStatusCode(), HttpStatus.OK)) {
            throw new RuntimeException(String.format("\u83b7\u53d6\u90e8\u95e8\u4fe1\u606f\u5931\u8d25\uff01%s", responseEntity.getBody()));
        }
        JsonNode response = JsonUtil.toJsonNode((String)((String)responseEntity.getBody()));
        if (response == null || response.get("code").asInt() != 0 || response.get("data") == null) {
            throw new RuntimeException("\u83b7\u53d6\u90e8\u95e8\u63a5\u53e3code\u5931\u8d25:" + (response == null ? "" : response.get("msg").asText()));
        }
        JsonNode deptInfo = response.get("data").get("department");
        if (deptInfo == null) {
            return JsonUtil.getMapper().createObjectNode();
        }
        ObjectNode orgNode = JsonUtil.getMapper().createObjectNode();
        orgNode.set("id", deptInfo.get("department_id"));
        orgNode.set("code", JsonUtil.toJsonNode((String)JsonUtil.toJson((Object)UUID.randomUUID().toString().replaceAll("-", ""))));
        orgNode.set("name", deptInfo.get("name"));
        orgNode.set("parentId", deptInfo.get("parent_department_id"));
        orgNode.set("flybookId", deptInfo.get("department_id"));
        return orgNode;
    }

    @Override
    public ArrayNode getUserListByDeptId(String deptId) throws Exception {
        ResponseEntity responseEntity;
        String url = FlyBookConsts.getUserListByDeptIdUrl(deptId);
        try {
            responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, this.getDefaultEntity(), String.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            if (Objects.equals(400, e.getRawStatusCode()) && StringUtil.isNotEmpty((String)e.getMessage()) && e.getMessage().contains("these ids not existed")) {
                this.logger.info("\u672a\u627e\u5230\u90e8\u95e8ID\uff01");
                return JsonUtil.getMapper().createArrayNode();
            }
            this.logger.error("\u83b7\u53d6\u76f4\u5c5e\u90e8\u95e8\u7528\u6237\u5217\u8868\u63a5\u53e3\u8bbf\u95ee\u5f02\u5e38\uff01", (Throwable)e);
            return JsonUtil.getMapper().createArrayNode();
        }
        if (!Objects.equals(responseEntity.getStatusCode(), HttpStatus.OK)) {
            throw new RuntimeException(String.format("\u83b7\u53d6\u76f4\u5c5e\u90e8\u95e8\u7528\u6237\u5217\u8868\u63a5\u53e3\u8bbf\u95ee\u5931\u8d25\uff01%s", responseEntity.getBody()));
        }
        JsonNode response = JsonUtil.toJsonNode((String)((String)responseEntity.getBody()));
        if (response == null || response.get("code").asInt() != 0 || response.get("data") == null) {
            throw new RuntimeException("\u83b7\u53d6\u76f4\u5c5e\u90e8\u95e8\u7528\u6237\u5217\u8868\u63a5\u53e3code\u5931\u8d25:" + (response == null ? "" : response.get("msg").asText()));
        }
        JsonNode items = response.get("data").get("items");
        if (items == null || items.isEmpty()) {
            return JsonUtil.getMapper().createArrayNode();
        }
        ArrayNode arrayNode = (ArrayNode)items;
        ArrayNode result = JsonUtil.getMapper().createArrayNode();
        for (JsonNode item : arrayNode) {
            if (item.get("mobile") == null) {
                throw new BaseException("\u8bf7\u5f00\u901a\u6743\u9650\u7ba1\u7406\u4e2d\u7684\u901a\u8baf\u5f55\u6743\u9650\uff01");
            }
            String mobile = item.get("mobile").asText();
            mobile = mobile.startsWith("+86") ? mobile.replaceFirst("^\\+86", "") : mobile;
            ObjectNode userNode = JsonUtil.getMapper().createObjectNode();
            userNode.set("userid", item.get("user_id"));
            userNode.set("name", item.get("name"));
            userNode.set("department", item.get("department_ids"));
            userNode.set("mobile", JsonUtil.toJsonNode((String)mobile));
            result.add((JsonNode)userNode);
        }
        return result;
    }

    private HttpEntity<String> getDefaultEntity() throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.setBearerAuth(FlybookTokenUtil.getToken());
        return new HttpEntity((MultiValueMap)headers);
    }

    @Override
    public ObjectNode createDepartment(String deptId, String deptName, String parentId) throws Exception {
        ResponseEntity responseEntity;
        String url = FlyBookConsts.createDeptUrl();
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setBearerAuth(FlybookTokenUtil.getToken());
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("name", deptName);
            map.put("department_id", deptId);
            map.put("parent_department_id", parentId);
            HttpEntity httpEntity = new HttpEntity(map, (MultiValueMap)headers);
            responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            if (StringUtil.isNotEmpty((String)e.getMessage()) && e.getMessage().contains("duplicate name error")) {
                ObjectNode result = JsonUtil.getMapper().createObjectNode();
                result.set("code", JsonUtil.toJsonNode((Object)40018));
                result.set("msg", JsonUtil.toJsonNode((String)e.getMessage()));
                return result;
            }
            this.logger.error("\u521b\u5efa\u90e8\u95e8\u8bbf\u95ee\u5f02\u5e38\uff01", (Throwable)e);
            return null;
        }
        if (!Objects.equals(responseEntity.getStatusCode(), HttpStatus.OK)) {
            throw new RuntimeException(String.format("\u521b\u5efa\u90e8\u95e8\u63a5\u53e3\u8bbf\u95ee\u5931\u8d25\uff01%s", responseEntity.getBody()));
        }
        JsonNode response = JsonUtil.toJsonNode((String)((String)responseEntity.getBody()));
        if (response == null || response.get("code") == null) {
            throw new RuntimeException("\u521b\u5efa\u90e8\u95e8\u63a5\u53e3code\u5931\u8d25\uff01");
        }
        ObjectNode result = JsonUtil.getMapper().createObjectNode();
        result.set("code", response.get("code"));
        result.set("msg", response.get("msg"));
        if (response.get("data") != null && response.get("data").get("department") != null) {
            result.set("department_id", response.get("data").get("department").get("department_id"));
        }
        return result;
    }

    @Override
    public ObjectNode createUser(String userId, String name, String mobile, List<String> deptId) throws Exception {
        ResponseEntity responseEntity;
        String url = FlyBookConsts.createUserUrl();
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setBearerAuth(FlybookTokenUtil.getToken());
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("name", name);
            map.put("mobile", mobile);
            map.put("department_ids", deptId);
            map.put("employee_type", 1);
            HttpEntity httpEntity = new HttpEntity(map, (MultiValueMap)headers);
            responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            if (StringUtil.isNotEmpty((String)e.getMessage()) && e.getMessage().contains("mobile has already exist")) {
                ObjectNode result = JsonUtil.getMapper().createObjectNode();
                result.set("code", JsonUtil.toJsonNode((Object)41001));
                result.set("msg", JsonUtil.toJsonNode((String)e.getMessage()));
                return result;
            }
            this.logger.error("\u521b\u5efa\u90e8\u95e8\u8bbf\u95ee\u5f02\u5e38\uff01", (Throwable)e);
            return null;
        }
        if (!Objects.equals(responseEntity.getStatusCode(), HttpStatus.OK)) {
            throw new RuntimeException(String.format("\u521b\u5efa\u7528\u6237\u63a5\u53e3\u8bbf\u95ee\u5931\u8d25\uff01%s", responseEntity.getBody()));
        }
        JsonNode response = JsonUtil.toJsonNode((String)((String)responseEntity.getBody()));
        if (response == null) {
            throw new RuntimeException("\u521b\u5efa\u7528\u6237\u63a5\u53e3code\u5931\u8d25\uff01");
        }
        return (ObjectNode)response;
    }

    @Override
    public ObjectNode sendCardMessage(List<String> receiveIds, String content) {
        String url = FlyBookConsts.batchSendCardUrl();
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setBearerAuth(FlybookTokenUtil.getToken());
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("msg_type", "interactive");
            map.put("card", JsonUtil.toJsonNode((String)content));
            map.put("user_ids", receiveIds);
            HttpEntity httpEntity = new HttpEntity(map, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
            if (!HttpStatus.OK.equals((Object)responseEntity.getStatusCode())) {
                throw new RuntimeException("\u8bbf\u95ee\u53d1\u9001\u5361\u7247\u63a5\u53e3\u5931\u8d25\uff01");
            }
            JsonNode response = JsonUtil.toJsonNode((String)((String)responseEntity.getBody()));
            if (response == null) {
                throw new RuntimeException("\u8bbf\u95ee\u53d1\u9001\u5361\u7247\u63a5\u53e3\u8fd4\u56de\u7a7a\u4fe1\u606f\uff01");
            }
            if (!response.has("code")) {
                throw new RuntimeException("\u8bbf\u95ee\u53d1\u9001\u5361\u7247\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u7ed3\u6784\u4e0d\u6b63\u786e\uff01");
            }
            return (ObjectNode)response;
        }
        catch (HttpClientErrorException e) {
            this.logger.error("\u98de\u4e66-\u8bbf\u95ee\u53d1\u9001\u5361\u7247\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38\uff01", (Throwable)e);
            throw new RuntimeException("\u98de\u4e66-\u8bbf\u95ee\u53d1\u9001\u5361\u7247\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38\uff01", e);
        }
        catch (IOException ioe) {
            this.logger.error("\u98de\u4e66-\u83b7\u53d6\u8bbf\u95ee\u4ee4\u724c\u5f02\u5e38\u6216\u8005\u5361\u7247\u5185\u5bb9\u683c\u5f0f\u9519\u8bef\uff01", (Throwable)ioe);
            throw new RuntimeException("\u98de\u4e66-\u83b7\u53d6\u8bbf\u95ee\u4ee4\u724c\u5f02\u5e38\u6216\u8005\u5361\u7247\u5185\u5bb9\u683c\u5f0f\u9519\u8bef\uff01", ioe);
        }
        catch (Exception e) {
            this.logger.error("\u98de\u4e66-\u53d1\u9001\u5361\u7247\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
            throw new RuntimeException("\u98de\u4e66-\u53d1\u9001\u5361\u7247\u4fe1\u606f\u5f02\u5e38\uff01", e);
        }
    }
}

