/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.system.persistence.manager.impl;

import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiDepartmentListRequest;
import com.dingtalk.api.request.OapiV2DepartmentCreateRequest;
import com.dingtalk.api.response.OapiDepartmentListResponse;
import com.dingtalk.api.response.OapiV2DepartmentCreateResponse;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.string.StringConverter;
import com.hotent.system.consts.DingTalkConsts;
import com.hotent.system.enums.ExterUniEnum;
import com.hotent.system.model.WxOrg;
import com.hotent.system.persistence.manager.DingTalkOrgService;
import com.hotent.system.persistence.manager.HtOrgService;
import com.hotent.system.util.DingTalkTokenUtil;
import com.hotent.system.util.ThreadMessageUtil;
import com.taobao.api.TaobaoRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DingTalkOrgServiceImpl
implements DingTalkOrgService {
    protected Logger logger = LoggerFactory.getLogger(DingTalkOrgServiceImpl.class);
    @Resource
    UCFeignService orgManager;
    @Resource
    HtOrgService htOrgService;

    @Override
    public void create(ObjectNode org) {
        this.create(org, "1");
    }

    private String create(ObjectNode org, String parentDeptId) {
        if (org == null) {
            return "";
        }
        parentDeptId = StringUtil.isEmpty((String)parentDeptId) ? "1" : parentDeptId;
        ObjectNode result = null;
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient(DingTalkConsts.getCreateOrgUrl());
            OapiV2DepartmentCreateRequest req = new OapiV2DepartmentCreateRequest();
            req.setParentId(StringConverter.toLong((String)parentDeptId));
            if (org.get("orderNo") != null) {
                req.setOrder(StringConverter.toLong((String)org.get("orderNo").asText()));
            }
            if (org.get("name") != null) {
                req.setName(org.get("name").asText());
            }
            OapiV2DepartmentCreateResponse rsp = (OapiV2DepartmentCreateResponse)client.execute((TaobaoRequest)req, DingTalkTokenUtil.getToken());
            result = (ObjectNode)JsonUtil.toJsonNode((String)rsp.getBody());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        if (result == null) {
            this.logger.error("\u4e0a\u4f20\u7ec4\u7ec7\u4fe1\u606f\u65e0\u8fd4\u56de\u503c\uff01");
            return "";
        }
        String errcode = result.get("errcode").asText();
        if ("0".equals(errcode)) {
            this.logger.info("\u4e0a\u4f20\u7ec4\u7ec7\u6570\u636e\u6210\u529f\uff01\uff08\u9489\u9489\uff09");
            if (result.get("result") == null && result.get("result").get("dept_id") == null) {
                this.logger.error("\u4e0a\u4f20\u7ec4\u7ec7\u4fe1\u606f\u65e0\u8fd4\u56de\u90e8\u95e8ID\u503c\uff01");
                return "";
            }
            String deptId = result.get("result").get("dept_id").asText();
            this.htOrgService.updateLocalDbExternal(org.get("id").asText(), deptId, ExterUniEnum.Dingtalk);
            return deptId;
        }
        if ("60021".equals(errcode)) {
            String errmsg = result.get("errmsg").asText();
            String deptId = errmsg.substring(errmsg.indexOf("=") + 1).trim();
            this.htOrgService.updateLocalDbExternal(org.get("id").asText(), deptId, ExterUniEnum.Dingtalk);
            return deptId;
        }
        if (org.get("code") != null && org.get("name") != null) {
            ThreadMessageUtil.addMapMsg(org.get("code").asText() + "[" + org.get("name").asText() + "]", result.get("errmsg").asText());
        }
        return "";
    }

    @Override
    public void update(ObjectNode org) {
    }

    @Override
    public void delete(String orgId) {
    }

    @Override
    public void syncAllOrg() {
        String rootOrgId = "0";
        String rootDeptId = "1";
        List orgUnitList = this.orgManager.getOrgUniteByType(ExterUniEnum.Dingtalk.getType());
        this.syncOrg(rootOrgId, rootDeptId, orgUnitList);
    }

    private void syncOrg(String parentOrgId, String parentDeptId, List<ObjectNode> orgUnitList) {
        List orgList = this.orgManager.getOrgsByparentId(parentOrgId);
        if (CollectionUtils.isEmpty((Collection)orgList)) {
            return;
        }
        for (ObjectNode node : orgList) {
            String id = node.get("id").asText();
            String nodeParentId = this.htOrgService.getDeptIdByOrgId(id, orgUnitList, ExterUniEnum.Dingtalk);
            if (StringUtil.isEmpty((String)nodeParentId)) {
                nodeParentId = this.create(node, parentDeptId);
            }
            this.syncOrg(id, nodeParentId, orgUnitList);
        }
    }

    @Override
    public List<WxOrg> getDepartmentTree() throws Exception {
        String rootDeptId = "1";
        return this.getDepartmentList(rootDeptId);
    }

    private List<WxOrg> getDepartmentList(String deptId) throws Exception {
        DefaultDingTalkClient client = new DefaultDingTalkClient(DingTalkConsts.getDepartmentListUrl());
        OapiDepartmentListRequest request = new OapiDepartmentListRequest();
        request.setId(deptId);
        request.setFetchChild(Boolean.valueOf(false));
        request.setHttpMethod("GET");
        OapiDepartmentListResponse response = (OapiDepartmentListResponse)client.execute((TaobaoRequest)request, DingTalkTokenUtil.getToken());
        ArrayList<WxOrg> wxOrgList = new ArrayList<WxOrg>();
        if (!Long.valueOf(0L).equals(response.getErrcode())) {
            return wxOrgList;
        }
        List departmentList = response.getDepartment();
        if (CollectionUtils.isEmpty((Collection)departmentList)) {
            return wxOrgList;
        }
        for (OapiDepartmentListResponse.Department o : departmentList) {
            String subDeptId = String.valueOf(o.getId());
            WxOrg wxOrg = new WxOrg();
            wxOrg.setId(subDeptId);
            wxOrg.setName(o.getName());
            wxOrg.setParentid(String.valueOf(o.getParentid()));
            List<WxOrg> subNodeList = this.getDepartmentList(subDeptId);
            wxOrg.setChildren(CollectionUtils.isEmpty(subNodeList) ? null : subNodeList);
            wxOrgList.add(wxOrg);
        }
        return wxOrgList;
    }
}

