/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.system.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.TenantUtil;
import com.hotent.system.consts.FlyBookConsts;
import com.hotent.system.model.TokenModel;
import com.hotent.system.util.ExtUniUtil;
import com.hotent.system.util.FlybookHttpUtil;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlybookTokenUtil {
    protected static Logger log = LoggerFactory.getLogger(FlybookTokenUtil.class);
    private static ConcurrentHashMap<String, TokenModel> modelList = new ConcurrentHashMap();

    public static synchronized String getToken() throws IOException {
        TokenModel model = ExtUniUtil.getModel(modelList);
        if (!model.isInit()) {
            return FlybookTokenUtil.requestToken();
        }
        if (model.isExpire(model.getLastUpdTime(), model.getExprieIn())) {
            return FlybookTokenUtil.requestToken();
        }
        return model.getToken();
    }

    private static String requestToken() throws IOException {
        String url = FlyBookConsts.getTenantTokenUrl();
        ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
        objectNode.put("app_id", FlyBookConsts.getUnite().getCorpId());
        objectNode.put("app_secret", FlyBookConsts.getUnite().getCorpSecret());
        String rtn = FlybookHttpUtil.sendHttpsRequest(url, JsonUtil.toJson((Object)objectNode), "POST");
        JsonNode jsonObj = JsonUtil.toJsonNode((String)rtn);
        if (jsonObj.get("code").asInt() == 0) {
            String token = jsonObj.get("tenant_access_token").asText();
            int expireIn = jsonObj.get("expire").asInt();
            TokenModel model = new TokenModel();
            model.setCorpToken(token, expireIn);
            ExtUniUtil.putModel(model, modelList);
            return token;
        }
        TokenModel model = new TokenModel();
        model.setInit(false);
        ExtUniUtil.putModel(model, modelList);
        String errMsg = jsonObj.get("msg").asText();
        log.error(errMsg);
        throw new RuntimeException("\u83b7\u53d6accessToken\u5931\u8d25:<br>" + errMsg);
    }

    private static TokenModel getModel() {
        String tenantId = TenantUtil.getCurrentTenantId();
        if (StringUtil.isEmpty((String)tenantId)) {
            tenantId = "-1";
        }
        return modelList.containsKey(tenantId) ? modelList.get(tenantId) : new TokenModel();
    }

    public static boolean clearToken() {
        String tenantId = TenantUtil.getCurrentTenantId();
        if (StringUtil.isEmpty((String)tenantId)) {
            tenantId = "-1";
        }
        try {
            modelList.put(tenantId, new TokenModel());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error(ex.getMessage());
            return false;
        }
        return true;
    }
}

