/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.system.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.TenantUtil;
import com.hotent.system.consts.WeChatOffAccConsts;
import com.hotent.system.model.TokenModel;
import com.hotent.system.util.ExtUniUtil;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatOffAccTokenUtil {
    protected static Logger log = LoggerFactory.getLogger(WechatOffAccTokenUtil.class);
    private static ConcurrentHashMap<String, TokenModel> modelList = new ConcurrentHashMap();

    public static synchronized String getToken() throws IOException {
        TokenModel model = ExtUniUtil.getModel(modelList);
        if (!model.isInit()) {
            String token = WechatOffAccTokenUtil.requestToken();
            return token;
        }
        if (model.isExpire(model.getLastUpdTime(), model.getExprieIn())) {
            String token = WechatOffAccTokenUtil.requestToken();
            return token;
        }
        return model.getToken();
    }

    private static String requestToken() throws IOException {
        String url = WeChatOffAccConsts.getTokenUrl();
        String rtn = HttpUtil.sendHttpsRequest((String)url, (String)"", (String)"GET");
        JsonNode jsonObj = JsonUtil.toJsonNode((String)rtn);
        System.out.println(rtn);
        if (BeanUtils.isNotEmpty((Object)jsonObj.get("access_token"))) {
            String token = jsonObj.get("access_token").asText();
            int expireIn = jsonObj.get("expires_in").asInt();
            TokenModel model = new TokenModel();
            model.setCorpToken(token, expireIn);
            ExtUniUtil.putModel(model, modelList);
            return token;
        }
        TokenModel model = new TokenModel();
        model.setInit(false);
        ExtUniUtil.putModel(model, modelList);
        String errMsg = jsonObj.get("errmsg").asText();
        log.error(errMsg);
        throw new RuntimeException("\u83b7\u53d6accessToken\u5931\u8d25:<br>" + errMsg);
    }

    public static boolean clearToken() {
        String tenantId = TenantUtil.getCurrentTenantId();
        if (StringUtil.isEmpty((String)tenantId)) {
            tenantId = "-1";
        }
        try {
            modelList.put(tenantId, new TokenModel());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error(ex.getMessage());
            return false;
        }
        return true;
    }
}

