/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.system.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.TenantUtil;
import com.hotent.system.consts.WeChatWorkConsts;
import com.hotent.system.model.TokenModel;
import com.hotent.system.util.ExtUniUtil;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatWorkTokenUtil {
    protected static Logger log = LoggerFactory.getLogger(WechatWorkTokenUtil.class);
    private static ConcurrentHashMap<String, TokenModel> modelList = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, TokenModel> agentModelList = new ConcurrentHashMap();

    public static synchronized String getToken() throws IOException {
        TokenModel model = ExtUniUtil.getModel(modelList);
        if (!model.isInit()) {
            String token = WechatWorkTokenUtil.requestToken();
            return token;
        }
        if (model.isExpire(model.getLastUpdTime(), model.getExprieIn())) {
            String token = WechatWorkTokenUtil.requestToken();
            return token;
        }
        return model.getToken();
    }

    private static String requestToken() throws IOException {
        String url = WeChatWorkConsts.getTokenUrl();
        String rtn = HttpUtil.sendHttpsRequest((String)url, (String)"", (String)"GET");
        JsonNode jsonObj = JsonUtil.toJsonNode((String)rtn);
        System.out.println(rtn);
        if (jsonObj.get("errcode").asInt() == 0) {
            String token = jsonObj.get("access_token").asText();
            int expireIn = jsonObj.get("expires_in").asInt();
            TokenModel model = new TokenModel();
            model.setCorpToken(token, expireIn);
            ExtUniUtil.putModel(model, modelList);
            return token;
        }
        TokenModel model = new TokenModel();
        model.setInit(false);
        ExtUniUtil.putModel(model, modelList);
        String errMsg = jsonObj.get("errmsg").asText();
        log.error(errMsg);
        throw new RuntimeException("\u83b7\u53d6accessToken\u5931\u8d25:<br>" + errMsg);
    }

    public static synchronized String getAgentToken() throws IOException {
        TokenModel agentModel = ExtUniUtil.getModel(agentModelList);
        if (!agentModel.isInit()) {
            String token = WechatWorkTokenUtil.requestAgentToken();
            return token;
        }
        if (agentModel.isExpire(agentModel.getLastUpdTime(), agentModel.getExprieIn())) {
            String token = WechatWorkTokenUtil.requestAgentToken();
            return token;
        }
        return agentModel.getToken();
    }

    private static String requestAgentToken() throws IOException {
        String url = WeChatWorkConsts.getAgentToKenUrl();
        String rtn = HttpUtil.sendHttpsRequest((String)url, (String)"", (String)"GET");
        JsonNode jsonObj = JsonUtil.toJsonNode((String)rtn);
        System.out.println(rtn);
        if (jsonObj.get("errcode").asInt() == 0) {
            String token = jsonObj.get("access_token").asText();
            int expireIn = jsonObj.get("expires_in").asInt();
            TokenModel agentModel = new TokenModel();
            agentModel.setCorpToken(token, expireIn);
            ExtUniUtil.putModel(agentModel, agentModelList);
            return token;
        }
        TokenModel agentModel = new TokenModel();
        agentModel.setInit(false);
        ExtUniUtil.putModel(agentModel, agentModelList);
        String errMsg = jsonObj.get("errmsg").asText();
        log.error(errMsg);
        throw new RuntimeException("\u83b7\u53d6accessToken\u5931\u8d25:" + errMsg);
    }

    public static boolean clearToken() {
        String tenantId = TenantUtil.getCurrentTenantId();
        if (StringUtil.isEmpty((String)tenantId)) {
            tenantId = "-1";
        }
        try {
            modelList.put(tenantId, new TokenModel());
            agentModelList.put(tenantId, new TokenModel());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error(ex.getMessage());
            return false;
        }
        return true;
    }
}

