/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.jms.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.cache.annotation.CachePut;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.conf.JmsConfig;
import com.hotent.base.conf.SaaSConfig;
import com.hotent.base.context.BaseContext;
import com.hotent.base.entity.URIEntity;
import com.hotent.base.handler.MultiTenantHandler;
import com.hotent.base.jms.JmsConsumerService;
import com.hotent.base.jms.JmsHandler;
import com.hotent.base.jms.JmsMessage;
import com.hotent.base.jms.JmsNoticeConsumerService;
import com.hotent.base.jms.JmsProducer;
import com.hotent.base.jms.Notice;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ExtendClassLoader;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.jms.api.BpmRunTimeServer;
import com.hotent.jms.api.PortalServer;
import com.hotent.jms.model.JmsSysTypeChangeMessage;
import com.hotent.jms.model.JmsTableTypeConf;
import com.hotent.jms.model.JmsTableTypeFiledDetail;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class JmsConsumerServiceImpl
implements JmsConsumerService {
    private static final Log logger = LogFactory.getLog(JmsConsumerService.class);
    private Map<String, JmsHandler> jmsHandlerMap = new HashMap<String, JmsHandler>();
    private Set<URIEntity> uriEntitySet = new HashSet<URIEntity>();
    @Resource
    JmsNoticeConsumerService jmsNoticeConsumerService;
    @Resource
    CommonManager commonManager;
    @Resource
    BaseContext baseContext;
    @Resource
    BpmRunTimeServer bpmRunTimeServer;
    @Resource
    JmsConfig jmsConfig;
    @Resource
    JmsProducer jmsProducer;
    @Resource
    PortalServer portalServer;
    @Value(value="${openApi.prefix:'openApi'}")
    private String PREFIX;

    private void initJmsHandList() {
        if (BeanUtils.isNotEmpty(this.jmsHandlerMap)) {
            return;
        }
        List jmsHandList = (List)AppUtil.getBean((String)"jmsHandList");
        for (JmsHandler handler : jmsHandList) {
            this.jmsHandlerMap.put(handler.getType(), handler);
        }
    }

    public void handlerJmsMessage(String source) {
        logger.debug((Object)("[JMS]:start consume jmsMessage:" + source));
        if (StringUtil.isEmpty((String)source)) {
            return;
        }
        try {
            ObjectNode object = (ObjectNode)JsonUtil.toJsonNode((String)source);
            if (BeanUtils.isEmpty((Object)object)) {
                return;
            }
            if (this.jmsConfig.isOtherQueueEnable()) {
                this.jmsProducer.sendToQueue((Object)object, this.jmsConfig.getOtherQueueName());
            }
            this.initJmsHandList();
            String tenantId = null;
            if (object.has("tenantId")) {
                tenantId = object.get("tenantId").asText();
            }
            if (object.hasNonNull("extendVars")) {
                JmsMessage jmsMessage = (JmsMessage)JsonUtil.toBean((JsonNode)object, JmsMessage.class);
                JmsHandler jmsHandler = this.jmsHandlerMap.get(jmsMessage.getType());
                if (StringUtil.isNotEmpty((String)tenantId)) {
                    this.baseContext.setTempTenantId(tenantId);
                }
                jmsHandler.send(jmsMessage);
            } else if (object.hasNonNull("messageTypes")) {
                if (StringUtil.isNotEmpty((String)tenantId)) {
                    this.baseContext.setTempTenantId(tenantId);
                }
                this.jmsNoticeConsumerService.sendNotice((Notice)JsonUtil.toBean((JsonNode)object, Notice.class), this.baseContext.getCurrentTenantId());
            }
        }
        catch (Exception e) {
            logger.error((Object)("[JMS]:consume jmsMessage fail:" + e.getMessage()));
        }
    }

    public void handlerSysLog(String source) {
        logger.debug((Object)("[JMS]:start consume sysLogMessage:" + source));
        if (StringUtil.isEmpty((String)source)) {
            return;
        }
        try {
            JsonNode jsonNode = JsonUtil.toJsonNode((String)source);
            if (BeanUtils.isNotEmpty((Object)jsonNode) && jsonNode.isObject()) {
                ObjectNode objectNode = (ObjectNode)jsonNode;
                String type = JsonUtil.getString((JsonNode)objectNode, (String)"type");
                String logType = JsonUtil.getString((JsonNode)objectNode, (String)"logType");
                String opName = JsonUtil.getString((JsonNode)objectNode, (String)"opeName");
                String executor = JsonUtil.getString((JsonNode)objectNode, (String)"executor");
                String ip = JsonUtil.getString((JsonNode)objectNode, (String)"ip");
                String reqUrl = JsonUtil.getString((JsonNode)objectNode, (String)"reqUrl");
                String elapsedTime = JsonUtil.getString((JsonNode)objectNode, (String)"elapsedTime");
                String systemType = JsonUtil.getString((JsonNode)objectNode, (String)"systemType", (String)"");
                if ("sysLog".equals(type)) {
                    String tenantId = JsonUtil.getString((JsonNode)objectNode, (String)"tenantId");
                    if (StringUtil.isNotEmpty((String)tenantId)) {
                        BaseContext baseContext = (BaseContext)AppUtil.getBean(BaseContext.class);
                        baseContext.setTempTenantId(tenantId);
                        this.jmsNoticeConsumerService.addSysLogs(JsonUtil.getString((JsonNode)objectNode, (String)"id"), opName, executor, ip, logType, JsonUtil.getString((JsonNode)objectNode, (String)"moduleType"), reqUrl, JsonUtil.getString((JsonNode)objectNode, (String)"opeContent"), elapsedTime, systemType);
                    } else {
                        logger.debug((Object)String.format("\u8bb0\u5f55\u65e5\u5fd7\u65f6\u672a\u83b7\u53d6\u5230tenantId\uff0c\u64cd\u4f5c\u540d\u79f0\uff1a%s\uff0c\u64cd\u4f5c\u4eba\uff1a%s\uff0cip\uff1a%s\uff0c\u8bf7\u6c42\u5730\u5740\uff1a%s", opName, executor, ip, reqUrl));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("[JMS]:consume jmsMessage fail:" + e.getMessage()));
        }
    }

    public void handlerSysTypeChange(String source) {
        logger.debug((Object)("[JMS]:start consume sysTypeChangeMessage:" + source));
        System.err.println(source);
        if (StringUtil.isEmpty((String)source)) {
            return;
        }
        try {
            JmsSysTypeChangeMessage type = (JmsSysTypeChangeMessage)JsonUtil.toBean((String)source, JmsSysTypeChangeMessage.class);
            if (StringUtil.isNotEmpty((String)type.getTypeGroupKey()) && JmsTableTypeConf.getTypeConf().containsKey(type.getTypeGroupKey().toUpperCase())) {
                List<JmsTableTypeFiledDetail> detailList = JmsTableTypeConf.getTypeConf().get(type.getTypeGroupKey().toUpperCase());
                for (JmsTableTypeFiledDetail jmsTableTypeFiledDetail : detailList) {
                    this.changeType(type, jmsTableTypeFiledDetail);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("[JMS]:consume sysTypeChangeMessage fail:" + e.getMessage()));
        }
    }

    private void changeType(JmsSysTypeChangeMessage type, JmsTableTypeFiledDetail detail) {
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("UPDATE ").append(detail.getTableName()).append(" set ");
        if (2 == type.getOpType()) {
            if (StringUtil.isNotEmpty((String)detail.getTypeIdFiledName())) {
                sqlSb.append(detail.getTypeIdFiledName()).append(" = ''");
            }
            type.setTypeName("");
        } else if (3 == type.getOpType() && StringUtil.isNotEmpty((String)detail.getTypeIdFiledName())) {
            sqlSb.append(detail.getTypeIdFiledName()).append(" = '");
            sqlSb.append(type.getTypeId()).append("'");
        }
        if (StringUtil.isNotEmpty((String)detail.getTypeNameFiledName())) {
            if (StringUtil.isNotEmpty((String)detail.getTypeIdFiledName()) && 1 != type.getOpType()) {
                sqlSb.append(",");
            }
            sqlSb.append(detail.getTypeNameFiledName()).append(" = '").append(type.getTypeName());
        }
        sqlSb.append("' where ");
        SaaSConfig saaSConfig = (SaaSConfig)AppUtil.getBean(SaaSConfig.class);
        if (saaSConfig.isEnable()) {
            MultiTenantHandler.setThreadLocalIgnore();
            sqlSb.append(detail.getTableName() + ".tenant_id_='" + type.getTenantId() + "' and ");
        }
        if (StringUtil.isNotEmpty((String)type.getOldTypeId())) {
            sqlSb.append(detail.getTableName() + "." + detail.getTypeIdFiledName() + "='" + type.getOldTypeId() + "' and ");
        }
        if (3 == type.getOpType() && StringUtil.isNotEmpty((String)detail.getPkFiledName())) {
            String sql = null;
            if (StringUtil.isNotEmpty((String)type.getEntityIds())) {
                sqlSb.append(detail.getPkFiledName()).append(" in ('").append(StringUtil.join((String[])type.getEntityIds().split(","), (String)"','")).append("')");
            } else {
                sql = sqlSb.lastIndexOf(" and ") >= 0 ? sqlSb.substring(0, sqlSb.lastIndexOf(" and ")) : sqlSb.substring(0, sqlSb.lastIndexOf(" where "));
            }
            this.commonManager.execute(sql == null ? sqlSb.toString() : sql);
        } else if (StringUtil.isNotEmpty((String)detail.getTypeIdFiledName())) {
            sqlSb.append(detail.getTypeIdFiledName()).append("='").append(type.getTypeId()).append("'");
            this.commonManager.execute(sqlSb.toString());
        } else if (StringUtil.isNotEmpty((String)detail.getTypeNameFiledName())) {
            sqlSb.append(detail.getTypeNameFiledName()).append("='").append(type.getOldTypeName()).append("'");
            this.commonManager.execute(sqlSb.toString());
        }
    }

    public void handlerUrlMessage(String source) {
        logger.debug((Object)("[JMS]:start consume UrlMessage:" + source));
        if (StringUtil.isEmpty((String)source)) {
            return;
        }
        try {
            URIEntity entity = (URIEntity)JsonUtil.toBean((String)source, URIEntity.class);
            if (BeanUtils.isNotEmpty((Object)entity)) {
                entity.setClassURI(entity.getClassURI().replace("${openApi.prefix}", this.PREFIX).replace("//", "/"));
                JmsConsumerServiceImpl jmsConsumerService = (JmsConsumerServiceImpl)AppUtil.getBean(this.getClass());
                this.uriEntitySet.add(entity);
                jmsConsumerService.putCache("openApi", this.uriEntitySet);
                logger.debug((Object)("[JMS]: queue message is :" + entity.getClass().getName() + "---" + entity));
            }
        }
        catch (Exception e) {
            logger.error((Object)("[JMS]:consume jmsMessage fail:" + e.getMessage()));
        }
    }

    @CachePut(value={"SYS_UC_OPEN_API"}, key="#openApi", firstCache=@FirstCache(timeUnit=TimeUnit.DAYS, expireTime=3650))
    private Set<URIEntity> putCache(String openApi, Set<URIEntity> set) {
        return set;
    }

    public void handlerPublishJar(String source) {
        logger.debug((Object)("[JMS]:start consume publishJar:" + source));
        if (StringUtil.isEmpty((String)source)) {
            logger.debug((Object)"[JMS]:jar id is empty, publish all jar!");
        }
        try {
            this.bpmRunTimeServer.publishJar(source);
        }
        catch (Exception e) {
            logger.error((Object)("[JMS]:consume jmsMessage fail:" + e.getMessage()));
        }
    }

    public void handlerRemoveExtendClass(String source) {
        logger.debug((Object)("[JMS]:start consume publishJar:" + source));
        if (StringUtil.isEmpty((String)source)) {
            return;
        }
        ExtendClassLoader.removeRegistedBean((String)source);
    }

    public void handlerAutoTest(String source) {
        logger.debug((Object)("[JMS]:start consume publishJar:" + source));
        if (StringUtil.isEmpty((String)source)) {
            return;
        }
        try {
            ObjectNode object = (ObjectNode)JsonUtil.toJsonNode((String)source);
            if (BeanUtils.isEmpty((Object)object)) {
                return;
            }
            this.bpmRunTimeServer.handlerAutoTest(object);
        }
        catch (Exception e) {
            logger.error((Object)("[JMS]:consume jmsMessage fail:" + e.getMessage()));
        }
    }

    public void handlerScheduleSync(String source) {
        logger.debug((Object)("[JMS]:start consume handlerScheduleSync:" + source));
        if (StringUtil.isEmpty((String)source)) {
            return;
        }
        try {
            JmsSysTypeChangeMessage type = (JmsSysTypeChangeMessage)JsonUtil.toBean((String)source, JmsSysTypeChangeMessage.class);
            if (StringUtil.isNotEmpty((String)type.getTypeGroupKey()) && JmsTableTypeConf.getTypeConf().containsKey(type.getTypeGroupKey().toUpperCase())) {
                List<JmsTableTypeFiledDetail> detailList = JmsTableTypeConf.getTypeConf().get(type.getTypeGroupKey().toUpperCase());
                for (JmsTableTypeFiledDetail jmsTableTypeFiledDetail : detailList) {
                    this.changeType(type, jmsTableTypeFiledDetail);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("[JMS]:consume sysTypeChangeMessage fail:" + e.getMessage()));
        }
    }

    public void handlerPreviewTrans(String source) {
        try {
            this.portalServer.handlerPreviewTrans(source);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("[JMS]:consume handlerPreviewTrans fail:" + e.getMessage()));
        }
    }
}

