/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.job.model;

import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.job.api.IJobLogService;
import com.hotent.job.model.SysJobLog;
import java.time.LocalDateTime;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Trigger;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.ResourceTransactionManager;

@DisallowConcurrentExecution
public abstract class BaseJob
implements Job {
    public abstract void executeJob(JobExecutionContext var1) throws Exception;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        String jobName = context.getJobDetail().getKey().getName();
        Boolean trans = false;
        JobDetail jobDetail = context.getJobDetail();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        Object transObj = jobDataMap.get((Object)"transaction");
        if (BeanUtils.isNotEmpty((Object)transObj)) {
            trans = Boolean.parseBoolean(transObj.toString());
        }
        String trigName = "directExec";
        Trigger trig = context.getTrigger();
        if (trig != null) {
            trigName = trig.getKey().getName();
        }
        LocalDateTime strStartTime = LocalDateTime.now();
        long startTime = System.currentTimeMillis();
        ResourceTransactionManager transactionManager = null;
        TransactionStatus status = null;
        if (trans.booleanValue()) {
            transactionManager = (ResourceTransactionManager)AppUtil.getBean((String)"transactionManager");
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            status = transactionManager.getTransaction((TransactionDefinition)def);
        }
        try {
            this.executeJob(context);
            long endTime = System.currentTimeMillis();
            LocalDateTime strEndTime = LocalDateTime.now();
            long runTime = (endTime - startTime) / 1000L;
            this.addLog(jobName, trigName, strStartTime, strEndTime, runTime, "\u4efb\u52a1\u6267\u884c\u6210\u529f!", SysJobLog.STATE_YES);
            if (trans.booleanValue()) {
                transactionManager.commit(status);
            }
        }
        catch (Exception ex) {
            if (trans.booleanValue()) {
                transactionManager.rollback(status);
            }
            long endTime = System.currentTimeMillis();
            LocalDateTime strEndTime = LocalDateTime.now();
            long runTime = (endTime - startTime) / 1000L;
            try {
                String rootCause = ExceptionUtils.getRootCauseMessage((Throwable)ex);
                this.addLog(jobName, trigName, strStartTime, strEndTime, runTime, rootCause, SysJobLog.STATE_NO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void addLog(String jobName, String trigName, LocalDateTime startTime, LocalDateTime endTime, long runTime, String content, Integer state) throws Exception {
        IJobLogService logService = (IJobLogService)AppUtil.getBean(IJobLogService.class);
        SysJobLog jobLog = new SysJobLog(jobName, trigName, startTime, endTime, content, state, runTime);
        String id = UniqueIdUtil.getSuid();
        jobLog.setId(id);
        logService.createLog(jobLog);
    }
}

