/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.job.conf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.quartz.SchedulerFactoryBeanCustomizer;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class QuartzConfigration
implements SchedulerFactoryBeanCustomizer {
    private DataSource dataSource;
    private PlatformTransactionManager transactionManager;

    @Autowired
    public QuartzConfigration(@Qualifier(value="dataSource") DataSource dataSource, @Qualifier(value="transactionManager") PlatformTransactionManager transactionManager) {
        this.dataSource = dataSource;
        this.transactionManager = transactionManager;
    }

    public void customize(SchedulerFactoryBean schedulerFactoryBean) {
        schedulerFactoryBean.setDataSource(this.dataSource);
        schedulerFactoryBean.setTransactionManager(this.transactionManager);
        ClassPathResource resource = new ClassPathResource("quartz.properties");
        Properties properties = new Properties();
        InputStream in = null;
        try {
            in = resource.getInputStream();
            BufferedReader bf = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            properties.load(bf);
            schedulerFactoryBean.setQuartzProperties(properties);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

