/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.job.job;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.BpmRuntimeFeignService;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.job.model.BaseJob;
import com.hotent.uc.api.impl.util.ContextUtil;
import javax.annotation.Resource;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class FlowStartJob
extends BaseJob {
    @Resource
    BpmRuntimeFeignService bpmRuntimeFeignService;

    @Override
    public void executeJob(JobExecutionContext context) throws Exception {
        String defaultAccount = "admin";
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String flowkey = jobDataMap.getString("flowkey");
        String startAccount = jobDataMap.getString("startAccount");
        if (StringUtil.isNotEmpty((String)startAccount)) {
            defaultAccount = startAccount;
        }
        ContextUtil.setCurrentUserByAccount((String)defaultAccount);
        if (BeanUtils.isEmpty((Object)flowkey)) {
            throw new BaseException("\u5b9a\u65f6\u542f\u52a8\u6d41\u7a0b\u7684\u81ea\u52a8\u4efb\u52a1\u4e2d\u5fc5\u987b\u914d\u7f6eflowkey\u6765\u6307\u5b9a\u8981\u542f\u52a8\u7684\u6d41\u7a0b.");
        }
        this.startFlow(flowkey, defaultAccount);
    }

    private void startFlow(String flowKey, String account) throws Exception {
        ObjectNode startFlowResult;
        ObjectNode startFlowParam = JsonUtil.getMapper().createObjectNode();
        startFlowParam.put("flowKey", flowKey);
        startFlowParam.put("account", account);
        if (this.bpmRuntimeFeignService == null) {
            this.bpmRuntimeFeignService = (BpmRuntimeFeignService)AppUtil.getBean(BpmRuntimeFeignService.class);
        }
        if (BeanUtils.isNotEmpty((Object)(startFlowResult = this.bpmRuntimeFeignService.start(startFlowParam))) && !startFlowResult.get("state").asBoolean()) {
            String message = "\u6d41\u7a0b\u542f\u52a8\u5931\u8d25";
            if (BeanUtils.isNotEmpty((Object)startFlowResult) && BeanUtils.isNotEmpty((Object)startFlowResult.get("message"))) {
                message = message + ":" + startFlowResult.get("message").asText();
            }
            throw new BaseException(message);
        }
    }
}

