/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.mail.persistence.manager.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.file.service.FileService;
import com.hotent.file.util.AppFileUtil;
import com.hotent.mail.model.MailAttachment;
import com.hotent.mail.persistence.dao.MailAttachmentDao;
import com.hotent.mail.persistence.manager.MailAttachmentManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="mailAttachmentManager")
public class MailAttachmentManagerImpl
extends BaseManagerImpl<MailAttachmentDao, MailAttachment>
implements MailAttachmentManager {
    @Resource
    FileService fileService;

    @Override
    public List<MailAttachment> getByMailId(String mailId) {
        return ((MailAttachmentDao)this.baseMapper).getByMailId(mailId);
    }

    @Override
    public void updateFilePath(String fileName, String mailId, String filePath) {
        ((MailAttachmentDao)this.baseMapper).updateFilePath(fileName, mailId, filePath);
    }

    @Override
    public List<MailAttachment> getByOutMailFileIds(String fileIds) throws Exception {
        ArrayList<MailAttachment> result = new ArrayList<MailAttachment>();
        if (StringUtil.isEmpty((String)fileIds)) {
            return result;
        }
        JsonNode jsonNode = JsonUtil.toJsonNode((String)fileIds);
        for (Object obj : jsonNode) {
            ObjectNode json = (ObjectNode)obj;
            String id = JsonUtil.getString((JsonNode)json, (String)"id", (String)"");
            String filePath = AppFileUtil.getBasePath() + File.separator + this.fileService.getFilePath(id);
            MailAttachment attachment = new MailAttachment();
            attachment.setId(id);
            attachment.setFileName(JsonUtil.getString((JsonNode)json, (String)"name", (String)""));
            attachment.setFilePath(filePath);
            result.add(attachment);
        }
        return result;
    }

    @Override
    public void delByMailId(String mailId) {
        ((MailAttachmentDao)this.baseMapper).delByMailId(mailId);
    }
}

