/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.mail.controller;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.file.util.AppFileUtil;
import com.hotent.mail.model.Mail;
import com.hotent.mail.model.MailAttachment;
import com.hotent.mail.model.MailLinkman;
import com.hotent.mail.model.MailSetting;
import com.hotent.mail.persistence.manager.MailAttachmentManager;
import com.hotent.mail.persistence.manager.MailLinkmanManager;
import com.hotent.mail.persistence.manager.MailManager;
import com.hotent.mail.persistence.manager.MailSettingManager;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mail/mail/mail/v1/"})
@Api(tags={"\u5916\u90e8\u90ae\u4ef6"})
@ApiGroup(group={"group_portal"})
public class MailController
extends BaseController<MailManager, Mail> {
    @Resource
    MailManager mailManager;
    @Resource
    MailSettingManager mailSettingManager;
    @Resource
    MailAttachmentManager mailAttachmentManager;
    @Resource
    MailLinkmanManager mailLinkmanManager;
    @Resource
    IUserService is;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5916\u90e8\u90ae\u4ef6\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u5916\u90e8\u90ae\u4ef6\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<Mail> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        String userId = ContextUtil.getCurrentUserId();
        List query = queryFilter.getQuerys();
        for (QueryField queryField : query) {
            System.out.println(queryField.getProperty());
            if ("subject".equals(queryField.getProperty())) {
                queryField.setGroup("mail");
                continue;
            }
            if ("senderAddress".equals(queryField.getProperty())) {
                queryField.setGroup("mail");
                continue;
            }
            if (!"senderName".equals(queryField.getProperty())) continue;
            queryField.setGroup("mail");
        }
        QueryField qf = new QueryField();
        qf.setGroup("mainplus");
        qf.setOperation(QueryOP.EQUAL);
        qf.setProperty("userId");
        qf.setRelation(FieldRelation.AND);
        qf.setValue((Object)userId);
        query.add(qf);
        PageList pageList = this.mailManager.query(queryFilter);
        List list = pageList.getRows();
        for (Mail m : list) {
            MailLinkman mailman = this.mailLinkmanManager.findLinkMan(m.getSenderAddress(), userId);
            if (mailman != null) {
                m.setIsExitedMan("0");
                continue;
            }
            m.setIsExitedMan("1");
        }
        return pageList;
    }

    @RequestMapping(value={"mailList"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u5f97\u90ae\u4ef6\u5206\u9875\u5217\u8868", httpMethod="GET", notes="\u53d6\u5f97\u90ae\u4ef6\u5206\u9875\u5217\u8868")
    public CommonResult<List<Mail>> mailList(@ApiParam(name="id", value="\u9ed8\u8ba4\u90ae\u7bb1id", required=true) @RequestParam String mailSetId, @ApiParam(name="types", value="\u7c7b\u578b", required=true) @RequestParam String type, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter, HttpServletResponse response) throws Exception {
        IUser user = ContextUtil.getCurrentUser();
        String userId = user.getUserId();
        MailSetting defaultMail = this.mailSettingManager.getByIsDefault(userId);
        if (BeanUtils.isEmpty((Object)((Object)defaultMail))) {
            return new CommonResult(false, "\u65e0\u9ed8\u8ba4\u90ae\u7bb1\uff01");
        }
        queryFilter.addFilter("userId", (Object)userId, QueryOP.EQUAL);
        queryFilter.addFilter("setId", (Object)mailSetId, QueryOP.EQUAL);
        queryFilter.addFilter("type", (Object)type, QueryOP.EQUAL);
        List<Mail> list = this.mailManager.getFolderList(queryFilter);
        return new CommonResult(true, "", list);
    }

    @RequestMapping(value={"mailSettingList"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u5f97\u90ae\u4ef6\u914d\u7f6e\u5217\u8868", httpMethod="GET", notes="\u53d6\u5f97\u90ae\u4ef6\u914d\u7f6e\u5217\u8868")
    public MailSetting mailList(@ApiParam(name="mailSetId", value="\u9ed8\u8ba4\u90ae\u7bb1id", required=true) @RequestParam String mailSetId) throws Exception {
        MailSetting setting = (MailSetting)this.mailSettingManager.get((Serializable)((Object)mailSetId));
        return setting;
    }

    @RequestMapping(value={"sync"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u90ae\u7bb1\u540c\u6b65\u5904\u7406", httpMethod="POST", notes="\u90ae\u7bb1\u540c\u6b65\u5904\u7406")
    public CommonResult<String> executeJob(@ApiParam(name="id", value="\u90ae\u7bb1id", required=true) @RequestParam String id) throws Exception {
        MailSetting mailSetting = (MailSetting)this.mailSettingManager.get((Serializable)((Object)id));
        String userId = ContextUtil.getCurrentUserId();
        ArrayList<Mail> mailList = new ArrayList();
        try {
            mailList = this.mailManager.getMailListBySetting(mailSetting);
            this.mailManager.saveMail(mailList, id, userId);
            return new CommonResult(true, "\u540c\u6b65\u90ae\u4ef6\u6210\u529f", null);
        }
        catch (Exception e) {
            String message = null;
            String str = ThreadMsgUtil.getMessage();
            if (StringUtil.isNotEmpty((String)str)) {
                message = "\u540c\u6b65\u90ae\u4ef6\u5931\u8d25:" + str;
            } else {
                message = "\u540c\u6b65\u90ae\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u90ae\u7bb1\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\uff01";
                e.printStackTrace();
            }
            return new CommonResult(false, message, null);
        }
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5916\u90e8\u90ae\u4ef6\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u83b7\u53d6\u5916\u90e8\u90ae\u4ef6\u660e\u7ec6\u9875\u9762")
    @ResponseBody
    public Mail getJson(@ApiParam(name="id", value="\u90ae\u7bb1id", required=true) @RequestParam String id) throws Exception {
        if (StringUtil.isEmpty((String)id)) {
            return new Mail();
        }
        Mail mail = (Mail)this.mailManager.get((Serializable)((Object)id));
        short type = mail.getType();
        if (type == Mail.Mail_InBox) {
            this.mailManager.emailRead(mail);
        }
        List<MailAttachment> attachments = this.mailAttachmentManager.getByMailId(mail.getId());
        attachments = type == Mail.Mail_OutBox || type == Mail.Mail_DraftBox ? this.mailAttachmentManager.getByOutMailFileIds(mail.getFileIds()) : this.mailAttachmentManager.getByMailId(mail.getId());
        mail.setMailAttachments(attachments);
        return mail;
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5916\u90e8\u90ae\u4ef6\u8bb0\u5f55", httpMethod="POST", notes="\u6279\u91cf\u5220\u9664\u5916\u90e8\u90ae\u4ef6\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="id", value="\u90ae\u7bb1id", required=true) @RequestParam String ids, @ApiParam(name="types", value="\u90ae\u7bb1\u7c7b\u578b", required=true) @RequestParam String type) throws Exception {
        String[] lAryId = StringUtil.getStringAryByStr((String)ids);
        String message = null;
        try {
            if (Integer.parseInt(type) == 4) {
                this.mailManager.removeByIds(Arrays.asList(lAryId));
                message = "\u6210\u529f\u5220\u9664\u672c\u5730\u4e0a\u90ae\u4ef6!";
            } else {
                this.mailManager.addDump(lAryId);
                message = "\u6210\u529f\u5c06\u90ae\u4ef6\u79fb\u81f3\u5783\u573e\u7bb1";
            }
            return new CommonResult(true, message, null);
        }
        catch (Exception ex) {
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25:" + ex.getMessage(), null);
        }
    }

    @RequestMapping(value={"warn"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u65e0\u90ae\u4ef6\u65f6\u7684\u63d0\u793a\u4fe1\u606f", httpMethod="POST", notes="\u65e0\u90ae\u4ef6\u65f6\u7684\u63d0\u793a\u4fe1\u606f")
    public int warn() throws Exception {
        String userId = ContextUtil.getCurrentUserId();
        int count = this.mailSettingManager.getCountByUserId(userId);
        return count;
    }

    @RequestMapping(value={"reply"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u56de\u590d\u90ae\u4ef6", httpMethod="POST", notes="\u56de\u590d\u90ae\u4ef6")
    @ResponseBody
    public Mail reply(@ApiParam(name="mailId", value="\u90ae\u7bb1id", required=true) @RequestParam String mailId) throws Exception {
        Mail mail = this.mailManager.getMailReply(mailId);
        return mail;
    }

    @RequestMapping(value={"getMailSetting"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u90ae\u7bb1\u914d\u7f6e", httpMethod="POST", notes="\u83b7\u53d6\u90ae\u7bb1\u914d\u7f6e")
    public MailSetting getMailSetting(@ApiParam(name="mailSetId", value="\u90ae\u7bb1\u914d\u7f6eid", required=true) @RequestParam String mailSetId) {
        MailSetting mailUserSeting = (MailSetting)this.mailSettingManager.get((Serializable)((Object)mailSetId));
        return mailUserSeting;
    }

    @RequestMapping(value={"get"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u5f97\u90ae\u4ef6\u660e\u7ec6", httpMethod="GET", notes="\u53d6\u5f97\u90ae\u4ef6\u660e\u7ec6")
    public List<MailAttachment> get(@ApiParam(name="mailId", value="\u90ae\u7bb1id", required=true) @RequestParam String mailId, @ApiParam(name="mailSetId", value="\u90ae\u7bb1\u914d\u7f6eid", required=true) @RequestParam String mailSetId) throws Exception {
        Mail mail = (Mail)this.mailManager.get((Serializable)((Object)mailId));
        short type = mail.getType();
        List<MailAttachment> attachments = this.mailAttachmentManager.getByMailId(mailId);
        if (type == Mail.Mail_InBox) {
            this.mailManager.emailRead(mail);
        }
        attachments = type == Mail.Mail_OutBox || type == Mail.Mail_DraftBox ? this.mailAttachmentManager.getByOutMailFileIds(mail.getFileIds()) : this.mailAttachmentManager.getByMailId(mailId);
        return attachments;
    }

    @RequestMapping(value={"getMail"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u5f97\u90ae\u4ef6", httpMethod="GET", notes="\u53d6\u5f97\u90ae\u4ef6")
    public Mail getMailList(@ApiParam(name="mailId", value="\u90ae\u7bb1id", required=true) @RequestParam String mailId) {
        Mail mail = null;
        mail = StringUtil.isNotZeroEmpty((String)mailId) ? new Mail() : (Mail)this.mailManager.get((Serializable)((Object)mailId));
        return mail;
    }

    @RequestMapping(value={"mailEdit"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u90ae\u4ef6\u7f16\u8f91", httpMethod="GET", notes="\u90ae\u4ef6\u7f16\u8f91")
    public List<MailSetting> edit(@ApiParam(name="mailId", value="\u90ae\u7bb1id", required=true) @RequestParam String mailId, @ApiParam(name="returnUrl", value="\u8fd4\u56de\u5730\u5740") @RequestParam String returnUrl) throws Exception {
        String userId = ContextUtil.getCurrentUserId();
        List<MailSetting> list = this.mailSettingManager.getMailByUserId(userId);
        return list;
    }

    @RequestMapping(value={"getMailTreeData"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u5f97\u90ae\u7bb1\u6811\u5f62\u5217\u8868\u7684json\u6570\u636e", httpMethod="GET", notes="\u83b7\u5f97\u90ae\u7bb1\u6811\u5f62\u5217\u8868\u7684json\u6570\u636e")
    public List<MailSetting> getMailTreeData() throws Exception {
        String userId = ContextUtil.getCurrentUserId();
        List<MailSetting> list = this.mailManager.getMailTreeData(userId);
        List json = BeanUtils.listToTree(list);
        return json;
    }

    @RequestMapping(value={"getRecieveServerTypeData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u90ae\u4ef6\u63a5\u6536\u670d\u52a1\u5668\u7c7b\u578b\u7684json\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u90ae\u4ef6\u63a5\u6536\u670d\u52a1\u5668\u7c7b\u578b\u7684json\u6570\u636e")
    public String getRecieveServerType(@ApiParam(name="mailSetId", value="\u90ae\u7bb1\u914d\u7f6eid", required=true) @RequestParam String mailSetId) throws Exception {
        MailSetting mailSetting = (MailSetting)this.mailSettingManager.get((Serializable)((Object)mailSetId));
        String type = mailSetting.getMailType();
        return type;
    }

    @RequestMapping(value={"send"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u6216\u66f4\u65b0\u90ae\u4ef6", httpMethod="POST", notes="\u6dfb\u52a0\u6216\u66f4\u65b0\u90ae\u4ef6")
    public CommonResult<Set<String>> save(@ApiParam(name="mail", value="\u90ae\u4ef6") @RequestBody Mail mail, HttpServletRequest request) throws Exception {
        short type = mail.getType();
        String userId = ContextUtil.getCurrentUserId();
        MailSetting mailSetting = this.mailSettingManager.getMailByAddress(mail.getSenderAddress());
        mail.setSendDate(LocalDateTime.now());
        mail.setIsReply(mail.getIsReply());
        mail.setUserId(userId);
        mail.setSenderName(mailSetting.getNickName());
        mail.setSetId(mailSetting.getId());
        String context = request.getContextPath();
        String basePath = AppFileUtil.getBasePath();
        String msg = "\u90ae\u4ef6\u53d1\u9001";
        try {
            Set<String> list = this.getMailAddress(mail);
            if (type == 2) {
                if ("exchange".equals(mailSetting.getMailType())) {
                    this.mailManager.sendExchangeMail(mailSetting, mail);
                    mail.setIsRead((short)0);
                    mail.setContent(Base64.getBase64((String)mail.getContent()));
                    Mail notnull = (Mail)this.mailManager.get((Serializable)((Object)mail.getId()));
                    if (notnull != null) {
                        this.mailManager.update((Model)mail);
                    } else {
                        this.mailManager.create((Model)mail);
                    }
                } else {
                    this.mailManager.sendMail(mail, userId, mail.getId(), mail.getIsReply().shortValue(), context, basePath);
                    mail.setContent(Base64.getBase64((String)mail.getContent()));
                    mail.setIsRead((short)0);
                    Mail notnull = (Mail)this.mailManager.get((Serializable)((Object)mail.getId()));
                    if (notnull != null) {
                        this.mailManager.update((Model)mail);
                    } else {
                        this.mailManager.create((Model)mail);
                    }
                }
                return new CommonResult(true, "\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
            }
            if (StringUtil.isZeroEmpty((String)mail.getId())) {
                mail.setId(UniqueIdUtil.getSuid());
                mail.setContent(Base64.getBase64((String)mail.getContent()));
                mail.setIsRead((short)0);
                this.mailManager.create((Model)mail);
                msg = "\u90ae\u4ef6\u4fdd\u5b58";
            } else {
                this.mailManager.update((Model)mail);
                msg = "\u90ae\u4ef6\u66f4\u65b0";
            }
            Set<String> set = this.checkAddress(list);
            return new CommonResult(true, msg + "\u6210\u529f", set);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, msg + "\u5931\u8d25!", null);
        }
    }

    private void handLinkMan(String userId, Set<String> list, String mailId) throws Exception {
        MailLinkman man = null;
        for (String address : list) {
            man = this.mailLinkmanManager.findLinkMan(address, userId);
            String linkName = this.mailManager.getNameByEmail(address);
            if (man != null) {
                man.setSendTimes(man.getSendTimes() + 1L);
                man.setMailId(mailId);
                man.setLinkName(linkName);
                man.setLinkAddress(address);
                LocalDateTime date = LocalDateTime.now();
                man.setSendTime(date);
                this.mailLinkmanManager.update((Model)man);
                continue;
            }
            man = new MailLinkman();
            man.setSendTimes(1L);
            man.setUserId(userId);
            man.setMailId(mailId);
            man.setLinkName(linkName);
            man.setSendTime(LocalDateTime.now());
            man.setLinkAddress(address);
            man.setId(UniqueIdUtil.getSuid());
            this.mailLinkmanManager.create((Model)man);
        }
    }

    private Set<String> getMailAddress(Mail mail) {
        String toAddess = mail.getReceiverAddresses();
        String ccAddress = mail.getCopyToAddresses();
        String bccAddress = mail.getBcCAddresses();
        ArrayList<String> list = new ArrayList<String>();
        this.addAddress(toAddess, list);
        this.addAddress(ccAddress, list);
        this.addAddress(bccAddress, list);
        HashSet<String> set = new HashSet<String>(list);
        return set;
    }

    private void addAddress(String address, List<String> list) {
        String[] aryAddress;
        if (StringUtil.isEmpty((String)address)) {
            return;
        }
        address = StringUtil.trim((String)address, (String)",");
        for (String addr : aryAddress = address.split(",")) {
            list.add(addr);
        }
    }

    private Set<String> checkAddress(Set<String> set) {
        HashSet<String> rtnset = new HashSet<String>();
        for (String addr : set) {
            List list = this.is.getByEmail(addr);
            if (BeanUtils.isNotEmpty((Object)list)) continue;
            rtnset.add(addr);
        }
        return rtnset;
    }

    @RequestMapping(value={"getToReadMailList"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u672a\u8bfb\u90ae\u4ef6\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u672a\u8bfb\u90ae\u4ef6\u5217\u8868")
    public PageList<Mail> getToReadMailList() throws Exception {
        String userId = ContextUtil.getCurrentUserId();
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), Integer.valueOf(15)));
        queryFilter.addFilter("USER_ID_", (Object)userId, QueryOP.EQUAL);
        queryFilter.addFilter("TYPE_", (Object)1, QueryOP.EQUAL);
        queryFilter.addFilter("IS_READ_", (Object)0, QueryOP.EQUAL);
        PageList mailList = this.mailManager.query(queryFilter);
        return mailList;
    }

    @RequestMapping(value={"isRead"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u90ae\u4ef6\u53d8\u6210\u5df2\u8bfb", httpMethod="GET", notes="\u90ae\u4ef6\u53d8\u6210\u5df2\u8bfb")
    public void isRead(@ApiParam(name="id", value="id", required=true) @RequestParam String id) {
        this.mailManager.isRead(id);
    }
}

