/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.mail.controller;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.mail.model.MailLinkman;
import com.hotent.mail.persistence.manager.MailLinkmanManager;
import com.hotent.mail.persistence.manager.MailManager;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.service.IUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Controller
@RestController
@RequestMapping(value={"/mail/mail/mailLinkman/v1/"})
@Api(tags={"\u5916\u90e8\u90ae\u4ef6\u8054\u7cfb\u4eba"})
@ApiGroup(group={"group_portal"})
public class MailLinkmanController
extends BaseController<MailLinkmanManager, MailLinkman> {
    @Resource
    MailLinkmanManager mailLinkmanManager;
    @Resource
    MailManager mailManager;
    @Resource
    IUserService ius;
    @Resource
    UCFeignService ucService;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5916\u90e8\u90ae\u4ef6\u6700\u8fd1\u8054\u7cfb\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u5916\u90e8\u90ae\u4ef6\u6700\u8fd1\u8054\u7cfb\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<MailLinkman> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        queryFilter.addFilter("userId", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL, FieldRelation.AND, "userId");
        return this.mailLinkmanManager.query(queryFilter);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5916\u90e8\u90ae\u4ef6\u6700\u8fd1\u8054\u7cfb\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u5916\u90e8\u90ae\u4ef6\u6700\u8fd1\u8054\u7cfb\u660e\u7ec6\u9875\u9762")
    @ResponseBody
    public MailLinkman getJson(@ApiParam(name="id", value="\u8054\u7cfbid", required=true) @RequestParam String id) throws Exception {
        if (StringUtil.isEmpty((String)id)) {
            return new MailLinkman();
        }
        MailLinkman mailLinkman = (MailLinkman)this.mailLinkmanManager.get((Serializable)((Object)id));
        return mailLinkman;
    }

    @RequestMapping(value={"getLinkMan"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u90ae\u7bb1\u5730\u5740\u67e5\u8be2\u8054\u7cfb\u4eba\u4fe1\u606f", httpMethod="GET", notes="\u901a\u8fc7\u90ae\u7bb1\u5730\u5740\u67e5\u8be2\u8054\u7cfb\u4eba\u4fe1\u606f")
    @ResponseBody
    public CommonResult<String> getLinkMan(@ApiParam(name="mailId", value="\u90ae\u7bb1\u5730\u5740", required=true) @RequestParam String mailId) throws Exception {
        String userId = ContextUtil.getCurrentUserId();
        MailLinkman mailLinkman = this.mailLinkmanManager.findLinkMan(mailId, userId);
        if (mailLinkman != null) {
            return new CommonResult(true, "1");
        }
        return new CommonResult(true, "2");
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u5916\u90e8\u90ae\u4ef6\u6700\u8fd1\u8054\u7cfb\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u5916\u90e8\u90ae\u4ef6\u6700\u8fd1\u8054\u7cfb\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="mailLinkman", value="\u8ba1\u5212\u540d\u79f0") @RequestBody MailLinkman mailLinkman) throws Exception {
        String resultMsg = null;
        String LINKID = mailLinkman.getId();
        String mailId = mailLinkman.getMailId();
        String userId = ContextUtil.getCurrentUserId();
        mailLinkman.setUserId(userId);
        try {
            if (StringUtil.isEmpty((String)LINKID)) {
                MailLinkman mailman = this.mailLinkmanManager.findLinkMan(mailId, userId);
                if (mailman != null) {
                    resultMsg = "\u8be5\u90ae\u7bb1\u5730\u5740\u5df2\u5b58\u5728\uff0c\u65e0\u987b\u91cd\u590d\u6dfb\u52a0";
                    return new CommonResult(false, resultMsg);
                }
                mailLinkman.setId(UniqueIdUtil.getSuid());
                this.mailLinkmanManager.create((Model)mailLinkman);
                resultMsg = "\u6dfb\u52a0\u90ae\u7bb1\u8054\u7cfb\u4eba\u6210\u529f";
            } else {
                this.mailLinkmanManager.update((Model)mailLinkman);
                resultMsg = "\u66f4\u65b0\u90ae\u7bb1\u8054\u7cfb\u4eba\u6210\u529f";
            }
            return new CommonResult(true, resultMsg);
        }
        catch (Exception e) {
            resultMsg = "\u5bf9\u5916\u90e8\u90ae\u4ef6\u6700\u8fd1\u8054\u7cfb\u64cd\u4f5c\u5931\u8d25";
            return new CommonResult(false, resultMsg);
        }
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5916\u90e8\u90ae\u4ef6\u6700\u8fd1\u8054\u7cfb\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u5916\u90e8\u90ae\u4ef6\u6700\u8fd1\u8054\u7cfb\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u8054\u7cfb\u4ebaids", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = StringUtil.getStringAryByStr((String)ids);
            this.mailLinkmanManager.removeByIds(Arrays.asList(aryIds));
            return new CommonResult(true, "\u5220\u9664\u5916\u90e8\u90ae\u4ef6\u6700\u8fd1\u8054\u7cfb\u6210\u529f", null);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u5916\u90e8\u90ae\u4ef6\u6700\u8fd1\u8054\u7cfb\u5931\u8d25", null);
        }
    }

    @RequestMapping(value={"getMailLinkmanData"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6700\u8fd1\u8054\u7cfb\u4eba\u6811\u5f62\u5217\u8868\u7684json\u6570\u636e", httpMethod="GET", notes="\u6700\u8fd1\u8054\u7cfb\u4eba\u6811\u5f62\u5217\u8868\u7684json\u6570\u636e")
    public List<MailLinkman> getOutMailLinkmanData(@ApiParam(name="condition", value="\u6700\u8fd1\u8054\u7cfb", required=true) @RequestParam String condition) throws Exception {
        String userId = ContextUtil.getCurrentUserId();
        List<MailLinkman> mailLinkmans = this.mailLinkmanManager.getAllByUserId(userId, condition);
        ArrayList<MailLinkman> mailLinkmanList = new ArrayList<MailLinkman>();
        for (MailLinkman man : mailLinkmans) {
            String linkName = this.mailManager.getNameByEmail(man.getLinkAddress());
            man.setLinkAddress(linkName + "(" + man.getLinkAddress() + ")");
            man.setLinkName(linkName);
            mailLinkmanList.add(man);
        }
        return mailLinkmanList;
    }

    @RequestMapping(value={"getMailAndUserData"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u90ae\u7bb1\u8054\u7cfb\u4eba\u548c\u7528\u6237", httpMethod="GET", notes="\u6a21\u7cca\u67e5\u8be2\u90ae\u7bb1\u8054\u7cfb\u4eba\u548c\u7528\u6237")
    @ResponseBody
    public List<MailLinkman> getMailAndUserData(@ApiParam(name="query", value="\u67e5\u8be2\u6761\u4ef6", required=true) @RequestParam String query) throws Exception {
        ArrayList<MailLinkman> mailLinkmanList = new ArrayList();
        if (StringUtil.isEmpty((String)query)) {
            return new ArrayList<MailLinkman>();
        }
        query = "%" + query + "%";
        mailLinkmanList = this.mailLinkmanManager.queryByAll(query);
        List list = this.ucService.getUserByNameaAndEmal(query);
        if (BeanUtils.isNotEmpty((Object)list)) {
            for (ObjectNode o : list) {
                ObjectNode org;
                MailLinkman mail = new MailLinkman();
                String userId = o.get("id").asText();
                String name = o.get("fullname").asText();
                if (o.get("email") != null) {
                    String email = o.get("email").asText();
                    mail.setMailId(email);
                }
                if ((org = this.ucService.getMainGroup(userId)) != null) {
                    String orgName = org.get("name").asText();
                    mail.setOrgName(orgName);
                }
                mail.setId(userId);
                mail.setLinkName(name);
                mailLinkmanList.add(mail);
            }
        }
        return mailLinkmanList;
    }
}

