/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.mail.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.mail.model.MailSetting;
import com.hotent.mail.persistence.manager.MailSettingManager;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.service.IUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mail/mail/mailSetting/v1/"})
@Api(tags={"\u5916\u90e8\u90ae\u4ef6\u8bbe\u7f6e"})
@ApiGroup(group={"group_portal"})
public class MailSettingController
extends BaseController<MailSettingManager, MailSetting> {
    @Resource
    MailSettingManager mailSettingManager;
    @Resource
    IUserService ius;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5916\u90e8\u90ae\u4ef6\u7528\u6237\u8bbe\u7f6e\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u5916\u90e8\u90ae\u4ef6\u7528\u6237\u8bbe\u7f6e\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<MailSetting> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        queryFilter.addFilter("userId", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL, FieldRelation.AND, "userId");
        return this.mailSettingManager.query(queryFilter);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5916\u90e8\u90ae\u4ef6\u7528\u6237\u8bbe\u7f6e\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u83b7\u53d6\u5916\u90e8\u90ae\u4ef6\u7528\u6237\u8bbe\u7f6e\u660e\u7ec6\u9875\u9762")
    @ResponseBody
    public MailSetting getJson(@ApiParam(name="id", value="\u90ae\u7bb1\u8bbe\u7f6eid", required=true) @RequestParam String id) throws Exception {
        return (MailSetting)this.mailSettingManager.get((Serializable)((Object)id));
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u5916\u90e8\u90ae\u4ef6\u7528\u6237\u8bbe\u7f6e\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u5916\u90e8\u90ae\u4ef6\u7528\u6237\u8bbe\u7f6e\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="mailSetting", value="\u90ae\u7bb1\u8bbe\u7f6e") @RequestBody MailSetting mailSetting, @ApiParam(name="isOriginPwd", value="\u662f\u5426\u539f\u59cb\u5bc6\u7801", required=true) @RequestParam Optional<Boolean> isOriginPwd) throws Exception {
        try {
            this.mailSettingManager.saveSetting(mailSetting, isOriginPwd.orElse(false), ContextUtil.getCurrentUserId());
            return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            return new CommonResult(false, message);
        }
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5916\u90e8\u90ae\u4ef6\u7528\u6237\u8bbe\u7f6e\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u5916\u90e8\u90ae\u4ef6\u7528\u6237\u8bbe\u7f6e\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u5916\u90e8\u90ae\u4ef6\u7528\u6237id", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = StringUtil.getStringAryByStr((String)ids);
            this.mailSettingManager.removeByIds(Arrays.asList(aryIds));
            return new CommonResult(true, "\u5220\u9664\u5916\u90e8\u90ae\u4ef6\u7528\u6237\u8bbe\u7f6e\u6210\u529f", null);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u5916\u90e8\u90ae\u4ef6\u7528\u6237\u8bbe\u7f6e\u5931\u8d25", null);
        }
    }

    @RequestMapping(value={"test"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d4b\u8bd5\u63a5\u6536/\u53d1\u9001 \u670d\u52a1\u5668\u8fde\u63a5\u60c5\u51b5", httpMethod="POST", notes="\u6d4b\u8bd5\u63a5\u6536/\u53d1\u9001 \u670d\u52a1\u5668\u8fde\u63a5\u60c5\u51b5")
    public CommonResult<String> test(@ApiParam(name="id", value="\u8ba1\u5212\u540d\u79f0", required=true) @RequestParam Optional<String> id, @ApiParam(name="isOriginPwd", value="\u662f\u5426\u539f\u59cb\u5bc6\u7801", required=true) @RequestParam Optional<Boolean> isOriginPwd, @ApiParam(name="mailSetting", value="\u90ae\u7bb1\u8bbe\u7f6e") @RequestBody @Valid Optional<MailSetting> mailSetting) throws Exception {
        try {
            MailSetting setting = mailSetting.orElse(null);
            if (BeanUtils.isNotEmpty((Object)((Object)setting)) && setting.getMailType() != null) {
                this.mailSettingManager.testConnection(setting, isOriginPwd.orElse(false));
            } else {
                this.mailSettingManager.testConnection(id.orElse(null));
            }
            return new CommonResult();
        }
        catch (Exception ex) {
            String message = "\u6d4b\u8bd5\u8fde\u63a5\u5931\u8d25,\u8bf7\u68c0\u67e5\u90ae\u7bb1\u914d\u7f6e";
            return new CommonResult(false, message);
        }
    }

    @RequestMapping(value={"setDefault"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u6539\u9ed8\u8ba4\u90ae\u7bb1\u8bbe\u7f6e", httpMethod="POST", notes="\u66f4\u6539\u9ed8\u8ba4\u90ae\u7bb1\u8bbe\u7f6e")
    public CommonResult<String> setupDefault(@ApiParam(name="id", value="\u90ae\u7bb1\u8bbe\u7f6eid", required=true) @RequestParam String id) throws Exception {
        String userId = ContextUtil.getCurrentUserId();
        MailSetting mailSetting = (MailSetting)this.mailSettingManager.get((Serializable)((Object)id));
        mailSetting.setIsDefault((short)1);
        try {
            this.mailSettingManager.setDefault(mailSetting, userId);
            return new CommonResult(true, "\u8bbe\u7f6e\u6210\u529f!");
        }
        catch (Exception ex) {
            return new CommonResult(false, "\u8bbe\u7f6e\u5931\u8d25!");
        }
    }
}

