/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.mail.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.exception.NotFoundException;
import com.hotent.base.exception.ServerRejectException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.EncryptUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.mail.model.MailSetting;
import com.hotent.mail.persistence.dao.MailSettingDao;
import com.hotent.mail.persistence.manager.MailManager;
import com.hotent.mail.persistence.manager.MailSettingManager;
import com.hotent.mail.util.ExchangeMailUtil;
import com.hotent.mail.util.MailUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.service.IUserService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="mailSettingManager")
public class MailSettingManagerImpl
extends BaseManagerImpl<MailSettingDao, MailSetting>
implements MailSettingManager {
    @Resource
    MailManager mailManager;
    @Resource
    IUserService userService;

    @Override
    public void testConnection(String setId) throws Exception {
        MailSetting mailSetting = (MailSetting)this.get((Serializable)((Object)setId));
        if (BeanUtils.isEmpty((Object)((Object)mailSetting))) {
            throw new NotFoundException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u90ae\u7bb1\u8d26\u53f7");
        }
        MailSetting seting = this.getBymailSetting(mailSetting);
        this.test(seting);
    }

    @Override
    public void testConnection(MailSetting mailSetting, boolean isOriginPwd) throws Exception {
        String id = mailSetting.getId();
        if (isOriginPwd || StringUtil.isEmpty((String)id)) {
            String password = mailSetting.getPassword();
            mailSetting.setPassword(EncryptUtil.encrypt((String)password));
        }
        MailSetting seting = this.getBymailSetting(mailSetting);
        this.test(seting);
    }

    private void test(MailSetting mailSetting) throws Exception {
        String mailType = mailSetting.getMailType();
        if ("exchange".equals(mailType)) {
            String sendPort = mailSetting.getSendPort();
            ExchangeMailUtil ma = new ExchangeMailUtil(sendPort, mailSetting.getMailAddress(), mailSetting.getPassword());
            ma.receive(1);
        } else {
            MailUtil mailUtil = new MailUtil(mailSetting);
            mailUtil.connectSmtpAndReceiver();
        }
    }

    public MailSetting getBymailSetting(MailSetting mailSetting) throws Exception {
        MailSetting seting = new MailSetting();
        String protocal = mailSetting.getMailType();
        seting.setProtocal(protocal);
        seting.setMailAddress(mailSetting.getMailAddress());
        seting.setPassword(EncryptUtil.decrypt((String)mailSetting.getPassword()));
        seting.setNickName(mailSetting.getNickName());
        seting.setSSL(mailSetting.getSSL());
        seting.setValidate(mailSetting.getValidate());
        seting.setIsDeleteRemote(mailSetting.getIsDeleteRemote());
        seting.setIsHandleAttach(mailSetting.getIsHandleAttach());
        seting.setMailType(mailSetting.getMailType());
        seting.setSendHost(mailSetting.getSmtpHost());
        seting.setSendPort(mailSetting.getSmtpPort());
        if ("pop3".equals(protocal)) {
            seting.setReceiveHost(mailSetting.getPopHost());
            seting.setReceivePort(mailSetting.getPopPort());
        } else {
            seting.setReceiveHost(mailSetting.getImapHost());
            seting.setReceivePort(mailSetting.getImapPort());
        }
        return seting;
    }

    @Override
    public void setDefault(MailSetting mailSetting, String currentUserId) throws Exception {
        MailSetting mail = ((MailSettingDao)this.baseMapper).getByIsDefault(currentUserId);
        if (BeanUtils.isNotEmpty((Object)((Object)mail))) {
            mail.setIsDefault((short)0);
            ((MailSettingDao)this.baseMapper).updateDefault(mail);
        }
        ((MailSettingDao)this.baseMapper).updateDefault(mailSetting);
    }

    @Override
    public boolean isExistMail(MailSetting mailSetting) throws Exception {
        String id = mailSetting.getId();
        String address = mailSetting.getMailAddress();
        if (StringUtil.isNotEmpty((String)id)) {
            return false;
        }
        int result = ((MailSettingDao)this.baseMapper).getCountByAddress(address);
        return result > 0;
    }

    @Override
    public MailSetting getMailByAddress(String address) {
        return ((MailSettingDao)this.baseMapper).getMailByAddress(address);
    }

    @Override
    public MailSetting getByIsDefault(String userId) {
        return ((MailSettingDao)this.baseMapper).getByIsDefault(userId);
    }

    @Override
    public List<MailSetting> getMailByUserId(String userId) {
        return ((MailSettingDao)this.baseMapper).getMailByUserId(userId);
    }

    @Override
    public List<MailSetting> getAllByUserId(QueryFilter queryFilter) {
        Map params = queryFilter.getParams();
        return ((MailSettingDao)this.baseMapper).getAllByUserId(params);
    }

    @Override
    public int getCountByUserId(String userId) {
        return ((MailSettingDao)this.baseMapper).getCountByUserId(userId);
    }

    @Override
    public void delAllByIds(String[] lAryId) {
        for (String setId : lAryId) {
            this.remove((Serializable)((Object)setId));
            this.mailManager.remove((Serializable)((Object)setId));
        }
    }

    @Override
    public void updateLastEnvelop(String id, String messageId, LocalDateTime lastReceiveTime) {
        ((MailSettingDao)this.baseMapper).updateLastEnvelop(id, messageId, lastReceiveTime);
    }

    @Override
    public void saveSetting(MailSetting mailSetting, boolean isOriginPwd, String userAccount) throws Exception {
        if (this.isExistMail(mailSetting)) {
            throw new ServerRejectException("\u8be5\u90ae\u7bb1\u5730\u5740\u5df2\u7ecf\u8bbe\u7f6e\u8fc7\uff0c\u4e0d\u80fd\u91cd\u590d\u8bbe\u7f6e");
        }
        String id = mailSetting.getId();
        mailSetting.setSendHost(mailSetting.getSmtpHost());
        mailSetting.setSendPort(mailSetting.getSmtpPort());
        if (mailSetting.getMailType().equals("pop3")) {
            mailSetting.setReceiveHost(mailSetting.getPopHost());
            mailSetting.setReceivePort(mailSetting.getPopPort());
        } else {
            mailSetting.setReceiveHost(mailSetting.getImapHost());
            mailSetting.setReceivePort(mailSetting.getImapPort());
        }
        if (StringUtil.isEmpty((String)id)) {
            mailSetting.setId(UniqueIdUtil.getSuid());
            String userId = ContextUtil.getCurrentUserId();
            mailSetting.setUserId(userId);
            mailSetting.setProtocal(mailSetting.getMailType());
            mailSetting.setPassword(EncryptUtil.encrypt((String)mailSetting.getPassword()));
            int count = this.getCountByUserId(userId);
            if (count == 0) {
                mailSetting.setIsDefault((short)1);
            } else {
                mailSetting.setIsDefault((short)0);
            }
            this.create((Model)mailSetting);
        } else {
            String mailPass = mailSetting.getPassword();
            if (isOriginPwd) {
                mailSetting.setPassword(EncryptUtil.encrypt((String)mailPass));
            }
            this.update((Model)mailSetting);
        }
    }
}

