/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.mail.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.hotent.base.attachment.Attachment;
import com.hotent.base.attachment.AttachmentService;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.file.model.FileInfo;
import com.hotent.file.service.FileService;
import com.hotent.file.util.AppFileUtil;
import com.hotent.mail.api.AttacheHandler;
import com.hotent.mail.model.Mail;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.BodyType;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.enumeration.search.SortDirection;
import microsoft.exchange.webservices.data.core.service.folder.Folder;
import microsoft.exchange.webservices.data.core.service.item.EmailMessage;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.core.service.schema.EmailMessageSchema;
import microsoft.exchange.webservices.data.core.service.schema.ItemSchema;
import microsoft.exchange.webservices.data.credential.ExchangeCredentials;
import microsoft.exchange.webservices.data.credential.WebCredentials;
import microsoft.exchange.webservices.data.property.complex.AttachmentCollection;
import microsoft.exchange.webservices.data.property.complex.EmailAddress;
import microsoft.exchange.webservices.data.property.complex.MessageBody;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.search.FindItemsResults;
import microsoft.exchange.webservices.data.search.ItemView;
import microsoft.exchange.webservices.data.search.filter.SearchFilter;

public class ExchangeMailUtil {
    private AttachmentService attachmentService;
    private String mailServer;
    private String user;
    private String password;
    private String domain;
    private AttacheHandler handler;

    public ExchangeMailUtil(String mailServer, String user, String password) {
        this.mailServer = "https://" + mailServer + "/EWS/exchange.asmx";
        this.user = user;
        this.password = password;
    }

    public ExchangeMailUtil(String mailServer, String user, String password, String domain) {
        this.mailServer = "https://" + mailServer + "/EWS/exchange.asmx";
        this.user = user;
        this.password = password;
        this.domain = domain;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExchangeService getExchangeService() {
        try (ExchangeService service = new ExchangeService(ExchangeVersion.Exchange2010_SP2);){
            WebCredentials credentials = this.domain == null ? new WebCredentials(this.user, this.password) : new WebCredentials(this.user, this.password, this.domain);
            service.setCredentials((ExchangeCredentials)credentials);
            service.setUrl(new URI(this.mailServer));
            ExchangeService exchangeService = service;
            return exchangeService;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List<Mail> receive(int max, SearchFilter searchFilter) throws Exception {
        ExchangeService service = new ExchangeService(ExchangeVersion.Exchange2010_SP2);
        WebCredentials credentials = new WebCredentials(this.user, this.password);
        service.setCredentials((ExchangeCredentials)credentials);
        service.setUrl(new URI(this.mailServer));
        Folder inbox = Folder.bind((ExchangeService)service, (WellKnownFolderName)WellKnownFolderName.Inbox);
        int count = inbox.getTotalCount();
        if (max > 0) {
            count = count > max ? max : count;
        }
        ItemView view = new ItemView(count);
        view.getOrderBy().add((PropertyDefinitionBase)ItemSchema.DateTimeReceived, SortDirection.Descending);
        FindItemsResults findResults = searchFilter == null ? service.findItems(inbox.getId(), view) : service.findItems(inbox.getId(), searchFilter, view);
        int size = findResults.getItems().size();
        ArrayList<Mail> result = new ArrayList<Mail>();
        if (size == 0) {
            return result;
        }
        service.loadPropertiesForItems((Iterable)findResults, PropertySet.FirstClassProperties);
        for (Item item : findResults.getItems()) {
            EmailMessage message = (EmailMessage)item;
            Mail mail = this.getMail(message);
            result.add(mail);
        }
        return result;
    }

    public List<Mail> receive(int max) throws Exception {
        return this.receive(max, null);
    }

    public List<Mail> receive() throws Exception {
        return this.receive(0, null);
    }

    public List<Mail> receive(AttacheHandler handler, LocalDateTime date) throws Exception {
        this.handler = handler;
        SearchFilter.IsGreaterThan searchFilter = null;
        if (date != null) {
            Date t = DateFormatUtil.parse((LocalDateTime)date);
            searchFilter = new SearchFilter.IsGreaterThan((PropertyDefinitionBase)EmailMessageSchema.DateTimeReceived, (Object)t);
        }
        return this.receive(Integer.MAX_VALUE, (SearchFilter)searchFilter);
    }

    public void send(String subject, String[] to, String[] cc, String[] as, String bodyText, String[] attachmentPaths) throws Exception {
        ExchangeService service = this.getExchangeService();
        EmailMessage msg = new EmailMessage(service);
        msg.setSubject(subject);
        MessageBody body = MessageBody.getMessageBodyFromText((String)bodyText);
        body.setBodyType(BodyType.HTML);
        msg.setBody(body);
        for (String toPerson : to) {
            msg.getToRecipients().add(toPerson);
        }
        if (BeanUtils.isNotEmpty((Object)cc)) {
            for (String ccPerson : cc) {
                if (!StringUtil.isNotEmpty((String)ccPerson)) continue;
                msg.getCcRecipients().add(ccPerson);
            }
        }
        if (BeanUtils.isNotEmpty((Object)as)) {
            for (String asPerson : as) {
                if (!StringUtil.isNotEmpty((String)asPerson)) continue;
                msg.getCcRecipients().add(asPerson);
            }
        }
        if (BeanUtils.isNotEmpty((Object)attachmentPaths)) {
            FileService fileService = (FileService)AppUtil.getBean(FileService.class);
            for (String attachmentPath : attachmentPaths) {
                if (!StringUtil.isNotEmpty((String)attachmentPath)) continue;
                ArrayNode attachmentObjs = (ArrayNode)JsonUtil.toJsonNode((String)attachmentPath);
                for (JsonNode jsonNode : attachmentObjs) {
                    FileInfo fileInfo = fileService.getFileInfo(jsonNode.get("id").asText());
                    if (!BeanUtils.isNotEmpty((Object)fileInfo)) continue;
                    String fileName = fileInfo.getFullFileName();
                    if ("folder".equals(fileInfo.getStoreType())) {
                        String filePath = AppFileUtil.getAttachPath() + File.separator + fileInfo.getFilePath();
                        File file = new File(filePath);
                        if (!file.exists()) continue;
                        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
                        byte[] fileBlob = FileUtil.readByte((InputStream)inputStream);
                        msg.getAttachments().addFileAttachment(fileName, fileBlob);
                        continue;
                    }
                    if ("database".equals(fileInfo.getStoreType())) {
                        byte[] fileBlob = fileInfo.getBytes();
                        msg.getAttachments().addFileAttachment(fileName, fileBlob);
                        continue;
                    }
                    if (!"ftp".equals(fileInfo.getStoreType()) && !"aliyunOss".equals(fileInfo.getStoreType())) continue;
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                    this.attachmentService.download((Attachment)fileInfo, (OutputStream)outStream, BeanUtils.isNotEmpty((Object)fileInfo) ? fileInfo.getProp6() : "");
                    ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
                    msg.getAttachments().addFileAttachment(fileName, (InputStream)inStream);
                }
            }
        }
        msg.send();
    }

    public void send(String subject, String[] to, String[] cc, String[] as, String bodyText) throws Exception {
        this.send(subject, to, cc, as, bodyText, null);
    }

    public Mail getMail(EmailMessage message) throws Exception {
        Mail mail = new Mail();
        LocalDateTime sentDate = null;
        if (message.getDateTimeSent() != null) {
            Instant instant = message.getDateTimeSent().toInstant();
            ZoneId zone = ZoneId.systemDefault();
            sentDate = LocalDateTime.ofInstant(instant, zone);
        } else {
            sentDate = LocalDateTime.now();
        }
        mail.setSendDate(sentDate);
        String subject = message.getSubject();
        if (subject != null) {
            mail.setSubject(subject);
        } else {
            mail.setSubject("\u65e0\u4e3b\u9898");
        }
        if (message.getHasAttachments()) {
            AttachmentCollection attachments = message.getAttachments();
            if (this.handler != null) {
                this.handler.handle(attachments, mail);
            }
        }
        String content = message.getBody().toString();
        mail.setContent(Base64.getBase64((String)content));
        mail.setSenderAddress(message.getFrom().getAddress());
        mail.setSenderName(message.getFrom().getName());
        mail.setReceiverAddresses(message.getReceivedBy().getAddress());
        mail.setReceiverName(message.getReceivedBy().getName());
        mail = this.getBccAddressesAndNames(message, mail);
        mail = this.getCcAddressesAndNames(message, mail);
        return mail;
    }

    public Mail getBccAddressesAndNames(EmailMessage message, Mail mail) throws Exception {
        List items = message.getBccRecipients().getItems();
        StringBuffer bccAddresses = new StringBuffer();
        StringBuffer bccNames = new StringBuffer();
        if (items.size() > 0) {
            for (int i = 0; i < items.size(); ++i) {
                if (i == items.size() - 1) {
                    bccAddresses.append(((EmailAddress)items.get(i)).getAddress());
                    bccNames.append(((EmailAddress)items.get(i)).getName());
                    continue;
                }
                bccAddresses.append(((EmailAddress)items.get(i)).getAddress()).append(",");
                bccNames.append(((EmailAddress)items.get(i)).getName()).append(",");
            }
        }
        mail.setBcCAddresses(bccAddresses.toString());
        mail.setBccName(bccNames.toString());
        return mail;
    }

    public Mail getCcAddressesAndNames(EmailMessage message, Mail mail) throws Exception {
        List items = message.getCcRecipients().getItems();
        StringBuffer ccAddresses = new StringBuffer();
        StringBuffer ccNames = new StringBuffer();
        if (items.size() > 0) {
            for (int i = 0; i < items.size(); ++i) {
                if (i == items.size() - 1) {
                    ccAddresses.append(((EmailAddress)items.get(i)).getAddress());
                    ccNames.append(((EmailAddress)items.get(i)).getName());
                    continue;
                }
                ccAddresses.append(((EmailAddress)items.get(i)).getAddress()).append(",");
                ccNames.append(((EmailAddress)items.get(i)).getName()).append(",");
            }
        }
        mail.setCopyToAddresses(ccAddresses.toString());
        mail.setCopyToName(ccNames.toString());
        return mail;
    }
}

