/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.office;

import com.hotent.base.jwt.JwtTokenHandler;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.AuthenticationUtil;
import io.jsonwebtoken.Claims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;

public class AuthUtil {
    public static Logger logger = LoggerFactory.getLogger(AuthUtil.class);

    public static void auth(String token) {
        JwtTokenHandler jwtTokenHandler = (JwtTokenHandler)AppUtil.getBean(JwtTokenHandler.class);
        UserDetailsService userDetailsService = (UserDetailsService)AppUtil.getBean(UserDetailsService.class);
        try {
            Claims claims = jwtTokenHandler.parseToken(token);
            String username = claims.getSubject();
            UserDetails userDetails = userDetailsService.loadUserByUsername(username);
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            AuthenticationUtil.setAuthentication((Authentication)authentication);
        }
        catch (Exception e) {
            logger.error("\u624b\u52a8token\u8ba4\u8bc1\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }
}

