/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.office;

import com.hotent.base.util.BeanUtils;
import com.hotent.office.documentserver.storage.FileStoragePathBuilder;
import com.hotent.office.documentserver.util.SSLUtils;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.modelmapper.ModelMapper;
import org.modelmapper.config.Configuration;
import org.modelmapper.convention.MatchingStrategies;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class IntegrationConfiguration {
    @Value(value="${files.storage}")
    private String storageAddress;
    @Value(value="${files.docservice.verify-peer-off}")
    private String verifyPerrOff;
    @Resource
    @Lazy
    private FileStoragePathBuilder storagePathBuilder;
    @Resource
    private SSLUtils ssl;

    @Bean
    public ModelMapper mapper() {
        ModelMapper mapper = new ModelMapper();
        mapper.getConfiguration().setMatchingStrategy(MatchingStrategies.STRICT).setFieldMatchingEnabled(true).setSkipNullEnabled(true).setFieldAccessLevel(Configuration.AccessLevel.PRIVATE);
        return mapper;
    }

    @PostConstruct
    public void init() {
        this.storagePathBuilder.configure(BeanUtils.isEmpty((Object)this.storageAddress) ? null : this.storageAddress);
        if (!this.verifyPerrOff.isEmpty()) {
            try {
                if (this.verifyPerrOff.equals("true")) {
                    this.ssl.turnOffSslChecking();
                } else {
                    this.ssl.turnOnSslChecking();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

