/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.office.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.vo.DefaultFileVo;
import com.hotent.file.util.AppFileUtil;
import com.hotent.office.documentserver.managers.history.HistoryManager;
import com.hotent.office.documentserver.managers.jwt.JwtManager;
import com.hotent.office.documentserver.models.enums.Action;
import com.hotent.office.documentserver.models.enums.Type;
import com.hotent.office.documentserver.models.filemodel.FileModel;
import com.hotent.office.documentserver.storage.FileStorageMutator;
import com.hotent.office.documentserver.util.FileUtil;
import com.hotent.office.entities.User;
import com.hotent.office.manager.OfficeManager;
import com.hotent.office.model.DefaultFile;
import com.hotent.office.model.OfficeAttachment;
import com.hotent.office.services.UserServices;
import com.hotent.office.services.configurers.FileConfigurer;
import com.hotent.office.services.configurers.wrappers.DefaultFileWrapper;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Locale;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"KM\u7cfb\u7edf\u6587\u4ef6\u63a7\u5236\u5668"})
@ApiGroup(group={"group_office"})
@CrossOrigin(value={"*"})
@Controller
@RequestMapping(value={"${url.prefix}"})
public class OfficeController {
    @Autowired
    private FileConfigurer<DefaultFileWrapper> fileConfigurer;
    @Autowired
    private JwtManager jwtManager;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private FileStorageMutator storageMutator;
    @Autowired
    private HistoryManager historyManager;
    @Autowired
    private UserServices userService;
    @Resource
    OfficeManager officeManager;

    @GetMapping(value={"createHistory"})
    @ApiOperation(value="\u521d\u59cb\u5386\u53f2\u8bb0\u5f55\u521b\u5efa", httpMethod="GET", notes="\u521d\u59cb\u5386\u53f2\u8bb0\u5f55\u521b\u5efa")
    public void createHistory(@RequestParam(value="fileId") String fileId, @RequestParam(value="source", required=false, defaultValue="template") String source) throws Exception {
        IUser currentUser = ContextUtil.getCurrentUser();
        DefaultFileVo fileInfo = FileUtil.getFileInfo(fileId);
        this.storageMutator.createMeta2(fileId, currentUser.getAccount(), source, fileInfo.getExtensionName(), fileInfo.getFilePath());
    }

    @GetMapping(value={"createFileWithStream"})
    @ApiOperation(value="\u6587\u4ef6\u521b\u5efa", httpMethod="GET", notes="\u6587\u4ef6\u521b\u5efa")
    public void createFileWithStream(@RequestParam(value="fileId") String fileId, @RequestParam(value="source", required=false, defaultValue="template") String source) throws Exception {
        IUser currentUser = ContextUtil.getCurrentUser();
        DefaultFileVo fileInfo = FileUtil.getFileInfo(fileId);
        OfficeAttachment attachment = new OfficeAttachment();
        attachment.setId(fileInfo.getId());
        attachment.setFilePath(fileInfo.getFilePath());
        attachment.setStoreType(AppFileUtil.getSaveType((String)""));
        this.storageMutator.createMeta2(fileId, currentUser.getAccount(), source, fileInfo.getExtensionName(), fileInfo.getFilePath());
    }

    @GetMapping(path={"queryHistory"})
    @ResponseBody
    public String queryHistory(@RequestParam(value="fileId") String fileId, @RequestParam(value="source", required=false, defaultValue="template") String source) throws IOException {
        Action action = Action.edit;
        Type type = Type.desktop;
        Locale locale = LocaleContextHolder.getLocale();
        IUser currentUser = ContextUtil.getCurrentUser();
        User user = this.userService.createUser(currentUser.getUserId(), currentUser.getFullname(), currentUser.getEmail());
        DefaultFileVo fileInfo = FileUtil.getFileInfo(fileId);
        DefaultFile defaultFile = DefaultFile.builder().id(fileId).createBy(fileInfo.getCreateBy()).createtor(fileInfo.getCreatorName()).fileExt(fileInfo.getExtensionName()).ownerId(fileInfo.getCreateBy()).ownerName(fileInfo.getCreatorName()).createBy(fileInfo.getCreateBy()).createtor(fileInfo.getCreatorName()).filename(fileInfo.getFileName()).version(fileInfo.getVersion()).build();
        String fileName = fileInfo.getFileName() + "." + fileInfo.getExtensionName();
        FileModel fileModel = this.fileConfigurer.getFileModel(DefaultFileWrapper.builder().type(type).lang(locale.toLanguageTag()).action(action).user(user).fileName(fileName).fileId(fileId).defaultFile(defaultFile).build());
        String[] history = this.historyManager.getHistoryFromDb(fileModel.getDocument());
        return history[0];
    }

    @RequestMapping(path={"${url.editor}"})
    public String editor(@RequestParam(value="fileId") String fileId, @RequestParam(value="action", required=false) String actionParam, @RequestParam(value="type", required=false) String typeParam, @RequestParam(value="actionLink", required=false) String actionLink, @RequestParam(value="token", required=false) String token, @RequestParam(value="filePath", required=false) String filePath, @RequestParam(value="source", required=false, defaultValue="EIP") String source, @RequestParam(value="isShare", required=false) boolean isShare, Model model) throws IOException {
        return this.officeManager.editor(fileId, actionParam, typeParam, actionLink, token, filePath, source, model);
    }
}

