/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.office.controller;

import cn.hutool.core.lang.Assert;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hotent.base.context.BaseContext;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.vo.DefaultFileVo;
import com.hotent.file.util.AppFileUtil;
import com.hotent.office.documentserver.callbacks.CallbackHandler;
import com.hotent.office.documentserver.managers.callback.CallbackManager;
import com.hotent.office.documentserver.managers.document.DocumentManager;
import com.hotent.office.documentserver.managers.jwt.JwtManager;
import com.hotent.office.documentserver.models.enums.DocumentType;
import com.hotent.office.documentserver.storage.FileStorageMutator;
import com.hotent.office.documentserver.storage.FileStoragePathBuilder;
import com.hotent.office.documentserver.storage.LocalFileStorage;
import com.hotent.office.documentserver.util.FileUtil;
import com.hotent.office.documentserver.util.file.FileUtility;
import com.hotent.office.documentserver.util.service.ServiceConverter;
import com.hotent.office.dto.Converter;
import com.hotent.office.dto.Track;
import com.hotent.office.entities.User;
import com.hotent.office.manager.OfficeVersionManager;
import com.hotent.office.model.OfficeAttachment;
import com.hotent.office.services.KeyServieces;
import com.hotent.office.services.UserServices;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.UrlResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@CrossOrigin(value={"*"})
@Controller
public class OfficeController2 {
    @Value(value="${files.docservice.header}")
    private String documentJwtHeader;
    @Value(value="${filesize-max}")
    private String filesizeMax;
    @Value(value="${files.docservice.url.site}")
    private String docserviceUrlSite;
    @Value(value="${files.docservice.url.command}")
    private String docserviceUrlCommand;
    @Autowired
    private FileUtility fileUtility;
    @Autowired
    private DocumentManager documentManager;
    @Autowired
    private JwtManager jwtManager;
    @Autowired
    private FileStorageMutator storageMutator;
    @Autowired
    private FileStoragePathBuilder storagePathBuilder;
    @Autowired
    private UserServices userService;
    @Autowired
    private CallbackHandler callbackHandler;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ServiceConverter serviceConverter;
    @Autowired
    private CallbackManager callbackManager;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private LocalFileStorage localFileStorage;
    @Autowired
    private OfficeVersionManager officeVersionManager;
    @Autowired
    private KeyServieces keyServieces;
    @Resource
    PortalFeignService portalFeignService;

    private String createUserMetadata(String uid, String fullFileName) {
        String ext = fullFileName.substring(fullFileName.lastIndexOf(".") + 1);
        Optional<User> optionalUser = this.userService.findUserById(uid);
        String documentType = this.fileUtility.getDocumentType(fullFileName).toString().toLowerCase();
        if (optionalUser.isPresent()) {
            User user = optionalUser.get();
            this.storageMutator.createMeta(fullFileName, String.valueOf(user.getId()), user.getName(), ext, fullFileName);
        }
        return "{ \"filename\": \"" + fullFileName + "\", \"documentType\": \"" + documentType + "\" }";
    }

    private ResponseEntity<org.springframework.core.io.Resource> downloadFile(String fileName) {
        org.springframework.core.io.Resource resource = this.storageMutator.loadFileAsResource(fileName);
        String contentType = "application/octet-stream";
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"attachment; filename=\"" + resource.getFilename() + "\""})).body((Object)resource);
    }

    private ResponseEntity<org.springframework.core.io.Resource> downloadFileById(String fileId, String source) throws IOException {
        DefaultFileVo fileInfo = FileUtil.getFileInfo(fileId);
        String name = fileInfo.getFileName();
        String title = name + "." + fileInfo.getExtensionName();
        String fileLocation = fileInfo.getFilePath();
        Path filePath = Paths.get(fileLocation, new String[0]);
        UrlResource resource = new UrlResource(filePath.toUri());
        String contentType = "application/octet-stream";
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"attachment; filename=\"" + URLEncoder.encode(title, "UTF-8") + "\""})).body((Object)resource);
    }

    private ResponseEntity<org.springframework.core.io.Resource> downloadFileHistory(String fileId, String version, String file, String source) throws IOException {
        org.springframework.core.io.Resource resource = this.storageMutator.loadFileAsResourceHistory(fileId, version, file, source);
        String contentType = "application/octet-stream";
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"attachment; filename=\"" + resource.getFilename() + "\""})).body((Object)resource);
    }

    @PostMapping(value={"/upload"}, consumes={"multipart/form-data"})
    @ResponseBody
    public String upload(@RequestParam(value="file") MultipartFile file) {
        try {
            String uid = ContextUtil.getCurrentUserId();
            String fullFileName = file.getOriginalFilename();
            String fileExtension = this.fileUtility.getFileExtension(fullFileName);
            long fileSize = file.getSize();
            byte[] bytes = file.getBytes();
            if (this.fileUtility.getMaxFileSize() < fileSize || fileSize <= 0L) {
                return "{ \"error\": \"File size is incorrect\"}";
            }
            if (!this.fileUtility.getFileExts().contains(fileExtension)) {
                return "{ \"error\": \"File type is not supported\"}";
            }
            String fileNamePath = this.storageMutator.updateFile(fullFileName, bytes);
            if (BeanUtils.isEmpty((Object)fileNamePath)) {
                throw new IOException("Could not update a file");
            }
            fullFileName = this.fileUtility.getFileNameWithoutExtension(fileNamePath) + fileExtension;
            return this.createUserMetadata(uid, fullFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "{ \"error\": \"Something went wrong when uploading the file.\"}";
        }
    }

    @PostMapping(path={"${url.converter}"})
    @ResponseBody
    public String convert(@RequestBody Converter body, @CookieValue(value="uid") String uid, @CookieValue(value="ulang") String lang, @RequestParam(value="fileId", required=false) String fileId, @RequestParam(value="source", required=false) String source) throws IOException {
        String fileName = body.getFileName();
        DefaultFileVo fileInfo = FileUtil.getFileInfo(fileId);
        File file = new File(fileInfo.getFilePath());
        String filedir = fileInfo.getFilePath();
        if (file.exists()) {
            filedir = file.getParent();
        }
        String fileUri = this.documentManager.getDownloadUrl(fileName, true, filedir, "");
        String filePass = body.getFilePass() != null ? body.getFilePass() : null;
        String fileExt = this.fileUtility.getFileExtension(fileName);
        DocumentType type = this.fileUtility.getDocumentType(fileName);
        String internalFileExt = this.fileUtility.getInternalExtension(type);
        try {
            if (this.fileUtility.getConvertExts().contains(fileExt)) {
                String key = this.localFileStorage.getKey(filedir, fileName, fileId, "");
                String newFileUri = this.serviceConverter.getConvertedUri(fileUri, fileExt, internalFileExt, key, filePass, true, lang);
                if (newFileUri.isEmpty()) {
                    return "{ \"step\" : \"0\", \"filename\" : \"" + fileName + "\"}";
                }
                String nameWithInternalExt = this.fileUtility.getFileNameWithoutExtension(fileName) + internalFileExt;
                String correctedName = this.documentManager.getCorrectName(nameWithInternalExt, filedir);
                URL url = new URL(newFileUri);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                InputStream stream = connection.getInputStream();
                if (stream == null) {
                    connection.disconnect();
                    throw new RuntimeException("Input stream is null");
                }
                this.storageMutator.createFile(Paths.get(this.storagePathBuilder.getFileLocation(correctedName), new String[0]), stream);
                fileName = correctedName;
            }
            return this.createUserMetadata(uid, fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "{ \"error\": \"The file can't be converted.\"}";
        }
    }

    @PostMapping(value={"/delete"})
    @ResponseBody
    public String delete(@RequestBody Converter body) {
        try {
            String fullFileName = this.fileUtility.getFileName(body.getFileName());
            boolean fileSuccess = this.storageMutator.deleteFile(fullFileName);
            boolean historySuccess = this.storageMutator.deleteFileHistory(fullFileName);
            return "{ \"success\": \"" + (fileSuccess && historySuccess) + "\"}";
        }
        catch (Exception e) {
            return "{ \"error\": \"" + e.getMessage() + "\"}";
        }
    }

    @GetMapping(value={"/office/v1/downloadhistory"})
    public ResponseEntity<org.springframework.core.io.Resource> downloadHistory(HttpServletRequest request, @RequestParam(value="fileId") String fileId, @RequestParam(value="ver", required=false) String version, @RequestParam(value="file") String file, @RequestParam(value="source", defaultValue="template") String source) {
        try {
            if (this.jwtManager.tokenEnabled()) {
                String header = request.getHeader(this.documentJwtHeader == null || this.documentJwtHeader.isEmpty() ? "Authorization" : this.documentJwtHeader);
                if (header != null && !header.isEmpty()) {
                    String token = header.replace("Bearer ", "");
                    this.jwtManager.readToken(token);
                } else {
                    return null;
                }
            }
            return this.downloadFileHistory(fileId, version, file, source);
        }
        catch (Exception e) {
            return null;
        }
    }

    @GetMapping(value={"/assets"})
    public ResponseEntity<org.springframework.core.io.Resource> assets(@RequestParam(value="name") String name) {
        String fileName = Paths.get("assets", "sample", this.fileUtility.getFileName(name)).toString();
        return this.downloadFile(fileName);
    }

    @GetMapping(value={"/csv"})
    public ResponseEntity<org.springframework.core.io.Resource> csv() {
        String fileName = Paths.get("assets", "sample", "csv.csv").toString();
        return this.downloadFile(fileName);
    }

    @GetMapping(value={"/files"})
    @ResponseBody
    public ArrayList<Map<String, Object>> files(@RequestParam(value="fileId", required=false) String fileId) {
        return fileId == null ? this.documentManager.getFilesInfo() : this.documentManager.getFilesInfo(fileId);
    }

    @PostMapping(path={"${url.track}"})
    @ResponseBody
    public String track(HttpServletRequest request, @RequestParam(value="fileId") String fileId, @RequestParam(value="source") String source, @RequestParam(value="userAddress") String userAddress, @RequestBody Track body) {
        try {
            String bodyString = this.objectMapper.writeValueAsString((Object)body);
            String header = request.getHeader(this.documentJwtHeader == null || this.documentJwtHeader.isEmpty() ? "Authorization" : this.documentJwtHeader);
            if (bodyString.isEmpty()) {
                throw new RuntimeException("{\"error\":1,\"message\":\"Request payload is empty\"}");
            }
            JSONObject bodyCheck = this.jwtManager.parseBody(bodyString, header);
            body = (Track)this.objectMapper.readValue(bodyCheck.toJSONString(), Track.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
        int error = this.callbackHandler.handle(body, fileId, source);
        return "{\"error\":" + error + "}";
    }

    @PostMapping(value={"/saveas"})
    @ResponseBody
    public String saveAs(@RequestBody JSONObject body, @CookieValue(value="uid") String uid) {
        String title = (String)body.get((Object)"title");
        String saveAsFileUrl = (String)body.get((Object)"url");
        try {
            String fileName = this.documentManager.getCorrectName(title, "");
            String curExt = this.fileUtility.getFileExtension(fileName);
            if (!this.fileUtility.getFileExts().contains(curExt)) {
                return "{\"error\":\"File type is not supported\"}";
            }
            URL url = new URL(saveAsFileUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            InputStream stream = connection.getInputStream();
            if (Integer.parseInt(this.filesizeMax) < stream.available() || stream.available() <= 0) {
                return "{\"error\":\"File size is incorrect\"}";
            }
            this.storageMutator.createFile(Paths.get(this.storagePathBuilder.getFileLocation(fileName), new String[0]), stream);
            this.createUserMetadata(uid, fileName);
            return "{\"file\":  \"" + fileName + "\"}";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "{ \"error\" : 1, \"message\" : \"" + e.getMessage() + "\"}";
        }
    }

    @PostMapping(value={"${url.prefix}rename"})
    @ResponseBody
    public String rename(@RequestBody JSONObject body) {
        String fileId = body.get((Object)"fileId").toString();
        String newFileName = body.get((Object)"newfilename").toString();
        DefaultFileVo fileVo = new DefaultFileVo();
        fileVo.setId(fileId);
        fileVo.setFileName(newFileName);
        Assert.isTrue((boolean)this.portalFeignService.saveFile(fileVo).getState(), (String)"\u4fdd\u5b58\u6587\u4ef6\u540d\u5931\u8d25", (Object[])new Object[0]);
        return "result ok";
    }

    @GetMapping(path={"${url.download}"})
    public void download(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="fileId") String fileId, @RequestParam(value="source", required=false, defaultValue="EIP") String source) {
        try {
            String header;
            if (this.jwtManager.tokenEnabled() && (header = request.getHeader(this.documentJwtHeader == null || this.documentJwtHeader.isEmpty() ? "Authorization" : this.documentJwtHeader)) != null && !header.isEmpty()) {
                String token = header.replace("Bearer ", "");
                this.jwtManager.readToken(token);
            }
            this.downloadFileById(fileId, source, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void downloadFileById(String fileId, String source, HttpServletResponse response) throws MalformedURLException, UnsupportedEncodingException {
        DefaultFileVo fileInfo = FileUtil.getFileInfo(fileId);
        OfficeAttachment attachment = new OfficeAttachment();
        attachment.setId(fileInfo.getId());
        attachment.setFileName(fileInfo.getFileName());
        attachment.setFilePath(fileInfo.getFilePath());
        attachment.setStoreType(AppFileUtil.getSaveType((String)""));
        attachment.setExt(fileInfo.getExtensionName());
        this.localFileStorage.download(attachment, (OutputStream)response.getOutputStream());
    }

    @PostMapping(value={"${url.prefix}historyRestore"})
    @ResponseBody
    public void historyRestore(@RequestBody JSONObject body) throws IOException {
    }
}

