/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.office.controller;

import com.hotent.office.documentserver.storage.FileStorageMutator;
import com.hotent.office.documentserver.storage.FileStoragePathBuilder;
import com.hotent.office.documentserver.util.Misc;
import com.hotent.office.documentserver.util.file.FileUtility;
import com.hotent.office.entities.User;
import com.hotent.office.services.UserServices;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@CrossOrigin(value={"*"})
@Controller
@RequestMapping(value={"${url.prefix}"})
public class OfficeIndexController {
    @Autowired
    private FileStorageMutator storageMutator;
    @Autowired
    private FileStoragePathBuilder storagePathBuilder;
    @Autowired
    private FileUtility fileUtility;
    @Autowired
    private Misc mistUtility;
    @Autowired
    private UserServices userService;
    @Value(value="${files.docservice.url.site}")
    private String docserviceSite;
    @Value(value="${files.docservice.url.preloader}")
    private String docservicePreloader;
    @Value(value="${url.converter}")
    private String urlConverter;
    @Value(value="${url.editor}")
    private String urlEditor;
    @Value(value="${url.index}")
    private String index;
    @Value(value="${files.docservice.languages}")
    private String langs;

    @GetMapping(value={"index"})
    public String index(Model model) {
        File[] files = this.storageMutator.getStoredFiles();
        ArrayList<String> docTypes = new ArrayList<String>();
        ArrayList<Boolean> filesEditable = new ArrayList<Boolean>();
        ArrayList<String> versions = new ArrayList<String>();
        ArrayList<Boolean> isFillFormDoc = new ArrayList<Boolean>();
        List<String> langsAndKeys = Arrays.asList(this.langs.split("\\|"));
        LinkedHashMap languages = new LinkedHashMap();
        langsAndKeys.forEach(str -> {
            String[] couple = str.split(":");
            languages.put(couple[0], couple[1]);
        });
        List<User> users = this.userService.findAll();
        String tooltip = users.stream().map(user -> this.mistUtility.convertUserDescriptions(user.getName(), user.getDescriptions())).collect(Collectors.joining());
        for (File file : files) {
            String fileName = file.getName();
            docTypes.add(this.fileUtility.getDocumentType(fileName).toString().toLowerCase());
            filesEditable.add(this.fileUtility.getEditedExts().contains(this.fileUtility.getFileExtension(fileName)));
            versions.add(" [" + this.storagePathBuilder.getFileVersion(fileName, true) + "]");
            isFillFormDoc.add(this.fileUtility.getFillExts().contains(this.fileUtility.getFileExtension(fileName)));
        }
        model.addAttribute("isFillFormDoc", isFillFormDoc);
        model.addAttribute("versions", versions);
        model.addAttribute("files", (Object)files);
        model.addAttribute("docTypes", docTypes);
        model.addAttribute("filesEditable", filesEditable);
        model.addAttribute("datadocs", (Object)(this.docserviceSite + this.docservicePreloader));
        model.addAttribute("tooltip", (Object)tooltip);
        model.addAttribute("users", users);
        model.addAttribute("languages", languages);
        return "index.html";
    }

    @PostMapping(value={"/config"})
    @ResponseBody
    public HashMap<String, String> configParameters() {
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("FillExtList", String.join((CharSequence)",", this.fileUtility.getFillExts()));
        configuration.put("ConverExtList", String.join((CharSequence)",", this.fileUtility.getConvertExts()));
        configuration.put("EditedExtList", String.join((CharSequence)",", this.fileUtility.getEditedExts()));
        configuration.put("UrlConverter", this.urlConverter);
        configuration.put("UrlEditor", this.urlEditor);
        return configuration;
    }
}

