/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.office.documentserver.callbacks;

import com.hotent.office.documentserver.callbacks.Callback;
import com.hotent.office.dto.Track;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CallbackHandler {
    private Logger logger = LoggerFactory.getLogger(CallbackHandler.class);
    private Map<Integer, Callback> callbackHandlers = new HashMap<Integer, Callback>();

    public void register(int code, Callback callback) {
        this.callbackHandlers.put(code, callback);
    }

    public int handle(Track body, String fileId, String source) {
        Callback callback = this.callbackHandlers.get(body.getStatus());
        if (callback == null) {
            this.logger.warn("Callback status " + body.getStatus() + " is not supported yet");
            return 0;
        }
        int result = callback.handle(body, fileId, source);
        return result;
    }
}

