/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.office.documentserver.managers.callback;

import cn.keking.service.FileHandlerService;
import cn.keking.utils.DownloadUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hotent.base.attachment.Attachment;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.vo.DefaultFileVo;
import com.hotent.file.util.AppFileUtil;
import com.hotent.office.documentserver.managers.callback.CallbackManager;
import com.hotent.office.documentserver.managers.document.DocumentManager;
import com.hotent.office.documentserver.managers.jwt.JwtManager;
import com.hotent.office.documentserver.storage.FileStorageMutator;
import com.hotent.office.documentserver.storage.FileStoragePathBuilder;
import com.hotent.office.documentserver.storage.LocalFileStorage;
import com.hotent.office.documentserver.util.FileUtil;
import com.hotent.office.documentserver.util.file.FileUtility;
import com.hotent.office.documentserver.util.service.ServiceConverter;
import com.hotent.office.dto.ChangesHistory;
import com.hotent.office.dto.Track;
import com.hotent.office.manager.OfficeVersionManager;
import com.hotent.office.model.OfficeAttachment;
import com.hotent.office.model.OfficeVersion;
import com.hotent.office.services.KeyServieces;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Component
@Primary
public class DefaultCallbackManager
implements CallbackManager {
    @Value(value="${files.docservice.url.site}")
    private String docserviceUrlSite;
    @Value(value="${files.docservice.url.command}")
    private String docserviceUrlCommand;
    @Value(value="${files.docservice.header}")
    private String documentJwtHeader;
    @Resource
    private UCFeignService ucFeignService;
    @Autowired
    private DocumentManager documentManager;
    @Autowired
    private JwtManager jwtManager;
    @Autowired
    private FileUtility fileUtility;
    @Autowired
    private FileStorageMutator storageMutator;
    @Autowired
    private FileStoragePathBuilder storagePathBuilder;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ServiceConverter serviceConverter;
    @Autowired
    private LocalFileStorage localFileStorage;
    @Autowired
    private KeyServieces keyServieces;
    @Autowired
    private OfficeVersionManager officeVersionManager;
    @Resource
    FileHandlerService fileHandlerService;

    private void downloadToFile(String url, Path path) throws Exception {
        if (url == null || url.isEmpty()) {
            throw new RuntimeException("Url argument is not specified");
        }
        if (path == null) {
            throw new RuntimeException("Path argument is not specified");
        }
        URL uri = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)uri.openConnection();
        InputStream stream = connection.getInputStream();
        if (stream == null) {
            connection.disconnect();
            throw new RuntimeException("Input stream is null");
        }
        this.storageMutator.createOrUpdateFile(path, stream);
        stream.close();
    }

    @Override
    public void processSaveByFileId(Track body, String fileId, String source) {
    }

    private void rewriteChanges(List<ChangesHistory> changes) {
        changes.forEach(item -> {
            item.setUpdateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            CommonResult jsonNode = this.ucFeignService.getUserById(item.getUser().getId());
            JsonNode value = (JsonNode)jsonNode.getValue();
            item.getUser().setAccount(value.get("account").asText());
        });
    }

    @Override
    public void commandRequest(String method, String key, HashMap meta) {
        String responseCode;
        String DocumentCommandUrl = this.docserviceUrlSite + this.docserviceUrlCommand;
        URL url = new URL(DocumentCommandUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("c", method);
        params.put("key", key);
        if (meta != null) {
            params.put("meta", meta);
        }
        if (this.jwtManager.tokenEnabled()) {
            HashMap<String, Object> payloadMap = new HashMap<String, Object>();
            payloadMap.put("payload", params);
            String headerToken = this.jwtManager.createToken(payloadMap);
            connection.setRequestProperty(this.documentJwtHeader.equals("") ? "Authorization" : this.documentJwtHeader, "Bearer " + headerToken);
            String token = this.jwtManager.createToken(params);
            params.put("token", token);
        }
        String bodyString = this.objectMapper.writeValueAsString(params);
        byte[] bodyByte = bodyString.getBytes(StandardCharsets.UTF_8);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        connection.setDoOutput(true);
        connection.connect();
        try (OutputStream os = connection.getOutputStream();){
            os.write(bodyByte);
        }
        InputStream stream = connection.getInputStream();
        if (stream == null) {
            throw new RuntimeException("Could not get an answer");
        }
        String jsonString = this.serviceConverter.convertStreamToString(stream);
        connection.disconnect();
        JSONObject response = this.serviceConverter.convertStringToJSON(jsonString);
        switch (responseCode = response.get((Object)"error").toString()) {
            case "0": 
            case "4": {
                break;
            }
            default: {
                throw new RuntimeException(response.toJSONString());
            }
        }
    }

    @Override
    public void processForceSaveByFileId(Track body, String fileId, String source) {
        this.saveFile(body, fileId, source);
    }

    @Override
    public void processSaveAttachmentByFileId(Track body, String fileId, String source) {
    }

    public void saveFile(Track body, String fileId, String source) throws Exception {
        String downloadUri = body.getUrl();
        DefaultFileVo file = FileUtil.getFileInfo(fileId);
        CommonResult res = this.ucFeignService.getUserById(file.getCreateBy());
        String currentSaveType = AppFileUtil.getSaveType((String)"");
        OfficeAttachment newVersion = new OfficeAttachment();
        newVersion.setId(file.getId());
        newVersion.setFilePath(file.getFilePath());
        newVersion.setStoreType(currentSaveType);
        newVersion.setExt(file.getExtensionName());
        newVersion.setFileName(file.getFileName());
        this.urlToAttachment(downloadUri, newVersion);
        OfficeVersion officeVersion = (OfficeVersion)((Object)this.officeVersionManager.getOne((Wrapper)Wrappers.lambdaQuery().eq(OfficeVersion::getFileId, (Object)fileId), false));
        if (officeVersion == null) {
            officeVersion = new OfficeVersion(fileId, 1);
        } else {
            officeVersion.setVersion(officeVersion.getVersion() + 1);
        }
        officeVersion.setKey(body.getKey());
        this.officeVersionManager.saveOrUpdate((Object)officeVersion);
        this.removeOfficePreviewCache(file);
    }

    private void removeOfficePreviewCache(DefaultFileVo file) {
        String cacheFilePath = DownloadUtils.getRelFilePath((String)file.getId(), (String)file.getFileName(), (String)file.getExtensionName());
        File cacheFile = new File(cacheFilePath);
        if (cacheFile.exists()) {
            cacheFile.delete();
        }
        this.fileHandlerService.removePdfCache(this.getPdfName(file));
    }

    private String getPdfName(DefaultFileVo file) {
        boolean isHtml = file.getExtensionName().equalsIgnoreCase("xls") || file.getExtensionName().equalsIgnoreCase("xlsx");
        return (isHtml ? "getPreviewFile" + File.separator : "") + file.getId() + "." + (isHtml ? "html" : "pdf");
    }

    private void urlToAttachment(String url, Attachment attachment) throws Exception {
        if (url == null || url.isEmpty()) {
            throw new RuntimeException("Url argument is not specified");
        }
        URL uri = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)uri.openConnection();
        try (InputStream stream = connection.getInputStream();){
            if (stream == null) {
                connection.disconnect();
                throw new RuntimeException("Input stream is null");
            }
            this.localFileStorage.createFile(attachment, stream);
        }
    }
}

